/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.dataflow.qual.Pure;

@I
public abstract class AbstractSequentialList<E>
extends AbstractList<E> {
    protected AbstractSequentialList() {
    }

    @Override
    @Pure
    public E get(@org.checkerframework.checker.igj.qual.ReadOnly AbstractSequentialList<E> this, int n) {
        try {
            return this.listIterator(n).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    @Override
    public E set(@Mutable AbstractSequentialList<E> this, int n, E e) {
        try {
            ListIterator<E> listIterator = this.listIterator(n);
            E e2 = listIterator.next();
            listIterator.set(e);
            return e2;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    @Override
    public void add(@Mutable AbstractSequentialList<E> this, int n, E e) {
        try {
            this.listIterator(n).add(e);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    @Override
    public E remove(@Mutable AbstractSequentialList<E> this, int n) {
        try {
            ListIterator<E> listIterator = this.listIterator(n);
            E e = listIterator.next();
            listIterator.remove();
            return e;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    @Override
    public boolean addAll(@Mutable AbstractSequentialList<E> this, int n, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Collection<? extends E> collection) {
        try {
            boolean bl = false;
            ListIterator<E> listIterator = this.listIterator(n);
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                listIterator.add(iterator.next());
                bl = true;
            }
            return bl;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
    }

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly AbstractSequentialList<E> this) {
        return this.listIterator();
    }

    @Override
    public abstract @I @PolyRead ListIterator<E> listIterator(@org.checkerframework.checker.igj.qual.ReadOnly AbstractSequentialList<E> this, int var1);
}

