/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@ReadOnly
public final class Boolean
implements Serializable,
Comparable<Boolean> {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = Class.getPrimitiveClass("boolean");
    private final boolean value;
    private static final long serialVersionUID = -3665804199014368530L;

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(@Nullable String string) {
        this(Boolean.toBoolean(string));
    }

    @Pure
    public static boolean parseBoolean(@Nullable String string) {
        return Boolean.toBoolean(string);
    }

    @Pure
    public boolean booleanValue() {
        return this.value;
    }

    @Pure
    public static Boolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Pure
    public static Boolean valueOf(@Nullable String string) {
        return Boolean.toBoolean(string) ? TRUE : FALSE;
    }

    @Pure
    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    @SideEffectFree
    public String toString() {
        return this.value ? "true" : "false";
    }

    @Pure
    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    @Pure
    public boolean equals(@Nullable @ReadOnly Object object) {
        if (object instanceof Boolean) {
            return this.value == (Boolean)object;
        }
        return false;
    }

    @Pure
    public static boolean getBoolean(@Nullable String string) {
        boolean bl = false;
        try {
            bl = Boolean.toBoolean(System.getProperty(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    @Pure
    public int compareTo(Boolean bl) {
        return Boolean.compare(this.value, bl.value);
    }

    public static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    private static boolean toBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }
}

