/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.SourceVersion;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.ClassGetName;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.javacutil.BugInCF;

public class TreeUtilsAfterJava11 {
    private static final int sourceVersionNumber = Integer.parseInt(SourceVersion.latest().toString().substring("RELEASE_".length()));

    private TreeUtilsAfterJava11() {
        throw new AssertionError((Object)"Cannot be instantiated.");
    }

    private static void assertVersionAtLeast(int version) {
        if (sourceVersionNumber < version) {
            throw new BugInCF("Method call requires at least Java version %s, but the current version is %s", version, sourceVersionNumber);
        }
    }

    private static Object invokeNonNullResult(Method method, Tree receiver) {
        Object result = TreeUtilsAfterJava11.invoke(method, receiver);
        if (result != null) {
            return result;
        }
        throw new BugInCF("Expected nonnull result for method invocation: %s for tree: %s", method.getName(), receiver);
    }

    private static @Nullable Object invoke(Method method, Tree receiver) {
        try {
            return method.invoke((Object)receiver, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF(e, "Reflection failed for method: %s for tree: %s", method.getName(), receiver);
        }
    }

    private static Method getMethod(Class<?> clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new BugInCF("Method %s not found in class %s", name, clazz);
        }
    }

    private static Class<?> classForName(@ClassGetName String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new BugInCF("Class not found " + name);
        }
    }

    public static class InstanceOfUtils {
        private static @Nullable Method GET_PATTERN = null;

        private InstanceOfUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        @Pure
        public static @Nullable Tree getPattern(InstanceOfTree instanceOfTree) {
            if (sourceVersionNumber < 16) {
                return null;
            }
            if (GET_PATTERN == null) {
                GET_PATTERN = TreeUtilsAfterJava11.getMethod(InstanceOfTree.class, "getPattern");
            }
            return (Tree)TreeUtilsAfterJava11.invoke(InstanceOfUtils.GET_PATTERN, instanceOfTree);
        }
    }

    public static class JCVariableDeclUtils {
        private static @Nullable Method DECLARED_USING_VAR = null;

        private JCVariableDeclUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        @Pure
        public static boolean declaredUsingVar(JCTree.JCVariableDecl variableTree) {
            Boolean result;
            if (sourceVersionNumber < 16) {
                return false;
            }
            if (DECLARED_USING_VAR == null) {
                DECLARED_USING_VAR = TreeUtilsAfterJava11.getMethod(JCTree.JCVariableDecl.class, "declaredUsingVar");
            }
            return (result = (Boolean)TreeUtilsAfterJava11.invoke(JCVariableDeclUtils.DECLARED_USING_VAR, variableTree)) != null ? result : false;
        }
    }

    public static class YieldUtils {
        private static @Nullable Method GET_VALUE = null;

        private YieldUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static ExpressionTree getValue(Tree yieldTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(13);
            if (GET_VALUE == null) {
                Class yieldTreeClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.YieldTree");
                GET_VALUE = TreeUtilsAfterJava11.getMethod(yieldTreeClass, "getValue");
            }
            return (ExpressionTree)TreeUtilsAfterJava11.invokeNonNullResult(YieldUtils.GET_VALUE, yieldTree);
        }
    }

    public static class SwitchExpressionUtils {
        private static @Nullable Method GET_EXPRESSION = null;
        private static @Nullable Method GET_CASES = null;

        private SwitchExpressionUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static List<? extends CaseTree> getCases(Tree switchExpressionTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(12);
            if (GET_CASES == null) {
                Class switchExpressionClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.SwitchExpressionTree");
                GET_CASES = TreeUtilsAfterJava11.getMethod(switchExpressionClass, "getCases");
            }
            return (List)TreeUtilsAfterJava11.invokeNonNullResult(SwitchExpressionUtils.GET_CASES, switchExpressionTree);
        }

        public static ExpressionTree getExpression(Tree switchExpressionTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(12);
            if (GET_EXPRESSION == null) {
                Class switchExpressionClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.SwitchExpressionTree");
                GET_EXPRESSION = TreeUtilsAfterJava11.getMethod(switchExpressionClass, "getExpression");
            }
            return (ExpressionTree)TreeUtilsAfterJava11.invokeNonNullResult(SwitchExpressionUtils.GET_EXPRESSION, switchExpressionTree);
        }
    }

    public static class PatternCaseLabelUtils {
        private static @Nullable Method GET_PATTERN = null;

        private PatternCaseLabelUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static boolean isPatternCaseLabelTree(Tree tree) {
            return tree.getKind().name().contentEquals("PATTERN_CASE_LABEL");
        }

        public static Tree getPattern(Tree patternCaseLabelTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(21);
            if (GET_PATTERN == null) {
                Class patternCaseLabelClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.PatternCaseLabelTree");
                GET_PATTERN = TreeUtilsAfterJava11.getMethod(patternCaseLabelClass, "getPattern");
            }
            return (Tree)TreeUtilsAfterJava11.invokeNonNullResult(PatternCaseLabelUtils.GET_PATTERN, patternCaseLabelTree);
        }
    }

    public static class DeconstructionPatternUtils {
        private static @Nullable Method GET_DECONSTRUCTOR = null;
        private static @Nullable Method GET_NESTED_PATTERNS = null;

        private DeconstructionPatternUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static ExpressionTree getDeconstructor(Tree tree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(21);
            if (GET_DECONSTRUCTOR == null) {
                Class deconstructionPatternClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.DeconstructionPatternTree");
                GET_DECONSTRUCTOR = TreeUtilsAfterJava11.getMethod(deconstructionPatternClass, "getDeconstructor");
            }
            return (ExpressionTree)TreeUtilsAfterJava11.invokeNonNullResult(DeconstructionPatternUtils.GET_DECONSTRUCTOR, tree);
        }

        public static List<? extends Tree> getNestedPatterns(Tree tree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(21);
            if (GET_NESTED_PATTERNS == null) {
                Class deconstructionPatternClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.DeconstructionPatternTree");
                GET_NESTED_PATTERNS = TreeUtilsAfterJava11.getMethod(deconstructionPatternClass, "getNestedPatterns");
            }
            return (List)TreeUtilsAfterJava11.invokeNonNullResult(DeconstructionPatternUtils.GET_NESTED_PATTERNS, tree);
        }
    }

    public static class ConstantCaseLabelUtils {
        private static @Nullable Method GET_CONSTANT_EXPRESSION = null;

        private ConstantCaseLabelUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static boolean isConstantCaseLabelTree(Tree tree) {
            return tree.getKind().name().contentEquals("CONSTANT_CASE_LABEL");
        }

        public static ExpressionTree getConstantExpression(Tree constantCaseLabelTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(21);
            if (GET_CONSTANT_EXPRESSION == null) {
                Class constantCaseLabelTreeClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.ConstantCaseLabelTree");
                GET_CONSTANT_EXPRESSION = TreeUtilsAfterJava11.getMethod(constantCaseLabelTreeClass, "getConstantExpression");
            }
            return (ExpressionTree)TreeUtilsAfterJava11.invokeNonNullResult(ConstantCaseLabelUtils.GET_CONSTANT_EXPRESSION, constantCaseLabelTree);
        }
    }

    public static class CaseUtils {
        private static @Nullable Method GET_EXPRESSIONS = null;
        private static @Nullable Method GET_BODY = null;
        private static @Nullable Method GET_KIND = null;
        private static @Nullable Method GET_LABELS = null;
        private static @Nullable Method GET_GUARD = null;

        private CaseUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static boolean isCaseRule(CaseTree caseTree) {
            if (sourceVersionNumber < 12) {
                return false;
            }
            if (GET_KIND == null) {
                GET_KIND = TreeUtilsAfterJava11.getMethod(CaseTree.class, "getCaseKind");
            }
            Enum kind = (Enum)TreeUtilsAfterJava11.invokeNonNullResult(CaseUtils.GET_KIND, caseTree);
            return kind.name().contentEquals("RULE");
        }

        public static @Nullable Tree getBody(CaseTree caseTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(12);
            if (GET_BODY == null) {
                GET_BODY = TreeUtilsAfterJava11.getMethod(CaseTree.class, "getBody");
            }
            return (Tree)TreeUtilsAfterJava11.invoke(CaseUtils.GET_BODY, caseTree);
        }

        public static boolean isDefaultCaseTree(CaseTree caseTree) {
            if (sourceVersionNumber >= 21) {
                for (Tree tree : CaseUtils.getLabels(caseTree, true)) {
                    if (!CaseUtils.isDefaultCaseLabelTree(tree)) continue;
                    return true;
                }
                return false;
            }
            return CaseUtils.getExpressions(caseTree).isEmpty();
        }

        public static boolean isDefaultCaseLabelTree(Tree tree) {
            return tree.getKind().name().contentEquals("DEFAULT_CASE_LABEL");
        }

        public static List<? extends Tree> getLabels(CaseTree caseTree) {
            return CaseUtils.getLabels(caseTree, false);
        }

        private static List<? extends Tree> getLabels(CaseTree caseTree, boolean useDefaultCaseLabelTree) {
            if (sourceVersionNumber >= 21) {
                if (GET_LABELS == null) {
                    GET_LABELS = TreeUtilsAfterJava11.getMethod(CaseTree.class, "getLabels");
                }
                List caseLabelTrees = (List)TreeUtilsAfterJava11.invokeNonNullResult(CaseUtils.GET_LABELS, caseTree);
                ArrayList<Tree> labels = new ArrayList<Tree>();
                for (Tree caseLabel : caseLabelTrees) {
                    if (CaseUtils.isDefaultCaseLabelTree(caseLabel)) {
                        if (!useDefaultCaseLabelTree) continue;
                        labels.add(caseLabel);
                        continue;
                    }
                    if (ConstantCaseLabelUtils.isConstantCaseLabelTree(caseLabel)) {
                        labels.add(ConstantCaseLabelUtils.getConstantExpression(caseLabel));
                        continue;
                    }
                    if (!PatternCaseLabelUtils.isPatternCaseLabelTree(caseLabel)) continue;
                    labels.add(PatternCaseLabelUtils.getPattern(caseLabel));
                }
                return labels;
            }
            return CaseUtils.getExpressions(caseTree);
        }

        public static List<? extends ExpressionTree> getExpressions(CaseTree caseTree) {
            if (sourceVersionNumber >= 12) {
                if (GET_EXPRESSIONS == null) {
                    GET_EXPRESSIONS = TreeUtilsAfterJava11.getMethod(CaseTree.class, "getExpressions");
                }
                return (List)TreeUtilsAfterJava11.invokeNonNullResult(CaseUtils.GET_EXPRESSIONS, caseTree);
            }
            ExpressionTree expression = caseTree.getExpression();
            if (expression == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(expression);
        }

        public static @Nullable ExpressionTree getGuard(CaseTree caseTree) {
            if (sourceVersionNumber < 21) {
                return null;
            }
            if (GET_GUARD == null) {
                GET_GUARD = TreeUtilsAfterJava11.getMethod(CaseTree.class, "getGuard");
            }
            return (ExpressionTree)TreeUtilsAfterJava11.invoke(CaseUtils.GET_GUARD, caseTree);
        }
    }

    public static class BindingPatternUtils {
        private static @Nullable Method GET_VARIABLE = null;

        private BindingPatternUtils() {
            throw new AssertionError((Object)"Cannot be instantiated.");
        }

        public static VariableTree getVariable(Tree bindingPatternTree) {
            TreeUtilsAfterJava11.assertVersionAtLeast(16);
            if (GET_VARIABLE == null) {
                Class bindingPatternClass = TreeUtilsAfterJava11.classForName("com.sun.source.tree.BindingPatternTree");
                GET_VARIABLE = TreeUtilsAfterJava11.getMethod(bindingPatternClass, "getVariable");
            }
            return (VariableTree)TreeUtilsAfterJava11.invokeNonNullResult(BindingPatternUtils.GET_VARIABLE, bindingPatternTree);
        }
    }
}

