/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.plumelib.util.StringsPlume;

public class ArrayCreationNode
extends Node {
    protected final @Nullable NewArrayTree tree;
    protected final List<Node> dimensions;
    protected final List<Node> initializers;

    public ArrayCreationNode(@Nullable NewArrayTree tree, TypeMirror type, List<Node> dimensions, List<Node> initializers) {
        super(type);
        this.tree = tree;
        this.dimensions = dimensions;
        this.initializers = initializers;
    }

    public List<Node> getDimensions() {
        return this.dimensions;
    }

    public Node getDimension(int i) {
        return this.dimensions.get(i);
    }

    public List<Node> getInitializers() {
        return this.initializers;
    }

    public Node getInitializer(int i) {
        return this.initializers.get(i);
    }

    @Override
    public @Nullable Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayCreation(this, p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new " + this.type);
        if (!this.dimensions.isEmpty()) {
            sb.append(" (");
            sb.append(StringsPlume.join((CharSequence)", ", this.dimensions));
            sb.append(")");
        }
        if (!this.initializers.isEmpty() || this.dimensions.isEmpty()) {
            sb.append(" {");
            sb.append(StringsPlume.join((CharSequence)", ", this.initializers));
            sb.append("}");
        }
        return sb.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayCreationNode)) {
            return false;
        }
        ArrayCreationNode other = (ArrayCreationNode)obj;
        return this.getDimensions().equals(other.getDimensions()) && this.getInitializers().equals(other.getInitializers());
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.initializers);
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(this.dimensions.size() + this.initializers.size());
        list.addAll(this.dimensions);
        list.addAll(this.initializers);
        return list;
    }
}

