/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.expression.FormalParameter;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionConverter;
import org.checkerframework.dataflow.expression.ThisReference;

public class ViewpointAdaptJavaExpression
extends JavaExpressionConverter {
    private final @Nullable List<JavaExpression> args;
    private final @Nullable JavaExpression thisReference;

    public static JavaExpression viewpointAdapt(JavaExpression javaExpr, @Nullable List<JavaExpression> args) {
        return ViewpointAdaptJavaExpression.viewpointAdapt(javaExpr, null, args);
    }

    public static JavaExpression viewpointAdapt(JavaExpression javaExpr, @Nullable JavaExpression thisReference) {
        return ViewpointAdaptJavaExpression.viewpointAdapt(javaExpr, thisReference, null);
    }

    public static JavaExpression viewpointAdapt(JavaExpression javaExpr, @Nullable JavaExpression thisReference, @Nullable List<JavaExpression> args) {
        return new ViewpointAdaptJavaExpression(thisReference, args).convert(javaExpr);
    }

    private ViewpointAdaptJavaExpression(@Nullable JavaExpression thisReference, @Nullable List<JavaExpression> args) {
        this.args = args;
        this.thisReference = thisReference;
    }

    @Override
    protected JavaExpression visitThisReference(ThisReference thisExpr, Void unused) {
        if (this.thisReference != null) {
            return this.thisReference;
        }
        return super.visitThisReference(thisExpr, unused);
    }

    @Override
    protected JavaExpression visitFormalParameter(FormalParameter parameterExpr, Void unused) {
        int index;
        if (this.args != null && (index = parameterExpr.getIndex() - 1) < this.args.size()) {
            return this.args.get(index);
        }
        return super.visitFormalParameter(parameterExpr, unused);
    }
}

