/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ReturnTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ReturnNode
extends Node {
    protected final ReturnTree returnTree;
    protected final @Nullable Node result;

    public ReturnNode(ReturnTree returnTree, @Nullable Node result, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.result = result;
        this.returnTree = returnTree;
    }

    public @Nullable Node getResult() {
        return this.result;
    }

    @Override
    public ReturnTree getTree() {
        return this.returnTree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitReturn(this, p);
    }

    public String toString() {
        if (this.result != null) {
            return "return " + this.result;
        }
        return "return";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ReturnNode)) {
            return false;
        }
        ReturnNode other = (ReturnNode)obj;
        return Objects.equals(this.result, other.result);
    }

    public int hashCode() {
        return Objects.hash(ReturnNode.class, this.result);
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        if (this.result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.result);
    }
}

