/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import com.sun.source.tree.Tree;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;

public class BinaryOperation
extends JavaExpression {
    protected final Tree.Kind operationKind;
    protected final JavaExpression left;
    protected final JavaExpression right;

    public BinaryOperation(TypeMirror type, Tree.Kind operationKind, JavaExpression left, JavaExpression right) {
        super(type);
        this.operationKind = operationKind;
        this.left = left;
        this.right = right;
    }

    public BinaryOperation(BinaryOperationNode node, JavaExpression left, JavaExpression right) {
        this(node.getType(), node.getTree().getKind(), left, right);
    }

    public Tree.Kind getOperationKind() {
        return this.operationKind;
    }

    public JavaExpression getLeft() {
        return this.left;
    }

    public JavaExpression getRight() {
        return this.right;
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        return this.left.containsOfClass(clazz) || this.right.containsOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.left.isDeterministic(provider) && this.right.isDeterministic(provider);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.left.isUnassignableByOtherCode() && this.right.isUnassignableByOtherCode();
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.left.isUnmodifiableByOtherCode() && this.right.isUnmodifiableByOtherCode();
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof BinaryOperation)) {
            return false;
        }
        BinaryOperation other = (BinaryOperation)je;
        return this.operationKind == other.getOperationKind() && this.left.syntacticEquals(other.left) && this.right.syntacticEquals(other.right);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.left.containsSyntacticEqualJavaExpression(other) || this.right.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return this.left.containsModifiableAliasOf(store, other) || this.right.containsModifiableAliasOf(store, other);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationKind, this.left, this.right});
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BinaryOperation)) {
            return false;
        }
        BinaryOperation biOp = (BinaryOperation)other;
        if (this.operationKind != biOp.getOperationKind()) {
            return false;
        }
        if (this.isCommutative()) {
            return this.left.equals(biOp.left) && this.right.equals(biOp.right) || this.left.equals(biOp.right) && this.right.equals(biOp.left);
        }
        return this.left.equals(biOp.left) && this.right.equals(biOp.right);
    }

    private boolean isCommutative() {
        switch (this.operationKind) {
            case PLUS: 
            case MULTIPLY: 
            case AND: 
            case OR: 
            case XOR: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.left.toString() + " " + this.operationKindToString(this.operationKind) + " " + this.right.toString();
    }

    private String operationKindToString(Tree.Kind operationKind) {
        switch (operationKind) {
            case CONDITIONAL_AND: {
                return "&&";
            }
            case AND: {
                return "&";
            }
            case OR: {
                return "|";
            }
            case DIVIDE: {
                return "/";
            }
            case EQUAL_TO: {
                return "==";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_EQUAL: {
                return ">=";
            }
            case LEFT_SHIFT: {
                return "<<";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_EQUAL: {
                return "<=";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case NOT_EQUAL_TO: {
                return "!=";
            }
            case CONDITIONAL_OR: {
                return "||";
            }
            case PLUS: {
                return "+";
            }
            case REMAINDER: {
                return "%";
            }
            case RIGHT_SHIFT: {
                return ">>";
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return ">>>";
            }
            case XOR: {
                return "^";
            }
        }
        throw new BugInCF("unhandled " + (Object)((Object)operationKind));
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitBinaryOperation(this, p);
    }
}

