/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.ClassDeclarationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.javacutil.TreeUtils;
import org.plumelib.util.StringsPlume;

public class ObjectCreationNode
extends Node {
    protected final NewClassTree tree;
    protected final Node constructor;
    protected final List<Node> arguments;
    protected final @Nullable ClassDeclarationNode classbody;

    public ObjectCreationNode(NewClassTree tree, Node constructor, List<Node> arguments, @Nullable ClassDeclarationNode classbody) {
        super(TreeUtils.typeOf((Tree)tree));
        this.tree = tree;
        this.constructor = constructor;
        this.arguments = arguments;
        this.classbody = classbody;
    }

    public Node getConstructor() {
        return this.constructor;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    public @Nullable Node getClassBody() {
        return this.classbody;
    }

    @Override
    public NewClassTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitObjectCreation(this, p);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new " + this.constructor + "(");
        sb.append(StringsPlume.join((CharSequence)", ", this.arguments));
        sb.append(")");
        if (this.classbody != null) {
            sb.append(" ");
            sb.append(this.classbody.toString());
        }
        return sb.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ObjectCreationNode)) {
            return false;
        }
        ObjectCreationNode other = (ObjectCreationNode)obj;
        if (this.constructor == null && other.getConstructor() != null) {
            return false;
        }
        return this.getConstructor().equals(other.getConstructor()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        return Objects.hash(this.constructor, this.arguments);
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(1 + this.arguments.size());
        list.add(this.constructor);
        list.addAll(this.arguments);
        return list;
    }
}

