/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.javacutil.TreeUtils;

public class ArrayAccessNode
extends Node {
    protected final Tree tree;
    protected final Node array;
    protected final Node index;
    protected @Nullable ExpressionTree arrayExpression;

    public ArrayAccessNode(Tree t, Node array, Node index) {
        super(TreeUtils.typeOf((Tree)t));
        assert (t instanceof ArrayAccessTree);
        this.tree = t;
        this.array = array;
        this.index = index;
    }

    public @Nullable ExpressionTree getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(@Nullable ExpressionTree arrayExpression) {
        this.arrayExpression = arrayExpression;
    }

    public Node getArray() {
        return this.array;
    }

    public Node getIndex() {
        return this.index;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayAccess(this, p);
    }

    public String toString() {
        String base = this.getArray().toString() + "[" + this.getIndex() + "]";
        return base;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayAccessNode)) {
            return false;
        }
        ArrayAccessNode other = (ArrayAccessNode)obj;
        return this.getArray().equals(other.getArray()) && this.getIndex().equals(other.getIndex());
    }

    public int hashCode() {
        return Objects.hash(this.getArray(), this.getIndex());
    }

    @Override
    public Collection<Node> getOperands() {
        return Arrays.asList(this.getArray(), this.getIndex());
    }
}

