/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlockImpl;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ReturnNode;

public class ControlFlowGraph {
    protected final SpecialBlock entryBlock;
    protected final SpecialBlock regularExitBlock;
    protected final SpecialBlock exceptionalExitBlock;
    protected UnderlyingAST underlyingAST;
    protected IdentityHashMap<Tree, Node> treeLookup;
    protected IdentityHashMap<Tree, Node> convertedTreeLookup;
    protected IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup;
    protected final List<ReturnNode> returnNodes;
    protected final IdentityHashMap<Tree, List<Tree>> generatedTreesLookupMap;

    public ControlFlowGraph(SpecialBlock entryBlock, SpecialBlockImpl regularExitBlock, SpecialBlockImpl exceptionalExitBlock, UnderlyingAST underlyingAST, IdentityHashMap<Tree, Node> treeLookup, IdentityHashMap<Tree, Node> convertedTreeLookup, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup, List<ReturnNode> returnNodes, IdentityHashMap<Tree, List<Tree>> generatedTreesLookupMap) {
        this.entryBlock = entryBlock;
        this.underlyingAST = underlyingAST;
        this.treeLookup = treeLookup;
        this.unaryAssignNodeLookup = unaryAssignNodeLookup;
        this.convertedTreeLookup = convertedTreeLookup;
        this.regularExitBlock = regularExitBlock;
        this.exceptionalExitBlock = exceptionalExitBlock;
        this.returnNodes = returnNodes;
        this.generatedTreesLookupMap = generatedTreesLookupMap;
    }

    public Node getNodeCorrespondingToTree(Tree t) {
        if (this.convertedTreeLookup.containsKey(t)) {
            return this.convertedTreeLookup.get(t);
        }
        return this.treeLookup.get(t);
    }

    public SpecialBlock getEntryBlock() {
        return this.entryBlock;
    }

    public List<ReturnNode> getReturnNodes() {
        return this.returnNodes;
    }

    public SpecialBlock getRegularExitBlock() {
        return this.regularExitBlock;
    }

    public SpecialBlock getExceptionalExitBlock() {
        return this.exceptionalExitBlock;
    }

    public UnderlyingAST getUnderlyingAST() {
        return this.underlyingAST;
    }

    public Set<Block> getAllBlocks() {
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> worklist = new LinkedList<Block>();
        Block cur = this.entryBlock;
        visited.add(this.entryBlock);
        while (cur != null) {
            LinkedList<Block> succs = new LinkedList<Block>();
            if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                ConditionalBlock ccur = (ConditionalBlock)cur;
                succs.add(ccur.getThenSuccessor());
                succs.add(ccur.getElseSuccessor());
            } else {
                assert (cur instanceof SingleSuccessorBlock);
                Block b = ((SingleSuccessorBlock)cur).getSuccessor();
                if (b != null) {
                    succs.add(b);
                }
            }
            if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
                ExceptionBlock ecur = (ExceptionBlock)cur;
                for (Set<Block> exceptionSuccSet : ecur.getExceptionalSuccessors().values()) {
                    succs.addAll(exceptionSuccSet);
                }
            }
            for (Block b : succs) {
                if (visited.contains(b)) continue;
                visited.add(b);
                worklist.add(b);
            }
            cur = (Block)worklist.poll();
        }
        return visited;
    }

    public List<Block> getDepthFirstOrderedBlocks() {
        LinkedList<Block> dfsOrderResult = new LinkedList<Block>();
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> worklist = new LinkedList<Block>();
        worklist.add(this.entryBlock);
        while (!worklist.isEmpty()) {
            Block cur = (Block)worklist.getLast();
            if (visited.contains(cur)) {
                dfsOrderResult.add(cur);
                worklist.removeLast();
                continue;
            }
            visited.add(cur);
            Deque<Block> successors = this.getSuccessors(cur);
            successors.removeAll(visited);
            worklist.addAll(successors);
        }
        Collections.reverse(dfsOrderResult);
        return dfsOrderResult;
    }

    private Deque<Block> getSuccessors(Block cur) {
        LinkedList<Block> succs = new LinkedList<Block>();
        if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
            ConditionalBlock ccur = (ConditionalBlock)cur;
            succs.add(ccur.getThenSuccessor());
            succs.add(ccur.getElseSuccessor());
        } else {
            assert (cur instanceof SingleSuccessorBlock);
            Block b = ((SingleSuccessorBlock)cur).getSuccessor();
            if (b != null) {
                succs.add(b);
            }
        }
        if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
            ExceptionBlock ecur = (ExceptionBlock)cur;
            for (Set<Block> exceptionSuccSet : ecur.getExceptionalSuccessors().values()) {
                succs.addAll(exceptionSuccSet);
            }
        }
        return succs;
    }

    public IdentityHashMap<Tree, Node> getTreeLookup() {
        return new IdentityHashMap<Tree, Node>(this.treeLookup);
    }

    public IdentityHashMap<UnaryTree, AssignmentNode> getUnaryAssignNodeLookup() {
        return new IdentityHashMap<UnaryTree, AssignmentNode>(this.unaryAssignNodeLookup);
    }

    public IdentityHashMap<Tree, List<Tree>> getGeneratedTreesLookup() {
        return new IdentityHashMap<Tree, List<Tree>>(this.generatedTreesLookupMap);
    }

    public MethodTree getContainingMethod(Tree t) {
        if (this.treeLookup.containsKey(t) && this.underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)this.underlyingAST;
            return cfgMethod.getMethod();
        }
        return null;
    }

    public ClassTree getContainingClass(Tree t) {
        if (this.treeLookup.containsKey(t) && this.underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)this.underlyingAST;
            return cfgMethod.getClassTree();
        }
        return null;
    }
}

