/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import java.util.Objects;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.Receiver;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.TypesUtils;

public class FieldAccess
extends Receiver {
    protected final Receiver receiver;
    protected final VariableElement field;

    public Receiver getReceiver() {
        return this.receiver;
    }

    public VariableElement getField() {
        return this.field;
    }

    public FieldAccess(Receiver receiver, FieldAccessNode node) {
        super(node.getType());
        this.receiver = receiver;
        this.field = node.getElement();
    }

    public FieldAccess(Receiver receiver, TypeMirror type, VariableElement fieldElement) {
        super(type);
        this.receiver = receiver;
        this.field = fieldElement;
    }

    public boolean isFinal() {
        return ElementUtils.isFinal(this.field);
    }

    public boolean isStatic() {
        return ElementUtils.isStatic(this.field);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof FieldAccess)) {
            return false;
        }
        FieldAccess fa = (FieldAccess)obj;
        return fa.getField().equals(this.getField()) && fa.getReceiver().equals(this.getReceiver());
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.getReceiver());
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
        return super.containsModifiableAliasOf(store, other) || this.receiver.containsModifiableAliasOf(store, other);
    }

    @Override
    public boolean containsSyntacticEqualReceiver(Receiver other) {
        return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualReceiver(other);
    }

    @Override
    public boolean syntacticEquals(Receiver other) {
        if (!(other instanceof FieldAccess)) {
            return false;
        }
        FieldAccess fa = (FieldAccess)other;
        return super.syntacticEquals(other) || fa.getField().equals(this.getField()) && fa.getReceiver().syntacticEquals(this.getReceiver());
    }

    public String toString() {
        if (this.receiver instanceof ClassName) {
            return this.receiver.getType() + "." + this.field;
        }
        return this.receiver + "." + this.field;
    }

    @Override
    public boolean containsOfClass(Class<? extends Receiver> clazz) {
        return this.getClass() == clazz || this.receiver.containsOfClass(clazz);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.isFinal() && this.getReceiver().isUnassignableByOtherCode();
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.isUnassignableByOtherCode() && TypesUtils.isImmutableTypeInJdk(this.getReceiver().type);
    }
}

