/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.expression.Receiver;

public class ArrayAccess
extends Receiver {
    protected final Receiver receiver;
    protected final Receiver index;

    public ArrayAccess(TypeMirror type, Receiver receiver, Receiver index) {
        super(type);
        this.receiver = receiver;
        this.index = index;
    }

    @Override
    public boolean containsOfClass(Class<? extends Receiver> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        if (this.receiver.containsOfClass(clazz)) {
            return true;
        }
        return this.index.containsOfClass(clazz);
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public Receiver getIndex() {
        return this.index;
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return false;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return false;
    }

    @Override
    public boolean containsSyntacticEqualReceiver(Receiver other) {
        return this.syntacticEquals(other) || this.receiver.syntacticEquals(other) || this.index.syntacticEquals(other);
    }

    @Override
    public boolean syntacticEquals(Receiver other) {
        if (!(other instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess otherArrayAccess = (ArrayAccess)other;
        if (!this.receiver.syntacticEquals(otherArrayAccess.receiver)) {
            return false;
        }
        return this.index.syntacticEquals(otherArrayAccess.index);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
        if (this.receiver.containsModifiableAliasOf(store, other)) {
            return true;
        }
        return this.index.containsModifiableAliasOf(store, other);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)obj;
        return this.receiver.equals(other.receiver) && this.index.equals(other.index);
    }

    public int hashCode() {
        return Objects.hash(this.receiver, this.index);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.receiver.toString());
        result.append("[");
        result.append(this.index.toString());
        result.append("]");
        return result.toString();
    }
}

