/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import javax.lang.model.element.VariableElement;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.expression.JavaExpression;
import org.checkerframework.shaded.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.shaded.dataflow.expression.LocalVariable;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.TypeAnnotationUtils;

public class FormalParameter
extends JavaExpression {
    protected final int index;
    protected final VariableElement element;

    public FormalParameter(int index, VariableElement element) {
        super(ElementUtils.getType(element));
        this.index = index;
        this.element = element;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof FormalParameter)) {
            return false;
        }
        FormalParameter other = (FormalParameter)obj;
        return this.index == other.index && LocalVariable.sameElement(this.element, other.element);
    }

    public int getIndex() {
        return this.index;
    }

    public VariableElement getElement() {
        return this.element;
    }

    public int hashCode() {
        Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
        return Objects.hash(this.index, vs.name.toString(), TypeAnnotationUtils.unannotatedType(vs.type).toString(), vs.owner.toString());
    }

    public String toString() {
        return "#" + this.index;
    }

    @Override
    public String toStringDebug() {
        return super.toStringDebug() + " [element=" + this.element + ", owner=" + ((Symbol.VarSymbol)this.element).owner + "]";
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        return (T)(this.getClass() == clazz ? this : null);
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof FormalParameter)) {
            return false;
        }
        FormalParameter other = (FormalParameter)je;
        return this.index == other.index;
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other);
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return false;
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return false;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return true;
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitFormalParameter(this, p);
    }
}

