/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.util;

import java.util.Collections;
import java.util.IdentityHashMap;
import org.checkerframework.shaded.checker.interning.qual.FindDistinct;
import org.checkerframework.shaded.dataflow.util.AbstractMostlySingleton;
import org.checkerframework.shaded.javacutil.BugInCF;

public final class IdentityMostlySingleton<T>
extends AbstractMostlySingleton<T> {
    public IdentityMostlySingleton() {
        super(AbstractMostlySingleton.State.EMPTY);
    }

    public IdentityMostlySingleton(T value) {
        super(AbstractMostlySingleton.State.SINGLETON, value);
    }

    @Override
    public boolean add(@FindDistinct T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingleton.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                if (this.value == e) {
                    return false;
                }
                this.makeNonSingleton();
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    private void makeNonSingleton() {
        this.state = AbstractMostlySingleton.State.ANY;
        this.set = Collections.newSetFromMap(new IdentityHashMap(4));
        assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
        this.set.add(this.value);
        this.value = null;
    }

    @Override
    public boolean contains(Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }
}

