/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;

public class NotEqualNode
extends BinaryOperationNode {
    public NotEqualNode(BinaryTree tree, Node left, Node right) {
        super(tree, left, right);
        assert (tree.getKind() == Tree.Kind.NOT_EQUAL_TO);
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitNotEqual(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " != " + this.getRightOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NotEqualNode)) {
            return false;
        }
        NotEqualNode other = (NotEqualNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

