/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.builder;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.dataflow.qual.TerminatesExecution;
import org.checkerframework.shaded.checker.interning.qual.FindDistinct;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.UnderlyingAST;
import org.checkerframework.shaded.dataflow.cfg.builder.CFGBuilder;
import org.checkerframework.shaded.dataflow.cfg.builder.ConditionalJump;
import org.checkerframework.shaded.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.shaded.dataflow.cfg.builder.Label;
import org.checkerframework.shaded.dataflow.cfg.builder.NodeHolder;
import org.checkerframework.shaded.dataflow.cfg.builder.NodeWithExceptionsHolder;
import org.checkerframework.shaded.dataflow.cfg.builder.PhaseOneResult;
import org.checkerframework.shaded.dataflow.cfg.builder.TreeInfo;
import org.checkerframework.shaded.dataflow.cfg.builder.TryCatchFrame;
import org.checkerframework.shaded.dataflow.cfg.builder.TryFinallyFrame;
import org.checkerframework.shaded.dataflow.cfg.builder.TryFinallyScopeCell;
import org.checkerframework.shaded.dataflow.cfg.builder.TryFinallyScopeMap;
import org.checkerframework.shaded.dataflow.cfg.builder.TryStack;
import org.checkerframework.shaded.dataflow.cfg.builder.UnconditionalJump;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.shaded.dataflow.cfg.node.ArrayTypeNode;
import org.checkerframework.shaded.dataflow.cfg.node.AssertionErrorNode;
import org.checkerframework.shaded.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.shaded.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.shaded.dataflow.cfg.node.BitwiseAndNode;
import org.checkerframework.shaded.dataflow.cfg.node.BitwiseComplementNode;
import org.checkerframework.shaded.dataflow.cfg.node.BitwiseOrNode;
import org.checkerframework.shaded.dataflow.cfg.node.BitwiseXorNode;
import org.checkerframework.shaded.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.CaseNode;
import org.checkerframework.shaded.dataflow.cfg.node.CharacterLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.ClassDeclarationNode;
import org.checkerframework.shaded.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.shaded.dataflow.cfg.node.ConditionalAndNode;
import org.checkerframework.shaded.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.shaded.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.shaded.dataflow.cfg.node.DoubleLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.EqualToNode;
import org.checkerframework.shaded.dataflow.cfg.node.ExplicitThisNode;
import org.checkerframework.shaded.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.FloatLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.FloatingDivisionNode;
import org.checkerframework.shaded.dataflow.cfg.node.FloatingRemainderNode;
import org.checkerframework.shaded.dataflow.cfg.node.FunctionalInterfaceNode;
import org.checkerframework.shaded.dataflow.cfg.node.GreaterThanNode;
import org.checkerframework.shaded.dataflow.cfg.node.GreaterThanOrEqualNode;
import org.checkerframework.shaded.dataflow.cfg.node.ImplicitThisNode;
import org.checkerframework.shaded.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.shaded.dataflow.cfg.node.IntegerDivisionNode;
import org.checkerframework.shaded.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.IntegerRemainderNode;
import org.checkerframework.shaded.dataflow.cfg.node.LambdaResultExpressionNode;
import org.checkerframework.shaded.dataflow.cfg.node.LeftShiftNode;
import org.checkerframework.shaded.dataflow.cfg.node.LessThanNode;
import org.checkerframework.shaded.dataflow.cfg.node.LessThanOrEqualNode;
import org.checkerframework.shaded.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.shaded.dataflow.cfg.node.LongLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.MarkerNode;
import org.checkerframework.shaded.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.shaded.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.shaded.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.shaded.dataflow.cfg.node.NullChkNode;
import org.checkerframework.shaded.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.shaded.dataflow.cfg.node.NumericalMinusNode;
import org.checkerframework.shaded.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.shaded.dataflow.cfg.node.NumericalPlusNode;
import org.checkerframework.shaded.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.shaded.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.shaded.dataflow.cfg.node.PackageNameNode;
import org.checkerframework.shaded.dataflow.cfg.node.ParameterizedTypeNode;
import org.checkerframework.shaded.dataflow.cfg.node.PrimitiveTypeNode;
import org.checkerframework.shaded.dataflow.cfg.node.ReturnNode;
import org.checkerframework.shaded.dataflow.cfg.node.SignedRightShiftNode;
import org.checkerframework.shaded.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.shaded.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.shaded.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.shaded.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.SuperNode;
import org.checkerframework.shaded.dataflow.cfg.node.SynchronizedNode;
import org.checkerframework.shaded.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.shaded.dataflow.cfg.node.ThisNode;
import org.checkerframework.shaded.dataflow.cfg.node.ThrowNode;
import org.checkerframework.shaded.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.shaded.dataflow.cfg.node.UnsignedRightShiftNode;
import org.checkerframework.shaded.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.shaded.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.shaded.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.shaded.dataflow.util.IdentityMostlySingleton;
import org.checkerframework.shaded.javacutil.AnnotationProvider;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.Pair;
import org.checkerframework.shaded.javacutil.TreePathUtil;
import org.checkerframework.shaded.javacutil.TreeUtils;
import org.checkerframework.shaded.javacutil.TypeKindUtils;
import org.checkerframework.shaded.javacutil.TypesUtils;
import org.checkerframework.shaded.javacutil.trees.TreeBuilder;
import org.checkerframework.shaded.org.plumelib.util.CollectionsPlume;

public class CFGTranslationPhaseOne
extends TreePathScanner<Node, Void> {
    final ProcessingEnvironment env;
    final Elements elements;
    final Types types;
    final Trees trees;
    public final TreeBuilder treeBuilder;
    final AnnotationProvider annotationProvider;
    final boolean assumeAssertionsDisabled;
    final boolean assumeAssertionsEnabled;
    final Label regularExitLabel;
    final Label exceptionalExitLabel;
    @Nullable TryFinallyScopeCell returnTargetL;
    @Nullable TryFinallyScopeCell breakTargetL;
    Map<Name, Label> breakLabels;
    @Nullable TryFinallyScopeCell continueTargetL;
    Map<Name, Label> continueLabels;
    private final TryStack tryStack;
    final IdentityHashMap<Tree, Set<Node>> treeLookupMap;
    final IdentityHashMap<Tree, Set<Node>> convertedTreeLookupMap;
    final IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookupMap;
    final ArrayList<ExtendedNode> nodeList;
    final Map<Label, Integer> bindings;
    final Set<Integer> leaders;
    private final List<ReturnNode> returnNodes;
    final List<ClassTree> declaredClasses;
    final List<LambdaExpressionTree> declaredLambdas;
    final TypeMirror arithmeticExceptionType;
    final TypeMirror arrayIndexOutOfBoundsExceptionType;
    final TypeMirror assertionErrorType;
    final TypeMirror classCastExceptionType;
    final TypeMirror iterableType;
    final TypeMirror negativeArraySizeExceptionType;
    final TypeMirror nullPointerExceptionType;
    final @Nullable TypeMirror outOfMemoryErrorType;
    final @Nullable TypeMirror classCircularityErrorType;
    final @Nullable TypeMirror classFormatErrorType;
    final @Nullable TypeMirror noClassDefFoundErrorType;
    final TypeMirror stringType;
    final TypeMirror throwableType;
    final Set<TypeMirror> uncheckedExceptionTypes;
    final Set<TypeMirror> newArrayExceptionTypes;
    protected long uid = 0L;
    protected VariableTree ea = null;
    private final Map<Tree, ParenthesizedTree> parenMapping = new HashMap<Tree, ParenthesizedTree>();

    public CFGTranslationPhaseOne(TreeBuilder treeBuilder, AnnotationProvider annotationProvider, boolean assumeAssertionsEnabled, boolean assumeAssertionsDisabled, ProcessingEnvironment env) {
        this.env = env;
        this.treeBuilder = treeBuilder;
        this.annotationProvider = annotationProvider;
        assert (!assumeAssertionsDisabled || !assumeAssertionsEnabled);
        this.assumeAssertionsEnabled = assumeAssertionsEnabled;
        this.assumeAssertionsDisabled = assumeAssertionsDisabled;
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.trees = Trees.instance(env);
        this.treeLookupMap = new IdentityHashMap();
        this.convertedTreeLookupMap = new IdentityHashMap();
        this.unaryAssignNodeLookupMap = new IdentityHashMap();
        this.nodeList = new ArrayList();
        this.bindings = new HashMap<Label, Integer>();
        this.leaders = new HashSet<Integer>();
        this.regularExitLabel = new Label();
        this.exceptionalExitLabel = new Label();
        this.tryStack = new TryStack(this.exceptionalExitLabel);
        this.returnTargetL = new TryFinallyScopeCell(this.regularExitLabel);
        this.breakLabels = new HashMap<Name, Label>(2);
        this.continueLabels = new HashMap<Name, Label>(2);
        this.returnNodes = new ArrayList<ReturnNode>();
        this.declaredClasses = new ArrayList<ClassTree>();
        this.declaredLambdas = new ArrayList<LambdaExpressionTree>();
        this.arithmeticExceptionType = this.getTypeMirror(ArithmeticException.class);
        this.arrayIndexOutOfBoundsExceptionType = this.getTypeMirror(ArrayIndexOutOfBoundsException.class);
        this.assertionErrorType = this.getTypeMirror(AssertionError.class);
        this.classCastExceptionType = this.getTypeMirror(ClassCastException.class);
        this.iterableType = this.types.erasure(this.getTypeMirror(Iterable.class));
        this.negativeArraySizeExceptionType = this.getTypeMirror(NegativeArraySizeException.class);
        this.nullPointerExceptionType = this.getTypeMirror(NullPointerException.class);
        this.outOfMemoryErrorType = this.maybeGetTypeMirror(OutOfMemoryError.class);
        this.classCircularityErrorType = this.maybeGetTypeMirror(ClassCircularityError.class);
        this.classFormatErrorType = this.maybeGetTypeMirror(ClassFormatError.class);
        this.noClassDefFoundErrorType = this.maybeGetTypeMirror(NoClassDefFoundError.class);
        this.stringType = this.getTypeMirror(String.class);
        this.throwableType = this.getTypeMirror(Throwable.class);
        this.uncheckedExceptionTypes = new LinkedHashSet<TypeMirror>(2);
        this.uncheckedExceptionTypes.add(this.getTypeMirror(RuntimeException.class));
        this.uncheckedExceptionTypes.add(this.getTypeMirror(Error.class));
        this.newArrayExceptionTypes = new LinkedHashSet<TypeMirror>(2);
        this.newArrayExceptionTypes.add(this.negativeArraySizeExceptionType);
        if (this.outOfMemoryErrorType != null) {
            this.newArrayExceptionTypes.add(this.outOfMemoryErrorType);
        }
    }

    public PhaseOneResult process(TreePath bodyPath, UnderlyingAST underlyingAST) {
        LambdaExpressionTree lambdaTree;
        Node finalNode = (Node)this.scan(bodyPath, null);
        if (underlyingAST.getKind() == UnderlyingAST.Kind.LAMBDA && (lambdaTree = ((UnderlyingAST.CFGLambda)underlyingAST).getLambdaTree()).getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            LambdaResultExpressionNode resultNode = new LambdaResultExpressionNode((ExpressionTree)lambdaTree.getBody(), finalNode, this.env.getTypeUtils());
            this.extendWithNode(resultNode);
        }
        this.nodeList.add(new UnconditionalJump(this.regularExitLabel));
        return new PhaseOneResult(underlyingAST, this.treeLookupMap, this.convertedTreeLookupMap, this.unaryAssignNodeLookupMap, this.nodeList, this.bindings, this.leaders, this.returnNodes, this.regularExitLabel, this.exceptionalExitLabel, this.declaredClasses, this.declaredLambdas);
    }

    public PhaseOneResult process(CompilationUnitTree root, UnderlyingAST underlyingAST) {
        TreePath bodyPath = this.trees.getPath(root, underlyingAST.getCode());
        assert (bodyPath != null);
        return this.process(bodyPath, underlyingAST);
    }

    public void handleArtificialTree(Tree tree) {
    }

    protected void addToLookupMap(Node node) {
        Tree tree = node.getTree();
        if (tree == null) {
            return;
        }
        Set<Node> existing = this.treeLookupMap.get(tree);
        if (existing == null) {
            this.treeLookupMap.put(tree, new IdentityMostlySingleton<Node>(node));
        } else {
            existing.add(node);
        }
        Tree enclosingParens = this.parenMapping.get(tree);
        while (enclosingParens != null) {
            Set<Node> exp = this.treeLookupMap.get(enclosingParens);
            if (exp == null) {
                this.treeLookupMap.put(enclosingParens, new IdentityMostlySingleton<Node>(node));
            } else if (!existing.contains(node)) {
                exp.add(node);
            }
            enclosingParens = this.parenMapping.get(enclosingParens);
        }
    }

    protected void addToConvertedLookupMap(Node node) {
        Tree tree = node.getTree();
        this.addToConvertedLookupMap(tree, node);
    }

    protected void addToConvertedLookupMap(Tree tree, Node node) {
        assert (tree != null);
        assert (this.treeLookupMap.containsKey(tree));
        Set<Node> existing = this.convertedTreeLookupMap.get(tree);
        if (existing == null) {
            this.convertedTreeLookupMap.put(tree, new IdentityMostlySingleton<Node>(node));
        } else {
            existing.add(node);
        }
    }

    protected void addToUnaryAssignLookupMap(UnaryTree tree, AssignmentNode unaryAssignNode) {
        this.unaryAssignNodeLookupMap.put(tree, unaryAssignNode);
    }

    protected void extendWithNode(Node node) {
        this.addToLookupMap(node);
        this.extendWithExtendedNode(new NodeHolder(node));
    }

    protected NodeWithExceptionsHolder extendWithNodeWithException(Node node, TypeMirror cause) {
        this.addToLookupMap(node);
        return this.extendWithNodeWithExceptions(node, Collections.singleton(cause));
    }

    protected NodeWithExceptionsHolder extendWithNodeWithExceptions(Node node, Set<TypeMirror> causes) {
        this.addToLookupMap(node);
        LinkedHashMap<TypeMirror, Set<Label>> exceptions = new LinkedHashMap<TypeMirror, Set<Label>>(causes.size());
        for (TypeMirror cause : causes) {
            exceptions.put(cause, this.tryStack.possibleLabels(cause));
        }
        NodeWithExceptionsHolder exNode = new NodeWithExceptionsHolder(node, exceptions);
        this.extendWithExtendedNode(exNode);
        return exNode;
    }

    protected NodeWithExceptionsHolder extendWithClassNameNode(ClassNameNode node) {
        LinkedHashSet<TypeMirror> thrownSet = new LinkedHashSet<TypeMirror>(4);
        if (this.classCircularityErrorType != null) {
            thrownSet.add(this.classCircularityErrorType);
        }
        if (this.classFormatErrorType != null) {
            thrownSet.add(this.classFormatErrorType);
        }
        if (this.noClassDefFoundErrorType != null) {
            thrownSet.add(this.noClassDefFoundErrorType);
        }
        if (this.outOfMemoryErrorType != null) {
            thrownSet.add(this.outOfMemoryErrorType);
        }
        return this.extendWithNodeWithExceptions(node, thrownSet);
    }

    protected <T extends Node> T insertNodeAfter(T node, Node pred) {
        this.addToLookupMap(node);
        this.insertExtendedNodeAfter(new NodeHolder(node), pred);
        return node;
    }

    protected NodeWithExceptionsHolder insertNodeWithExceptionsAfter(Node node, Set<TypeMirror> causes, Node pred) {
        this.addToLookupMap(node);
        LinkedHashMap<TypeMirror, Set<Label>> exceptions = new LinkedHashMap<TypeMirror, Set<Label>>(causes.size());
        for (TypeMirror cause : causes) {
            exceptions.put(cause, this.tryStack.possibleLabels(cause));
        }
        NodeWithExceptionsHolder exNode = new NodeWithExceptionsHolder(node, exceptions);
        this.insertExtendedNodeAfter(exNode, pred);
        return exNode;
    }

    protected void extendWithExtendedNode(ExtendedNode n) {
        this.nodeList.add(n);
    }

    protected void insertExtendedNodeAfter(ExtendedNode n, @FindDistinct Node pred) {
        int index = -1;
        for (int i = 0; i < this.nodeList.size(); ++i) {
            ExtendedNode inList = this.nodeList.get(i);
            if (!(inList instanceof NodeHolder) && !(inList instanceof NodeWithExceptionsHolder) || inList.getNode() != pred) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.nodeList.add(index + 1, n);
            for (Map.Entry<Label, Integer> e : this.bindings.entrySet()) {
                if (e.getValue() < index + 1) continue;
                this.bindings.put(e.getKey(), e.getValue() + 1);
            }
            HashSet<Integer> oldLeaders = new HashSet<Integer>(this.leaders);
            this.leaders.clear();
            for (Integer l : oldLeaders) {
                if (l >= index + 1) {
                    this.leaders.add(l + 1);
                    continue;
                }
                this.leaders.add(l);
            }
        } else {
            this.nodeList.add(n);
        }
    }

    protected void addLabelForNextNode(Label l) {
        assert (!this.bindings.containsKey(l));
        this.leaders.add(this.nodeList.size());
        this.bindings.put(l, this.nodeList.size());
    }

    protected String uniqueName(String prefix) {
        return prefix + "#num" + this.uid++;
    }

    protected Node box(Node node) {
        if (TypesUtils.isPrimitive(node.getType())) {
            PrimitiveType primitive = this.types.getPrimitiveType(node.getType().getKind());
            DeclaredType boxedType = this.types.getDeclaredType(this.types.boxedClass(primitive), new TypeMirror[0]);
            TypeElement boxedElement = (TypeElement)boxedType.asElement();
            IdentifierTree classTree = this.treeBuilder.buildClassUse(boxedElement);
            this.handleArtificialTree(classTree);
            ClassNameNode className = new ClassNameNode(classTree);
            className.setInSource(false);
            this.insertNodeAfter(className, node);
            MemberSelectTree valueOfSelect = this.treeBuilder.buildValueOfMethodAccess(classTree);
            this.handleArtificialTree(valueOfSelect);
            MethodAccessNode valueOfAccess = new MethodAccessNode(valueOfSelect, className);
            valueOfAccess.setInSource(false);
            this.insertNodeAfter(valueOfAccess, className);
            MethodInvocationTree valueOfCall = this.treeBuilder.buildMethodInvocation(valueOfSelect, (ExpressionTree)node.getTree());
            this.handleArtificialTree(valueOfCall);
            MethodInvocationNode boxed = new MethodInvocationNode(valueOfCall, valueOfAccess, Collections.singletonList(node), this.getCurrentPath());
            boxed.setInSource(false);
            this.addToConvertedLookupMap(node.getTree(), boxed);
            this.insertNodeWithExceptionsAfter(boxed, this.uncheckedExceptionTypes, valueOfAccess);
            return boxed;
        }
        return node;
    }

    protected Node unbox(Node node) {
        if (TypesUtils.isBoxedPrimitive(node.getType())) {
            MemberSelectTree primValueSelect = this.treeBuilder.buildPrimValueMethodAccess(node.getTree());
            this.handleArtificialTree(primValueSelect);
            MethodAccessNode primValueAccess = new MethodAccessNode(primValueSelect, node);
            primValueAccess.setInSource(false);
            this.insertNodeWithExceptionsAfter(primValueAccess, Collections.singleton(this.nullPointerExceptionType), node);
            MethodInvocationTree primValueCall = this.treeBuilder.buildMethodInvocation(primValueSelect);
            this.handleArtificialTree(primValueCall);
            MethodInvocationNode unboxed = new MethodInvocationNode(primValueCall, primValueAccess, Collections.emptyList(), this.getCurrentPath());
            unboxed.setInSource(false);
            this.addToConvertedLookupMap(node.getTree(), unboxed);
            this.insertNodeWithExceptionsAfter(unboxed, this.uncheckedExceptionTypes, primValueAccess);
            return unboxed;
        }
        return node;
    }

    private TreeInfo getTreeInfo(Tree tree) {
        TypeMirror type = TreeUtils.typeOf(tree);
        final boolean boxed = TypesUtils.isBoxedPrimitive(type);
        final TypeMirror unboxedType = boxed ? this.types.unboxedType(type) : type;
        final boolean bool = TypesUtils.isBooleanType(type);
        final boolean numeric = TypesUtils.isNumeric(unboxedType);
        return new TreeInfo(){

            @Override
            public boolean isNumeric() {
                return numeric;
            }

            @Override
            public boolean isBoxed() {
                return boxed;
            }

            @Override
            public boolean isBoolean() {
                return bool;
            }

            @Override
            public TypeMirror unboxedType() {
                return unboxedType;
            }
        };
    }

    private Node unboxAsNeeded(Node node, boolean boxed) {
        return boxed ? this.unbox(node) : node;
    }

    protected Node stringConversion(Node node) {
        if (!TypesUtils.isString(node.getType())) {
            StringConversionNode converted = new StringConversionNode(node.getTree(), node, this.stringType);
            this.addToConvertedLookupMap(converted);
            this.insertNodeAfter(converted, node);
            return converted;
        }
        return node;
    }

    protected Node unaryNumericPromotion(Node node) {
        node = this.unbox(node);
        switch (node.getType().getKind()) {
            case BYTE: 
            case CHAR: 
            case SHORT: {
                PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
                WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, intType);
                this.addToConvertedLookupMap(widened);
                this.insertNodeAfter(widened, node);
                return widened;
            }
        }
        return node;
    }

    protected boolean isNumericOrBoxed(TypeMirror type) {
        if (TypesUtils.isBoxedPrimitive(type)) {
            type = this.types.unboxedType(type);
        }
        return TypesUtils.isNumeric(type);
    }

    protected TypeMirror binaryPromotedType(TypeMirror left, TypeMirror right) {
        if (TypesUtils.isBoxedPrimitive(left)) {
            left = this.types.unboxedType(left);
        }
        if (TypesUtils.isBoxedPrimitive(right)) {
            right = this.types.unboxedType(right);
        }
        TypeKind promotedTypeKind = TypeKindUtils.widenedNumericType(left, right);
        return this.types.getPrimitiveType(promotedTypeKind);
    }

    protected Node binaryNumericPromotion(Node node, TypeMirror exprType) {
        if (!this.types.isSameType((node = this.unbox(node)).getType(), exprType)) {
            WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, exprType);
            this.addToConvertedLookupMap(widened);
            this.insertNodeAfter(widened, node);
            return widened;
        }
        return node;
    }

    protected Node widen(Node node, TypeMirror destType) {
        assert (TypesUtils.isPrimitive(node.getType()) && TypesUtils.isPrimitive(destType)) : "widening must be applied to primitive types";
        if (this.types.isSubtype(node.getType(), destType) && !this.types.isSameType(node.getType(), destType)) {
            WideningConversionNode widened = new WideningConversionNode(node.getTree(), node, destType);
            this.addToConvertedLookupMap(widened);
            this.insertNodeAfter(widened, node);
            return widened;
        }
        return node;
    }

    protected Node narrow(Node node, TypeMirror destType) {
        assert (TypesUtils.isPrimitive(node.getType()) && TypesUtils.isPrimitive(destType)) : "narrowing must be applied to primitive types";
        if (this.types.isSubtype(destType, node.getType()) && !this.types.isSameType(destType, node.getType())) {
            NarrowingConversionNode narrowed = new NarrowingConversionNode(node.getTree(), node, destType);
            this.addToConvertedLookupMap(narrowed);
            this.insertNodeAfter(narrowed, node);
            return narrowed;
        }
        return node;
    }

    protected Node narrowAndBox(Node node, TypeMirror destType) {
        if (TypesUtils.isBoxedPrimitive(destType)) {
            return this.box(this.narrow(node, this.types.unboxedType(destType)));
        }
        return this.narrow(node, destType);
    }

    protected boolean conversionRequiresNarrowing(TypeMirror varType, Node node) {
        TypeMirror unboxedVarType = TypesUtils.isBoxedPrimitive(varType) ? this.types.unboxedType(varType) : varType;
        TypeKind unboxedVarKind = unboxedVarType.getKind();
        boolean isLeftNarrowableTo = unboxedVarKind == TypeKind.BYTE || unboxedVarKind == TypeKind.SHORT || unboxedVarKind == TypeKind.CHAR;
        boolean isRightConstant = node instanceof ValueLiteralNode;
        return isLeftNarrowableTo && isRightConstant;
    }

    protected Node commonConvert(Node node, TypeMirror varType, boolean contextAllowsNarrowing) {
        TypeMirror nodeType = node.getType();
        boolean isSameType = this.types.isSameType(nodeType, varType);
        if (isSameType) {
            return node;
        }
        boolean isRightNumeric = TypesUtils.isNumeric(nodeType);
        boolean isRightPrimitive = TypesUtils.isPrimitive(nodeType);
        boolean isRightBoxed = TypesUtils.isBoxedPrimitive(nodeType);
        boolean isRightReference = nodeType instanceof ReferenceType;
        boolean isLeftNumeric = TypesUtils.isNumeric(varType);
        boolean isLeftPrimitive = TypesUtils.isPrimitive(varType);
        boolean isLeftReference = varType instanceof ReferenceType;
        boolean isSubtype = this.types.isSubtype(nodeType, varType);
        if (isRightNumeric && isLeftNumeric && isSubtype) {
            node = this.widen(node, varType);
            nodeType = node.getType();
        } else if (!(isRightReference && isLeftReference && isSubtype)) {
            if (isRightPrimitive && isLeftReference) {
                if (contextAllowsNarrowing && this.conversionRequiresNarrowing(varType, node)) {
                    node = this.narrowAndBox(node, varType);
                    nodeType = node.getType();
                } else {
                    node = this.box(node);
                    nodeType = node.getType();
                }
            } else if (isRightBoxed && isLeftPrimitive) {
                nodeType = (node = this.unbox(node)).getType();
                if (this.types.isSubtype(nodeType, varType) && !this.types.isSameType(nodeType, varType)) {
                    node = this.widen(node, varType);
                    nodeType = node.getType();
                }
            } else if (isRightPrimitive && isLeftPrimitive && contextAllowsNarrowing && this.conversionRequiresNarrowing(varType, node)) {
                node = this.narrow(node, varType);
                nodeType = node.getType();
            }
        }
        return node;
    }

    protected Node assignConvert(Node node, TypeMirror varType) {
        return this.commonConvert(node, varType, true);
    }

    protected Node methodInvocationConvert(Node node, TypeMirror formalType) {
        return this.commonConvert(node, formalType, false);
    }

    protected List<Node> convertCallArguments(ExecutableElement method, List<? extends ExpressionTree> actualExprs) {
        List<? extends VariableElement> formals = method.getParameters();
        int numFormals = formals.size();
        ArrayList<Node> convertedNodes = new ArrayList<Node>(numFormals);
        int numActuals = actualExprs.size();
        if (method.isVarArgs()) {
            int lastArgIndex = numFormals - 1;
            TypeMirror lastParamType = formals.get(lastArgIndex).asType();
            if (numActuals == numFormals && this.types.isAssignable(TreeUtils.typeOf(actualExprs.get(numActuals - 1)), lastParamType)) {
                for (int i = 0; i < numActuals; ++i) {
                    Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                    if (actualVal == null) {
                        throw new BugInCF("CFGBuilder: scan returned null for %s [%s]", actualExprs.get(i), actualExprs.get(i).getClass());
                    }
                    convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i).asType()));
                }
            } else {
                assert (lastParamType instanceof ArrayType) : "variable argument formal must be an array";
                for (int i = 0; i < lastArgIndex; ++i) {
                    Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                    convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i).asType()));
                }
                TypeMirror elemType = ((ArrayType)lastParamType).getComponentType();
                ArrayList<ExpressionTree> inits = new ArrayList<ExpressionTree>(numActuals - lastArgIndex);
                ArrayList<Node> initializers = new ArrayList<Node>(numActuals - lastArgIndex);
                for (int i = lastArgIndex; i < numActuals; ++i) {
                    inits.add(actualExprs.get(i));
                    Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                    initializers.add(this.assignConvert(actualVal, elemType));
                }
                NewArrayTree wrappedVarargs = this.treeBuilder.buildNewArray(elemType, inits);
                this.handleArtificialTree(wrappedVarargs);
                ArrayCreationNode lastArgument = new ArrayCreationNode(wrappedVarargs, lastParamType, Collections.emptyList(), initializers);
                this.extendWithNode(lastArgument);
                convertedNodes.add(lastArgument);
            }
        } else {
            for (int i = 0; i < numActuals; ++i) {
                Node actualVal = (Node)this.scan(actualExprs.get(i), null);
                convertedNodes.add(this.methodInvocationConvert(actualVal, formals.get(i).asType()));
            }
        }
        return convertedNodes;
    }

    protected Node conditionalExprPromotion(Node node, TypeMirror destType) {
        TypeMirror unboxedDestType;
        TypeMirror nodeType = node.getType();
        if (this.types.isSameType(nodeType, destType)) {
            return node;
        }
        if (TypesUtils.isPrimitive(nodeType) && TypesUtils.isBoxedPrimitive(destType)) {
            return this.box(node);
        }
        boolean isBoxedPrimitive = TypesUtils.isBoxedPrimitive(nodeType);
        TypeMirror unboxedNodeType = isBoxedPrimitive ? this.types.unboxedType(nodeType) : nodeType;
        TypeMirror typeMirror = unboxedDestType = TypesUtils.isBoxedPrimitive(destType) ? this.types.unboxedType(destType) : destType;
        if (TypesUtils.isNumeric(unboxedNodeType) && TypesUtils.isNumeric(unboxedDestType)) {
            if (unboxedNodeType.getKind() == TypeKind.BYTE && destType.getKind() == TypeKind.SHORT) {
                if (isBoxedPrimitive) {
                    node = this.unbox(node);
                }
                return this.widen(node, destType);
            }
            TypeKind destKind = destType.getKind();
            if (destKind == TypeKind.BYTE || destKind == TypeKind.CHAR || destKind == TypeKind.SHORT) {
                if (isBoxedPrimitive) {
                    return this.unbox(node);
                }
                if (nodeType.getKind() == TypeKind.INT) {
                    return this.narrow(node, destType);
                }
            }
            return this.binaryNumericPromotion(node, destType);
        }
        if (TypesUtils.isPrimitive(nodeType) && (destType.getKind() == TypeKind.DECLARED || destType.getKind() == TypeKind.UNION || destType.getKind() == TypeKind.INTERSECTION)) {
            return this.box(node);
        }
        return node;
    }

    protected @Nullable Name getLabel(TreePath path) {
        Tree parent;
        if (path.getParentPath() != null && (parent = path.getParentPath().getLeaf()).getKind() == Tree.Kind.LABELED_STATEMENT) {
            return ((LabeledStatementTree)parent).getLabel();
        }
        return null;
    }

    @Override
    public Node visitAnnotatedType(AnnotatedTypeTree tree, Void p) {
        return (Node)this.scan(tree.getUnderlyingType(), p);
    }

    @Override
    public Node visitAnnotation(AnnotationTree tree, Void p) {
        throw new BugInCF("AnnotationTree is unexpected in AST to CFG translation");
    }

    @Override
    public MethodInvocationNode visitMethodInvocation(MethodInvocationTree tree, Void p) {
        boolean terminatesExecution;
        ExecutableElement method = TreeUtils.elementFromUse(tree);
        if (method == null) {
            return null;
        }
        ExpressionTree methodSelect = tree.getMethodSelect();
        assert (TreeUtils.isMethodAccess(methodSelect)) : "Expected a method access, but got: " + methodSelect;
        List<? extends ExpressionTree> actualExprs = tree.getArguments();
        Node receiver = this.getReceiver(methodSelect);
        MethodAccessNode target = new MethodAccessNode(methodSelect, receiver);
        ExecutableElement element = TreeUtils.elementFromUse(tree);
        if (ElementUtils.isStatic(element) || receiver instanceof ThisNode) {
            this.extendWithNode(target);
        } else {
            this.extendWithNodeWithException(target, this.nullPointerExceptionType);
        }
        List<Object> arguments = TreeUtils.isEnumSuper(tree) ? Collections.emptyList() : this.convertCallArguments(method, actualExprs);
        MethodInvocationNode node = new MethodInvocationNode(tree, target, arguments, this.getCurrentPath());
        List<? extends TypeMirror> thrownTypes = element.getThrownTypes();
        LinkedHashSet<TypeMirror> thrownSet = new LinkedHashSet<TypeMirror>(thrownTypes.size() + this.uncheckedExceptionTypes.size());
        thrownSet.addAll(thrownTypes);
        thrownSet.addAll(this.uncheckedExceptionTypes);
        NodeWithExceptionsHolder extendedNode = this.extendWithNodeWithExceptions(node, thrownSet);
        Element methodElement = TreeUtils.elementFromTree(tree);
        boolean bl = terminatesExecution = this.annotationProvider.getDeclAnnotation(methodElement, TerminatesExecution.class) != null;
        if (terminatesExecution) {
            extendedNode.setTerminatesExecution(true);
        }
        return node;
    }

    @Override
    public Node visitAssert(AssertTree tree, Void p) {
        if (this.assumeAssertionsEnabled || this.assumeAssertionsEnabledFor(tree)) {
            this.translateAssertWithAssertionsEnabled(tree);
            return null;
        }
        if (this.assumeAssertionsDisabled) {
            return null;
        }
        VariableTree ea = this.getAssertionsEnabledVariable();
        Label assertionEnabled = new Label();
        Label assertionDisabled = new Label();
        this.extendWithNode(new LocalVariableNode(ea));
        this.extendWithExtendedNode(new ConditionalJump(assertionEnabled, assertionDisabled));
        this.addLabelForNextNode(assertionEnabled);
        this.translateAssertWithAssertionsEnabled(tree);
        this.addLabelForNextNode(assertionDisabled);
        return null;
    }

    protected boolean assumeAssertionsEnabledFor(AssertTree tree) {
        return false;
    }

    protected VariableTree getAssertionsEnabledVariable() {
        if (this.ea == null) {
            String name = this.uniqueName("assertionsEnabled");
            Element owner = this.findOwner();
            ExpressionTree initializer = null;
            this.ea = this.treeBuilder.buildVariableDecl(this.types.getPrimitiveType(TypeKind.BOOLEAN), name, owner, initializer);
        }
        return this.ea;
    }

    private Element findOwner() {
        MethodTree enclosingMethod = TreePathUtil.enclosingMethod(this.getCurrentPath());
        if (enclosingMethod != null) {
            return TreeUtils.elementFromDeclaration(enclosingMethod);
        }
        ClassTree enclosingClass = TreePathUtil.enclosingClass(this.getCurrentPath());
        return TreeUtils.elementFromDeclaration(enclosingClass);
    }

    protected void translateAssertWithAssertionsEnabled(AssertTree tree) {
        Label assertEnd = new Label();
        Label elseEntry = new Label();
        Node condition = this.unbox((Node)this.scan(tree.getCondition(), null));
        ConditionalJump cjump = new ConditionalJump(assertEnd, elseEntry);
        this.extendWithExtendedNode(cjump);
        Node detail = null;
        this.addLabelForNextNode(elseEntry);
        if (tree.getDetail() != null) {
            detail = (Node)this.scan(tree.getDetail(), null);
        }
        AssertionErrorNode assertNode = new AssertionErrorNode(tree, condition, detail, this.assertionErrorType);
        this.extendWithNode(assertNode);
        NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(new ThrowNode(null, assertNode, this.env.getTypeUtils()), this.assertionErrorType);
        exNode.setTerminatesExecution(true);
        this.addLabelForNextNode(assertEnd);
    }

    @Override
    public Node visitAssignment(AssignmentTree tree, Void p) {
        AssignmentNode assignmentNode;
        ExpressionTree variable = tree.getVariable();
        TypeMirror varType = TreeUtils.typeOf(variable);
        if (TreeUtils.isFieldAccess(variable)) {
            Node receiver = this.getReceiver(variable);
            Node expression = (Node)this.scan(tree.getExpression(), p);
            expression = this.assignConvert(expression, varType);
            FieldAccessNode target = new FieldAccessNode(variable, receiver);
            target.setLValue();
            Element element = TreeUtils.elementFromUse(variable);
            if (ElementUtils.isStatic(element) || receiver instanceof ThisNode) {
                this.extendWithNode(target);
            } else {
                this.extendWithNodeWithException(target, this.nullPointerExceptionType);
            }
            assignmentNode = new AssignmentNode(tree, target, expression);
            this.extendWithNode(assignmentNode);
        } else {
            Node target = (Node)this.scan(variable, p);
            target.setLValue();
            assignmentNode = this.translateAssignment((Tree)tree, target, tree.getExpression());
        }
        return assignmentNode;
    }

    protected AssignmentNode translateAssignment(Tree tree, Node target, ExpressionTree rhs) {
        Node expression = (Node)this.scan(rhs, null);
        return this.translateAssignment(tree, target, expression);
    }

    protected AssignmentNode translateAssignment(Tree tree, Node target, Node expression) {
        assert (tree instanceof AssignmentTree || tree instanceof VariableTree);
        target.setLValue();
        expression = this.assignConvert(expression, target.getType());
        AssignmentNode assignmentNode = new AssignmentNode(tree, target, expression);
        this.extendWithNode(assignmentNode);
        return assignmentNode;
    }

    private Node getReceiver(ExpressionTree tree) {
        assert (TreeUtils.isFieldAccess(tree) || TreeUtils.isMethodAccess(tree));
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return (Node)this.scan(mtree.getExpression(), null);
        }
        Element ele = TreeUtils.elementFromUse(tree);
        TypeElement declaringClass = ElementUtils.enclosingTypeElement(ele);
        TypeMirror type = ElementUtils.getType(declaringClass);
        if (ElementUtils.isStatic(ele)) {
            ClassNameNode node = new ClassNameNode(type, declaringClass);
            this.extendWithClassNameNode(node);
            return node;
        }
        ImplicitThisNode node = new ImplicitThisNode(type);
        this.extendWithNode(node);
        return node;
    }

    protected Tree.Kind withoutAssignment(Tree.Kind kind) {
        switch (kind) {
            case DIVIDE_ASSIGNMENT: {
                return Tree.Kind.DIVIDE;
            }
            case MULTIPLY_ASSIGNMENT: {
                return Tree.Kind.MULTIPLY;
            }
            case REMAINDER_ASSIGNMENT: {
                return Tree.Kind.REMAINDER;
            }
            case MINUS_ASSIGNMENT: {
                return Tree.Kind.MINUS;
            }
            case PLUS_ASSIGNMENT: {
                return Tree.Kind.PLUS;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
            case AND_ASSIGNMENT: {
                return Tree.Kind.AND;
            }
            case OR_ASSIGNMENT: {
                return Tree.Kind.OR;
            }
            case XOR_ASSIGNMENT: {
                return Tree.Kind.XOR;
            }
        }
        return Tree.Kind.ERRONEOUS;
    }

    @Override
    public Node visitCompoundAssignment(CompoundAssignmentTree tree, Void p) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case DIVIDE_ASSIGNMENT: 
            case MULTIPLY_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                Node value = (Node)this.scan(tree.getExpression(), p);
                TypeMirror exprType = TreeUtils.typeOf(tree);
                TypeMirror leftType = TreeUtils.typeOf(tree.getVariable());
                TypeMirror rightType = TreeUtils.typeOf(tree.getExpression());
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                value = this.binaryNumericPromotion(value, promotedType);
                BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.MULTIPLY_ASSIGNMENT) {
                    operNode = new NumericalMultiplicationNode(operTree, targetRHS, value);
                } else if (kind == Tree.Kind.DIVIDE_ASSIGNMENT) {
                    if (TypesUtils.isIntegralPrimitive(exprType)) {
                        operNode = new IntegerDivisionNode(operTree, targetRHS, value);
                        this.extendWithNodeWithException(operNode, this.arithmeticExceptionType);
                    } else {
                        operNode = new FloatingDivisionNode(operTree, targetRHS, value);
                    }
                } else {
                    assert (kind == Tree.Kind.REMAINDER_ASSIGNMENT);
                    if (TypesUtils.isIntegralPrimitive(exprType)) {
                        operNode = new IntegerRemainderNode(operTree, targetRHS, value);
                        this.extendWithNodeWithException(operNode, this.arithmeticExceptionType);
                    } else {
                        operNode = new FloatingRemainderNode(operTree, targetRHS, value);
                    }
                }
                this.extendWithNode(operNode);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
            case MINUS_ASSIGNMENT: 
            case PLUS_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                Node value = (Node)this.scan(tree.getExpression(), p);
                TypeMirror leftType = TreeUtils.typeOf(tree.getVariable());
                TypeMirror rightType = TreeUtils.typeOf(tree.getExpression());
                if (TypesUtils.isString(leftType) || TypesUtils.isString(rightType)) {
                    assert (kind == Tree.Kind.PLUS_ASSIGNMENT);
                    Node targetRHS = this.stringConversion(targetLHS);
                    value = this.stringConversion(value);
                    StringConcatenateAssignmentNode r = new StringConcatenateAssignmentNode(tree, targetRHS, value);
                    this.extendWithNode(r);
                    return r;
                }
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                value = this.binaryNumericPromotion(value, promotedType);
                BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.PLUS_ASSIGNMENT) {
                    operNode = new NumericalAdditionNode(operTree, targetRHS, value);
                } else {
                    assert (kind == Tree.Kind.MINUS_ASSIGNMENT);
                    operNode = new NumericalSubtractionNode(operTree, targetRHS, value);
                }
                this.extendWithNode(operNode);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                Node value = (Node)this.scan(tree.getExpression(), p);
                TypeMirror leftType = TreeUtils.typeOf(tree.getVariable());
                Node targetRHS = this.unaryNumericPromotion(targetLHS);
                value = this.unaryNumericPromotion(value);
                BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.LEFT_SHIFT_ASSIGNMENT) {
                    operNode = new LeftShiftNode(operTree, targetRHS, value);
                } else if (kind == Tree.Kind.RIGHT_SHIFT_ASSIGNMENT) {
                    operNode = new SignedRightShiftNode(operTree, targetRHS, value);
                } else {
                    assert (kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
                    operNode = new UnsignedRightShiftNode(operTree, targetRHS, value);
                }
                this.extendWithNode(operNode);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
            case AND_ASSIGNMENT: 
            case OR_ASSIGNMENT: 
            case XOR_ASSIGNMENT: {
                BinaryOperationNode operNode;
                Node targetLHS = (Node)this.scan(tree.getVariable(), p);
                Node value = (Node)this.scan(tree.getExpression(), p);
                TypeMirror leftType = TreeUtils.typeOf(tree.getVariable());
                TypeMirror rightType = TreeUtils.typeOf(tree.getExpression());
                Node targetRHS = null;
                if (this.isNumericOrBoxed(leftType) && this.isNumericOrBoxed(rightType)) {
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    targetRHS = this.binaryNumericPromotion(targetLHS, promotedType);
                    value = this.binaryNumericPromotion(value, promotedType);
                } else if (TypesUtils.isBooleanType(leftType) && TypesUtils.isBooleanType(rightType)) {
                    targetRHS = this.unbox(targetLHS);
                    value = this.unbox(value);
                } else {
                    throw new BugInCF("Both arguments to logical operation must be numeric or boolean");
                }
                BinaryTree operTree = this.treeBuilder.buildBinary(leftType, this.withoutAssignment(kind), tree.getVariable(), tree.getExpression());
                this.handleArtificialTree(operTree);
                if (kind == Tree.Kind.AND_ASSIGNMENT) {
                    operNode = new BitwiseAndNode(operTree, targetRHS, value);
                } else if (kind == Tree.Kind.OR_ASSIGNMENT) {
                    operNode = new BitwiseOrNode(operTree, targetRHS, value);
                } else {
                    assert (kind == Tree.Kind.XOR_ASSIGNMENT);
                    operNode = new BitwiseXorNode(operTree, targetRHS, value);
                }
                this.extendWithNode(operNode);
                TypeCastTree castTree = this.treeBuilder.buildTypeCast(leftType, operTree);
                this.handleArtificialTree(castTree);
                TypeCastNode castNode = new TypeCastNode(castTree, operNode, leftType, this.types);
                castNode.setInSource(false);
                this.extendWithNode(castNode);
                AssignmentNode assignNode = new AssignmentNode(tree, targetLHS, castNode);
                this.extendWithNode(assignNode);
                return assignNode;
            }
        }
        throw new BugInCF("unexpected compound assignment type");
    }

    @Override
    public Node visitBinary(BinaryTree tree, Void p) {
        BinaryOperationNode r = null;
        ExpressionTree leftTree = tree.getLeftOperand();
        ExpressionTree rightTree = tree.getRightOperand();
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case DIVIDE: 
            case MULTIPLY: 
            case REMAINDER: {
                TypeMirror exprType = TreeUtils.typeOf(tree);
                TypeMirror leftType = TreeUtils.typeOf(leftTree);
                TypeMirror rightType = TreeUtils.typeOf(rightTree);
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                Node right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                if (kind == Tree.Kind.MULTIPLY) {
                    r = new NumericalMultiplicationNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.DIVIDE) {
                    if (TypesUtils.isIntegralPrimitive(exprType)) {
                        r = new IntegerDivisionNode(tree, left, right);
                        this.extendWithNodeWithException(r, this.arithmeticExceptionType);
                        break;
                    }
                    r = new FloatingDivisionNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.REMAINDER);
                if (TypesUtils.isIntegralPrimitive(exprType)) {
                    r = new IntegerRemainderNode(tree, left, right);
                    this.extendWithNodeWithException(r, this.arithmeticExceptionType);
                    break;
                }
                r = new FloatingRemainderNode(tree, left, right);
                break;
            }
            case MINUS: 
            case PLUS: {
                TypeMirror leftType = TreeUtils.typeOf(leftTree);
                TypeMirror rightType = TreeUtils.typeOf(rightTree);
                if (TypesUtils.isString(leftType) || TypesUtils.isString(rightType)) {
                    assert (kind == Tree.Kind.PLUS);
                    Node left = this.stringConversion((Node)this.scan(leftTree, p));
                    Node right = this.stringConversion((Node)this.scan(rightTree, p));
                    r = new StringConcatenateNode(tree, left, right);
                    break;
                }
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                Node right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                if (kind == Tree.Kind.PLUS) {
                    r = new NumericalAdditionNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.MINUS);
                r = new NumericalSubtractionNode(tree, left, right);
                break;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                Node left = this.unaryNumericPromotion((Node)this.scan(leftTree, p));
                Node right = this.unaryNumericPromotion((Node)this.scan(rightTree, p));
                if (kind == Tree.Kind.LEFT_SHIFT) {
                    r = new LeftShiftNode(tree, left, right);
                    break;
                }
                if (kind == Tree.Kind.RIGHT_SHIFT) {
                    r = new SignedRightShiftNode(tree, left, right);
                    break;
                }
                assert (kind == Tree.Kind.UNSIGNED_RIGHT_SHIFT);
                r = new UnsignedRightShiftNode(tree, left, right);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: {
                BinaryOperationNode node;
                TypeMirror rightType;
                TypeMirror leftType = TreeUtils.typeOf(leftTree);
                if (TypesUtils.isBoxedPrimitive(leftType)) {
                    leftType = this.types.unboxedType(leftType);
                }
                if (TypesUtils.isBoxedPrimitive(rightType = TreeUtils.typeOf(rightTree))) {
                    rightType = this.types.unboxedType(rightType);
                }
                TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                Node left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                Node right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                if (kind == Tree.Kind.GREATER_THAN) {
                    node = new GreaterThanNode(tree, left, right);
                } else if (kind == Tree.Kind.GREATER_THAN_EQUAL) {
                    node = new GreaterThanOrEqualNode(tree, left, right);
                } else if (kind == Tree.Kind.LESS_THAN) {
                    node = new LessThanNode(tree, left, right);
                } else {
                    assert (kind == Tree.Kind.LESS_THAN_EQUAL);
                    node = new LessThanOrEqualNode(tree, left, right);
                }
                this.extendWithNode(node);
                return node;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                BinaryOperationNode node;
                TreeInfo leftInfo = this.getTreeInfo(leftTree);
                TreeInfo rightInfo = this.getTreeInfo(rightTree);
                Node left = (Node)this.scan(leftTree, p);
                Node right = (Node)this.scan(rightTree, p);
                if (leftInfo.isNumeric() && rightInfo.isNumeric() && (!leftInfo.isBoxed() || !rightInfo.isBoxed())) {
                    TypeMirror promotedType = this.binaryPromotedType(leftInfo.unboxedType(), rightInfo.unboxedType());
                    left = this.binaryNumericPromotion(left, promotedType);
                    right = this.binaryNumericPromotion(right, promotedType);
                } else if (leftInfo.isBoolean() && rightInfo.isBoolean() && (!leftInfo.isBoxed() || !rightInfo.isBoxed())) {
                    left = this.unboxAsNeeded(left, leftInfo.isBoxed());
                    right = this.unboxAsNeeded(right, rightInfo.isBoxed());
                }
                if (kind == Tree.Kind.EQUAL_TO) {
                    node = new EqualToNode(tree, left, right);
                } else {
                    assert (kind == Tree.Kind.NOT_EQUAL_TO);
                    node = new NotEqualNode(tree, left, right);
                }
                this.extendWithNode(node);
                return node;
            }
            case AND: 
            case OR: 
            case XOR: {
                BinaryOperationNode node;
                Node right;
                Node left;
                boolean isBooleanOp;
                TypeMirror leftType = TreeUtils.typeOf(leftTree);
                TypeMirror rightType = TreeUtils.typeOf(rightTree);
                boolean bl = isBooleanOp = TypesUtils.isBooleanType(leftType) && TypesUtils.isBooleanType(rightType);
                if (isBooleanOp) {
                    left = this.unbox((Node)this.scan(leftTree, p));
                    right = this.unbox((Node)this.scan(rightTree, p));
                } else if (this.isNumericOrBoxed(leftType) && this.isNumericOrBoxed(rightType)) {
                    TypeMirror promotedType = this.binaryPromotedType(leftType, rightType);
                    left = this.binaryNumericPromotion((Node)this.scan(leftTree, p), promotedType);
                    right = this.binaryNumericPromotion((Node)this.scan(rightTree, p), promotedType);
                } else {
                    left = this.unbox((Node)this.scan(leftTree, p));
                    right = this.unbox((Node)this.scan(rightTree, p));
                }
                if (kind == Tree.Kind.AND) {
                    node = new BitwiseAndNode(tree, left, right);
                } else if (kind == Tree.Kind.OR) {
                    node = new BitwiseOrNode(tree, left, right);
                } else {
                    assert (kind == Tree.Kind.XOR);
                    node = new BitwiseXorNode(tree, left, right);
                }
                this.extendWithNode(node);
                return node;
            }
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                ConditionalJump cjump;
                Label rightStartL = new Label();
                Label shortCircuitL = new Label();
                Node left = (Node)this.scan(leftTree, p);
                if (kind == Tree.Kind.CONDITIONAL_AND) {
                    cjump = new ConditionalJump(rightStartL, shortCircuitL);
                    cjump.setFalseFlowRule(Store.FlowRule.ELSE_TO_ELSE);
                } else {
                    cjump = new ConditionalJump(shortCircuitL, rightStartL);
                    cjump.setTrueFlowRule(Store.FlowRule.THEN_TO_THEN);
                }
                this.extendWithExtendedNode(cjump);
                this.addLabelForNextNode(rightStartL);
                Node right = (Node)this.scan(rightTree, p);
                this.addLabelForNextNode(shortCircuitL);
                BinaryOperationNode node = kind == Tree.Kind.CONDITIONAL_AND ? new ConditionalAndNode(tree, left, right) : new ConditionalOrNode(tree, left, right);
                this.extendWithNode(node);
                return node;
            }
            default: {
                throw new BugInCF("unexpected binary tree: " + (Object)((Object)kind));
            }
        }
        assert (r != null) : "unexpected binary tree";
        this.extendWithNode(r);
        return r;
    }

    @Override
    public Node visitBlock(BlockTree tree, Void p) {
        for (StatementTree statementTree : tree.getStatements()) {
            this.scan(statementTree, null);
        }
        return null;
    }

    @Override
    public Node visitBreak(BreakTree tree, Void p) {
        Name label = tree.getLabel();
        if (label == null) {
            assert (this.breakTargetL != null) : "no target for break statement";
            this.extendWithExtendedNode(new UnconditionalJump(this.breakTargetL.accessLabel()));
        } else {
            assert (this.breakLabels.containsKey(label));
            this.extendWithExtendedNode(new UnconditionalJump(this.breakLabels.get(label)));
        }
        return null;
    }

    @Override
    public Node visitSwitch(SwitchTree tree, Void p) {
        SwitchBuilder builder = new SwitchBuilder(tree);
        builder.build();
        return null;
    }

    @Override
    public Node visitCase(CaseTree tree, Void p) {
        throw new AssertionError((Object)"case visitor is implemented in SwitchBuilder");
    }

    @Override
    public Node visitCatch(CatchTree tree, Void p) {
        this.scan(tree.getParameter(), p);
        this.scan(tree.getBlock(), p);
        return null;
    }

    @Override
    public Node visitClass(ClassTree tree, Void p) {
        this.declaredClasses.add(tree);
        ClassDeclarationNode classbody = new ClassDeclarationNode(tree);
        this.extendWithNode(classbody);
        return classbody;
    }

    @Override
    public Node visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
        TypeMirror exprType = TreeUtils.typeOf(tree);
        Label trueStart = new Label();
        Label falseStart = new Label();
        Label merge = new Label();
        Node condition = this.unbox((Node)this.scan(tree.getCondition(), p));
        ConditionalJump cjump = new ConditionalJump(trueStart, falseStart);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(trueStart);
        Node trueExpr = (Node)this.scan(tree.getTrueExpression(), p);
        trueExpr = this.conditionalExprPromotion(trueExpr, exprType);
        this.extendWithExtendedNode(new UnconditionalJump(merge, Store.FlowRule.BOTH_TO_THEN));
        this.addLabelForNextNode(falseStart);
        Node falseExpr = (Node)this.scan(tree.getFalseExpression(), p);
        falseExpr = this.conditionalExprPromotion(falseExpr, exprType);
        this.extendWithExtendedNode(new UnconditionalJump(merge, Store.FlowRule.BOTH_TO_ELSE));
        this.addLabelForNextNode(merge);
        TernaryExpressionNode node = new TernaryExpressionNode(tree, condition, trueExpr, falseExpr);
        this.extendWithNode(node);
        return node;
    }

    @Override
    public Node visitContinue(ContinueTree tree, Void p) {
        Name label = tree.getLabel();
        if (label == null) {
            assert (this.continueTargetL != null) : "no target for continue statement";
            this.extendWithExtendedNode(new UnconditionalJump(this.continueTargetL.accessLabel()));
        } else {
            assert (this.continueLabels.containsKey(label));
            this.extendWithExtendedNode(new UnconditionalJump(this.continueLabels.get(label)));
        }
        return null;
    }

    @Override
    public Node visitDoWhileLoop(DoWhileLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label conditionStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
        this.breakTargetL = new TryFinallyScopeCell(loopExit);
        TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
        this.continueTargetL = new TryFinallyScopeCell(conditionStart);
        this.addLabelForNextNode(loopEntry);
        assert (tree.getStatement() != null);
        this.scan(tree.getStatement(), p);
        this.addLabelForNextNode(conditionStart);
        assert (tree.getCondition() != null);
        this.unbox((Node)this.scan(tree.getCondition(), p));
        ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(loopExit);
        this.breakTargetL = oldBreakTargetL;
        this.continueTargetL = oldContinueTargetL;
        return null;
    }

    @Override
    public Node visitErroneous(ErroneousTree tree, Void p) {
        throw new BugInCF("ErroneousTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitExpressionStatement(ExpressionStatementTree tree, Void p) {
        return (Node)this.scan(tree.getExpression(), p);
    }

    @Override
    public Node visitEnhancedForLoop(EnhancedForLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label conditionStart = new Label();
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label updateStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
        this.breakTargetL = new TryFinallyScopeCell(loopExit);
        TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
        this.continueTargetL = new TryFinallyScopeCell(updateStart);
        VariableTree variable = tree.getVariable();
        VariableElement variableElement = TreeUtils.elementFromDeclaration(variable);
        ExpressionTree expression = tree.getExpression();
        StatementTree statement = tree.getStatement();
        TypeMirror exprType = TreeUtils.typeOf(expression);
        if (this.types.isSubtype(exprType, this.iterableType)) {
            exprType = TypesUtils.upperBound(exprType);
            assert (exprType instanceof DeclaredType) : "an Iterable must be a DeclaredType";
            DeclaredType declaredExprType = (DeclaredType)exprType;
            declaredExprType.getTypeArguments();
            MemberSelectTree iteratorSelect = this.treeBuilder.buildIteratorMethodAccess(expression);
            this.handleArtificialTree(iteratorSelect);
            MethodInvocationTree iteratorCall = this.treeBuilder.buildMethodInvocation(iteratorSelect);
            this.handleArtificialTree(iteratorCall);
            VariableTree iteratorVariable = this.createEnhancedForLoopIteratorVariable(iteratorCall, variableElement);
            this.handleArtificialTree(iteratorVariable);
            VariableDeclarationNode iteratorVariableDecl = new VariableDeclarationNode(iteratorVariable);
            iteratorVariableDecl.setInSource(false);
            this.extendWithNode(iteratorVariableDecl);
            Node expressionNode = (Node)this.scan(expression, p);
            MethodAccessNode iteratorAccessNode = new MethodAccessNode(iteratorSelect, expressionNode);
            iteratorAccessNode.setInSource(false);
            this.extendWithNode(iteratorAccessNode);
            MethodInvocationNode iteratorCallNode = new MethodInvocationNode(iteratorCall, iteratorAccessNode, Collections.emptyList(), this.getCurrentPath());
            iteratorCallNode.setInSource(false);
            this.extendWithNode(iteratorCallNode);
            this.translateAssignment((Tree)iteratorVariable, (Node)new LocalVariableNode(iteratorVariable), iteratorCallNode);
            this.addLabelForNextNode(conditionStart);
            IdentifierTree iteratorUse1 = this.treeBuilder.buildVariableUse(iteratorVariable);
            this.handleArtificialTree(iteratorUse1);
            LocalVariableNode iteratorReceiverNode = new LocalVariableNode(iteratorUse1);
            iteratorReceiverNode.setInSource(false);
            this.extendWithNode(iteratorReceiverNode);
            MemberSelectTree hasNextSelect = this.treeBuilder.buildHasNextMethodAccess(iteratorUse1);
            this.handleArtificialTree(hasNextSelect);
            MethodAccessNode hasNextAccessNode = new MethodAccessNode(hasNextSelect, iteratorReceiverNode);
            hasNextAccessNode.setInSource(false);
            this.extendWithNode(hasNextAccessNode);
            MethodInvocationTree hasNextCall = this.treeBuilder.buildMethodInvocation(hasNextSelect);
            this.handleArtificialTree(hasNextCall);
            MethodInvocationNode hasNextCallNode = new MethodInvocationNode(hasNextCall, hasNextAccessNode, Collections.emptyList(), this.getCurrentPath());
            hasNextCallNode.setInSource(false);
            this.extendWithNode(hasNextCallNode);
            this.extendWithExtendedNode(new ConditionalJump(loopEntry, loopExit));
            this.addLabelForNextNode(loopEntry);
            this.extendWithNode(new VariableDeclarationNode(variable));
            IdentifierTree iteratorUse2 = this.treeBuilder.buildVariableUse(iteratorVariable);
            this.handleArtificialTree(iteratorUse2);
            LocalVariableNode iteratorReceiverNode2 = new LocalVariableNode(iteratorUse2);
            iteratorReceiverNode2.setInSource(false);
            this.extendWithNode(iteratorReceiverNode2);
            MemberSelectTree nextSelect = this.treeBuilder.buildNextMethodAccess(iteratorUse2);
            this.handleArtificialTree(nextSelect);
            MethodAccessNode nextAccessNode = new MethodAccessNode(nextSelect, iteratorReceiverNode2);
            nextAccessNode.setInSource(false);
            this.extendWithNode(nextAccessNode);
            MethodInvocationTree nextCall = this.treeBuilder.buildMethodInvocation(nextSelect);
            this.handleArtificialTree(nextCall);
            MethodInvocationNode nextCallNode = new MethodInvocationNode(nextCall, nextAccessNode, Collections.emptyList(), this.getCurrentPath());
            nextCallNode.setIterableExpression(expression);
            nextCallNode.setInSource(false);
            this.extendWithNode(nextCallNode);
            AssignmentNode assignNode = this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), nextCall);
            ((MethodInvocationNode)assignNode.getExpression()).setIterableExpression(expression);
            assert (statement != null);
            this.scan(statement, p);
            this.addLabelForNextNode(updateStart);
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        } else {
            VariableTree arrayVariable = this.createEnhancedForLoopArrayVariable(expression, variableElement);
            this.handleArtificialTree(arrayVariable);
            VariableDeclarationNode arrayVariableNode = new VariableDeclarationNode(arrayVariable);
            arrayVariableNode.setInSource(false);
            this.extendWithNode(arrayVariableNode);
            Node expressionNode = (Node)this.scan(expression, p);
            this.translateAssignment((Tree)arrayVariable, (Node)new LocalVariableNode(arrayVariable), expressionNode);
            PrimitiveType intType = this.types.getPrimitiveType(TypeKind.INT);
            LiteralTree zero = this.treeBuilder.buildLiteral(0);
            this.handleArtificialTree(zero);
            VariableTree indexVariable = this.treeBuilder.buildVariableDecl(intType, this.uniqueName("index"), variableElement.getEnclosingElement(), (ExpressionTree)zero);
            this.handleArtificialTree(indexVariable);
            VariableDeclarationNode indexVariableNode = new VariableDeclarationNode(indexVariable);
            indexVariableNode.setInSource(false);
            this.extendWithNode(indexVariableNode);
            IntegerLiteralNode zeroNode = new IntegerLiteralNode(zero);
            this.extendWithNode(zeroNode);
            this.translateAssignment((Tree)indexVariable, (Node)new LocalVariableNode(indexVariable), zeroNode);
            this.addLabelForNextNode(conditionStart);
            IdentifierTree indexUse1 = this.treeBuilder.buildVariableUse(indexVariable);
            this.handleArtificialTree(indexUse1);
            LocalVariableNode indexNode1 = new LocalVariableNode(indexUse1);
            indexNode1.setInSource(false);
            this.extendWithNode(indexNode1);
            IdentifierTree arrayUse1 = this.treeBuilder.buildVariableUse(arrayVariable);
            this.handleArtificialTree(arrayUse1);
            LocalVariableNode arrayNode1 = new LocalVariableNode(arrayUse1);
            this.extendWithNode(arrayNode1);
            MemberSelectTree lengthSelect = this.treeBuilder.buildArrayLengthAccess(arrayUse1);
            this.handleArtificialTree(lengthSelect);
            FieldAccessNode lengthAccessNode = new FieldAccessNode(lengthSelect, arrayNode1);
            lengthAccessNode.setInSource(false);
            this.extendWithNode(lengthAccessNode);
            BinaryTree lessThan = this.treeBuilder.buildLessThan(indexUse1, lengthSelect);
            this.handleArtificialTree(lessThan);
            LessThanNode lessThanNode = new LessThanNode(lessThan, indexNode1, lengthAccessNode);
            lessThanNode.setInSource(false);
            this.extendWithNode(lessThanNode);
            this.extendWithExtendedNode(new ConditionalJump(loopEntry, loopExit));
            this.addLabelForNextNode(loopEntry);
            this.extendWithNode(new VariableDeclarationNode(variable));
            IdentifierTree arrayUse2 = this.treeBuilder.buildVariableUse(arrayVariable);
            this.handleArtificialTree(arrayUse2);
            LocalVariableNode arrayNode2 = new LocalVariableNode(arrayUse2);
            arrayNode2.setInSource(false);
            this.extendWithNode(arrayNode2);
            IdentifierTree indexUse2 = this.treeBuilder.buildVariableUse(indexVariable);
            this.handleArtificialTree(indexUse2);
            LocalVariableNode indexNode2 = new LocalVariableNode(indexUse2);
            indexNode2.setInSource(false);
            this.extendWithNode(indexNode2);
            ArrayAccessTree arrayAccess = this.treeBuilder.buildArrayAccess(arrayUse2, indexUse2);
            this.handleArtificialTree(arrayAccess);
            ArrayAccessNode arrayAccessNode = new ArrayAccessNode(arrayAccess, arrayNode2, indexNode2);
            arrayAccessNode.setArrayExpression(expression);
            arrayAccessNode.setInSource(false);
            this.extendWithNode(arrayAccessNode);
            AssignmentNode arrayAccessAssignNode = this.translateAssignment((Tree)variable, (Node)new LocalVariableNode(variable), arrayAccessNode);
            this.extendWithNodeWithException(arrayAccessNode, this.nullPointerExceptionType);
            Node arrayAccessAssignNodeExpr = arrayAccessAssignNode.getExpression();
            if (arrayAccessAssignNodeExpr instanceof ArrayAccessNode) {
                ((ArrayAccessNode)arrayAccessAssignNodeExpr).setArrayExpression(expression);
            } else if (arrayAccessAssignNodeExpr instanceof MethodInvocationNode) {
                MethodInvocationNode boxingNode = (MethodInvocationNode)arrayAccessAssignNodeExpr;
                boxingNode.setIterableExpression(expression);
            }
            assert (statement != null);
            this.scan(statement, p);
            this.addLabelForNextNode(updateStart);
            IdentifierTree indexUse3 = this.treeBuilder.buildVariableUse(indexVariable);
            this.handleArtificialTree(indexUse3);
            LocalVariableNode indexNode3 = new LocalVariableNode(indexUse3);
            indexNode3.setInSource(false);
            this.extendWithNode(indexNode3);
            LiteralTree oneTree = this.treeBuilder.buildLiteral(1);
            this.handleArtificialTree(oneTree);
            IntegerLiteralNode one = new IntegerLiteralNode(oneTree);
            one.setInSource(false);
            this.extendWithNode(one);
            BinaryTree addOneTree = this.treeBuilder.buildBinary(intType, Tree.Kind.PLUS, indexUse3, oneTree);
            this.handleArtificialTree(addOneTree);
            NumericalAdditionNode addOneNode = new NumericalAdditionNode(addOneTree, indexNode3, one);
            addOneNode.setInSource(false);
            this.extendWithNode(addOneNode);
            AssignmentTree assignTree = this.treeBuilder.buildAssignment(indexUse3, (ExpressionTree)addOneTree);
            this.handleArtificialTree(assignTree);
            AssignmentNode assignNode = new AssignmentNode(assignTree, indexNode3, addOneNode);
            assignNode.setInSource(false);
            this.extendWithNode(assignNode);
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        }
        this.addLabelForNextNode(loopExit);
        this.breakTargetL = oldBreakTargetL;
        this.continueTargetL = oldContinueTargetL;
        return null;
    }

    protected VariableTree createEnhancedForLoopIteratorVariable(MethodInvocationTree iteratorCall, VariableElement variableElement) {
        TypeMirror iteratorType = TreeUtils.typeOf(iteratorCall);
        VariableTree iteratorVariable = this.treeBuilder.buildVariableDecl(iteratorType, this.uniqueName("iter"), variableElement.getEnclosingElement(), (ExpressionTree)iteratorCall);
        return iteratorVariable;
    }

    protected VariableTree createEnhancedForLoopArrayVariable(ExpressionTree expression, VariableElement variableElement) {
        TypeMirror arrayType = TreeUtils.typeOf(expression);
        VariableTree arrayVariable = this.treeBuilder.buildVariableDecl(arrayType, this.uniqueName("array"), variableElement.getEnclosingElement(), expression);
        return arrayVariable;
    }

    @Override
    public Node visitForLoop(ForLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label conditionStart = new Label();
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label updateStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
        this.breakTargetL = new TryFinallyScopeCell(loopExit);
        TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
        this.continueTargetL = new TryFinallyScopeCell(updateStart);
        for (StatementTree statementTree : tree.getInitializer()) {
            this.scan(statementTree, p);
        }
        this.addLabelForNextNode(conditionStart);
        if (tree.getCondition() != null) {
            this.unbox((Node)this.scan(tree.getCondition(), p));
            ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
            this.extendWithExtendedNode(cjump);
        }
        this.addLabelForNextNode(loopEntry);
        assert (tree.getStatement() != null);
        this.scan(tree.getStatement(), p);
        this.addLabelForNextNode(updateStart);
        for (ExpressionStatementTree expressionStatementTree : tree.getUpdate()) {
            this.scan(expressionStatementTree, p);
        }
        this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        this.addLabelForNextNode(loopExit);
        this.breakTargetL = oldBreakTargetL;
        this.continueTargetL = oldContinueTargetL;
        return null;
    }

    @Override
    public Node visitIdentifier(IdentifierTree tree, Void p) {
        Node node;
        if (TreeUtils.isFieldAccess(tree)) {
            Node receiver = this.getReceiver(tree);
            node = new FieldAccessNode(tree, receiver);
        } else {
            Element element = TreeUtils.elementFromUse(tree);
            switch (element.getKind()) {
                case FIELD: {
                    if (element.getSimpleName().contentEquals("this")) {
                        node = new ExplicitThisNode(tree);
                        break;
                    }
                    node = new SuperNode(tree);
                    break;
                }
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case PARAMETER: {
                    node = new LocalVariableNode(tree);
                    break;
                }
                case PACKAGE: {
                    node = new PackageNameNode(tree);
                    break;
                }
                default: {
                    if (ElementUtils.isTypeDeclaration(element)) {
                        node = new ClassNameNode(tree);
                        break;
                    }
                    if (ElementUtils.isBindingVariable(element)) {
                        node = new LocalVariableNode(tree);
                        break;
                    }
                    throw new BugInCF("bad element kind " + (Object)((Object)element.getKind()));
                }
            }
        }
        if (node instanceof ClassNameNode) {
            this.extendWithClassNameNode((ClassNameNode)node);
        } else {
            this.extendWithNode(node);
        }
        return node;
    }

    @Override
    public Node visitIf(IfTree tree, Void p) {
        Label thenEntry = new Label();
        Label elseEntry = new Label();
        Label endIf = new Label();
        this.unbox((Node)this.scan(tree.getCondition(), p));
        ConditionalJump cjump = new ConditionalJump(thenEntry, elseEntry);
        this.extendWithExtendedNode(cjump);
        this.addLabelForNextNode(thenEntry);
        StatementTree thenStatement = tree.getThenStatement();
        this.scan(thenStatement, p);
        this.extendWithExtendedNode(new UnconditionalJump(endIf));
        this.addLabelForNextNode(elseEntry);
        StatementTree elseStatement = tree.getElseStatement();
        if (elseStatement != null) {
            this.scan(elseStatement, p);
        }
        this.addLabelForNextNode(endIf);
        return null;
    }

    @Override
    public Node visitImport(ImportTree tree, Void p) {
        throw new BugInCF("ImportTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitArrayAccess(ArrayAccessTree tree, Void p) {
        Node array = (Node)this.scan(tree.getExpression(), p);
        Node index = this.unaryNumericPromotion((Node)this.scan(tree.getIndex(), p));
        ArrayAccessNode arrayAccess = new ArrayAccessNode(tree, array, index);
        this.extendWithNode(arrayAccess);
        this.extendWithNodeWithException(arrayAccess, this.arrayIndexOutOfBoundsExceptionType);
        this.extendWithNodeWithException(arrayAccess, this.nullPointerExceptionType);
        return arrayAccess;
    }

    @Override
    public Node visitLabeledStatement(LabeledStatementTree tree, Void p) {
        Name labelName = tree.getLabel();
        Label breakL = new Label(labelName + "_break");
        Label continueL = new Label(labelName + "_continue");
        this.breakLabels.put(labelName, breakL);
        this.continueLabels.put(labelName, continueL);
        this.scan(tree.getStatement(), p);
        this.addLabelForNextNode(breakL);
        this.breakLabels.remove(labelName);
        this.continueLabels.remove(labelName);
        return null;
    }

    @Override
    public Node visitLiteral(LiteralTree tree, Void p) {
        ValueLiteralNode r = null;
        switch (tree.getKind()) {
            case BOOLEAN_LITERAL: {
                r = new BooleanLiteralNode(tree);
                break;
            }
            case CHAR_LITERAL: {
                r = new CharacterLiteralNode(tree);
                break;
            }
            case DOUBLE_LITERAL: {
                r = new DoubleLiteralNode(tree);
                break;
            }
            case FLOAT_LITERAL: {
                r = new FloatLiteralNode(tree);
                break;
            }
            case INT_LITERAL: {
                r = new IntegerLiteralNode(tree);
                break;
            }
            case LONG_LITERAL: {
                r = new LongLiteralNode(tree);
                break;
            }
            case NULL_LITERAL: {
                r = new NullLiteralNode(tree);
                break;
            }
            case STRING_LITERAL: {
                r = new StringLiteralNode(tree);
                break;
            }
            default: {
                throw new BugInCF("unexpected literal tree");
            }
        }
        assert (r != null) : "unexpected literal tree";
        this.extendWithNode(r);
        return r;
    }

    @Override
    public Node visitMethod(MethodTree tree, Void p) {
        throw new BugInCF("MethodTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitModifiers(ModifiersTree tree, Void p) {
        throw new BugInCF("ModifiersTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitNewArray(NewArrayTree tree, Void p) {
        ArrayType type = (ArrayType)TreeUtils.typeOf(tree);
        TypeMirror elemType = type.getComponentType();
        List<? extends ExpressionTree> dimensions = tree.getDimensions();
        List<? extends ExpressionTree> initializers = tree.getInitializers();
        assert (dimensions != null);
        List<Node> dimensionNodes = CollectionsPlume.mapList(dim -> this.unaryNumericPromotion((Node)this.scan((Tree)dim, p)), dimensions);
        List<Object> initializerNodes = initializers == null ? Collections.emptyList() : CollectionsPlume.mapList(init -> this.assignConvert((Node)this.scan((Tree)init, p), elemType), initializers);
        ArrayCreationNode node = new ArrayCreationNode(tree, type, dimensionNodes, initializerNodes);
        this.extendWithNodeWithExceptions(node, this.newArrayExceptionTypes);
        return node;
    }

    @Override
    public Node visitNewClass(NewClassTree tree, Void p) {
        ExpressionTree enclosingExpr = tree.getEnclosingExpression();
        if (enclosingExpr != null) {
            this.scan(enclosingExpr, p);
        }
        ExecutableElement constructor = TreeUtils.elementFromUse(tree);
        List<? extends ExpressionTree> actualExprs = tree.getArguments();
        List<Node> arguments = this.convertCallArguments(constructor, actualExprs);
        Node constructorNode = (Node)this.scan(tree.getIdentifier(), p);
        ClassDeclarationNode classbody = (ClassDeclarationNode)this.scan(tree.getClassBody(), p);
        ObjectCreationNode node = new ObjectCreationNode(tree, constructorNode, arguments, classbody);
        List<? extends TypeMirror> thrownTypes = constructor.getThrownTypes();
        LinkedHashSet<TypeMirror> thrownSet = new LinkedHashSet<TypeMirror>(thrownTypes.size() + this.uncheckedExceptionTypes.size());
        thrownSet.addAll(thrownTypes);
        thrownSet.addAll(this.uncheckedExceptionTypes);
        this.extendWithNodeWithExceptions(node, thrownSet);
        return node;
    }

    @Override
    public Node visitParenthesized(ParenthesizedTree tree, Void p) {
        this.parenMapping.put(tree.getExpression(), tree);
        return (Node)this.scan(tree.getExpression(), p);
    }

    @Override
    public Node visitReturn(ReturnTree tree, Void p) {
        ExpressionTree ret = tree.getExpression();
        ReturnNode result = null;
        if (ret != null) {
            Node node = (Node)this.scan(ret, p);
            result = new ReturnNode(tree, node, this.env.getTypeUtils());
            this.returnNodes.add(result);
            this.extendWithNode(result);
        }
        this.extendWithExtendedNode(new UnconditionalJump(this.returnTargetL.accessLabel()));
        return result;
    }

    @Override
    public Node visitMemberSelect(MemberSelectTree tree, Void p) {
        Node expr = (Node)this.scan(tree.getExpression(), p);
        if (!TreeUtils.isFieldAccess(tree)) {
            Element element = TreeUtils.elementFromUse(tree);
            if (ElementUtils.isTypeElement(element)) {
                ClassNameNode result = new ClassNameNode(tree, expr);
                this.extendWithClassNameNode(result);
                return result;
            }
            if (element.getKind() == ElementKind.PACKAGE) {
                PackageNameNode result = new PackageNameNode(tree, (PackageNameNode)expr);
                this.extendWithNode(result);
                return result;
            }
            throw new BugInCF("Unexpected element kind: " + (Object)((Object)element.getKind()));
        }
        FieldAccessNode node = new FieldAccessNode(tree, expr);
        Element element = TreeUtils.elementFromUse(tree);
        if (ElementUtils.isStatic(element) || expr instanceof ImplicitThisNode || expr instanceof ExplicitThisNode) {
            this.extendWithNode(node);
        } else {
            this.extendWithNodeWithException(node, this.nullPointerExceptionType);
        }
        return node;
    }

    @Override
    public Node visitEmptyStatement(EmptyStatementTree tree, Void p) {
        return null;
    }

    @Override
    public Node visitSynchronized(SynchronizedTree tree, Void p) {
        Node synchronizedExpr = (Node)this.scan(tree.getExpression(), p);
        SynchronizedNode synchronizedStartNode = new SynchronizedNode(tree, synchronizedExpr, true, this.env.getTypeUtils());
        this.extendWithNode(synchronizedStartNode);
        this.scan(tree.getBlock(), p);
        SynchronizedNode synchronizedEndNode = new SynchronizedNode(tree, synchronizedExpr, false, this.env.getTypeUtils());
        this.extendWithNode(synchronizedEndNode);
        return null;
    }

    @Override
    public Node visitThrow(ThrowTree tree, Void p) {
        Node expression = (Node)this.scan(tree.getExpression(), p);
        TypeMirror exception = expression.getType();
        ThrowNode throwsNode = new ThrowNode(tree, expression, this.env.getTypeUtils());
        NodeWithExceptionsHolder exNode = this.extendWithNodeWithException(throwsNode, exception);
        exNode.setTerminatesExecution(true);
        return throwsNode;
    }

    @Override
    public Node visitCompilationUnit(CompilationUnitTree tree, Void p) {
        throw new BugInCF("CompilationUnitTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitTry(TryTree tree, Void p) {
        List<? extends CatchTree> catches = tree.getCatches();
        BlockTree finallyBlock = tree.getFinallyBlock();
        this.extendWithNode(new MarkerNode(tree, "start of try statement #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
        List<Pair<TypeMirror, Label>> catchLabels = CollectionsPlume.mapList(c -> Pair.of(TreeUtils.typeOf(c.getParameter().getType()), new Label()), catches);
        TryFinallyScopeCell oldReturnTargetL = this.returnTargetL;
        TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
        Map<Name, Label> oldBreakLabels = this.breakLabels;
        TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
        Map<Name, Label> oldContinueLabels = this.continueLabels;
        Label finallyLabel = null;
        Label exceptionalFinallyLabel = null;
        if (finallyBlock != null) {
            finallyLabel = new Label();
            exceptionalFinallyLabel = new Label();
            this.tryStack.pushFrame(new TryFinallyFrame(exceptionalFinallyLabel));
            this.returnTargetL = new TryFinallyScopeCell();
            this.breakTargetL = new TryFinallyScopeCell();
            this.breakLabels = new TryFinallyScopeMap();
            this.continueTargetL = new TryFinallyScopeCell();
            this.continueLabels = new TryFinallyScopeMap();
        }
        Label doneLabel = new Label();
        this.tryStack.pushFrame(new TryCatchFrame(this.types, catchLabels));
        List<? extends Tree> resources = tree.getResources();
        for (Tree tree2 : resources) {
            this.scan(tree2, p);
        }
        this.extendWithNode(new MarkerNode(tree, "start of try block #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
        this.scan(tree.getBlock(), p);
        this.extendWithNode(new MarkerNode(tree, "end of try block #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
        this.extendWithExtendedNode(new UnconditionalJump(CFGBuilder.firstNonNull(finallyLabel, doneLabel)));
        this.tryStack.popFrame();
        int catchIndex = 0;
        for (CatchTree catchTree : catches) {
            this.addLabelForNextNode((Label)catchLabels.get((int)catchIndex).second);
            this.extendWithNode(new MarkerNode(tree, "start of catch block for " + catchTree.getParameter().getType() + " #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
            this.scan(catchTree, p);
            this.extendWithNode(new MarkerNode(tree, "end of catch block for " + catchTree.getParameter().getType() + " #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
            ++catchIndex;
            this.extendWithExtendedNode(new UnconditionalJump(CFGBuilder.firstNonNull(finallyLabel, doneLabel)));
        }
        if (finallyLabel != null) {
            this.tryStack.popFrame();
            this.addLabelForNextNode(finallyLabel);
            this.extendWithNode(new MarkerNode(tree, "start of finally block #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
            this.scan(finallyBlock, p);
            this.extendWithNode(new MarkerNode(tree, "end of finally block #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
            this.extendWithExtendedNode(new UnconditionalJump(doneLabel));
            if (this.hasExceptionalPath(exceptionalFinallyLabel)) {
                this.addLabelForNextNode(exceptionalFinallyLabel);
                this.extendWithNode(new MarkerNode(tree, "start of finally block for Throwable #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.scan(finallyBlock, p);
                NodeWithExceptionsHolder nodeWithExceptionsHolder = this.extendWithNodeWithException(new MarkerNode(tree, "end of finally block for Throwable #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()), this.throwableType);
                nodeWithExceptionsHolder.setTerminatesExecution(true);
            }
            if (this.returnTargetL.wasAccessed()) {
                this.addLabelForNextNode(this.returnTargetL.peekLabel());
                this.returnTargetL = oldReturnTargetL;
                this.extendWithNode(new MarkerNode(tree, "start of finally block for return #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.scan(finallyBlock, p);
                this.extendWithNode(new MarkerNode(tree, "end of finally block for return #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.extendWithExtendedNode(new UnconditionalJump(this.returnTargetL.accessLabel()));
            } else {
                this.returnTargetL = oldReturnTargetL;
            }
            if (this.breakTargetL.wasAccessed()) {
                this.addLabelForNextNode(this.breakTargetL.peekLabel());
                this.breakTargetL = oldBreakTargetL;
                this.extendWithNode(new MarkerNode(tree, "start of finally block for break #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.scan(finallyBlock, p);
                this.extendWithNode(new MarkerNode(tree, "end of finally block for break #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.extendWithExtendedNode(new UnconditionalJump(this.breakTargetL.accessLabel()));
            } else {
                this.breakTargetL = oldBreakTargetL;
            }
            Map<Name, Label> map = ((TryFinallyScopeMap)this.breakLabels).getAccessedNames();
            if (!map.isEmpty()) {
                this.breakLabels = oldBreakLabels;
                for (Map.Entry<Name, Label> entry : map.entrySet()) {
                    this.addLabelForNextNode(entry.getValue());
                    this.extendWithNode(new MarkerNode(tree, "start of finally block for break label " + entry.getKey() + " #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                    this.scan(finallyBlock, p);
                    this.extendWithNode(new MarkerNode(tree, "end of finally block for break label " + entry.getKey() + " #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                    this.extendWithExtendedNode(new UnconditionalJump(this.breakLabels.get(entry.getKey())));
                }
            } else {
                this.breakLabels = oldBreakLabels;
            }
            if (this.continueTargetL.wasAccessed()) {
                this.addLabelForNextNode(this.continueTargetL.peekLabel());
                this.continueTargetL = oldContinueTargetL;
                this.extendWithNode(new MarkerNode(tree, "start of finally block for continue #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.scan(finallyBlock, p);
                this.extendWithNode(new MarkerNode(tree, "end of finally block for continue #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                this.extendWithExtendedNode(new UnconditionalJump(this.continueTargetL.accessLabel()));
            } else {
                this.continueTargetL = oldContinueTargetL;
            }
            Map<Name, Label> map2 = ((TryFinallyScopeMap)this.continueLabels).getAccessedNames();
            if (!map2.isEmpty()) {
                this.continueLabels = oldContinueLabels;
                for (Map.Entry<Name, Label> access : map2.entrySet()) {
                    this.addLabelForNextNode(access.getValue());
                    this.extendWithNode(new MarkerNode(tree, "start of finally block for continue label " + access.getKey() + " #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                    this.scan(finallyBlock, p);
                    this.extendWithNode(new MarkerNode(tree, "end of finally block for continue label " + access.getKey() + " #" + TreeUtils.treeUids.get(tree), this.env.getTypeUtils()));
                    this.extendWithExtendedNode(new UnconditionalJump(this.continueLabels.get(access.getKey())));
                }
            } else {
                this.continueLabels = oldContinueLabels;
            }
        }
        this.addLabelForNextNode(doneLabel);
        return null;
    }

    private boolean hasExceptionalPath(Label target) {
        for (ExtendedNode node : this.nodeList) {
            if (!(node instanceof NodeWithExceptionsHolder)) continue;
            NodeWithExceptionsHolder exceptionalNode = (NodeWithExceptionsHolder)node;
            for (Set<Label> labels : exceptionalNode.getExceptions().values()) {
                if (!labels.contains(target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Node visitParameterizedType(ParameterizedTypeTree tree, Void p) {
        ParameterizedTypeNode result = new ParameterizedTypeNode(tree);
        this.extendWithNode(result);
        return result;
    }

    @Override
    public Node visitUnionType(UnionTypeTree tree, Void p) {
        throw new BugInCF("UnionTypeTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitArrayType(ArrayTypeTree tree, Void p) {
        ArrayTypeNode result = new ArrayTypeNode(tree, this.types);
        this.extendWithNode(new ArrayTypeNode(tree, this.types));
        return result;
    }

    @Override
    public Node visitTypeCast(TypeCastTree tree, Void p) {
        Node operand = (Node)this.scan(tree.getExpression(), p);
        TypeMirror type = TreeUtils.typeOf(tree.getType());
        TypeCastNode node = new TypeCastNode(tree, operand, type, this.types);
        this.extendWithNodeWithException(node, this.classCastExceptionType);
        return node;
    }

    @Override
    public Node visitPrimitiveType(PrimitiveTypeTree tree, Void p) {
        PrimitiveTypeNode result = new PrimitiveTypeNode(tree, this.types);
        this.extendWithNode(result);
        return result;
    }

    @Override
    public Node visitTypeParameter(TypeParameterTree tree, Void p) {
        throw new BugInCF("TypeParameterTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitInstanceOf(InstanceOfTree tree, Void p) {
        Node operand = (Node)this.scan(tree.getExpression(), p);
        TypeMirror refType = TreeUtils.typeOf(tree.getType());
        InstanceOfNode node = new InstanceOfNode(tree, operand, refType, this.types);
        this.extendWithNode(node);
        return node;
    }

    @Override
    public Node visitUnary(UnaryTree tree, Void p) {
        Node result = null;
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case BITWISE_COMPLEMENT: 
            case UNARY_MINUS: 
            case UNARY_PLUS: {
                Node expr = (Node)this.scan(tree.getExpression(), p);
                expr = this.unaryNumericPromotion(expr);
                switch (kind) {
                    case BITWISE_COMPLEMENT: {
                        result = new BitwiseComplementNode(tree, expr);
                        break;
                    }
                    case UNARY_MINUS: {
                        result = new NumericalMinusNode(tree, expr);
                        break;
                    }
                    case UNARY_PLUS: {
                        result = new NumericalPlusNode(tree, expr);
                        break;
                    }
                    default: {
                        throw new BugInCF("Unexpected kind: " + (Object)((Object)kind));
                    }
                }
                this.extendWithNode(result);
                break;
            }
            case LOGICAL_COMPLEMENT: {
                Node expr = (Node)this.scan(tree.getExpression(), p);
                result = new ConditionalNotNode(tree, this.unbox(expr));
                this.extendWithNode(result);
                break;
            }
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                ExpressionTree exprTree = tree.getExpression();
                Node expr = (Node)this.scan(exprTree, p);
                boolean isIncrement = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.PREFIX_INCREMENT;
                boolean isPostfix = kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.POSTFIX_DECREMENT;
                AssignmentNode unaryAssign = this.createIncrementOrDecrementAssign(isPostfix ? null : tree, expr, isIncrement);
                this.addToUnaryAssignLookupMap(tree, unaryAssign);
                if (isPostfix) {
                    TypeMirror exprType = TreeUtils.typeOf(exprTree);
                    VariableTree tempVarDecl = this.treeBuilder.buildVariableDecl(exprType, this.uniqueName("tempPostfix"), this.findOwner(), tree.getExpression());
                    this.handleArtificialTree(tempVarDecl);
                    VariableDeclarationNode tempVarDeclNode = new VariableDeclarationNode(tempVarDecl);
                    tempVarDeclNode.setInSource(false);
                    this.extendWithNode(tempVarDeclNode);
                    IdentifierTree tempVar = this.treeBuilder.buildVariableUse(tempVarDecl);
                    this.handleArtificialTree(tempVar);
                    LocalVariableNode tempVarNode = new LocalVariableNode(tempVar);
                    tempVarNode.setInSource(false);
                    this.extendWithNode(tempVarNode);
                    AssignmentNode tempAssignNode = new AssignmentNode(tree, tempVarNode, expr);
                    tempAssignNode.setInSource(false);
                    this.extendWithNode(tempAssignNode);
                    IdentifierTree resultExpr = this.treeBuilder.buildVariableUse(tempVarDecl);
                    this.handleArtificialTree(resultExpr);
                    result = new LocalVariableNode(resultExpr);
                    result.setInSource(false);
                    this.extendWithNode(result);
                    break;
                }
                result = unaryAssign;
                break;
            }
            default: {
                if (tree.toString().startsWith("<*nullchk*>")) {
                    Node expr = (Node)this.scan(tree.getExpression(), p);
                    result = new NullChkNode(tree, expr);
                    this.extendWithNode(result);
                    break;
                }
                throw new BugInCF("Unknown kind (" + (Object)((Object)kind) + ") of unary expression: " + tree);
            }
        }
        return result;
    }

    private AssignmentNode createIncrementOrDecrementAssign(Tree target, Node expr, boolean isIncrement) {
        ExpressionTree exprTree = (ExpressionTree)expr.getTree();
        TypeMirror exprType = expr.getType();
        PrimitiveType oneType = this.types.getPrimitiveType(TypeKind.INT);
        TypeMirror promotedType = this.binaryPromotedType(exprType, oneType);
        LiteralTree oneTree = this.treeBuilder.buildLiteral(1);
        this.handleArtificialTree(oneTree);
        Node exprRHS = this.binaryNumericPromotion(expr, promotedType);
        Node one = new IntegerLiteralNode(oneTree);
        one.setInSource(false);
        this.extendWithNode(one);
        one = this.binaryNumericPromotion(one, promotedType);
        BinaryTree operTree = this.treeBuilder.buildBinary(promotedType, isIncrement ? Tree.Kind.PLUS : Tree.Kind.MINUS, exprTree, oneTree);
        this.handleArtificialTree(operTree);
        BinaryOperationNode operNode = isIncrement ? new NumericalAdditionNode(operTree, exprRHS, one) : new NumericalSubtractionNode(operTree, exprRHS, one);
        operNode.setInSource(false);
        this.extendWithNode(operNode);
        Node narrowed = this.narrowAndBox(operNode, exprType);
        if (target == null) {
            target = this.treeBuilder.buildAssignment(exprTree, (ExpressionTree)narrowed.getTree());
            this.handleArtificialTree(target);
        }
        AssignmentNode assignNode = new AssignmentNode(target, expr, narrowed);
        assignNode.setInSource(false);
        this.extendWithNode(assignNode);
        return assignNode;
    }

    @Override
    public Node visitVariable(VariableTree tree, Void p) {
        Tree.Kind kind;
        boolean isField = false;
        if (this.getCurrentPath().getParentPath() != null && ((kind = TreeUtils.getKindRecordAsClass(this.getCurrentPath().getParentPath().getLeaf())) == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE || kind == Tree.Kind.ENUM)) {
            isField = true;
        }
        AssignmentNode node = null;
        ClassTree enclosingClass = TreePathUtil.enclosingClass(this.getCurrentPath());
        TypeElement classElem = TreeUtils.elementFromDeclaration(enclosingClass);
        ImplicitThisNode receiver = new ImplicitThisNode(classElem.asType());
        if (isField) {
            ExpressionTree initializer = tree.getInitializer();
            assert (initializer != null);
            node = this.translateAssignment((Tree)tree, (Node)new FieldAccessNode(tree, TreeUtils.elementFromDeclaration(tree), receiver), initializer);
        } else {
            VariableDeclarationNode decl = new VariableDeclarationNode(tree);
            this.extendWithNode(decl);
            ExpressionTree initializer = tree.getInitializer();
            if (initializer != null) {
                node = this.translateAssignment((Tree)tree, (Node)new LocalVariableNode(tree, receiver), initializer);
            }
        }
        return node;
    }

    @Override
    public Node visitWhileLoop(WhileLoopTree tree, Void p) {
        Name parentLabel = this.getLabel(this.getCurrentPath());
        Label loopEntry = new Label();
        Label loopExit = new Label();
        Label conditionStart = parentLabel != null ? this.continueLabels.get(parentLabel) : new Label();
        TryFinallyScopeCell oldBreakTargetL = this.breakTargetL;
        this.breakTargetL = new TryFinallyScopeCell(loopExit);
        TryFinallyScopeCell oldContinueTargetL = this.continueTargetL;
        this.continueTargetL = new TryFinallyScopeCell(conditionStart);
        this.addLabelForNextNode(conditionStart);
        assert (tree.getCondition() != null);
        boolean isCondConstTrue = TreeUtils.isExprConstTrue(tree.getCondition());
        this.unbox((Node)this.scan(tree.getCondition(), p));
        if (!isCondConstTrue) {
            ConditionalJump cjump = new ConditionalJump(loopEntry, loopExit);
            this.extendWithExtendedNode(cjump);
        }
        this.addLabelForNextNode(loopEntry);
        assert (tree.getStatement() != null);
        this.scan(tree.getStatement(), p);
        if (isCondConstTrue) {
            this.extendWithExtendedNode(new UnconditionalJump(loopEntry));
        } else {
            this.extendWithExtendedNode(new UnconditionalJump(conditionStart));
        }
        this.addLabelForNextNode(loopExit);
        this.breakTargetL = oldBreakTargetL;
        this.continueTargetL = oldContinueTargetL;
        return null;
    }

    @Override
    public Node visitLambdaExpression(LambdaExpressionTree tree, Void p) {
        this.declaredLambdas.add(tree);
        FunctionalInterfaceNode node = new FunctionalInterfaceNode(tree);
        this.extendWithNode(node);
        return node;
    }

    @Override
    public Node visitMemberReference(MemberReferenceTree tree, Void p) {
        ExpressionTree enclosingExpr = tree.getQualifierExpression();
        if (enclosingExpr != null) {
            this.scan(enclosingExpr, p);
        }
        FunctionalInterfaceNode node = new FunctionalInterfaceNode(tree);
        this.extendWithNode(node);
        return node;
    }

    @Override
    public Node visitWildcard(WildcardTree tree, Void p) {
        throw new BugInCF("WildcardTree is unexpected in AST to CFG translation");
    }

    @Override
    public Node visitOther(Tree tree, Void p) {
        throw new BugInCF("Unknown AST element encountered in AST to CFG translation.");
    }

    private TypeMirror getTypeMirror(Class<?> clazz) {
        return TypesUtils.typeFromClass(clazz, this.types, this.elements);
    }

    private @Nullable TypeMirror maybeGetTypeMirror(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        assert (name != null) : clazz + " does not have a canonical name";
        TypeElement element = this.elements.getTypeElement(name);
        if (element == null) {
            return null;
        }
        return element.asType();
    }

    private class SwitchBuilder {
        private final SwitchTree switchTree;
        private final Label[] caseBodyLabels;
        private Node switchExpr;

        private SwitchBuilder(SwitchTree tree) {
            this.switchTree = tree;
            this.caseBodyLabels = new Label[this.switchTree.getCases().size() + 1];
        }

        public void build() {
            TryFinallyScopeCell oldBreakTargetL = CFGTranslationPhaseOne.this.breakTargetL;
            CFGTranslationPhaseOne.this.breakTargetL = new TryFinallyScopeCell(new Label());
            int cases = this.caseBodyLabels.length - 1;
            for (int i = 0; i < cases; ++i) {
                this.caseBodyLabels[i] = new Label();
            }
            this.caseBodyLabels[cases] = CFGTranslationPhaseOne.this.breakTargetL.peekLabel();
            TypeMirror switchExprType = TreeUtils.typeOf(this.switchTree.getExpression());
            VariableTree variable = CFGTranslationPhaseOne.this.treeBuilder.buildVariableDecl(switchExprType, CFGTranslationPhaseOne.this.uniqueName("switch"), CFGTranslationPhaseOne.this.findOwner(), null);
            CFGTranslationPhaseOne.this.handleArtificialTree(variable);
            VariableDeclarationNode variableNode = new VariableDeclarationNode(variable);
            variableNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(variableNode);
            IdentifierTree variableUse = CFGTranslationPhaseOne.this.treeBuilder.buildVariableUse(variable);
            CFGTranslationPhaseOne.this.handleArtificialTree(variableUse);
            LocalVariableNode variableUseNode = new LocalVariableNode(variableUse);
            variableUseNode.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(variableUseNode);
            Node switchExprNode = CFGTranslationPhaseOne.this.unbox((Node)CFGTranslationPhaseOne.this.scan(this.switchTree.getExpression(), null));
            AssignmentTree assign = CFGTranslationPhaseOne.this.treeBuilder.buildAssignment(variableUse, this.switchTree.getExpression());
            CFGTranslationPhaseOne.this.handleArtificialTree(assign);
            this.switchExpr = new AssignmentNode(assign, variableUseNode, switchExprNode);
            this.switchExpr.setInSource(false);
            CFGTranslationPhaseOne.this.extendWithNode(this.switchExpr);
            CFGTranslationPhaseOne.this.extendWithNode(new MarkerNode(this.switchTree, "start of switch statement #" + TreeUtils.treeUids.get(this.switchTree), CFGTranslationPhaseOne.this.env.getTypeUtils()));
            Integer defaultIndex = null;
            for (int i = 0; i < cases; ++i) {
                CaseTree caseTree = this.switchTree.getCases().get(i);
                if (TreeUtils.caseTreeGetExpressions(caseTree).isEmpty()) {
                    defaultIndex = i;
                    continue;
                }
                this.buildCase(caseTree, i);
            }
            if (defaultIndex != null) {
                this.buildCase(this.switchTree.getCases().get(defaultIndex), defaultIndex);
            }
            CFGTranslationPhaseOne.this.addLabelForNextNode(CFGTranslationPhaseOne.this.breakTargetL.peekLabel());
            CFGTranslationPhaseOne.this.breakTargetL = oldBreakTargetL;
            CFGTranslationPhaseOne.this.extendWithNode(new MarkerNode(this.switchTree, "end of switch statement #" + TreeUtils.treeUids.get(this.switchTree), CFGTranslationPhaseOne.this.env.getTypeUtils()));
        }

        private void buildCase(CaseTree tree, int index) {
            Label thisBodyL = this.caseBodyLabels[index];
            Label nextBodyL = this.caseBodyLabels[index + 1];
            Label nextCaseL = new Label();
            List<? extends ExpressionTree> exprTrees = TreeUtils.caseTreeGetExpressions(tree);
            if (!exprTrees.isEmpty()) {
                ArrayList<Node> exprs = new ArrayList<Node>();
                for (ExpressionTree expressionTree : exprTrees) {
                    exprs.add((Node)CFGTranslationPhaseOne.this.scan(expressionTree, null));
                }
                CaseNode caseNode = new CaseNode(tree, this.switchExpr, exprs, CFGTranslationPhaseOne.this.env.getTypeUtils());
                CFGTranslationPhaseOne.this.extendWithNode(caseNode);
                CFGTranslationPhaseOne.this.extendWithExtendedNode(new ConditionalJump(thisBodyL, nextCaseL));
            }
            CFGTranslationPhaseOne.this.addLabelForNextNode(thisBodyL);
            for (StatementTree statementTree : tree.getStatements()) {
                CFGTranslationPhaseOne.this.scan(statementTree, null);
            }
            CFGTranslationPhaseOne.this.extendWithExtendedNode(new UnconditionalJump(nextBodyL));
            CFGTranslationPhaseOne.this.addLabelForNextNode(nextCaseL);
        }
    }
}

