/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.block;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.shaded.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.shaded.dataflow.cfg.block.Block;

public abstract class BlockImpl
implements Block {
    protected final Block.BlockType type;
    protected final Set<BlockImpl> predecessors;
    static final AtomicLong nextUid = new AtomicLong(0L);
    final long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization BlockImpl this) {
        return this.uid;
    }

    protected BlockImpl(Block.BlockType type) {
        this.type = type;
        this.predecessors = new LinkedHashSet<BlockImpl>();
    }

    @Override
    public Block.BlockType getType() {
        return this.type;
    }

    @Override
    public Set<Block> getPredecessors() {
        return new LinkedHashSet<Block>(this.predecessors);
    }

    public void addPredecessor(BlockImpl pred) {
        this.predecessors.add(pred);
    }

    public void removePredecessor(BlockImpl pred) {
        this.predecessors.remove(pred);
    }
}

