/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.Element;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.shaded.javacutil.TreeUtils;

public class LocalVariableNode
extends Node {
    protected final Tree tree;
    protected final @Nullable Node receiver;

    public LocalVariableNode(Tree tree) {
        this(tree, null);
    }

    public LocalVariableNode(Tree tree, @Nullable Node receiver) {
        super(TreeUtils.typeOf(tree));
        assert (tree != null);
        assert (tree instanceof IdentifierTree || tree instanceof VariableTree);
        this.tree = tree;
        this.receiver = receiver;
    }

    public Element getElement() {
        Element el;
        if (this.tree instanceof IdentifierTree) {
            IdentifierTree itree = (IdentifierTree)this.tree;
            assert (TreeUtils.isUseOfElement(itree)) : "@AssumeAssertion(nullness): tree kind";
            el = TreeUtils.elementFromUse(itree);
        } else {
            assert (this.tree instanceof VariableTree);
            el = TreeUtils.elementFromDeclaration((VariableTree)this.tree);
        }
        return el;
    }

    public @Nullable Node getReceiver() {
        return this.receiver;
    }

    public String getName() {
        if (this.tree instanceof IdentifierTree) {
            return ((IdentifierTree)this.tree).getName().toString();
        }
        return ((VariableTree)this.tree).getName().toString();
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLocalVariable(this, p);
    }

    public String toString() {
        return this.getName().toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LocalVariableNode)) {
            return false;
        }
        LocalVariableNode other = (LocalVariableNode)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

