/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.expression;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.util.TreePath;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.expression.ClassName;
import org.checkerframework.nullaway.dataflow.expression.ExpressionTreeToJavaExpressionVisitor;
import org.checkerframework.nullaway.dataflow.expression.FormalParameter;
import org.checkerframework.nullaway.dataflow.expression.JavaExpression;
import org.checkerframework.nullaway.dataflow.expression.JavaExpressionParseException;
import org.checkerframework.nullaway.dataflow.expression.ThisReference;
import org.checkerframework.nullaway.javacutil.javacparse.JavacParse;
import org.checkerframework.nullaway.javacutil.javacparse.JavacParseResult;
import org.checkerframework.nullaway.org.plumelib.util.StringsPlume;

public class JavaExpressionParseUtil {
    static final String PARAMETER_REGEX = "#([1-9][0-9]*)";
    static final Pattern PARAMETER_PATTERN = Pattern.compile("#(\\d+)");
    static final String PARAMETER_PREFIX = "_param_";
    static final int PARAMETER_PREFIX_LENGTH = "_param_".length();
    static final String PARAMETER_REPLACEMENT = "_param_$1";

    private JavaExpressionParseUtil() {
        throw new Error("Do not instantiate");
    }

    public static JavaExpression parse(String expression, TypeMirror enclosingType, @Nullable ThisReference thisReference, @Nullable List<FormalParameter> parameters, @Nullable TreePath localVarPath, TreePath pathToCompilationUnit, ProcessingEnvironment env) throws JavaExpressionParseException {
        ExpressionTree exprTree;
        String expressionWithParameterNames = StringsPlume.replaceAll(expression, PARAMETER_PATTERN, PARAMETER_REPLACEMENT);
        try {
            JavacParseResult<ExpressionTree> jpr = JavacParse.parseExpression(expressionWithParameterNames);
            if (jpr.hasParseError()) {
                throw JavaExpressionParseException.construct(expression, jpr.getParseErrorMessages());
            }
            exprTree = jpr.getTree();
        }
        catch (IllegalArgumentException e) {
            @NonNull String msg = e.getMessage();
            throw JavaExpressionParseException.construct(expression, msg);
        }
        JavaExpression result = ExpressionTreeToJavaExpressionVisitor.convert(exprTree, enclosingType, thisReference, parameters, localVarPath, pathToCompilationUnit, env);
        if (result instanceof ClassName && !expression.endsWith(".class")) {
            throw JavaExpressionParseException.construct(expression, String.format("a class name cannot terminate a Java expression string, where result=%s [%s]", result, result.getClass()));
        }
        return result;
    }

    public static int parameterIndex(String s) {
        Matcher matcher = PARAMETER_PATTERN.matcher(s);
        if (matcher.matches()) {
            @NonNull String group1 = matcher.group(1);
            return Integer.parseInt(group1);
        }
        return -1;
    }
}

