/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.NodeVisitor;

public class LeftShiftNode
extends BinaryOperationNode {
    public LeftShiftNode(BinaryTree tree, Node left, Node right) {
        super(tree, left, right);
        assert (tree.getKind() == Tree.Kind.LEFT_SHIFT);
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLeftShift(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " << " + this.getRightOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LeftShiftNode)) {
            return false;
        }
        LeftShiftNode other = (LeftShiftNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

