/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.builder;

import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.util.Types;
import org.checkerframework.nullaway.dataflow.cfg.builder.Label;
import org.checkerframework.nullaway.dataflow.cfg.builder.TryFrame;
import org.checkerframework.nullaway.org.plumelib.util.IPair;

class TryCatchFrame
implements TryFrame {
    protected final Types types;
    protected final List<IPair<TypeMirror, Label>> catchLabels;

    public TryCatchFrame(Types types, List<IPair<TypeMirror, Label>> catchLabels) {
        this.types = types;
        this.catchLabels = catchLabels;
    }

    public String toString() {
        if (this.catchLabels.isEmpty()) {
            return "TryCatchFrame: no catch labels.";
        }
        StringJoiner sb = new StringJoiner(System.lineSeparator(), "TryCatchFrame: ", "");
        for (IPair<TypeMirror, Label> ptml : this.catchLabels) {
            sb.add(((TypeMirror)ptml.first).toString() + " -> " + ((Label)ptml.second).toString());
        }
        return sb.toString();
    }

    @Override
    public boolean possibleLabels(TypeMirror thrown, Set<Label> labels) {
        while (!(thrown instanceof DeclaredType)) {
            assert (thrown instanceof TypeVariable) : "thrown type must be a variable or a declared type";
            thrown = ((TypeVariable)thrown).getUpperBound();
        }
        DeclaredType declaredThrown = (DeclaredType)thrown;
        assert (thrown != null) : "thrown type must be bounded by a declared type";
        for (IPair<TypeMirror, Label> pair : this.catchLabels) {
            TypeMirror caught = (TypeMirror)pair.first;
            boolean canApply = false;
            if (caught.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredCaught = (DeclaredType)caught;
                if (this.types.isSubtype(declaredThrown, declaredCaught)) {
                    labels.add((Label)pair.second);
                    return true;
                }
                if (this.types.isSubtype(declaredCaught, declaredThrown)) {
                    canApply = true;
                }
            } else {
                assert (caught.getKind() == TypeKind.UNION) : "caught type must be a union or a declared type";
                UnionType caughtUnion = (UnionType)caught;
                for (TypeMirror typeMirror : caughtUnion.getAlternatives()) {
                    assert (typeMirror.getKind() == TypeKind.DECLARED) : "alternatives of an caught union type must be declared types";
                    DeclaredType declaredAlt = (DeclaredType)typeMirror;
                    if (this.types.isSubtype(declaredThrown, declaredAlt)) {
                        labels.add((Label)pair.second);
                        return true;
                    }
                    if (!this.types.isSubtype(declaredAlt, declaredThrown)) continue;
                    canApply = true;
                }
            }
            if (!canApply) continue;
            labels.add((Label)pair.second);
        }
        return false;
    }
}

