/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.collect;

import java.util.NoSuchElementException;
import org.checkerframework.com.google.common.annotations.Beta;
import org.checkerframework.com.google.common.annotations.GwtCompatible;
import org.checkerframework.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.com.google.common.base.Preconditions;
import org.checkerframework.com.google.common.collect.BoundType;
import org.checkerframework.com.google.common.collect.DescendingImmutableSortedSet;
import org.checkerframework.com.google.common.collect.DiscreteDomain;
import org.checkerframework.com.google.common.collect.EmptyContiguousSet;
import org.checkerframework.com.google.common.collect.ImmutableSortedSet;
import org.checkerframework.com.google.common.collect.Ordering;
import org.checkerframework.com.google.common.collect.Range;
import org.checkerframework.com.google.common.collect.RegularContiguousSet;
import org.checkerframework.com.google.errorprone.annotations.DoNotCall;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;

@GwtCompatible(emulated=true)
public abstract class ContiguousSet<@SubstringIndexBottom C extends @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Comparable>
extends ImmutableSortedSet<C> {
    final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness DiscreteDomain<C> domain;

    public static <C extends Comparable> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> create(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Range<C> range, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness DiscreteDomain<C> domain) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(domain);
        Range<C> effectiveRange = range;
        try {
            if (!range.hasLowerBound()) {
                effectiveRange = effectiveRange.intersection(Range.atLeast(domain.minValue()));
            }
            if (!range.hasUpperBound()) {
                effectiveRange = effectiveRange.intersection(Range.atMost(domain.maxValue()));
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(e);
        }
        boolean empty = effectiveRange.isEmpty() || Range.compareOrThrow(range.lowerBound.leastValueAbove(domain), range.upperBound.greatestValueBelow(domain)) > 0;
        return empty ? new EmptyContiguousSet<C>(domain) : new RegularContiguousSet<C>(effectiveRange, domain);
    }

    @Beta
    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Integer> closed(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int lower, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int upper) {
        return ContiguousSet.create(Range.closed(lower, upper), DiscreteDomain.integers());
    }

    @Beta
    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Long> closed(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long lower, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long upper) {
        return ContiguousSet.create(Range.closed(lower, upper), DiscreteDomain.longs());
    }

    @Beta
    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Integer> closedOpen(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int lower, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int upper) {
        return ContiguousSet.create(Range.closedOpen(lower, upper), DiscreteDomain.integers());
    }

    @Beta
    public static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Long> closedOpen(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long lower, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long upper) {
        return ContiguousSet.create(Range.closedOpen(lower, upper), DiscreteDomain.longs());
    }

    ContiguousSet(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness DiscreteDomain<C> domain) {
        super(Ordering.natural());
        this.domain = domain;
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> headSet(C toElement) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(toElement)), false);
    }

    @Override
    @SideEffectFree
    @GwtIncompatible
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> headSet(C toElement, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean inclusive) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(toElement)), inclusive);
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> subSet(C fromElement, C toElement) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, true, toElement, false);
    }

    @Override
    @SideEffectFree
    @GwtIncompatible
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> subSet(C fromElement, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean fromInclusive, C toElement, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator().compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> tailSet(C fromElement) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(fromElement)), true);
    }

    @Override
    @SideEffectFree
    @GwtIncompatible
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> tailSet(C fromElement, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean inclusive) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(fromElement)), inclusive);
    }

    @Override
    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> headSetImpl(C var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean var2);

    @Override
    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> subSetImpl(C var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean var2, C var3, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean var4);

    @Override
    abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> tailSetImpl(C var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean var2);

    public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> intersection(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ContiguousSet<C> var1);

    public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Range<C> range();

    public abstract @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Range<C> range(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness BoundType var1, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness BoundType var2);

    @Override
    @GwtIncompatible
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ImmutableSortedSet<C> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness String toString() {
        return this.range().toString();
    }

    @Deprecated
    @DoNotCall(value="Always throws UnsupportedOperationException")
    public static <E> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ImmutableSortedSet.Builder<E> builder() {
        throw new UnsupportedOperationException();
    }
}

