/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.com.google.common.collect;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.index.qual.LessThanBottom;
import org.checkerframework.errorprone.checker.index.qual.LessThanUnknown;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.errorprone.checker.index.qual.NonNegative;
import org.checkerframework.errorprone.checker.index.qual.SameLenBottom;
import org.checkerframework.errorprone.checker.index.qual.SameLenUnknown;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.errorprone.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundBottom;
import org.checkerframework.errorprone.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.errorprone.checker.initialization.qual.Initialized;
import org.checkerframework.errorprone.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.errorprone.checker.nullness.qual.EnsuresKeyFor;
import org.checkerframework.errorprone.checker.nullness.qual.EnsuresKeyForIf;
import org.checkerframework.errorprone.checker.nullness.qual.KeyFor;
import org.checkerframework.errorprone.checker.nullness.qual.KeyForBottom;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.nullness.qual.PolyNull;
import org.checkerframework.errorprone.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.errorprone.checker.signedness.qual.PolySigned;
import org.checkerframework.errorprone.checker.signedness.qual.Signed;
import org.checkerframework.errorprone.checker.signedness.qual.SignednessBottom;
import org.checkerframework.errorprone.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.errorprone.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.errorprone.com.google.common.annotations.J2ktIncompatible;
import org.checkerframework.errorprone.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.errorprone.com.google.common.base.Preconditions;
import org.checkerframework.errorprone.com.google.common.collect.AbstractMapEntry;
import org.checkerframework.errorprone.com.google.common.collect.CollectPreconditions;
import org.checkerframework.errorprone.com.google.common.collect.CollectSpliterators;
import org.checkerframework.errorprone.com.google.common.collect.CompactHashing;
import org.checkerframework.errorprone.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.checkerframework.errorprone.com.google.common.collect.Hashing;
import org.checkerframework.errorprone.com.google.common.collect.Maps;
import org.checkerframework.errorprone.com.google.common.collect.NullnessCasts;
import org.checkerframework.errorprone.com.google.common.collect.ObjectArrays;
import org.checkerframework.errorprone.com.google.common.collect.ParametricNullness;
import org.checkerframework.errorprone.com.google.common.primitives.Ints;
import org.checkerframework.errorprone.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.errorprone.com.google.errorprone.annotations.concurrent.LazyInit;
import org.checkerframework.errorprone.common.value.qual.BottomVal;
import org.checkerframework.errorprone.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
class CompactHashMap<@SubstringIndexBottom K, @SubstringIndexBottom V>
extends AbstractMap<K, V>
implements Serializable {
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object NOT_FOUND = new Object();
    @VisibleForTesting
    static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed double HASH_FLOODING_FPP = 0.001;
    private static final @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int MAX_HASH_BUCKET_LENGTH = 9;
    @CheckForNull
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Object table;
    @CheckForNull
    @VisibleForTesting
    transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed [] entries;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed [] keys;
    @CheckForNull
    @VisibleForTesting
    transient @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed [] values;
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int metadata;
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int size;
    @LazyInit
    @CheckForNull
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Set<K> keySetView;
    @LazyInit
    @CheckForNull
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Set<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V>> entrySetView;
    @LazyInit
    @CheckForNull
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Collection<V> valuesView;

    public static <K, V> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K, V> @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed CompactHashMap<K, V> createWithExpectedSize(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expectedSize) {
        return new CompactHashMap<K, V>(expectedSize);
    }

    CompactHashMap() {
        this.init(3);
    }

    CompactHashMap(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expectedSize) {
        this.init(expectedSize);
    }

    void init(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange(expectedSize, 1, 0x3FFFFFFF);
    }

    @VisibleForTesting
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean needsAllocArrays() {
        return this.table == null;
    }

    @CanIgnoreReturnValue
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int expectedSize = this.metadata;
        int buckets = CompactHashing.tableSize(expectedSize);
        this.table = CompactHashing.createTable(buckets);
        this.setHashTableMask(buckets - 1);
        this.entries = new int[expectedSize];
        this.keys = new Object[expectedSize];
        this.values = new Object[expectedSize];
        return expectedSize;
    }

    @CheckForNull
    @VisibleForTesting
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Map<K, V> delegateOrNull() {
        if (this.table instanceof Map) {
            return (Map)this.table;
        }
        return null;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map<K, V> createHashFloodingResistantDelegate(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int tableSize) {
        return new LinkedHashMap(tableSize, 1.0f);
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map<K, V> convertToHashFloodingResistantImplementation() {
        Map<K, V> newDelegate = this.createHashFloodingResistantDelegate(this.hashTableMask() + 1);
        int i = this.firstEntryIndex();
        while (i >= 0) {
            newDelegate.put(this.key(i), this.value(i));
            i = this.getSuccessor(i);
        }
        this.table = newDelegate;
        this.entries = null;
        this.keys = null;
        this.values = null;
        this.incrementModCount();
        return newDelegate;
    }

    private void setHashTableMask(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int mask) {
        int hashTableBits = 32 - Integer.numberOfLeadingZeros(mask);
        this.metadata = CompactHashing.maskCombine(this.metadata, hashTableBits, 31);
    }

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    void accessEntry(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int index) {
    }

    @Override
    @CheckForNull
    @ReleasesNoLocks
    @EnsuresKeyFor(value={"#1"}, map={"this"})
    @CanIgnoreReturnValue
    public @Nullable V put(@ParametricNullness K key, @ParametricNullness V value) {
        Map<K, V> delegate;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((delegate = this.delegateOrNull()) != null) {
            return delegate.put(key, value);
        }
        int[] entries = this.requireEntries();
        @Nullable Object[] keys = this.requireKeys();
        @Nullable Object[] values = this.requireValues();
        int newEntryIndex = this.size;
        int newSize = newEntryIndex + 1;
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int tableIndex = hash & mask;
        int next = CompactHashing.tableGet(this.requireTable(), tableIndex);
        if (next == 0) {
            if (newSize > mask) {
                mask = this.resizeTable(mask, CompactHashing.newCapacity(mask), hash, newEntryIndex);
            } else {
                CompactHashing.tableSet(this.requireTable(), tableIndex, newEntryIndex + 1);
            }
        } else {
            int entry;
            int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
            int bucketLength = 0;
            do {
                int entryIndex;
                if (CompactHashing.getHashPrefix(entry = entries[entryIndex = next - 1], mask) == hashPrefix && org.checkerframework.errorprone.com.google.common.base.Objects.equal(key, keys[entryIndex])) {
                    Object oldValue = values[entryIndex];
                    values[entryIndex] = value;
                    this.accessEntry(entryIndex);
                    return (V)oldValue;
                }
                next = CompactHashing.getNext(entry, mask);
                ++bucketLength;
            } while (next != 0);
            if (bucketLength >= 9) {
                return this.convertToHashFloodingResistantImplementation().put(key, value);
            }
            if (newSize > mask) {
                mask = this.resizeTable(mask, CompactHashing.newCapacity(mask), hash, newEntryIndex);
            } else {
                entries[entryIndex] = CompactHashing.maskCombine(entry, newEntryIndex + 1, mask);
            }
        }
        this.resizeMeMaybe(newSize);
        this.insertEntry(newEntryIndex, key, value, hash, mask);
        this.size = newSize;
        this.incrementModCount();
        return null;
    }

    void insertEntry(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int entryIndex, @ParametricNullness K key, @ParametricNullness V value, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int hash, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int mask) {
        this.setEntry(entryIndex, CompactHashing.maskCombine(hash, 0, mask));
        this.setKey(entryIndex, key);
        this.setValue(entryIndex, value);
    }

    private void resizeMeMaybe(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int newSize) {
        int newCapacity;
        int entriesSize = this.requireEntries().length;
        if (newSize > entriesSize && (newCapacity = Math.min(0x3FFFFFFF, entriesSize + Math.max(1, entriesSize >>> 1) | 1)) != entriesSize) {
            this.resizeEntries(newCapacity);
        }
    }

    void resizeEntries(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int newCapacity) {
        this.entries = Arrays.copyOf(this.requireEntries(), newCapacity);
        this.keys = Arrays.copyOf(this.requireKeys(), newCapacity);
        this.values = Arrays.copyOf(this.requireValues(), newCapacity);
    }

    @CanIgnoreReturnValue
    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int resizeTable(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int oldMask, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int newCapacity, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int targetHash, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int targetEntryIndex) {
        Object newTable = CompactHashing.createTable(newCapacity);
        int newMask = newCapacity - 1;
        if (targetEntryIndex != 0) {
            CompactHashing.tableSet(newTable, targetHash & newMask, targetEntryIndex + 1);
        }
        Object oldTable = this.requireTable();
        int[] entries = this.requireEntries();
        for (int oldTableIndex = 0; oldTableIndex <= oldMask; ++oldTableIndex) {
            int oldNext = CompactHashing.tableGet(oldTable, oldTableIndex);
            while (oldNext != 0) {
                int entryIndex = oldNext - 1;
                int oldEntry = entries[entryIndex];
                int hash = CompactHashing.getHashPrefix(oldEntry, oldMask) | oldTableIndex;
                int newTableIndex = hash & newMask;
                int newNext = CompactHashing.tableGet(newTable, newTableIndex);
                CompactHashing.tableSet(newTable, newTableIndex, oldNext);
                entries[entryIndex] = CompactHashing.maskCombine(hash, newNext, newMask);
                oldNext = CompactHashing.getNext(oldEntry, oldMask);
            }
        }
        this.table = newTable;
        this.setHashTableMask(newMask);
        return newMask;
    }

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int indexOf(@CheckForNull @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Object key) {
        int entry;
        if (this.needsAllocArrays()) {
            return -1;
        }
        int hash = Hashing.smearedHash(key);
        int mask = this.hashTableMask();
        int next = CompactHashing.tableGet(this.requireTable(), hash & mask);
        if (next == 0) {
            return -1;
        }
        int hashPrefix = CompactHashing.getHashPrefix(hash, mask);
        do {
            int entryIndex;
            if (CompactHashing.getHashPrefix(entry = this.entry(entryIndex = next - 1), mask) != hashPrefix || !org.checkerframework.errorprone.com.google.common.base.Objects.equal(key, this.key(entryIndex))) continue;
            return entryIndex;
        } while ((next = CompactHashing.getNext(entry, mask)) != 0);
        return -1;
    }

    @Override
    @EnsuresKeyForIf(expression={"#1"}, result=true, map={"this"})
    @Pure
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean containsKey(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object key) {
        Map<K, V> delegate = this.delegateOrNull();
        return delegate != null ? delegate.containsKey(key) : this.indexOf(key) != -1;
    }

    @Override
    @CheckForNull
    @Pure
    public @Nullable V get(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object key) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.get(key);
        }
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.accessEntry(index);
        return this.value(index);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public @Nullable V remove(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object key) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.remove(key);
        }
        Object oldValue = this.removeHelper(key);
        return (V)(oldValue == NOT_FOUND ? null : oldValue);
    }

    private @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object removeHelper(@CheckForNull @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed Object key) {
        if (this.needsAllocArrays()) {
            return NOT_FOUND;
        }
        int mask = this.hashTableMask();
        int index = CompactHashing.remove(key, null, mask, this.requireTable(), this.requireEntries(), this.requireKeys(), null);
        if (index == -1) {
            return NOT_FOUND;
        }
        V oldValue = this.value(index);
        this.moveLastEntry(index, mask);
        --this.size;
        this.incrementModCount();
        return oldValue;
    }

    void moveLastEntry(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int dstIndex, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int mask) {
        Object table = this.requireTable();
        int[] entries = this.requireEntries();
        @Nullable Object[] keys = this.requireKeys();
        @Nullable Object[] values = this.requireValues();
        int srcIndex = this.size() - 1;
        if (dstIndex < srcIndex) {
            int srcNext;
            Object key;
            keys[dstIndex] = key = keys[srcIndex];
            values[dstIndex] = values[srcIndex];
            keys[srcIndex] = null;
            values[srcIndex] = null;
            entries[dstIndex] = entries[srcIndex];
            entries[srcIndex] = 0;
            int tableIndex = Hashing.smearedHash(key) & mask;
            int next = CompactHashing.tableGet(table, tableIndex);
            if (next == (srcNext = srcIndex + 1)) {
                CompactHashing.tableSet(table, tableIndex, dstIndex + 1);
            } else {
                int entryIndex;
                int entry;
                while ((next = CompactHashing.getNext(entry = entries[entryIndex = next - 1], mask)) != srcNext) {
                }
                entries[entryIndex] = CompactHashing.maskCombine(entry, dstIndex + 1, mask);
            }
        } else {
            keys[dstIndex] = null;
            values[dstIndex] = null;
            entries[dstIndex] = 0;
        }
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int getSuccessor(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int entryIndex) {
        return entryIndex + 1 < this.size ? entryIndex + 1 : -1;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int adjustAfterRemove(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int indexBeforeRemove, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int indexRemoved) {
        return indexBeforeRemove - 1;
    }

    @Override
    public void replaceAll(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed BiFunction<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super K, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super V, @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @KeyForBottom @NonNull @Initialized @SignednessBottom ? extends V> function) {
        Preconditions.checkNotNull(function);
        Map<? super K, ? extends V> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.replaceAll(function);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setValue(i, function.apply(this.key(i), this.value(i)));
            }
        }
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Set<@KeyFor(value={"this"}) K> keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Set<K> createKeySet() {
        return new KeySetView();
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<K> keySetIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.keySet().iterator();
        }
        return new Itr<K>(){

            @Override
            @ParametricNullness
            K getOutput(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int entry) {
                return CompactHashMap.this.key(entry);
            }
        };
    }

    @Override
    public void forEach(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed BiConsumer<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super K, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super V> action) {
        Preconditions.checkNotNull(action);
        Map<? super K, ? super V> delegate = this.delegateOrNull();
        if (delegate != null) {
            delegate.forEach(action);
        } else {
            int i = this.firstEntryIndex();
            while (i >= 0) {
                action.accept(this.key(i), this.value(i));
                i = this.getSuccessor(i);
            }
        }
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Set<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Set<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView();
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V>> entrySetIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.entrySet().iterator();
        }
        return new Itr<Map.Entry<K, V>>(){

            @Override
            @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V> getOutput(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int entry) {
                return new MapEntry(entry);
            }
        };
    }

    @Override
    @Pure
    public @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int size() {
        Map<K, V> delegate = this.delegateOrNull();
        return delegate != null ? delegate.size() : this.size;
    }

    @Override
    @Pure
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Pure
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean containsValue(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object value) {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.containsValue(value);
        }
        for (int i = 0; i < this.size; ++i) {
            if (!org.checkerframework.errorprone.com.google.common.base.Objects.equal(value, this.value(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideEffectFree
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Collection<V> values() {
        return this.valuesView == null ? (this.valuesView = this.createValues()) : this.valuesView;
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Collection<V> createValues() {
        return new ValuesView();
    }

    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<V> valuesIterator() {
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            return delegate.values().iterator();
        }
        return new Itr<V>(){

            @Override
            @ParametricNullness
            V getOutput(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int entry) {
                return CompactHashMap.this.value(entry);
            }
        };
    }

    public void trimToSize() {
        int mask;
        int minimumTableSize;
        if (this.needsAllocArrays()) {
            return;
        }
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            Map<K, V> newDelegate = this.createHashFloodingResistantDelegate(this.size());
            newDelegate.putAll(delegate);
            this.table = newDelegate;
            return;
        }
        int size = this.size;
        if (size < this.requireEntries().length) {
            this.resizeEntries(size);
        }
        if ((minimumTableSize = CompactHashing.tableSize(size)) < (mask = this.hashTableMask())) {
            this.resizeTable(mask, minimumTableSize, 0, 0);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Map<K, V> delegate = this.delegateOrNull();
        if (delegate != null) {
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            delegate.clear();
            this.table = null;
            this.size = 0;
        } else {
            Arrays.fill(this.requireKeys(), 0, this.size, null);
            Arrays.fill(this.requireValues(), 0, this.size, null);
            CompactHashing.tableClear(this.requireTable());
            Arrays.fill(this.requireEntries(), 0, this.size, 0);
            this.size = 0;
        }
    }

    @J2ktIncompatible
    private void writeObject(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ObjectOutputStream stream) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        Iterator<Map.Entry<K, V>> entryIterator = this.entrySetIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<K, V> e = entryIterator.next();
            stream.writeObject(e.getKey());
            stream.writeObject(e.getValue());
        }
    }

    @J2ktIncompatible
    private void readObject(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ObjectInputStream stream) throws @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed IOException, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ClassNotFoundException {
        stream.defaultReadObject();
        int elementCount = stream.readInt();
        if (elementCount < 0) {
            throw new InvalidObjectException("Invalid size: " + elementCount);
        }
        this.init(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.put(key, value);
        }
    }

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object requireTable() {
        return Objects.requireNonNull(this.table);
    }

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] requireEntries() {
        return Objects.requireNonNull(this.entries);
    }

    private @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] requireKeys() {
        return Objects.requireNonNull(this.keys);
    }

    private @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] requireValues() {
        return Objects.requireNonNull(this.values);
    }

    private K key(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i) {
        return (K)this.requireKeys()[i];
    }

    private V value(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i) {
        return (V)this.requireValues()[i];
    }

    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int entry(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i) {
        return this.requireEntries()[i];
    }

    private void setKey(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i, K key) {
        this.requireKeys()[i] = key;
    }

    private void setValue(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i, V value) {
        this.requireValues()[i] = value;
    }

    private void setEntry(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int i, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int value) {
        this.requireEntries()[i] = value;
    }

    class ValuesView
    extends Maps.Values<K, V> {
        ValuesView() {
            super(CompactHashMap.this);
        }

        @Override
        @SideEffectFree
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public void forEach(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Consumer<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super V> action) {
            Preconditions.checkNotNull(action);
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                delegate.values().forEach(action);
            } else {
                int i = CompactHashMap.this.firstEntryIndex();
                while (i >= 0) {
                    action.accept(CompactHashMap.this.value(i));
                    i = CompactHashMap.this.getSuccessor(i);
                }
            }
        }

        @Override
        @SideEffectFree
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Spliterator<V> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 16);
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.values().spliterator() : Spliterators.spliterator(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, 16);
        }

        @Override
        @SideEffectFree
        public @PolyNull @PolySigned @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.values().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size);
        }

        @Override
        @SideEffectFree
        public <T> T @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] toArray(@PolyNull T @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] a) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    @Nullable T[] unsoundlyCovariantArray = a;
                    unsoundlyCovariantArray[0] = null;
                }
                return a;
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.values().toArray(a) : ObjectArrays.toArrayImpl(CompactHashMap.this.requireValues(), 0, CompactHashMap.this.size, a);
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        private final K key;
        private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int lastKnownIndex;

        MapEntry(int index) {
            this.key = CompactHashMap.this.key(index);
            this.lastKnownIndex = index;
        }

        @Override
        @ParametricNullness
        @Pure
        public K getKey() {
            return this.key;
        }

        private void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= CompactHashMap.this.size() || !org.checkerframework.errorprone.com.google.common.base.Objects.equal(this.key, CompactHashMap.this.key(this.lastKnownIndex))) {
                this.lastKnownIndex = CompactHashMap.this.indexOf(this.key);
            }
        }

        @Override
        @ParametricNullness
        @Pure
        public V getValue() {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate.get(this.key));
            }
            this.updateLastKnownIndex();
            return this.lastKnownIndex == -1 ? NullnessCasts.unsafeNull() : CompactHashMap.this.value(this.lastKnownIndex);
        }

        @Override
        @ParametricNullness
        public V setValue(@ParametricNullness V value) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return NullnessCasts.uncheckedCastNullableTToT(delegate.put(this.key, value));
            }
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, value);
                return NullnessCasts.unsafeNull();
            }
            Object old = CompactHashMap.this.value(this.lastKnownIndex);
            CompactHashMap.this.setValue(this.lastKnownIndex, value);
            return old;
        }
    }

    class EntrySetView
    extends Maps.EntrySet<K, V> {
        EntrySetView() {
        }

        @Override
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map<K, V> map() {
            return CompactHashMap.this;
        }

        @Override
        @SideEffectFree
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V>> iterator() {
            return CompactHashMap.this.entrySetIterator();
        }

        @Override
        @SideEffectFree
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Spliterator<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V>> spliterator() {
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.entrySet().spliterator() : CollectSpliterators.indexed(CompactHashMap.this.size, 17, x$0 -> new MapEntry(x$0));
        }

        @Override
        @Pure
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean contains(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object o) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return delegate.entrySet().contains(o);
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                int index = CompactHashMap.this.indexOf(entry.getKey());
                return index != -1 && org.checkerframework.errorprone.com.google.common.base.Objects.equal(CompactHashMap.this.value(index), entry.getValue());
            }
            return false;
        }

        @Override
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean remove(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object o) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                return delegate.entrySet().remove(o);
            }
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                if (CompactHashMap.this.needsAllocArrays()) {
                    return false;
                }
                int mask = CompactHashMap.this.hashTableMask();
                int index = CompactHashing.remove(entry.getKey(), entry.getValue(), mask, CompactHashMap.this.requireTable(), CompactHashMap.this.requireEntries(), CompactHashMap.this.requireKeys(), CompactHashMap.this.requireValues());
                if (index == -1) {
                    return false;
                }
                CompactHashMap.this.moveLastEntry(index, mask);
                CompactHashMap.this.size--;
                CompactHashMap.this.incrementModCount();
                return true;
            }
            return false;
        }
    }

    class KeySetView
    extends Maps.KeySet<K, V> {
        KeySetView() {
            super(CompactHashMap.this);
        }

        @Override
        @SideEffectFree
        public @Nullable @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Initialized @Signed Object @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().toArray() : ObjectArrays.copyAsObjectArray(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size);
        }

        @Override
        @SideEffectFree
        public <T> T @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] toArray(@PolyNull T @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed [] a) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (a.length > 0) {
                    @Nullable T[] unsoundlyCovariantArray = a;
                    unsoundlyCovariantArray[0] = null;
                }
                return a;
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().toArray(a) : ObjectArrays.toArrayImpl(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, a);
        }

        @Override
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean remove(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object o) {
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().remove(o) : CompactHashMap.this.removeHelper(o) != NOT_FOUND;
        }

        @Override
        @SideEffectFree
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        @Override
        @SideEffectFree
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Spliterator<K> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 17);
            }
            Map delegate = CompactHashMap.this.delegateOrNull();
            return delegate != null ? delegate.keySet().spliterator() : Spliterators.spliterator(CompactHashMap.this.requireKeys(), 0, CompactHashMap.this.size, 17);
        }

        @Override
        public void forEach(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Consumer<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super K> action) {
            Preconditions.checkNotNull(action);
            Map delegate = CompactHashMap.this.delegateOrNull();
            if (delegate != null) {
                delegate.keySet().forEach(action);
            } else {
                int i = CompactHashMap.this.firstEntryIndex();
                while (i >= 0) {
                    action.accept(CompactHashMap.this.key(i));
                    i = CompactHashMap.this.getSuccessor(i);
                }
            }
        }
    }

    private abstract class Itr<@SubstringIndexBottom T>
    implements Iterator<T> {
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int expectedMetadata;
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int currentIndex;
        @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int indexToRemove;

        private Itr() {
            this.expectedMetadata = CompactHashMap.this.metadata;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        @Override
        @Pure
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean hasNext() {
            return this.currentIndex >= 0;
        }

        @ParametricNullness
        abstract T getOutput(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int var1);

        @Override
        @ParametricNullness
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexToRemove = this.currentIndex;
            T result = this.getOutput(this.currentIndex);
            this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
            return result;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.indexToRemove >= 0);
            this.incrementExpectedModCount();
            CompactHashMap.this.remove(CompactHashMap.this.key(this.indexToRemove));
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }

        void incrementExpectedModCount() {
            this.expectedMetadata += 32;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.metadata != this.expectedMetadata) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

