/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.livevariable;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.errorprone.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.errorprone.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.errorprone.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.errorprone.dataflow.cfg.visualize.CFGVisualizer;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.livevariable.LiveVarNode;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.org.plumelib.util.ArraySet;

public class LiveVarStore
implements Store<LiveVarStore> {
    private final Set<LiveVarNode> liveVarNodeSet;

    public LiveVarStore() {
        this.liveVarNodeSet = new LinkedHashSet<LiveVarNode>();
    }

    public LiveVarStore(Set<LiveVarNode> liveVarNodeSet) {
        this.liveVarNodeSet = liveVarNodeSet;
    }

    public void putLiveVar(LiveVarNode variable) {
        this.liveVarNodeSet.add(variable);
    }

    public void killLiveVar(LiveVarNode variable) {
        this.liveVarNodeSet.remove(variable);
    }

    public void addUseInExpression(Node expression) {
        if (expression instanceof LocalVariableNode || expression instanceof FieldAccessNode) {
            LiveVarNode liveVarValue = new LiveVarNode(expression);
            this.putLiveVar(liveVarValue);
        } else if (expression instanceof UnaryOperationNode) {
            UnaryOperationNode unaryNode = (UnaryOperationNode)expression;
            this.addUseInExpression(unaryNode.getOperand());
        } else if (expression instanceof TernaryExpressionNode) {
            TernaryExpressionNode ternaryNode = (TernaryExpressionNode)expression;
            this.addUseInExpression(ternaryNode.getConditionOperand());
            this.addUseInExpression(ternaryNode.getThenOperand());
            this.addUseInExpression(ternaryNode.getElseOperand());
        } else if (expression instanceof TypeCastNode) {
            TypeCastNode typeCastNode = (TypeCastNode)expression;
            this.addUseInExpression(typeCastNode.getOperand());
        } else if (expression instanceof InstanceOfNode) {
            InstanceOfNode instanceOfNode = (InstanceOfNode)expression;
            this.addUseInExpression(instanceOfNode.getOperand());
        } else if (expression instanceof BinaryOperationNode) {
            BinaryOperationNode binaryNode = (BinaryOperationNode)expression;
            this.addUseInExpression(binaryNode.getLeftOperand());
            this.addUseInExpression(binaryNode.getRightOperand());
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LiveVarStore)) {
            return false;
        }
        LiveVarStore other = (LiveVarStore)obj;
        return other.liveVarNodeSet.equals(this.liveVarNodeSet);
    }

    public int hashCode() {
        return this.liveVarNodeSet.hashCode();
    }

    @Override
    public LiveVarStore copy() {
        return new LiveVarStore(new HashSet<LiveVarNode>(this.liveVarNodeSet));
    }

    @Override
    public LiveVarStore leastUpperBound(LiveVarStore other) {
        Set<LiveVarNode> liveVarNodeSetLub = ArraySet.newArraySetOrLinkedHashSet(this.liveVarNodeSet.size() + other.liveVarNodeSet.size());
        liveVarNodeSetLub.addAll(this.liveVarNodeSet);
        liveVarNodeSetLub.addAll(other.liveVarNodeSet);
        return new LiveVarStore(liveVarNodeSetLub);
    }

    @Override
    public LiveVarStore widenedUpperBound(LiveVarStore previous) {
        throw new BugInCF("wub of LiveVarStore get called!");
    }

    @Override
    public boolean canAlias(JavaExpression a, JavaExpression b) {
        return true;
    }

    @Override
    public String visualize(CFGVisualizer<?, LiveVarStore, ?> viz) {
        String key = "live variables";
        if (this.liveVarNodeSet.isEmpty()) {
            return viz.visualizeStoreKeyVal(key, "none");
        }
        StringJoiner sjStoreVal = new StringJoiner(", ");
        for (LiveVarNode liveVar : this.liveVarNodeSet) {
            sjStoreVal.add(liveVar.toString());
        }
        return viz.visualizeStoreKeyVal(key, sjStoreVal.toString());
    }

    public String toString() {
        return this.liveVarNodeSet.toString();
    }
}

