/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;

public class TreeInfo {
    protected static final Context.Key<TreeInfo> treeInfoKey = new Context.Key();
    private Name[] opname = new Name[JCTree.Tag.getNumberOfOperators()];
    public static final int notExpression = -1;
    public static final int noPrec = 0;
    public static final int assignPrec = 1;
    public static final int assignopPrec = 2;
    public static final int condPrec = 3;
    public static final int orPrec = 4;
    public static final int andPrec = 5;
    public static final int bitorPrec = 6;
    public static final int bitxorPrec = 7;
    public static final int bitandPrec = 8;
    public static final int eqPrec = 9;
    public static final int ordPrec = 10;
    public static final int shiftPrec = 11;
    public static final int addPrec = 12;
    public static final int mulPrec = 13;
    public static final int prefixPrec = 14;
    public static final int postfixPrec = 15;
    public static final int precCount = 16;

    public static TreeInfo instance(Context context) {
        TreeInfo instance = context.get(treeInfoKey);
        if (instance == null) {
            instance = new TreeInfo(context);
        }
        return instance;
    }

    private void setOpname(JCTree.Tag tag, String name, Names names) {
        this.setOpname(tag, names.fromString(name));
    }

    private void setOpname(JCTree.Tag tag, Name name) {
        this.opname[tag.operatorIndex()] = name;
    }

    private TreeInfo(Context context) {
        context.put(treeInfoKey, this);
        Names names = Names.instance(context);
        this.setOpname(JCTree.Tag.POS, "+++", names);
        this.setOpname(JCTree.Tag.NEG, "---", names);
        this.setOpname(JCTree.Tag.NOT, "!", names);
        this.setOpname(JCTree.Tag.COMPL, "~", names);
        this.setOpname(JCTree.Tag.PREINC, "++", names);
        this.setOpname(JCTree.Tag.PREDEC, "--", names);
        this.setOpname(JCTree.Tag.POSTINC, "++", names);
        this.setOpname(JCTree.Tag.POSTDEC, "--", names);
        this.setOpname(JCTree.Tag.NULLCHK, "<*nullchk*>", names);
        this.setOpname(JCTree.Tag.OR, "||", names);
        this.setOpname(JCTree.Tag.AND, "&&", names);
        this.setOpname(JCTree.Tag.EQ, "==", names);
        this.setOpname(JCTree.Tag.NE, "!=", names);
        this.setOpname(JCTree.Tag.LT, "<", names);
        this.setOpname(JCTree.Tag.GT, ">", names);
        this.setOpname(JCTree.Tag.LE, "<=", names);
        this.setOpname(JCTree.Tag.GE, ">=", names);
        this.setOpname(JCTree.Tag.BITOR, "|", names);
        this.setOpname(JCTree.Tag.BITXOR, "^", names);
        this.setOpname(JCTree.Tag.BITAND, "&", names);
        this.setOpname(JCTree.Tag.SL, "<<", names);
        this.setOpname(JCTree.Tag.SR, ">>", names);
        this.setOpname(JCTree.Tag.USR, ">>>", names);
        this.setOpname(JCTree.Tag.PLUS, "+", names);
        this.setOpname(JCTree.Tag.MINUS, names.hyphen);
        this.setOpname(JCTree.Tag.MUL, names.asterisk);
        this.setOpname(JCTree.Tag.DIV, names.slash);
        this.setOpname(JCTree.Tag.MOD, "%", names);
    }

    public static List<JCTree.JCExpression> args(JCTree t) {
        switch (t.getTag()) {
            case APPLY: {
                return ((JCTree.JCMethodInvocation)t).args;
            }
            case NEWCLASS: {
                return ((JCTree.JCNewClass)t).args;
            }
        }
        return null;
    }

    public Name operatorName(JCTree.Tag tag) {
        return this.opname[tag.operatorIndex()];
    }

    public static boolean isConstructor(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.METHODDEF)) {
            Name name = ((JCTree.JCMethodDecl)tree).name;
            return name == name.table.names.init;
        }
        return false;
    }

    public static boolean isReceiverParam(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.VARDEF)) {
            return ((JCTree.JCVariableDecl)tree).nameexpr != null;
        }
        return false;
    }

    public static boolean hasConstructors(List<JCTree> trees) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            if (TreeInfo.isConstructor((JCTree)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public static boolean isMultiCatch(JCTree.JCCatch catchClause) {
        return catchClause.param.vartype.hasTag(JCTree.Tag.TYPEUNION);
    }

    public static boolean isSyntheticInit(JCTree stat) {
        if (stat.hasTag(JCTree.Tag.EXEC)) {
            JCTree.JCExpressionStatement exec = (JCTree.JCExpressionStatement)stat;
            if (exec.expr.hasTag(JCTree.Tag.ASSIGN)) {
                JCTree.JCAssign assign = (JCTree.JCAssign)exec.expr;
                if (assign.lhs.hasTag(JCTree.Tag.SELECT)) {
                    Name selected;
                    JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)assign.lhs;
                    if (select.sym != null && (select.sym.flags() & 0x1000L) != 0L && (selected = TreeInfo.name(select.selected)) != null && selected == selected.table.names._this) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Name calledMethodName(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.EXEC)) {
            JCTree.JCExpressionStatement exec = (JCTree.JCExpressionStatement)tree;
            if (exec.expr.hasTag(JCTree.Tag.APPLY)) {
                Name mname = TreeInfo.name(((JCTree.JCMethodInvocation)exec.expr).meth);
                return mname;
            }
        }
        return null;
    }

    public static boolean isSelfCall(JCTree tree) {
        Name name = TreeInfo.calledMethodName(tree);
        if (name != null) {
            Names names = name.table.names;
            return name == names._this || name == names._super;
        }
        return false;
    }

    public static boolean isSuperCall(JCTree tree) {
        Name name = TreeInfo.calledMethodName(tree);
        if (name != null) {
            Names names = name.table.names;
            return name == names._super;
        }
        return false;
    }

    public static boolean isInitialConstructor(JCTree tree) {
        JCTree.JCMethodInvocation app = TreeInfo.firstConstructorCall(tree);
        if (app == null) {
            return false;
        }
        Name meth = TreeInfo.name(app.meth);
        return meth == null || meth != meth.table.names._this;
    }

    public static JCTree.JCMethodInvocation firstConstructorCall(JCTree tree) {
        if (!tree.hasTag(JCTree.Tag.METHODDEF)) {
            return null;
        }
        JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)tree;
        Names names = md.name.table.names;
        if (md.name != names.init) {
            return null;
        }
        if (md.body == null) {
            return null;
        }
        List<JCTree.JCStatement> stats = md.body.stats;
        while (stats.nonEmpty() && TreeInfo.isSyntheticInit((JCTree)stats.head)) {
            stats = stats.tail;
        }
        if (stats.isEmpty()) {
            return null;
        }
        if (!((JCTree.JCStatement)stats.head).hasTag(JCTree.Tag.EXEC)) {
            return null;
        }
        JCTree.JCExpressionStatement exec = (JCTree.JCExpressionStatement)stats.head;
        if (!exec.expr.hasTag(JCTree.Tag.APPLY)) {
            return null;
        }
        return (JCTree.JCMethodInvocation)exec.expr;
    }

    public static boolean isDiamond(JCTree tree) {
        switch (tree.getTag()) {
            case TYPEAPPLY: {
                return ((List)((JCTree.JCTypeApply)tree).getTypeArguments()).isEmpty();
            }
            case NEWCLASS: {
                return TreeInfo.isDiamond(((JCTree.JCNewClass)tree).clazz);
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.isDiamond(((JCTree.JCAnnotatedType)tree).underlyingType);
            }
        }
        return false;
    }

    public static boolean isEnumInit(JCTree tree) {
        switch (tree.getTag()) {
            case VARDEF: {
                return (((JCTree.JCVariableDecl)tree).mods.flags & 0x4000L) != 0L;
            }
        }
        return false;
    }

    public static void setPolyKind(JCTree tree, JCTree.JCPolyExpression.PolyKind pkind) {
        switch (tree.getTag()) {
            case APPLY: {
                ((JCTree.JCMethodInvocation)tree).polyKind = pkind;
                break;
            }
            case NEWCLASS: {
                ((JCTree.JCNewClass)tree).polyKind = pkind;
                break;
            }
            case REFERENCE: {
                ((JCTree.JCMemberReference)tree).refPolyKind = pkind;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected tree: " + tree));
            }
        }
    }

    public static void setVarargsElement(JCTree tree, Type varargsElement) {
        switch (tree.getTag()) {
            case APPLY: {
                ((JCTree.JCMethodInvocation)tree).varargsElement = varargsElement;
                break;
            }
            case NEWCLASS: {
                ((JCTree.JCNewClass)tree).varargsElement = varargsElement;
                break;
            }
            case REFERENCE: {
                ((JCTree.JCMemberReference)tree).varargsElement = varargsElement;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected tree: " + tree));
            }
        }
    }

    public static boolean isExpressionStatement(JCTree.JCExpression tree) {
        switch (tree.getTag()) {
            case APPLY: 
            case NEWCLASS: 
            case PREINC: 
            case PREDEC: 
            case POSTINC: 
            case POSTDEC: 
            case ASSIGN: 
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: 
            case ERRONEOUS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStaticSelector(JCTree base, Names names) {
        if (base == null) {
            return false;
        }
        switch (base.getTag()) {
            case IDENT: {
                JCTree.JCIdent id = (JCTree.JCIdent)base;
                return id.name != names._this && id.name != names._super && TreeInfo.isStaticSym(base);
            }
            case SELECT: {
                return TreeInfo.isStaticSym(base) && TreeInfo.isStaticSelector(((JCTree.JCFieldAccess)base).selected, names);
            }
            case TYPEAPPLY: 
            case TYPEARRAY: {
                return true;
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.isStaticSelector(((JCTree.JCAnnotatedType)base).underlyingType, names);
            }
        }
        return false;
    }

    private static boolean isStaticSym(JCTree tree) {
        Symbol sym = TreeInfo.symbol(tree);
        return sym.kind == 2 || sym.kind == 1;
    }

    public static boolean isNull(JCTree tree) {
        if (!tree.hasTag(JCTree.Tag.LITERAL)) {
            return false;
        }
        JCTree.JCLiteral lit = (JCTree.JCLiteral)tree;
        return lit.typetag == TypeTag.BOT;
    }

    public static boolean isInAnnotation(Env<?> env, JCTree tree) {
        TreePath tp = TreePath.getPath(env.toplevel, (Tree)tree);
        if (tp != null) {
            for (Tree t : tp) {
                if (t.getKind() != Tree.Kind.ANNOTATION) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCommentText(Env<?> env, JCTree tree) {
        DocCommentTable docComments = tree.hasTag(JCTree.Tag.TOPLEVEL) ? ((JCTree.JCCompilationUnit)tree).docComments : env.toplevel.docComments;
        return docComments == null ? null : docComments.getCommentText(tree);
    }

    public static DCTree.DCDocComment getCommentTree(Env<?> env, JCTree tree) {
        DocCommentTable docComments = tree.hasTag(JCTree.Tag.TOPLEVEL) ? ((JCTree.JCCompilationUnit)tree).docComments : env.toplevel.docComments;
        return docComments == null ? null : docComments.getCommentTree(tree);
    }

    public static int firstStatPos(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.BLOCK) && ((JCTree.JCBlock)tree).stats.nonEmpty()) {
            return ((JCTree.JCStatement)((JCTree.JCBlock)tree).stats.head).pos;
        }
        return tree.pos;
    }

    public static int endPos(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.BLOCK) && ((JCTree.JCBlock)tree).endpos != -1) {
            return ((JCTree.JCBlock)tree).endpos;
        }
        if (tree.hasTag(JCTree.Tag.SYNCHRONIZED)) {
            return TreeInfo.endPos(((JCTree.JCSynchronized)tree).body);
        }
        if (tree.hasTag(JCTree.Tag.TRY)) {
            JCTree.JCTry t = (JCTree.JCTry)tree;
            return TreeInfo.endPos(t.finalizer != null ? t.finalizer : (t.catchers.nonEmpty() ? t.catchers.last().body : t.body));
        }
        return tree.pos;
    }

    public static int getStartPos(JCTree tree) {
        if (tree == null) {
            return -1;
        }
        switch (tree.getTag()) {
            case APPLY: {
                return TreeInfo.getStartPos(((JCTree.JCMethodInvocation)tree).meth);
            }
            case ASSIGN: {
                return TreeInfo.getStartPos(((JCTree.JCAssign)tree).lhs);
            }
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: {
                return TreeInfo.getStartPos(((JCTree.JCAssignOp)tree).lhs);
            }
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case SL: 
            case SR: 
            case USR: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return TreeInfo.getStartPos(((JCTree.JCBinary)tree).lhs);
            }
            case CLASSDEF: {
                JCTree.JCClassDecl node = (JCTree.JCClassDecl)tree;
                if (node.mods.pos == -1) break;
                return node.mods.pos;
            }
            case CONDEXPR: {
                return TreeInfo.getStartPos(((JCTree.JCConditional)tree).cond);
            }
            case EXEC: {
                return TreeInfo.getStartPos(((JCTree.JCExpressionStatement)tree).expr);
            }
            case INDEXED: {
                return TreeInfo.getStartPos(((JCTree.JCArrayAccess)tree).indexed);
            }
            case METHODDEF: {
                JCTree.JCMethodDecl node = (JCTree.JCMethodDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods.pos;
                }
                if (node.typarams.nonEmpty()) {
                    return TreeInfo.getStartPos((JCTree)node.typarams.head);
                }
                return node.restype == null ? node.pos : TreeInfo.getStartPos(node.restype);
            }
            case SELECT: {
                return TreeInfo.getStartPos(((JCTree.JCFieldAccess)tree).selected);
            }
            case TYPEAPPLY: {
                return TreeInfo.getStartPos(((JCTree.JCTypeApply)tree).clazz);
            }
            case TYPEARRAY: {
                return TreeInfo.getStartPos(((JCTree.JCArrayTypeTree)tree).elemtype);
            }
            case TYPETEST: {
                return TreeInfo.getStartPos(((JCTree.JCInstanceOf)tree).expr);
            }
            case POSTINC: 
            case POSTDEC: {
                return TreeInfo.getStartPos(((JCTree.JCUnary)tree).arg);
            }
            case ANNOTATED_TYPE: {
                JCTree.JCAnnotatedType node = (JCTree.JCAnnotatedType)tree;
                if (node.annotations.nonEmpty()) {
                    if (node.underlyingType.hasTag(JCTree.Tag.TYPEARRAY) || node.underlyingType.hasTag(JCTree.Tag.SELECT)) {
                        return TreeInfo.getStartPos(node.underlyingType);
                    }
                    return TreeInfo.getStartPos((JCTree)node.annotations.head);
                }
                return TreeInfo.getStartPos(node.underlyingType);
            }
            case NEWCLASS: {
                JCTree.JCNewClass node = (JCTree.JCNewClass)tree;
                if (node.encl == null) break;
                return TreeInfo.getStartPos(node.encl);
            }
            case VARDEF: {
                JCTree.JCVariableDecl node = (JCTree.JCVariableDecl)tree;
                if (node.mods.pos != -1) {
                    return node.mods.pos;
                }
                if (node.vartype == null) {
                    return node.pos;
                }
                return TreeInfo.getStartPos(node.vartype);
            }
            case ERRONEOUS: {
                JCTree.JCErroneous node = (JCTree.JCErroneous)tree;
                if (node.errs == null || !node.errs.nonEmpty()) break;
                return TreeInfo.getStartPos((JCTree)node.errs.head);
            }
        }
        return tree.pos;
    }

    public static int getEndPos(JCTree tree, EndPosTable endPosTable) {
        if (tree == null) {
            return -1;
        }
        if (endPosTable == null) {
            return TreeInfo.endPos(tree);
        }
        int mapPos = endPosTable.getEndPos(tree);
        if (mapPos != -1) {
            return mapPos;
        }
        switch (tree.getTag()) {
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: {
                return TreeInfo.getEndPos(((JCTree.JCAssignOp)tree).rhs, endPosTable);
            }
            case OR: 
            case AND: 
            case BITOR: 
            case BITXOR: 
            case BITAND: 
            case EQ: 
            case NE: 
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case SL: 
            case SR: 
            case USR: 
            case PLUS: 
            case MINUS: 
            case MUL: 
            case DIV: 
            case MOD: {
                return TreeInfo.getEndPos(((JCTree.JCBinary)tree).rhs, endPosTable);
            }
            case CASE: {
                return TreeInfo.getEndPos(((JCTree.JCCase)tree).stats.last(), endPosTable);
            }
            case CATCH: {
                return TreeInfo.getEndPos(((JCTree.JCCatch)tree).body, endPosTable);
            }
            case CONDEXPR: {
                return TreeInfo.getEndPos(((JCTree.JCConditional)tree).falsepart, endPosTable);
            }
            case FORLOOP: {
                return TreeInfo.getEndPos(((JCTree.JCForLoop)tree).body, endPosTable);
            }
            case FOREACHLOOP: {
                return TreeInfo.getEndPos(((JCTree.JCEnhancedForLoop)tree).body, endPosTable);
            }
            case IF: {
                JCTree.JCIf node = (JCTree.JCIf)tree;
                if (node.elsepart == null) {
                    return TreeInfo.getEndPos(node.thenpart, endPosTable);
                }
                return TreeInfo.getEndPos(node.elsepart, endPosTable);
            }
            case LABELLED: {
                return TreeInfo.getEndPos(((JCTree.JCLabeledStatement)tree).body, endPosTable);
            }
            case MODIFIERS: {
                return TreeInfo.getEndPos(((JCTree.JCModifiers)tree).annotations.last(), endPosTable);
            }
            case SYNCHRONIZED: {
                return TreeInfo.getEndPos(((JCTree.JCSynchronized)tree).body, endPosTable);
            }
            case TOPLEVEL: {
                return TreeInfo.getEndPos(((JCTree.JCCompilationUnit)tree).defs.last(), endPosTable);
            }
            case TRY: {
                JCTree.JCTry node = (JCTree.JCTry)tree;
                if (node.finalizer != null) {
                    return TreeInfo.getEndPos(node.finalizer, endPosTable);
                }
                if (!node.catchers.isEmpty()) {
                    return TreeInfo.getEndPos(node.catchers.last(), endPosTable);
                }
                return TreeInfo.getEndPos(node.body, endPosTable);
            }
            case WILDCARD: {
                return TreeInfo.getEndPos(((JCTree.JCWildcard)tree).inner, endPosTable);
            }
            case TYPECAST: {
                return TreeInfo.getEndPos(((JCTree.JCTypeCast)tree).expr, endPosTable);
            }
            case TYPETEST: {
                return TreeInfo.getEndPos(((JCTree.JCInstanceOf)tree).clazz, endPosTable);
            }
            case PREINC: 
            case PREDEC: 
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: {
                return TreeInfo.getEndPos(((JCTree.JCUnary)tree).arg, endPosTable);
            }
            case WHILELOOP: {
                return TreeInfo.getEndPos(((JCTree.JCWhileLoop)tree).body, endPosTable);
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.getEndPos(((JCTree.JCAnnotatedType)tree).underlyingType, endPosTable);
            }
            case ERRONEOUS: {
                JCTree.JCErroneous node = (JCTree.JCErroneous)tree;
                if (node.errs == null || !node.errs.nonEmpty()) break;
                return TreeInfo.getEndPos(node.errs.last(), endPosTable);
            }
        }
        return -1;
    }

    public static JCDiagnostic.DiagnosticPosition diagEndPos(final JCTree tree) {
        final int endPos = TreeInfo.endPos(tree);
        return new JCDiagnostic.DiagnosticPosition(){

            @Override
            public JCTree getTree() {
                return tree;
            }

            @Override
            public int getStartPosition() {
                return TreeInfo.getStartPos(tree);
            }

            @Override
            public int getPreferredPosition() {
                return endPos;
            }

            @Override
            public int getEndPosition(EndPosTable endPosTable) {
                return TreeInfo.getEndPos(tree, endPosTable);
            }
        };
    }

    public static int finalizerPos(JCTree tree, PosKind posKind) {
        if (tree.hasTag(JCTree.Tag.TRY)) {
            JCTree.JCTry t = (JCTree.JCTry)tree;
            Assert.checkNonNull(t.finalizer);
            return posKind.toPos(t.finalizer);
        }
        if (tree.hasTag(JCTree.Tag.SYNCHRONIZED)) {
            return TreeInfo.endPos(((JCTree.JCSynchronized)tree).body);
        }
        throw new AssertionError();
    }

    public static int positionFor(Symbol sym, JCTree tree) {
        JCTree decl;
        return ((decl = TreeInfo.declarationFor((Symbol)sym, (JCTree)tree)) != null ? decl : tree).pos;
    }

    public static JCDiagnostic.DiagnosticPosition diagnosticPositionFor(Symbol sym, JCTree tree) {
        JCTree decl = TreeInfo.declarationFor(sym, tree);
        return (decl != null ? decl : tree).pos();
    }

    public static JCTree declarationFor(Symbol sym, JCTree tree) {
        class DeclScanner
        extends TreeScanner {
            JCTree result = null;
            final /* synthetic */ Symbol val$sym;

            DeclScanner(Symbol symbol) {
                this.val$sym = symbol;
            }

            @Override
            public void scan(JCTree tree) {
                if (tree != null && this.result == null) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitTopLevel(JCTree.JCCompilationUnit that) {
                if (that.packge == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitTopLevel(that);
                }
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitClassDef(that);
                }
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitMethodDef(that);
                }
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl that) {
                if (that.sym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitVarDef(that);
                }
            }

            @Override
            public void visitTypeParameter(JCTree.JCTypeParameter that) {
                if (that.type != null && that.type.tsym == this.val$sym) {
                    this.result = that;
                } else {
                    super.visitTypeParameter(that);
                }
            }
        }
        DeclScanner s = new DeclScanner(sym);
        tree.accept(s);
        return s.result;
    }

    public static Env<AttrContext> scopeFor(JCTree node, JCTree.JCCompilationUnit unit) {
        return TreeInfo.scopeFor(TreeInfo.pathFor(node, unit));
    }

    public static Env<AttrContext> scopeFor(List<JCTree> path) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static List<JCTree> pathFor(JCTree node, JCTree.JCCompilationUnit unit) {
        class Result
        extends Error {
            static final long serialVersionUID = -5942088234594905625L;
            List<JCTree> path;

            Result(List<JCTree> path) {
                this.path = path;
            }
        }
        try {
            class PathFinder
            extends TreeScanner {
                List<JCTree> path = List.nil();
                final /* synthetic */ JCTree val$node;

                PathFinder(JCTree jCTree) {
                    this.val$node = jCTree;
                }

                @Override
                public void scan(JCTree tree) {
                    if (tree != null) {
                        this.path = this.path.prepend(tree);
                        if (tree == this.val$node) {
                            throw new Result(this.path);
                        }
                        super.scan(tree);
                        this.path = this.path.tail;
                    }
                }
            }
            new PathFinder(node).scan(unit);
        }
        catch (Result result) {
            return result.path;
        }
        return List.nil();
    }

    public static JCTree referencedStatement(JCTree.JCLabeledStatement tree) {
        JCTree.JCStatement t = tree;
        while ((t = ((JCTree.JCLabeledStatement)t).body).hasTag(JCTree.Tag.LABELLED)) {
        }
        switch (t.getTag()) {
            case FORLOOP: 
            case FOREACHLOOP: 
            case WHILELOOP: 
            case DOLOOP: 
            case SWITCH: {
                return t;
            }
        }
        return tree;
    }

    public static JCTree.JCExpression skipParens(JCTree.JCExpression tree) {
        while (tree.hasTag(JCTree.Tag.PARENS)) {
            tree = ((JCTree.JCParens)tree).expr;
        }
        return tree;
    }

    public static JCTree skipParens(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.PARENS)) {
            return TreeInfo.skipParens((JCTree.JCParens)tree);
        }
        return tree;
    }

    public static List<Type> types(List<? extends JCTree> trees) {
        ListBuffer<Type> ts = new ListBuffer<Type>();
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            ts.append(((JCTree)l.head).type);
            l = l.tail;
        }
        return ts.toList();
    }

    public static Name name(JCTree tree) {
        switch (tree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)tree).name;
            }
            case SELECT: {
                return ((JCTree.JCFieldAccess)tree).name;
            }
            case TYPEAPPLY: {
                return TreeInfo.name(((JCTree.JCTypeApply)tree).clazz);
            }
        }
        return null;
    }

    public static Name fullName(JCTree tree) {
        tree = TreeInfo.skipParens(tree);
        switch (tree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)tree).name;
            }
            case SELECT: {
                Name sname = TreeInfo.fullName(((JCTree.JCFieldAccess)tree).selected);
                return sname == null ? null : sname.append('.', TreeInfo.name(tree));
            }
        }
        return null;
    }

    public static Symbol symbolFor(JCTree node) {
        Symbol sym = TreeInfo.symbolForImpl(node);
        return sym != null ? sym.baseSymbol() : null;
    }

    private static Symbol symbolForImpl(JCTree node) {
        node = TreeInfo.skipParens(node);
        switch (node.getTag()) {
            case TOPLEVEL: {
                return ((JCTree.JCCompilationUnit)node).packge;
            }
            case CLASSDEF: {
                return ((JCTree.JCClassDecl)node).sym;
            }
            case METHODDEF: {
                return ((JCTree.JCMethodDecl)node).sym;
            }
            case VARDEF: {
                return ((JCTree.JCVariableDecl)node).sym;
            }
            case IDENT: {
                return ((JCTree.JCIdent)node).sym;
            }
            case SELECT: {
                return ((JCTree.JCFieldAccess)node).sym;
            }
            case REFERENCE: {
                return ((JCTree.JCMemberReference)node).sym;
            }
            case NEWCLASS: {
                return ((JCTree.JCNewClass)node).constructor;
            }
            case APPLY: {
                return TreeInfo.symbolFor(((JCTree.JCMethodInvocation)node).meth);
            }
            case TYPEAPPLY: {
                return TreeInfo.symbolFor(((JCTree.JCTypeApply)node).clazz);
            }
            case ANNOTATION: 
            case TYPE_ANNOTATION: 
            case TYPEPARAMETER: {
                if (node.type != null) {
                    return node.type.tsym;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isDeclaration(JCTree node) {
        node = TreeInfo.skipParens(node);
        switch (node.getTag()) {
            case VARDEF: 
            case CLASSDEF: 
            case METHODDEF: {
                return true;
            }
        }
        return false;
    }

    public static Symbol symbol(JCTree tree) {
        tree = TreeInfo.skipParens(tree);
        switch (tree.getTag()) {
            case IDENT: {
                return ((JCTree.JCIdent)tree).sym;
            }
            case SELECT: {
                return ((JCTree.JCFieldAccess)tree).sym;
            }
            case TYPEAPPLY: {
                return TreeInfo.symbol(((JCTree.JCTypeApply)tree).clazz);
            }
            case ANNOTATED_TYPE: {
                return TreeInfo.symbol(((JCTree.JCAnnotatedType)tree).underlyingType);
            }
            case REFERENCE: {
                return ((JCTree.JCMemberReference)tree).sym;
            }
        }
        return null;
    }

    public static boolean nonstaticSelect(JCTree tree) {
        if (!(tree = TreeInfo.skipParens(tree)).hasTag(JCTree.Tag.SELECT)) {
            return false;
        }
        JCTree.JCFieldAccess s = (JCTree.JCFieldAccess)tree;
        Symbol e = TreeInfo.symbol(s.selected);
        return e == null || e.kind != 1 && e.kind != 2;
    }

    public static void setSymbol(JCTree tree, Symbol sym) {
        tree = TreeInfo.skipParens(tree);
        switch (tree.getTag()) {
            case IDENT: {
                ((JCTree.JCIdent)tree).sym = sym;
                break;
            }
            case SELECT: {
                ((JCTree.JCFieldAccess)tree).sym = sym;
                break;
            }
        }
    }

    public static long flags(JCTree tree) {
        switch (tree.getTag()) {
            case VARDEF: {
                return ((JCTree.JCVariableDecl)tree).mods.flags;
            }
            case METHODDEF: {
                return ((JCTree.JCMethodDecl)tree).mods.flags;
            }
            case CLASSDEF: {
                return ((JCTree.JCClassDecl)tree).mods.flags;
            }
            case BLOCK: {
                return ((JCTree.JCBlock)tree).flags;
            }
        }
        return 0L;
    }

    public static long firstFlag(long flags) {
        long flag = 1L;
        while ((flag & flags & 0x80000000FFFL) == 0L) {
            flag <<= 1;
        }
        return flag;
    }

    public static String flagNames(long flags) {
        return Flags.toString(flags & 0x80000000FFFL).trim();
    }

    public static int opPrec(JCTree.Tag op) {
        switch (op) {
            case PREINC: 
            case PREDEC: 
            case POS: 
            case NEG: 
            case NOT: 
            case COMPL: {
                return 14;
            }
            case POSTINC: 
            case POSTDEC: 
            case NULLCHK: {
                return 15;
            }
            case ASSIGN: {
                return 1;
            }
            case BITOR_ASG: 
            case BITXOR_ASG: 
            case BITAND_ASG: 
            case SL_ASG: 
            case SR_ASG: 
            case USR_ASG: 
            case PLUS_ASG: 
            case MINUS_ASG: 
            case MUL_ASG: 
            case DIV_ASG: 
            case MOD_ASG: {
                return 2;
            }
            case OR: {
                return 4;
            }
            case AND: {
                return 5;
            }
            case EQ: 
            case NE: {
                return 9;
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: {
                return 10;
            }
            case BITOR: {
                return 6;
            }
            case BITXOR: {
                return 7;
            }
            case BITAND: {
                return 8;
            }
            case SL: 
            case SR: 
            case USR: {
                return 11;
            }
            case PLUS: 
            case MINUS: {
                return 12;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 13;
            }
            case TYPETEST: {
                return 10;
            }
        }
        throw new AssertionError();
    }

    static Tree.Kind tagToKind(JCTree.Tag tag) {
        switch (tag) {
            case POSTINC: {
                return Tree.Kind.POSTFIX_INCREMENT;
            }
            case POSTDEC: {
                return Tree.Kind.POSTFIX_DECREMENT;
            }
            case PREINC: {
                return Tree.Kind.PREFIX_INCREMENT;
            }
            case PREDEC: {
                return Tree.Kind.PREFIX_DECREMENT;
            }
            case POS: {
                return Tree.Kind.UNARY_PLUS;
            }
            case NEG: {
                return Tree.Kind.UNARY_MINUS;
            }
            case COMPL: {
                return Tree.Kind.BITWISE_COMPLEMENT;
            }
            case NOT: {
                return Tree.Kind.LOGICAL_COMPLEMENT;
            }
            case MUL: {
                return Tree.Kind.MULTIPLY;
            }
            case DIV: {
                return Tree.Kind.DIVIDE;
            }
            case MOD: {
                return Tree.Kind.REMAINDER;
            }
            case PLUS: {
                return Tree.Kind.PLUS;
            }
            case MINUS: {
                return Tree.Kind.MINUS;
            }
            case SL: {
                return Tree.Kind.LEFT_SHIFT;
            }
            case SR: {
                return Tree.Kind.RIGHT_SHIFT;
            }
            case USR: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT;
            }
            case LT: {
                return Tree.Kind.LESS_THAN;
            }
            case GT: {
                return Tree.Kind.GREATER_THAN;
            }
            case LE: {
                return Tree.Kind.LESS_THAN_EQUAL;
            }
            case GE: {
                return Tree.Kind.GREATER_THAN_EQUAL;
            }
            case EQ: {
                return Tree.Kind.EQUAL_TO;
            }
            case NE: {
                return Tree.Kind.NOT_EQUAL_TO;
            }
            case BITAND: {
                return Tree.Kind.AND;
            }
            case BITXOR: {
                return Tree.Kind.XOR;
            }
            case BITOR: {
                return Tree.Kind.OR;
            }
            case AND: {
                return Tree.Kind.CONDITIONAL_AND;
            }
            case OR: {
                return Tree.Kind.CONDITIONAL_OR;
            }
            case MUL_ASG: {
                return Tree.Kind.MULTIPLY_ASSIGNMENT;
            }
            case DIV_ASG: {
                return Tree.Kind.DIVIDE_ASSIGNMENT;
            }
            case MOD_ASG: {
                return Tree.Kind.REMAINDER_ASSIGNMENT;
            }
            case PLUS_ASG: {
                return Tree.Kind.PLUS_ASSIGNMENT;
            }
            case MINUS_ASG: {
                return Tree.Kind.MINUS_ASSIGNMENT;
            }
            case SL_ASG: {
                return Tree.Kind.LEFT_SHIFT_ASSIGNMENT;
            }
            case SR_ASG: {
                return Tree.Kind.RIGHT_SHIFT_ASSIGNMENT;
            }
            case USR_ASG: {
                return Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT;
            }
            case BITAND_ASG: {
                return Tree.Kind.AND_ASSIGNMENT;
            }
            case BITXOR_ASG: {
                return Tree.Kind.XOR_ASSIGNMENT;
            }
            case BITOR_ASG: {
                return Tree.Kind.OR_ASSIGNMENT;
            }
            case NULLCHK: {
                return Tree.Kind.OTHER;
            }
            case ANNOTATION: {
                return Tree.Kind.ANNOTATION;
            }
            case TYPE_ANNOTATION: {
                return Tree.Kind.TYPE_ANNOTATION;
            }
        }
        return null;
    }

    public static JCTree.JCExpression typeIn(JCTree.JCExpression tree) {
        switch (tree.getTag()) {
            case ANNOTATED_TYPE: {
                return ((JCTree.JCAnnotatedType)tree).underlyingType;
            }
            case TYPEAPPLY: 
            case ERRONEOUS: 
            case IDENT: 
            case SELECT: 
            case TYPEARRAY: 
            case WILDCARD: 
            case TYPEPARAMETER: 
            case TYPEIDENT: {
                return tree;
            }
        }
        throw new AssertionError((Object)("Unexpected type tree: " + tree));
    }

    public static JCTree innermostType(JCTree type) {
        JCTree lastAnnotatedType = null;
        JCTree cur = type;
        block5: while (true) {
            switch (cur.getTag()) {
                case TYPEARRAY: {
                    lastAnnotatedType = null;
                    cur = ((JCTree.JCArrayTypeTree)cur).elemtype;
                    continue block5;
                }
                case WILDCARD: {
                    lastAnnotatedType = null;
                    cur = ((JCTree.JCWildcard)cur).inner;
                    continue block5;
                }
                case ANNOTATED_TYPE: {
                    lastAnnotatedType = cur;
                    cur = ((JCTree.JCAnnotatedType)cur).underlyingType;
                    continue block5;
                }
            }
            break;
        }
        if (lastAnnotatedType != null) {
            return lastAnnotatedType;
        }
        return cur;
    }

    public static boolean containsTypeAnnotation(JCTree e) {
        TypeAnnotationFinder finder = new TypeAnnotationFinder();
        finder.scan(e);
        return finder.foundTypeAnno;
    }

    private static class TypeAnnotationFinder
    extends TreeScanner {
        public boolean foundTypeAnno = false;

        private TypeAnnotationFinder() {
        }

        @Override
        public void scan(JCTree tree) {
            if (this.foundTypeAnno || tree == null) {
                return;
            }
            super.scan(tree);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation tree) {
            this.foundTypeAnno = this.foundTypeAnno || tree.hasTag(JCTree.Tag.TYPE_ANNOTATION);
        }
    }

    public static enum PosKind {
        START_POS{

            @Override
            int toPos(JCTree tree) {
                return TreeInfo.getStartPos(tree);
            }
        }
        ,
        FIRST_STAT_POS{

            @Override
            int toPos(JCTree tree) {
                return TreeInfo.firstStatPos(tree);
            }
        }
        ,
        END_POS{

            @Override
            int toPos(JCTree tree) {
                return TreeInfo.endPos(tree);
            }
        };


        abstract int toPos(JCTree var1);
    }
}

