/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Printer;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Warner;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.tools.JavaFileObject;

public class Types {
    protected static final Context.Key<Types> typesKey = new Context.Key();
    final Symtab syms;
    final JavacMessages messages;
    final Names names;
    final boolean allowBoxing;
    final boolean allowCovariantReturns;
    final boolean allowObjectToPrimitiveCast;
    final ClassReader reader;
    final Check chk;
    final Enter enter;
    JCDiagnostic.Factory diags;
    List<Warner> warnStack = List.nil();
    final Name capturedName;
    private final FunctionDescriptorLookupError functionDescriptorLookupError;
    public final Warner noWarnings;
    private final UnaryVisitor<Boolean> isUnbounded = new UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Void ignored) {
            List<Type> parms = t.tsym.type.allparams();
            List<Type> args = t.allparams();
            while (parms.nonEmpty()) {
                Type.WildcardType unb = new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass, (Type.TypeVar)((Type)parms.head).unannotatedType());
                if (!Types.this.containsType((Type)args.head, unb)) {
                    return false;
                }
                parms = parms.tail;
                args = args.tail;
            }
            return true;
        }
    };
    private final SimpleVisitor<Type, Symbol> asSub = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type t, Symbol sym) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Symbol sym) {
            if (t.tsym == sym) {
                return t;
            }
            Type base = Types.this.asSuper(sym.type, t.tsym);
            if (base == null) {
                return null;
            }
            ListBuffer<Type> from = new ListBuffer<Type>();
            ListBuffer<Type> to = new ListBuffer<Type>();
            try {
                Types.this.adapt(base, t, from, to);
            }
            catch (AdaptFailure ex) {
                return null;
            }
            Type res = Types.this.subst(sym.type, from.toList(), to.toList());
            if (!Types.this.isSubtype(res, t)) {
                return null;
            }
            ListBuffer openVars = new ListBuffer();
            List<Type> l = sym.type.allparams();
            while (l.nonEmpty()) {
                if (res.contains((Type)l.head) && !t.contains((Type)l.head)) {
                    openVars.append(l.head);
                }
                l = l.tail;
            }
            if (openVars.nonEmpty()) {
                if (t.isRaw()) {
                    res = Types.this.erasure(res);
                } else {
                    List<Type> opens = openVars.toList();
                    ListBuffer<Type.WildcardType> qs = new ListBuffer<Type.WildcardType>();
                    List<Type> iter = opens;
                    while (iter.nonEmpty()) {
                        qs.append(new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass, (Type.TypeVar)((Type)iter.head).unannotatedType()));
                        iter = iter.tail;
                    }
                    res = Types.this.subst(res, opens, qs.toList());
                }
            }
            return res;
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Symbol sym) {
            return t;
        }
    };
    private DescriptorCache descCache = new DescriptorCache();
    private Filter<Symbol> bridgeFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol t) {
            return t.kind == 16 && t.name != Types.this.names.init && t.name != Types.this.names.clinit && (t.flags() & 0x1000L) == 0L;
        }
    };
    private TypeRelation isSubtype = new TypeRelation(){
        private Set<TypePair> cache = new HashSet<TypePair>();

        @Override
        public Boolean visitType(Type t, Type s) {
            switch (t.getTag()) {
                case BYTE: {
                    return !s.hasTag(TypeTag.CHAR) && t.getTag().isSubRangeOf(s.getTag());
                }
                case CHAR: {
                    return !s.hasTag(TypeTag.SHORT) && t.getTag().isSubRangeOf(s.getTag());
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return t.getTag().isSubRangeOf(s.getTag());
                }
                case BOOLEAN: 
                case VOID: {
                    return t.hasTag(s.getTag());
                }
                case TYPEVAR: {
                    return Types.this.isSubtypeNoCapture(t.getUpperBound(), s);
                }
                case BOT: {
                    return s.hasTag(TypeTag.BOT) || s.hasTag(TypeTag.CLASS) || s.hasTag(TypeTag.ARRAY) || s.hasTag(TypeTag.TYPEVAR);
                }
                case WILDCARD: 
                case NONE: {
                    return false;
                }
            }
            throw new AssertionError((Object)("isSubtype " + (Object)((Object)t.getTag())));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsTypeRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Types.this.containsType(t.getTypeArguments(), s.getTypeArguments());
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return Types.this.containsType(t.getTypeArguments(), this.rewriteSupers(s).getTypeArguments());
        }

        private Type rewriteSupers(Type t) {
            if (!t.isParameterized()) {
                return t;
            }
            ListBuffer from = new ListBuffer();
            ListBuffer to = new ListBuffer();
            Types.this.adaptSelf(t, from, to);
            if (from.isEmpty()) {
                return t;
            }
            ListBuffer<Type> rewrite = new ListBuffer<Type>();
            boolean changed = false;
            for (Type orig : to.toList()) {
                Type s = this.rewriteSupers(orig);
                if (s.isSuperBound() && !s.isExtendsBound()) {
                    s = new Type.WildcardType(Types.this.syms.objectType, BoundKind.UNBOUND, Types.this.syms.boundClass);
                    changed = true;
                } else if (s != orig) {
                    s = new Type.WildcardType(Types.this.wildUpperBound(s), BoundKind.EXTENDS, Types.this.syms.boundClass);
                    changed = true;
                }
                rewrite.append(s);
            }
            if (changed) {
                return Types.this.subst(t.tsym.type, from.toList(), rewrite.toList());
            }
            return t;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Type s) {
            Type sup = Types.this.asSuper(t, s.tsym);
            if (sup == null) {
                return false;
            }
            if (!sup.hasTag(TypeTag.CLASS)) {
                return Types.this.isSubtypeNoCapture(sup, s);
            }
            return sup.tsym == s.tsym && (!s.isParameterized() || this.containsTypeRecursive(s, sup)) && Types.this.isSubtypeNoCapture(sup.getEnclosingType(), s.getEnclosingType());
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            if (s.hasTag(TypeTag.ARRAY)) {
                if (t.elemtype.isPrimitive()) {
                    return Types.this.isSameType(t.elemtype, Types.this.elemtype(s));
                }
                return Types.this.isSubtypeNoCapture(t.elemtype, Types.this.elemtype(s));
            }
            if (s.hasTag(TypeTag.CLASS)) {
                Name sname = s.tsym.getQualifiedName();
                return sname == Types.this.names.java_lang_Object || sname == Types.this.names.java_lang_Cloneable || sname == Types.this.names.java_io_Serializable;
            }
            return false;
        }

        @Override
        public Boolean visitUndetVar(Type.UndetVar t, Type s) {
            if (t == s || t.qtype == s || s.hasTag(TypeTag.ERROR) || s.hasTag(TypeTag.UNKNOWN)) {
                return true;
            }
            if (s.hasTag(TypeTag.BOT)) {
                return false;
            }
            t.addBound(Type.UndetVar.InferenceBound.UPPER, s, Types.this);
            return true;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return true;
        }
    };
    TypeRelation isSameTypeLoose = new LooseSameTypeVisitor();
    TypeRelation isSameTypeStrict = new SameTypeVisitor(){

        @Override
        boolean sameTypeVars(Type.TypeVar tv1, Type.TypeVar tv2) {
            return tv1 == tv2;
        }

        @Override
        protected boolean containsTypes(List<Type> ts1, List<Type> ts2) {
            return Types.this.isSameTypes(ts1, ts2, true);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (!s.hasTag(TypeTag.WILDCARD)) {
                return false;
            }
            Type.WildcardType t2 = (Type.WildcardType)s.unannotatedType();
            return t.kind == t2.kind && Types.this.isSameType(t.type, t2.type, true);
        }
    };
    TypeRelation isSameAnnotatedType = new LooseSameTypeVisitor(){

        @Override
        public Boolean visitAnnotatedType(Type.AnnotatedType t, Type s) {
            if (!s.isAnnotated()) {
                return false;
            }
            if (!((AbstractCollection)((Object)t.getAnnotationMirrors())).containsAll(s.getAnnotationMirrors())) {
                return false;
            }
            if (!((AbstractCollection)((Object)s.getAnnotationMirrors())).containsAll(t.getAnnotationMirrors())) {
                return false;
            }
            return (Boolean)this.visit(t.unannotatedType(), s);
        }
    };
    private TypeRelation containsType = new TypeRelation(){

        @Override
        public Boolean visitType(Type t, Type s) {
            if (s.isPartial()) {
                return Types.this.containedBy(s, t);
            }
            return Types.this.isSameType(t, s);
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (s.isPartial()) {
                return Types.this.containedBy(s, t);
            }
            return Types.this.isSameWildcard(t, s) || t.type == s || Types.this.isCaptureOf(s, t) || (t.isExtendsBound() || Types.this.isSubtypeNoCapture(Types.this.wildLowerBound(t), Types.this.cvarLowerBound(Types.this.wildLowerBound(s)))) && (t.isSuperBound() || Types.this.isSubtypeNoCapture(Types.this.cvarUpperBound(Types.this.wildUpperBound(s)), Types.this.wildUpperBound(t)));
        }

        @Override
        public Boolean visitUndetVar(Type.UndetVar t, Type s) {
            if (!s.hasTag(TypeTag.WILDCARD)) {
                return Types.this.isSameType(t, s);
            }
            return false;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return true;
        }
    };
    private TypeRelation isCastable = new TypeRelation(){

        @Override
        public Boolean visitType(Type t, Type s) {
            if (s.hasTag(TypeTag.ERROR)) {
                return true;
            }
            switch (t.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return s.isNumeric();
                }
                case BOOLEAN: {
                    return s.hasTag(TypeTag.BOOLEAN);
                }
                case VOID: {
                    return false;
                }
                case BOT: {
                    return Types.this.isSubtype(t, s);
                }
            }
            throw new AssertionError();
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            return Types.this.isCastable(Types.this.wildUpperBound(t), s, (Warner)Types.this.warnStack.head);
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Type s) {
            if (s.hasTag(TypeTag.ERROR) || s.hasTag(TypeTag.BOT)) {
                return true;
            }
            if (s.hasTag(TypeTag.TYPEVAR)) {
                if (Types.this.isCastable(t, s.getUpperBound(), Types.this.noWarnings)) {
                    ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                    return true;
                }
                return false;
            }
            if (t.isCompound() || s.isCompound()) {
                return !t.isCompound() ? this.visitIntersectionType((Type.IntersectionClassType)s.unannotatedType(), t, true) : this.visitIntersectionType((Type.IntersectionClassType)t.unannotatedType(), s, false);
            }
            if (s.hasTag(TypeTag.CLASS) || s.hasTag(TypeTag.ARRAY)) {
                boolean upcast = Types.this.isSubtype(Types.this.erasure(t), Types.this.erasure(s));
                if (upcast || Types.this.isSubtype(Types.this.erasure(s), Types.this.erasure(t))) {
                    Type highSub;
                    if (!upcast && s.hasTag(TypeTag.ARRAY)) {
                        if (!Types.this.isReifiable(s)) {
                            ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        }
                        return true;
                    }
                    if (s.isRaw()) {
                        return true;
                    }
                    if (t.isRaw()) {
                        if (!Types.this.isUnbounded(s)) {
                            ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        }
                        return true;
                    }
                    Type a = upcast ? t : s;
                    Type b = upcast ? s : t;
                    boolean HIGH = true;
                    boolean LOW = false;
                    boolean DONT_REWRITE_TYPEVARS = false;
                    Type aHigh = Types.this.rewriteQuantifiers(a, true, false);
                    Type aLow = Types.this.rewriteQuantifiers(a, false, false);
                    Type bHigh = Types.this.rewriteQuantifiers(b, true, false);
                    Type bLow = Types.this.rewriteQuantifiers(b, false, false);
                    Type lowSub = Types.this.asSub(bLow, aLow.tsym);
                    Type type = highSub = lowSub == null ? null : Types.this.asSub(bHigh, aHigh.tsym);
                    if (highSub == null) {
                        boolean REWRITE_TYPEVARS = true;
                        aHigh = Types.this.rewriteQuantifiers(a, true, true);
                        aLow = Types.this.rewriteQuantifiers(a, false, true);
                        bHigh = Types.this.rewriteQuantifiers(b, true, true);
                        bLow = Types.this.rewriteQuantifiers(b, false, true);
                        lowSub = Types.this.asSub(bLow, aLow.tsym);
                        Type type2 = highSub = lowSub == null ? null : Types.this.asSub(bHigh, aHigh.tsym);
                    }
                    if (highSub != null) {
                        if (a.tsym != highSub.tsym || a.tsym != lowSub.tsym) {
                            Assert.error(a.tsym + " != " + highSub.tsym + " != " + lowSub.tsym);
                        }
                        if (!(Types.this.disjointTypes(aHigh.allparams(), highSub.allparams()) || Types.this.disjointTypes(aHigh.allparams(), lowSub.allparams()) || Types.this.disjointTypes(aLow.allparams(), highSub.allparams()) || Types.this.disjointTypes(aLow.allparams(), lowSub.allparams()))) {
                            if (upcast ? Types.this.giveWarning(a, b) : Types.this.giveWarning(b, a)) {
                                ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                            }
                            return true;
                        }
                    }
                    if (Types.this.isReifiable(s)) {
                        return Types.this.isSubtypeUnchecked(a, b);
                    }
                    return Types.this.isSubtypeUnchecked(a, b, (Warner)Types.this.warnStack.head);
                }
                if (s.hasTag(TypeTag.CLASS)) {
                    if ((s.tsym.flags() & 0x200L) != 0L) {
                        return (t.tsym.flags() & 0x10L) == 0L ? Types.this.sideCast(t, s, (Warner)Types.this.warnStack.head) : Types.this.sideCastFinal(t, s, (Warner)Types.this.warnStack.head);
                    }
                    if ((t.tsym.flags() & 0x200L) != 0L) {
                        return (s.tsym.flags() & 0x10L) == 0L ? Types.this.sideCast(t, s, (Warner)Types.this.warnStack.head) : Types.this.sideCastFinal(t, s, (Warner)Types.this.warnStack.head);
                    }
                    return false;
                }
            }
            return false;
        }

        boolean visitIntersectionType(Type.IntersectionClassType ict, Type s, boolean reverse) {
            Warner warn = Types.this.noWarnings;
            for (Type c : ict.getComponents()) {
                warn.clear();
                if (!(reverse ? !Types.this.isCastable(s, c, warn) : !Types.this.isCastable(c, s, warn))) continue;
                return false;
            }
            if (warn.hasLint(Lint.LintCategory.UNCHECKED)) {
                ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            switch (s.getTag()) {
                case BOT: 
                case ERROR: {
                    return true;
                }
                case TYPEVAR: {
                    if (Types.this.isCastable(s, t, Types.this.noWarnings)) {
                        ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        return true;
                    }
                    return false;
                }
                case CLASS: {
                    return Types.this.isSubtype(t, s);
                }
                case ARRAY: {
                    if (Types.this.elemtype(t).isPrimitive() || Types.this.elemtype(s).isPrimitive()) {
                        return Types.this.elemtype(t).hasTag(Types.this.elemtype(s).getTag());
                    }
                    return (Boolean)this.visit(Types.this.elemtype(t), Types.this.elemtype(s));
                }
            }
            return false;
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Type s) {
            switch (s.getTag()) {
                case BOT: 
                case ERROR: {
                    return true;
                }
                case TYPEVAR: {
                    if (Types.this.isSubtype(t, s)) {
                        return true;
                    }
                    if (Types.this.isCastable(t.bound, s, Types.this.noWarnings)) {
                        ((Warner)Types.this.warnStack.head).warn(Lint.LintCategory.UNCHECKED);
                        return true;
                    }
                    return false;
                }
            }
            return Types.this.isCastable(t.bound, s, (Warner)Types.this.warnStack.head);
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return true;
        }
    };
    private TypeRelation disjointType = new TypeRelation(){
        private Set<TypePair> cache = new HashSet<TypePair>();

        @Override
        public Boolean visitType(Type t, Type s) {
            if (s.hasTag(TypeTag.WILDCARD)) {
                return (Boolean)this.visit(s, t);
            }
            return this.notSoftSubtypeRecursive(t, s) || this.notSoftSubtypeRecursive(s, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCastableRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Types.this.isCastable(t, s);
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean notSoftSubtypeRecursive(Type t, Type s) {
            TypePair pair = new TypePair(t, s);
            if (this.cache.add(pair)) {
                try {
                    boolean bl = Types.this.notSoftSubtype(t, s);
                    return bl;
                }
                finally {
                    this.cache.remove(pair);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (t.isUnbound()) {
                return false;
            }
            if (!s.hasTag(TypeTag.WILDCARD)) {
                if (t.isExtendsBound()) {
                    return this.notSoftSubtypeRecursive(s, t.type);
                }
                return this.notSoftSubtypeRecursive(t.type, s);
            }
            if (s.isUnbound()) {
                return false;
            }
            if (t.isExtendsBound()) {
                if (s.isExtendsBound()) {
                    return !this.isCastableRecursive(t.type, Types.this.wildUpperBound(s));
                }
                if (s.isSuperBound()) {
                    return this.notSoftSubtypeRecursive(Types.this.wildLowerBound(s), t.type);
                }
            } else if (t.isSuperBound() && s.isExtendsBound()) {
                return this.notSoftSubtypeRecursive(t.type, Types.this.wildUpperBound(s));
            }
            return false;
        }
    };
    private final Type.Mapping cvarLowerBoundMapping = new Type.Mapping("cvarLowerBound"){

        @Override
        public Type apply(Type t) {
            return Types.this.cvarLowerBound(t);
        }
    };
    private UnaryVisitor<Boolean> isReifiable = new UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void ignored) {
            return true;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Void ignored) {
            if (t.isCompound()) {
                return false;
            }
            if (!t.isParameterized()) {
                return true;
            }
            for (Type param : t.allparams()) {
                if (param.isUnbound()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Void ignored) {
            return (Boolean)this.visit(t.elemtype);
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void ignored) {
            return false;
        }
    };
    private Type.Mapping elemTypeFun = new Type.Mapping("elemTypeFun"){

        @Override
        public Type apply(Type t) {
            return Types.this.elemtype(t);
        }
    };
    private SimpleVisitor<Type, Symbol> asSuper = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type t, Symbol sym) {
            return null;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Symbol sym) {
            Type x;
            if (t.tsym == sym) {
                return t;
            }
            Type st = Types.this.supertype(t);
            if ((st.hasTag(TypeTag.CLASS) || st.hasTag(TypeTag.TYPEVAR)) && (x = Types.this.asSuper(st, sym)) != null) {
                return x;
            }
            if ((sym.flags() & 0x200L) != 0L) {
                List<Type> l = Types.this.interfaces(t);
                while (l.nonEmpty()) {
                    Type x2;
                    if (!((Type)l.head).hasTag(TypeTag.ERROR) && (x2 = Types.this.asSuper((Type)l.head, sym)) != null) {
                        return x2;
                    }
                    l = l.tail;
                }
            }
            return null;
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Symbol sym) {
            return Types.this.isSubtype(t, sym.type) ? sym.type : null;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Symbol sym) {
            if (t.tsym == sym) {
                return t;
            }
            return Types.this.asSuper(t.bound, sym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Symbol sym) {
            return t;
        }
    };
    private SimpleVisitor<Type, Symbol> memberType = new SimpleVisitor<Type, Symbol>(){

        @Override
        public Type visitType(Type t, Symbol sym) {
            return sym.type;
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Symbol sym) {
            return Types.this.memberType(Types.this.wildUpperBound(t), sym);
        }

        @Override
        public Type visitClassType(Type.ClassType t, Symbol sym) {
            Symbol owner = sym.owner;
            long flags = sym.flags();
            if ((flags & 8L) == 0L && owner.type.isParameterized()) {
                Type base = Types.this.asOuterSuper(t, owner);
                Type type = base = t.isCompound() ? Types.this.capture(base) : base;
                if (base != null) {
                    List<Type> ownerParams = owner.type.allparams();
                    List<Type> baseParams = base.allparams();
                    if (ownerParams.nonEmpty()) {
                        if (baseParams.isEmpty()) {
                            return Types.this.erasure(sym.type);
                        }
                        return Types.this.subst(sym.type, ownerParams, baseParams);
                    }
                }
            }
            return sym.type;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Symbol sym) {
            return Types.this.memberType(t.bound, sym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Symbol sym) {
            return t;
        }
    };
    private SimpleVisitor<Type, Boolean> erasure = new SimpleVisitor<Type, Boolean>(){

        @Override
        public Type visitType(Type t, Boolean recurse) {
            if (t.isPrimitive()) {
                return t;
            }
            return t.map(recurse != false ? Types.this.erasureRecFun : Types.this.erasureFun);
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Boolean recurse) {
            return Types.this.erasure(Types.this.wildUpperBound(t), recurse);
        }

        @Override
        public Type visitClassType(Type.ClassType t, Boolean recurse) {
            Type erased = t.tsym.erasure(Types.this);
            if (recurse.booleanValue()) {
                erased = new Type.ErasedClassType(erased.getEnclosingType(), erased.tsym);
            }
            return erased;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Boolean recurse) {
            return Types.this.erasure(t.bound, recurse);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Boolean recurse) {
            return t;
        }

        @Override
        public Type visitAnnotatedType(Type.AnnotatedType t, Boolean recurse) {
            Type erased = Types.this.erasure(t.unannotatedType(), recurse);
            if (erased.isAnnotated()) {
                erased = ((Type.AnnotatedType)erased).unannotatedType();
            }
            return erased.annotatedType((List<Attribute.TypeCompound>)t.getAnnotationMirrors());
        }
    };
    private Type.Mapping erasureFun = new Type.Mapping("erasure"){

        @Override
        public Type apply(Type t) {
            return Types.this.erasure(t);
        }
    };
    private Type.Mapping erasureRecFun = new Type.Mapping("erasureRecursive"){

        @Override
        public Type apply(Type t) {
            return Types.this.erasureRecursive(t);
        }
    };
    private UnaryVisitor<Type> supertype = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type t, Void ignored) {
            return Type.noType;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            if (t.supertype_field == null) {
                Type supertype = ((Symbol.ClassSymbol)t.tsym).getSuperclass();
                if (t.isInterface()) {
                    supertype = ((Type.ClassType)t.tsym.type).supertype_field;
                }
                if (t.supertype_field == null) {
                    List<Type> actuals = Types.this.classBound(t).allparams();
                    List<Type> formals = t.tsym.type.allparams();
                    t.supertype_field = t.hasErasedSupertypes() ? Types.this.erasureRecursive(supertype) : (formals.nonEmpty() ? Types.this.subst(supertype, formals, actuals) : supertype);
                }
            }
            return t.supertype_field;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            if (t.bound.hasTag(TypeTag.TYPEVAR) || !t.bound.isCompound() && !t.bound.isInterface()) {
                return t.bound;
            }
            return Types.this.supertype(t.bound);
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Void ignored) {
            if (t.elemtype.isPrimitive() || Types.this.isSameType(t.elemtype, Types.this.syms.objectType)) {
                return Types.this.arraySuperType();
            }
            return new Type.ArrayType(Types.this.supertype(t.elemtype), t.tsym);
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return Type.noType;
        }
    };
    private UnaryVisitor<List<Type>> interfaces = new UnaryVisitor<List<Type>>(){

        @Override
        public List<Type> visitType(Type t, Void ignored) {
            return List.nil();
        }

        @Override
        public List<Type> visitClassType(Type.ClassType t, Void ignored) {
            if (t.interfaces_field == null) {
                java.util.List interfaces = ((Symbol.ClassSymbol)t.tsym).getInterfaces();
                if (t.interfaces_field == null) {
                    Assert.check(t != t.tsym.type, t);
                    List<Type> actuals = t.allparams();
                    List<Type> formals = t.tsym.type.allparams();
                    t.interfaces_field = t.hasErasedSupertypes() ? Types.this.erasureRecursive((List<Type>)interfaces) : (formals.nonEmpty() ? Types.this.subst((List<Type>)interfaces, formals, actuals) : interfaces);
                }
            }
            return t.interfaces_field;
        }

        @Override
        public List<Type> visitTypeVar(Type.TypeVar t, Void ignored) {
            if (t.bound.isCompound()) {
                return Types.this.interfaces(t.bound);
            }
            if (t.bound.isInterface()) {
                return List.of(t.bound);
            }
            return List.nil();
        }
    };
    private final UnaryVisitor<List<Type>> directSupertypes = new UnaryVisitor<List<Type>>(){

        @Override
        public List<Type> visitType(Type type, Void ignored) {
            if (!type.isCompound()) {
                Type sup = Types.this.supertype(type);
                return sup == Type.noType || sup == type || sup == null ? Types.this.interfaces(type) : Types.this.interfaces(type).prepend(sup);
            }
            return this.visitIntersectionType((Type.IntersectionClassType)type);
        }

        private List<Type> visitIntersectionType(Type.IntersectionClassType it) {
            return it.getExplicitComponents();
        }
    };
    Map<Type, Boolean> isDerivedRawCache = new HashMap<Type, Boolean>();
    private UnaryVisitor<Type> classBound = new UnaryVisitor<Type>(){

        @Override
        public Type visitType(Type t, Void ignored) {
            return t;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            Type outer1 = Types.this.classBound(t.getEnclosingType());
            if (outer1 != t.getEnclosingType()) {
                return new Type.ClassType(outer1, (List<Type>)t.getTypeArguments(), t.tsym);
            }
            return t;
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            return Types.this.classBound(Types.this.supertype(t));
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return t;
        }
    };
    private ImplementationCache implCache = new ImplementationCache();
    private MembersClosureCache membersCache = new MembersClosureCache();
    TypeRelation hasSameArgs_strict = new HasSameArgs(true);
    TypeRelation hasSameArgs_nonstrict = new HasSameArgs(false);
    private static final Type.Mapping newInstanceFun = new Type.Mapping("newInstanceFun"){

        @Override
        public Type apply(Type t) {
            return new Type.TypeVar(t.tsym, t.getUpperBound(), t.getLowerBound());
        }
    };
    private final MapVisitor<List<Type>> methodWithParameters = new MapVisitor<List<Type>>(){

        @Override
        public Type visitType(Type t, List<Type> newParams) {
            throw new IllegalArgumentException("Not a method type: " + t);
        }

        @Override
        public Type visitMethodType(Type.MethodType t, List<Type> newParams) {
            return new Type.MethodType(newParams, t.restype, t.thrown, t.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll t, List<Type> newParams) {
            return new Type.ForAll(t.tvars, t.qtype.accept(this, newParams));
        }
    };
    private final MapVisitor<List<Type>> methodWithThrown = new MapVisitor<List<Type>>(){

        @Override
        public Type visitType(Type t, List<Type> newThrown) {
            throw new IllegalArgumentException("Not a method type: " + t);
        }

        @Override
        public Type visitMethodType(Type.MethodType t, List<Type> newThrown) {
            return new Type.MethodType(t.argtypes, t.restype, newThrown, t.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll t, List<Type> newThrown) {
            return new Type.ForAll(t.tvars, t.qtype.accept(this, newThrown));
        }
    };
    private final MapVisitor<Type> methodWithReturn = new MapVisitor<Type>(){

        @Override
        public Type visitType(Type t, Type newReturn) {
            throw new IllegalArgumentException("Not a method type: " + t);
        }

        @Override
        public Type visitMethodType(Type.MethodType t, Type newReturn) {
            return new Type.MethodType(t.argtypes, newReturn, t.thrown, t.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll t, Type newReturn) {
            return new Type.ForAll(t.tvars, t.qtype.accept(this, newReturn));
        }
    };
    private Map<Type, List<Type>> closureCache = new HashMap<Type, List<Type>>();
    Set<TypePair> mergeCache = new HashSet<TypePair>();
    private Type arraySuperType = null;
    private static final UnaryVisitor<Integer> hashCode = new UnaryVisitor<Integer>(){

        @Override
        public Integer visitType(Type t, Void ignored) {
            return t.getTag().ordinal();
        }

        @Override
        public Integer visitClassType(Type.ClassType t, Void ignored) {
            int result = (Integer)this.visit(t.getEnclosingType());
            result *= 127;
            result += t.tsym.flatName().hashCode();
            for (Type s : t.getTypeArguments()) {
                result *= 127;
                result += ((Integer)this.visit(s)).intValue();
            }
            return result;
        }

        @Override
        public Integer visitMethodType(Type.MethodType t, Void ignored) {
            int h = TypeTag.METHOD.ordinal();
            List<Type> thisargs = t.argtypes;
            while (thisargs.tail != null) {
                h = (h << 5) + (Integer)this.visit((Type)thisargs.head);
                thisargs = thisargs.tail;
            }
            return (h << 5) + (Integer)this.visit(t.restype);
        }

        @Override
        public Integer visitWildcardType(Type.WildcardType t, Void ignored) {
            int result = t.kind.hashCode();
            if (t.type != null) {
                result *= 127;
                result += ((Integer)this.visit(t.type)).intValue();
            }
            return result;
        }

        @Override
        public Integer visitArrayType(Type.ArrayType t, Void ignored) {
            return (Integer)this.visit(t.elemtype) + 12;
        }

        @Override
        public Integer visitTypeVar(Type.TypeVar t, Void ignored) {
            return System.identityHashCode(t.tsym);
        }

        @Override
        public Integer visitUndetVar(Type.UndetVar t, Void ignored) {
            return System.identityHashCode(t);
        }

        @Override
        public Integer visitErrorType(Type.ErrorType t, Void ignored) {
            return 0;
        }
    };

    public static Types instance(Context context) {
        Types instance = context.get(typesKey);
        if (instance == null) {
            instance = new Types(context);
        }
        return instance;
    }

    protected Types(Context context) {
        context.put(typesKey, this);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        Source source = Source.instance(context);
        this.allowBoxing = source.allowBoxing();
        this.allowCovariantReturns = source.allowCovariantReturns();
        this.allowObjectToPrimitiveCast = source.allowObjectToPrimitiveCast();
        this.reader = ClassReader.instance(context);
        this.chk = Check.instance(context);
        this.enter = Enter.instance(context);
        this.capturedName = this.names.fromString("<captured wildcard>");
        this.messages = JavacMessages.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.functionDescriptorLookupError = new FunctionDescriptorLookupError();
        this.noWarnings = new Warner(null);
    }

    public Type wildUpperBound(Type t) {
        if (t.hasTag(TypeTag.WILDCARD)) {
            Type.WildcardType w = (Type.WildcardType)t.unannotatedType();
            if (w.isSuperBound()) {
                return w.bound == null ? this.syms.objectType : w.bound.bound;
            }
            return this.wildUpperBound(w.type);
        }
        return t.unannotatedType();
    }

    public Type cvarUpperBound(Type t) {
        if (t.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar v = (Type.TypeVar)t.unannotatedType();
            return v.isCaptured() ? this.cvarUpperBound(v.bound) : v;
        }
        return t.unannotatedType();
    }

    public Type wildLowerBound(Type t) {
        if (t.hasTag(TypeTag.WILDCARD)) {
            Type.WildcardType w = (Type.WildcardType)t.unannotatedType();
            return w.isExtendsBound() ? this.syms.botType : this.wildLowerBound(w.type);
        }
        return t.unannotatedType();
    }

    public Type cvarLowerBound(Type t) {
        if (t.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar v = (Type.TypeVar)t.unannotatedType();
            return v.isCaptured() ? this.cvarLowerBound(v.getLowerBound()) : v;
        }
        return t.unannotatedType();
    }

    public boolean isUnbounded(Type t) {
        return this.isUnbounded.visit(t);
    }

    public Type asSub(Type t, Symbol sym) {
        return (Type)this.asSub.visit(t, sym);
    }

    public boolean isConvertible(Type t, Type s, Warner warn) {
        boolean sPrimitive;
        if (t.hasTag(TypeTag.ERROR)) {
            return true;
        }
        boolean tPrimitive = t.isPrimitive();
        if (tPrimitive == (sPrimitive = s.isPrimitive())) {
            return this.isSubtypeUnchecked(t, s, warn);
        }
        if (!this.allowBoxing) {
            return false;
        }
        return tPrimitive ? this.isSubtype(this.boxedClass((Type)t).type, s) : this.isSubtype(this.unboxedType(t), s);
    }

    public boolean isConvertible(Type t, Type s) {
        return this.isConvertible(t, s, this.noWarnings);
    }

    public Symbol findDescriptorSymbol(Symbol.TypeSymbol origin) throws FunctionDescriptorLookupError {
        return this.descCache.get(origin).getSymbol();
    }

    public Type findDescriptorType(Type origin) throws FunctionDescriptorLookupError {
        return this.descCache.get(origin.tsym).getType(origin);
    }

    public boolean isFunctionalInterface(Symbol.TypeSymbol tsym) {
        try {
            this.findDescriptorSymbol(tsym);
            return true;
        }
        catch (FunctionDescriptorLookupError ex) {
            return false;
        }
    }

    public boolean isFunctionalInterface(Type site) {
        try {
            this.findDescriptorType(site);
            return true;
        }
        catch (FunctionDescriptorLookupError ex) {
            return false;
        }
    }

    public Type removeWildcards(Type site) {
        Type capturedSite = this.capture(site);
        if (capturedSite != site) {
            Type formalInterface = site.tsym.type;
            ListBuffer<Type> typeargs = new ListBuffer<Type>();
            List<Type> actualTypeargs = site.getTypeArguments();
            List<Type> capturedTypeargs = capturedSite.getTypeArguments();
            for (Type t : formalInterface.getTypeArguments()) {
                if (((Type)actualTypeargs.head).hasTag(TypeTag.WILDCARD)) {
                    Type bound;
                    Type.WildcardType wt = (Type.WildcardType)((Type)actualTypeargs.head).unannotatedType();
                    switch (wt.kind) {
                        case EXTENDS: 
                        case UNBOUND: {
                            Type.CapturedType capVar = (Type.CapturedType)((Type)capturedTypeargs.head).unannotatedType();
                            bound = capVar.bound.containsAny(capturedSite.getTypeArguments()) ? wt.type : capVar.bound;
                            break;
                        }
                        default: {
                            bound = wt.type;
                        }
                    }
                    typeargs.append(bound);
                } else {
                    typeargs.append((Type)actualTypeargs.head);
                }
                actualTypeargs = actualTypeargs.tail;
                capturedTypeargs = capturedTypeargs.tail;
            }
            return this.subst(formalInterface, formalInterface.getTypeArguments(), typeargs.toList());
        }
        return site;
    }

    public Symbol.ClassSymbol makeFunctionalInterfaceClass(Env<AttrContext> env, Name name, List<Type> targets, long cflags) {
        if (targets.isEmpty()) {
            return null;
        }
        Symbol descSym = this.findDescriptorSymbol(((Type)targets.head).tsym);
        Type descType = this.findDescriptorType((Type)targets.head);
        Symbol.ClassSymbol csym = new Symbol.ClassSymbol(cflags, name, env.enclClass.sym.outermostClass());
        csym.completer = null;
        csym.members_field = new Scope(csym);
        Symbol.MethodSymbol instDescSym = new Symbol.MethodSymbol(descSym.flags(), descSym.name, descType, csym);
        csym.members_field.enter(instDescSym);
        Type.ClassType ctype = new Type.ClassType(Type.noType, List.nil(), csym);
        ctype.supertype_field = this.syms.objectType;
        ctype.interfaces_field = targets;
        csym.type = ctype;
        csym.sourcefile = ((Symbol.ClassSymbol)csym.owner).sourcefile;
        return csym;
    }

    public List<Symbol> functionalInterfaceBridges(Symbol.TypeSymbol origin) {
        Assert.check(this.isFunctionalInterface(origin));
        Symbol descSym = this.findDescriptorSymbol(origin);
        Scope.CompoundScope members = this.membersClosure(origin.type, false);
        ListBuffer<Symbol> overridden = new ListBuffer<Symbol>();
        block0: for (Symbol m2 : members.getElementsByName(descSym.name, this.bridgeFilter)) {
            if (m2 == descSym || !descSym.overrides(m2, origin, this, false)) continue;
            for (Symbol m3 : overridden) {
                if (!this.isSameType(m3.erasure(this), m2.erasure(this)) && (!m3.overrides(m2, origin, this, false) || !this.pendingBridges((Symbol.ClassSymbol)origin, m3.enclClass()) && ((Symbol.MethodSymbol)m2).binaryImplementation((Symbol.ClassSymbol)m3.owner, this) == null)) continue;
                continue block0;
            }
            overridden.add(m2);
        }
        return overridden.toList();
    }

    private boolean pendingBridges(Symbol.ClassSymbol origin, Symbol.TypeSymbol s) {
        if (origin.classfile != null && origin.classfile.getKind() == JavaFileObject.Kind.CLASS && this.enter.getEnv(origin) == null) {
            return false;
        }
        if (origin == s) {
            return true;
        }
        for (Type t : this.interfaces(origin.type)) {
            if (!this.pendingBridges((Symbol.ClassSymbol)t.tsym, s)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubtypeUnchecked(Type t, Type s) {
        return this.isSubtypeUnchecked(t, s, this.noWarnings);
    }

    public boolean isSubtypeUnchecked(Type t, Type s, Warner warn) {
        boolean result = this.isSubtypeUncheckedInternal(t, s, warn);
        if (result) {
            this.checkUnsafeVarargsConversion(t, s, warn);
        }
        return result;
    }

    private boolean isSubtypeUncheckedInternal(Type t, Type s, Warner warn) {
        Type t2;
        if (t.hasTag(TypeTag.ARRAY) && s.hasTag(TypeTag.ARRAY)) {
            t = t.unannotatedType();
            s = s.unannotatedType();
            if (((Type.ArrayType)t).elemtype.isPrimitive()) {
                return this.isSameType(this.elemtype(t), this.elemtype(s));
            }
            return this.isSubtypeUnchecked(this.elemtype(t), this.elemtype(s), warn);
        }
        if (this.isSubtype(t, s)) {
            return true;
        }
        if (t.hasTag(TypeTag.TYPEVAR)) {
            return this.isSubtypeUnchecked(t.getUpperBound(), s, warn);
        }
        if (!s.isRaw() && (t2 = this.asSuper(t, s.tsym)) != null && t2.isRaw()) {
            if (this.isReifiable(s)) {
                warn.silentWarn(Lint.LintCategory.UNCHECKED);
            } else {
                warn.warn(Lint.LintCategory.UNCHECKED);
            }
            return true;
        }
        return false;
    }

    private void checkUnsafeVarargsConversion(Type t, Type s, Warner warn) {
        if (!t.hasTag(TypeTag.ARRAY) || this.isReifiable(t)) {
            return;
        }
        t = t.unannotatedType();
        s = s.unannotatedType();
        Type.ArrayType from = (Type.ArrayType)t;
        boolean shouldWarn = false;
        switch (s.getTag()) {
            case ARRAY: {
                Type.ArrayType to = (Type.ArrayType)s;
                shouldWarn = from.isVarargs() && !to.isVarargs() && !this.isReifiable(from);
                break;
            }
            case CLASS: {
                shouldWarn = from.isVarargs();
            }
        }
        if (shouldWarn) {
            warn.warn(Lint.LintCategory.VARARGS);
        }
    }

    public final boolean isSubtype(Type t, Type s) {
        return this.isSubtype(t, s, true);
    }

    public final boolean isSubtypeNoCapture(Type t, Type s) {
        return this.isSubtype(t, s, false);
    }

    public boolean isSubtype(Type t, Type s, boolean capture) {
        Type lower;
        if (t == s) {
            return true;
        }
        if ((t = t.unannotatedType()) == (s = s.unannotatedType())) {
            return true;
        }
        if (s.isPartial()) {
            return this.isSuperType(s, t);
        }
        if (s.isCompound()) {
            for (Type s2 : this.interfaces(s).prepend(this.supertype(s))) {
                if (this.isSubtype(t, s2, capture)) continue;
                return false;
            }
            return true;
        }
        if (!t.hasTag(TypeTag.UNDETVAR) && !t.isCompound() && s != (lower = this.cvarLowerBound(this.wildLowerBound(s)))) {
            return this.isSubtype(capture ? this.capture(t) : t, lower, false);
        }
        return (Boolean)this.isSubtype.visit(capture ? this.capture(t) : t, s);
    }

    public boolean isSubtypeUnchecked(Type t, List<Type> ts, Warner warn) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (!this.isSubtypeUnchecked(t, (Type)l.head, warn)) {
                return false;
            }
            l = l.tail;
        }
        return true;
    }

    public boolean isSubtypes(List<Type> ts, List<Type> ss) {
        while (ts.tail != null && ss.tail != null && this.isSubtype((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.tail == null && ss.tail == null;
    }

    public boolean isSubtypesUnchecked(List<Type> ts, List<Type> ss, Warner warn) {
        while (ts.tail != null && ss.tail != null && this.isSubtypeUnchecked((Type)ts.head, (Type)ss.head, warn)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.tail == null && ss.tail == null;
    }

    public boolean isSuperType(Type t, Type s) {
        switch (t.getTag()) {
            case ERROR: {
                return true;
            }
            case UNDETVAR: {
                Type.UndetVar undet = (Type.UndetVar)t;
                if (t == s || undet.qtype == s || s.hasTag(TypeTag.ERROR) || s.hasTag(TypeTag.BOT)) {
                    return true;
                }
                undet.addBound(Type.UndetVar.InferenceBound.LOWER, s, this);
                return true;
            }
        }
        return this.isSubtype(s, t);
    }

    public boolean isSameTypes(List<Type> ts, List<Type> ss) {
        return this.isSameTypes(ts, ss, false);
    }

    public boolean isSameTypes(List<Type> ts, List<Type> ss, boolean strict) {
        while (ts.tail != null && ss.tail != null && this.isSameType((Type)ts.head, (Type)ss.head, strict)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.tail == null && ss.tail == null;
    }

    public boolean isSignaturePolymorphic(Symbol.MethodSymbol msym) {
        List<Type> argtypes = msym.type.getParameterTypes();
        return (msym.flags_field & 0x100L) != 0L && msym.owner == this.syms.methodHandleType.tsym && argtypes.tail.tail == null && ((Type)argtypes.head).hasTag(TypeTag.ARRAY) && msym.type.getReturnType().tsym == this.syms.objectType.tsym && ((Type.ArrayType)argtypes.head).elemtype.tsym == this.syms.objectType.tsym;
    }

    public boolean isSameType(Type t, Type s) {
        return this.isSameType(t, s, false);
    }

    public boolean isSameType(Type t, Type s, boolean strict) {
        return strict ? (Boolean)this.isSameTypeStrict.visit(t, s) : (Boolean)this.isSameTypeLoose.visit(t, s);
    }

    public boolean isSameAnnotatedType(Type t, Type s) {
        return (Boolean)this.isSameAnnotatedType.visit(t, s);
    }

    public boolean containedBy(Type t, Type s) {
        switch (t.getTag()) {
            case UNDETVAR: {
                if (s.hasTag(TypeTag.WILDCARD)) {
                    Type.UndetVar undetvar = (Type.UndetVar)t;
                    Type.WildcardType wt = (Type.WildcardType)s.unannotatedType();
                    switch (wt.kind) {
                        case UNBOUND: {
                            break;
                        }
                        case EXTENDS: {
                            Type bound = this.wildUpperBound(s);
                            undetvar.addBound(Type.UndetVar.InferenceBound.UPPER, bound, this);
                            break;
                        }
                        case SUPER: {
                            Type bound = this.wildLowerBound(s);
                            undetvar.addBound(Type.UndetVar.InferenceBound.LOWER, bound, this);
                            break;
                        }
                    }
                    return true;
                }
                return this.isSameType(t, s);
            }
            case ERROR: {
                return true;
            }
        }
        return this.containsType(s, t);
    }

    boolean containsType(List<Type> ts, List<Type> ss) {
        while (ts.nonEmpty() && ss.nonEmpty() && this.containsType((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.isEmpty() && ss.isEmpty();
    }

    public boolean containsType(Type t, Type s) {
        return (Boolean)this.containsType.visit(t, s);
    }

    public boolean isCaptureOf(Type s, Type.WildcardType t) {
        if (!s.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)s.unannotatedType()).isCaptured()) {
            return false;
        }
        return this.isSameWildcard(t, ((Type.CapturedType)s.unannotatedType()).wildcard);
    }

    public boolean isSameWildcard(Type.WildcardType t, Type s) {
        if (!s.hasTag(TypeTag.WILDCARD)) {
            return false;
        }
        Type.WildcardType w = (Type.WildcardType)s.unannotatedType();
        return w.kind == t.kind && w.type == t.type;
    }

    public boolean containsTypeEquivalent(List<Type> ts, List<Type> ss) {
        while (ts.nonEmpty() && ss.nonEmpty() && this.containsTypeEquivalent((Type)ts.head, (Type)ss.head)) {
            ts = ts.tail;
            ss = ss.tail;
        }
        return ts.isEmpty() && ss.isEmpty();
    }

    public boolean isEqualityComparable(Type s, Type t, Warner warn) {
        if (t.isNumeric() && s.isNumeric()) {
            return true;
        }
        boolean tPrimitive = t.isPrimitive();
        boolean sPrimitive = s.isPrimitive();
        if (!tPrimitive && !sPrimitive) {
            return this.isCastable(s, t, warn) || this.isCastable(t, s, warn);
        }
        return false;
    }

    public boolean isCastable(Type t, Type s) {
        return this.isCastable(t, s, this.noWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCastable(Type t, Type s, Warner warn) {
        if (t == s) {
            return true;
        }
        if (t.isPrimitive() != s.isPrimitive()) {
            return this.allowBoxing && (this.isConvertible(t, s, warn) || this.allowObjectToPrimitiveCast && s.isPrimitive() && this.isSubtype(this.boxedClass((Type)s).type, t));
        }
        if (warn != this.warnStack.head) {
            try {
                this.warnStack = this.warnStack.prepend(warn);
                this.checkUnsafeVarargsConversion(t, s, warn);
                boolean bl = (Boolean)this.isCastable.visit(t, s);
                return bl;
            }
            finally {
                this.warnStack = this.warnStack.tail;
            }
        }
        return (Boolean)this.isCastable.visit(t, s);
    }

    public boolean disjointTypes(List<Type> ts, List<Type> ss) {
        while (ts.tail != null && ss.tail != null) {
            if (this.disjointType((Type)ts.head, (Type)ss.head)) {
                return true;
            }
            ts = ts.tail;
            ss = ss.tail;
        }
        return false;
    }

    public boolean disjointType(Type t, Type s) {
        return (Boolean)this.disjointType.visit(t, s);
    }

    public List<Type> cvarLowerBounds(List<Type> ts) {
        return Type.map(ts, this.cvarLowerBoundMapping);
    }

    public boolean notSoftSubtype(Type t, Type s) {
        if (t == s) {
            return false;
        }
        if (t.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            return !this.isCastable(tv.bound, this.relaxBound(s), this.noWarnings);
        }
        if (!s.hasTag(TypeTag.WILDCARD)) {
            s = this.cvarUpperBound(s);
        }
        return !this.isSubtype(t, this.relaxBound(s));
    }

    private Type relaxBound(Type t) {
        if (t.hasTag(TypeTag.TYPEVAR)) {
            while (t.hasTag(TypeTag.TYPEVAR)) {
                t = t.getUpperBound();
            }
            t = this.rewriteQuantifiers(t, true, true);
        }
        return t;
    }

    public boolean isReifiable(Type t) {
        return this.isReifiable.visit(t);
    }

    public boolean isArray(Type t) {
        while (t.hasTag(TypeTag.WILDCARD)) {
            t = this.wildUpperBound(t);
        }
        return t.hasTag(TypeTag.ARRAY);
    }

    public Type elemtype(Type t) {
        switch (t.getTag()) {
            case WILDCARD: {
                return this.elemtype(this.wildUpperBound(t));
            }
            case ARRAY: {
                t = t.unannotatedType();
                return ((Type.ArrayType)t).elemtype;
            }
            case FORALL: {
                return this.elemtype(((Type.ForAll)t).qtype);
            }
            case ERROR: {
                return t;
            }
        }
        return null;
    }

    public Type elemtypeOrType(Type t) {
        Type elemtype = this.elemtype(t);
        return elemtype != null ? elemtype : t;
    }

    public int dimensions(Type t) {
        int result = 0;
        while (t.hasTag(TypeTag.ARRAY)) {
            ++result;
            t = this.elemtype(t);
        }
        return result;
    }

    public Type.ArrayType makeArrayType(Type t) {
        if (t.hasTag(TypeTag.VOID) || t.hasTag(TypeTag.PACKAGE)) {
            Assert.error("Type t must not be a VOID or PACKAGE type, " + t.toString());
        }
        return new Type.ArrayType(t, this.syms.arrayClass);
    }

    public Type asSuper(Type t, Symbol sym) {
        if (sym.type == this.syms.objectType) {
            return this.syms.objectType;
        }
        return (Type)this.asSuper.visit(t, sym);
    }

    public Type asOuterSuper(Type t, Symbol sym) {
        switch (t.getTag()) {
            case CLASS: {
                do {
                    Type s;
                    if ((s = this.asSuper(t, sym)) == null) continue;
                    return s;
                } while ((t = t.getEnclosingType()).hasTag(TypeTag.CLASS));
                return null;
            }
            case ARRAY: {
                return this.isSubtype(t, sym.type) ? sym.type : null;
            }
            case TYPEVAR: {
                return this.asSuper(t, sym);
            }
            case ERROR: {
                return t;
            }
        }
        return null;
    }

    public Type asEnclosingSuper(Type t, Symbol sym) {
        switch (t.getTag()) {
            case CLASS: {
                Type outer;
                do {
                    Type s;
                    if ((s = this.asSuper(t, sym)) == null) continue;
                    return s;
                } while ((t = (outer = t.getEnclosingType()).hasTag(TypeTag.CLASS) ? outer : (t.tsym.owner.enclClass() != null ? t.tsym.owner.enclClass().type : Type.noType)).hasTag(TypeTag.CLASS));
                return null;
            }
            case ARRAY: {
                return this.isSubtype(t, sym.type) ? sym.type : null;
            }
            case TYPEVAR: {
                return this.asSuper(t, sym);
            }
            case ERROR: {
                return t;
            }
        }
        return null;
    }

    public Type memberType(Type t, Symbol sym) {
        return (sym.flags() & 8L) != 0L ? sym.type : (Type)this.memberType.visit(t, sym);
    }

    public boolean isAssignable(Type t, Type s) {
        return this.isAssignable(t, s, this.noWarnings);
    }

    public boolean isAssignable(Type t, Type s, Warner warn) {
        if (t.hasTag(TypeTag.ERROR)) {
            return true;
        }
        if (t.getTag().isSubRangeOf(TypeTag.INT) && t.constValue() != null) {
            int value = ((Number)t.constValue()).intValue();
            switch (s.getTag()) {
                case BYTE: {
                    if (-128 > value || value > 127) break;
                    return true;
                }
                case CHAR: {
                    if (0 > value || value > 65535) break;
                    return true;
                }
                case SHORT: {
                    if (Short.MIN_VALUE > value || value > Short.MAX_VALUE) break;
                    return true;
                }
                case INT: {
                    return true;
                }
                case CLASS: {
                    switch (this.unboxedType(s).getTag()) {
                        case BYTE: 
                        case CHAR: 
                        case SHORT: {
                            return this.isAssignable(t, this.unboxedType(s), warn);
                        }
                    }
                }
            }
        }
        return this.isConvertible(t, s, warn);
    }

    public Type erasure(Type t) {
        return this.eraseNotNeeded(t) ? t : this.erasure(t, false);
    }

    private boolean eraseNotNeeded(Type t) {
        return t.isPrimitive() || this.syms.stringType.tsym == t.tsym;
    }

    private Type erasure(Type t, boolean recurse) {
        if (t.isPrimitive()) {
            return t;
        }
        return (Type)this.erasure.visit(t, recurse);
    }

    public List<Type> erasure(List<Type> ts) {
        return Type.map(ts, this.erasureFun);
    }

    public Type erasureRecursive(Type t) {
        return this.erasure(t, true);
    }

    public List<Type> erasureRecursive(List<Type> ts) {
        return Type.map(ts, this.erasureRecFun);
    }

    public Type makeCompoundType(List<Type> bounds) {
        return this.makeCompoundType(bounds, ((Type)bounds.head).tsym.isInterface());
    }

    public Type makeCompoundType(List<Type> bounds, boolean allInterfaces) {
        Assert.check(bounds.nonEmpty());
        Type firstExplicitBound = (Type)bounds.head;
        if (allInterfaces) {
            bounds = bounds.prepend(this.syms.objectType);
        }
        Symbol.ClassSymbol bc = new Symbol.ClassSymbol(0x41001401L, Type.moreInfo ? this.names.fromString(bounds.toString()) : this.names.empty, null, this.syms.noSymbol);
        bc.type = new Type.IntersectionClassType(bounds, bc, allInterfaces);
        bc.erasure_field = ((Type)bounds.head).hasTag(TypeTag.TYPEVAR) ? this.syms.objectType : this.erasure(firstExplicitBound);
        bc.members_field = new Scope(bc);
        return bc.type;
    }

    public Type makeCompoundType(Type bound1, Type bound2) {
        return this.makeCompoundType(List.of(bound1, bound2));
    }

    public Type supertype(Type t) {
        return this.supertype.visit(t);
    }

    public List<Type> interfaces(Type t) {
        return this.interfaces.visit(t);
    }

    public List<Type> directSupertypes(Type t) {
        return this.directSupertypes.visit(t);
    }

    public boolean isDirectSuperInterface(Symbol.TypeSymbol isym, Symbol.TypeSymbol origin) {
        for (Type i2 : this.interfaces(origin.type)) {
            if (isym != i2.tsym) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedRaw(Type t) {
        Boolean result = this.isDerivedRawCache.get(t);
        if (result == null) {
            result = this.isDerivedRawInternal(t);
            this.isDerivedRawCache.put(t, result);
        }
        return result;
    }

    public boolean isDerivedRawInternal(Type t) {
        if (t.isErroneous()) {
            return false;
        }
        return t.isRaw() || this.supertype(t) != Type.noType && this.isDerivedRaw(this.supertype(t)) || this.isDerivedRaw(this.interfaces(t));
    }

    public boolean isDerivedRaw(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty() && !this.isDerivedRaw((Type)l.head)) {
            l = l.tail;
        }
        return l.nonEmpty();
    }

    public void setBounds(Type.TypeVar t, List<Type> bounds) {
        this.setBounds(t, bounds, ((Type)bounds.head).tsym.isInterface());
    }

    public void setBounds(Type.TypeVar t, List<Type> bounds, boolean allInterfaces) {
        t.bound = bounds.tail.isEmpty() ? (Type)bounds.head : this.makeCompoundType(bounds, allInterfaces);
        t.rank_field = -1;
    }

    public List<Type> getBounds(Type.TypeVar t) {
        if (t.bound.hasTag(TypeTag.NONE)) {
            return List.nil();
        }
        if (t.bound.isErroneous() || !t.bound.isCompound()) {
            return List.of(t.bound);
        }
        if ((this.erasure((Type)t).tsym.flags() & 0x200L) == 0L) {
            return this.interfaces(t).prepend(this.supertype(t));
        }
        return this.interfaces(t);
    }

    public Type classBound(Type t) {
        return this.classBound.visit(t);
    }

    public boolean isSubSignature(Type t, Type s) {
        return this.isSubSignature(t, s, true);
    }

    public boolean isSubSignature(Type t, Type s, boolean strict) {
        return this.hasSameArgs(t, s, strict) || this.hasSameArgs(t, this.erasure(s), strict);
    }

    public boolean overrideEquivalent(Type t, Type s) {
        return this.hasSameArgs(t, s) || this.hasSameArgs(t, this.erasure(s)) || this.hasSameArgs(this.erasure(t), s);
    }

    public boolean overridesObjectMethod(Symbol.TypeSymbol origin, Symbol msym) {
        Scope.Entry e = this.syms.objectType.tsym.members().lookup(msym.name);
        while (e.scope != null) {
            if (msym.overrides(e.sym, origin, this, true)) {
                return true;
            }
            e = e.next();
        }
        return false;
    }

    public Symbol.MethodSymbol implementation(Symbol.MethodSymbol ms, Symbol.TypeSymbol origin, boolean checkResult, Filter<Symbol> implFilter) {
        return this.implCache.get(ms, origin, checkResult, implFilter);
    }

    public Scope.CompoundScope membersClosure(Type site, boolean skipInterface) {
        return (Scope.CompoundScope)this.membersCache.visit(site, skipInterface);
    }

    public List<Symbol.MethodSymbol> interfaceCandidates(Type site, Symbol.MethodSymbol ms) {
        MethodFilter filter = new MethodFilter(ms, site);
        List<Symbol.MethodSymbol> candidates = List.nil();
        for (Symbol s : this.membersClosure(site, false).getElements(filter)) {
            if (!site.tsym.isInterface() && !s.owner.isInterface()) {
                return List.of((Symbol.MethodSymbol)s);
            }
            if (candidates.contains(s)) continue;
            candidates = candidates.prepend((Symbol.MethodSymbol)s);
        }
        return this.prune(candidates);
    }

    public List<Symbol.MethodSymbol> prune(List<Symbol.MethodSymbol> methods) {
        ListBuffer<Symbol.MethodSymbol> methodsMin = new ListBuffer<Symbol.MethodSymbol>();
        for (Symbol.MethodSymbol m1 : methods) {
            boolean isMin_m1 = true;
            for (Symbol.MethodSymbol m2 : methods) {
                if (m1 == m2 || m2.owner == m1.owner || this.asSuper(m2.owner.type, m1.owner) == null) continue;
                isMin_m1 = false;
                break;
            }
            if (!isMin_m1) continue;
            methodsMin.append(m1);
        }
        return methodsMin.toList();
    }

    public boolean hasSameArgs(Type t, Type s) {
        return this.hasSameArgs(t, s, true);
    }

    public boolean hasSameArgs(Type t, Type s, boolean strict) {
        return this.hasSameArgs(t, s, strict ? this.hasSameArgs_strict : this.hasSameArgs_nonstrict);
    }

    private boolean hasSameArgs(Type t, Type s, TypeRelation hasSameArgs) {
        return (Boolean)hasSameArgs.visit(t, s);
    }

    public List<Type> subst(List<Type> ts, List<Type> from, List<Type> to) {
        return new Subst(from, to).subst(ts);
    }

    public Type subst(Type t, List<Type> from, List<Type> to) {
        return new Subst(from, to).subst(t);
    }

    /*
     * WARNING - void declaration
     */
    public List<Type> substBounds(List<Type> tvars, List<Type> from, List<Type> to) {
        void var7_10;
        if (tvars.isEmpty()) {
            return tvars;
        }
        ListBuffer<Type> newBoundsBuf = new ListBuffer<Type>();
        boolean changed = false;
        for (Type type : tvars) {
            Type.TypeVar tv = (Type.TypeVar)type;
            Type bound = this.subst(tv.bound, from, to);
            if (bound != tv.bound) {
                changed = true;
            }
            newBoundsBuf.append(bound);
        }
        if (!changed) {
            return tvars;
        }
        ListBuffer<Type.TypeVar> newTvars = new ListBuffer<Type.TypeVar>();
        for (Type t : tvars) {
            newTvars.append(new Type.TypeVar(t.tsym, null, this.syms.botType));
        }
        List list = newBoundsBuf.toList();
        from = tvars;
        to = newTvars.toList();
        while (!var7_10.isEmpty()) {
            var7_10.head = this.subst((Type)var7_10.head, from, to);
            List list2 = var7_10.tail;
        }
        List list3 = newBoundsBuf.toList();
        for (Type t : newTvars.toList()) {
            void var7_13;
            Type.TypeVar tv = (Type.TypeVar)t;
            tv.bound = (Type)var7_13.head;
            List list4 = var7_13.tail;
        }
        return newTvars.toList();
    }

    public Type.TypeVar substBound(Type.TypeVar t, List<Type> from, List<Type> to) {
        Type bound1 = this.subst(t.bound, from, to);
        if (bound1 == t.bound) {
            return t;
        }
        Type.TypeVar tv = new Type.TypeVar(t.tsym, null, this.syms.botType);
        tv.bound = this.subst(bound1, List.of(t), List.of(tv));
        return tv;
    }

    public boolean hasSameBounds(Type.ForAll t, Type.ForAll s) {
        List<Type> l1 = t.tvars;
        List<Type> l2 = s.tvars;
        while (l1.nonEmpty() && l2.nonEmpty() && this.isSameType(((Type)l1.head).getUpperBound(), this.subst(((Type)l2.head).getUpperBound(), s.tvars, t.tvars))) {
            l1 = l1.tail;
            l2 = l2.tail;
        }
        return l1.isEmpty() && l2.isEmpty();
    }

    public List<Type> newInstances(List<Type> tvars) {
        List<Type> tvars1;
        List<Type> l = tvars1 = Type.map(tvars, newInstanceFun);
        while (l.nonEmpty()) {
            Type.TypeVar tv = (Type.TypeVar)l.head;
            tv.bound = this.subst(tv.bound, tvars, tvars1);
            l = l.tail;
        }
        return tvars1;
    }

    public Type createMethodTypeWithParameters(Type original, List<Type> newParams) {
        return (Type)original.accept(this.methodWithParameters, newParams);
    }

    public Type createMethodTypeWithThrown(Type original, List<Type> newThrown) {
        return (Type)original.accept(this.methodWithThrown, newThrown);
    }

    public Type createMethodTypeWithReturn(Type original, Type newReturn) {
        return (Type)original.accept(this.methodWithReturn, newReturn);
    }

    public Type createErrorType(Type originalType) {
        return new Type.ErrorType(originalType, this.syms.errSymbol);
    }

    public Type createErrorType(Symbol.ClassSymbol c, Type originalType) {
        return new Type.ErrorType(c, originalType);
    }

    public Type createErrorType(Name name, Symbol.TypeSymbol container, Type originalType) {
        return new Type.ErrorType(name, container, originalType);
    }

    public int rank(Type t) {
        t = t.unannotatedType();
        switch (t.getTag()) {
            case CLASS: {
                Type.ClassType cls = (Type.ClassType)t;
                if (cls.rank_field < 0) {
                    Name fullname = cls.tsym.getQualifiedName();
                    if (fullname == this.names.java_lang_Object) {
                        cls.rank_field = 0;
                    } else {
                        int r = this.rank(this.supertype(cls));
                        List<Type> l = this.interfaces(cls);
                        while (l.nonEmpty()) {
                            if (this.rank((Type)l.head) > r) {
                                r = this.rank((Type)l.head);
                            }
                            l = l.tail;
                        }
                        cls.rank_field = r + 1;
                    }
                }
                return cls.rank_field;
            }
            case TYPEVAR: {
                Type.TypeVar tvar = (Type.TypeVar)t;
                if (tvar.rank_field < 0) {
                    int r = this.rank(this.supertype(tvar));
                    List<Type> l = this.interfaces(tvar);
                    while (l.nonEmpty()) {
                        if (this.rank((Type)l.head) > r) {
                            r = this.rank((Type)l.head);
                        }
                        l = l.tail;
                    }
                    tvar.rank_field = r + 1;
                }
                return tvar.rank_field;
            }
            case NONE: 
            case ERROR: {
                return 0;
            }
        }
        throw new AssertionError();
    }

    public String toString(Type t, Locale locale) {
        return Printer.createStandardPrinter(this.messages).visit(t, locale);
    }

    public String toString(Symbol t, Locale locale) {
        return Printer.createStandardPrinter(this.messages).visit(t, locale);
    }

    @Deprecated
    public String toString(Type t) {
        if (t.hasTag(TypeTag.FORALL)) {
            Type.ForAll forAll = (Type.ForAll)t;
            return this.typaramsString(forAll.tvars) + forAll.qtype;
        }
        return "" + t;
    }

    private String typaramsString(List<Type> tvars) {
        StringBuilder s = new StringBuilder();
        s.append('<');
        boolean first = true;
        for (Type t : tvars) {
            if (!first) {
                s.append(", ");
            }
            first = false;
            this.appendTyparamString((Type.TypeVar)t.unannotatedType(), s);
        }
        s.append('>');
        return s.toString();
    }

    private void appendTyparamString(Type.TypeVar t, StringBuilder buf) {
        buf.append(t);
        if (t.bound == null || t.bound.tsym.getQualifiedName() == this.names.java_lang_Object) {
            return;
        }
        buf.append(" extends ");
        Type bound = t.bound;
        if (!bound.isCompound()) {
            buf.append(bound);
        } else if ((this.erasure((Type)t).tsym.flags() & 0x200L) == 0L) {
            buf.append(this.supertype(t));
            for (Type intf : this.interfaces(t)) {
                buf.append('&');
                buf.append(intf);
            }
        } else {
            boolean first = true;
            for (Type intf : this.interfaces(t)) {
                if (!first) {
                    buf.append('&');
                }
                first = false;
                buf.append(intf);
            }
        }
    }

    public List<Type> closure(Type t) {
        List<Type> cl = this.closureCache.get(t);
        if (cl == null) {
            Type st = this.supertype(t);
            cl = !t.isCompound() ? (st.hasTag(TypeTag.CLASS) ? this.insert(this.closure(st), t) : (st.hasTag(TypeTag.TYPEVAR) ? this.closure(st).prepend(t) : List.of(t))) : this.closure(this.supertype(t));
            List<Type> l = this.interfaces(t);
            while (l.nonEmpty()) {
                cl = this.union(cl, this.closure((Type)l.head));
                l = l.tail;
            }
            this.closureCache.put(t, cl);
        }
        return cl;
    }

    public List<Type> insert(List<Type> cl, Type t) {
        if (cl.isEmpty()) {
            return cl.prepend(t);
        }
        if (t.tsym == ((Type)cl.head).tsym) {
            return cl;
        }
        if (t.tsym.precedes(((Type)cl.head).tsym, this)) {
            return cl.prepend(t);
        }
        return this.insert(cl.tail, t).prepend((Type)cl.head);
    }

    public List<Type> union(List<Type> cl1, List<Type> cl2) {
        if (cl1.isEmpty()) {
            return cl2;
        }
        if (cl2.isEmpty()) {
            return cl1;
        }
        if (((Type)cl1.head).tsym == ((Type)cl2.head).tsym) {
            return this.union(cl1.tail, cl2.tail).prepend((Type)cl1.head);
        }
        if (((Type)cl1.head).tsym.precedes(((Type)cl2.head).tsym, this)) {
            return this.union(cl1.tail, cl2).prepend((Type)cl1.head);
        }
        if (((Type)cl2.head).tsym.precedes(((Type)cl1.head).tsym, this)) {
            return this.union(cl1, cl2.tail).prepend((Type)cl2.head);
        }
        return this.union(cl1.tail, cl2).prepend((Type)cl1.head);
    }

    public List<Type> intersect(List<Type> cl1, List<Type> cl2) {
        if (cl1 == cl2) {
            return cl1;
        }
        if (cl1.isEmpty() || cl2.isEmpty()) {
            return List.nil();
        }
        if (((Type)cl1.head).tsym.precedes(((Type)cl2.head).tsym, this)) {
            return this.intersect(cl1.tail, cl2);
        }
        if (((Type)cl2.head).tsym.precedes(((Type)cl1.head).tsym, this)) {
            return this.intersect(cl1, cl2.tail);
        }
        if (this.isSameType((Type)cl1.head, (Type)cl2.head)) {
            return this.intersect(cl1.tail, cl2.tail).prepend((Type)cl1.head);
        }
        if (((Type)cl1.head).tsym == ((Type)cl2.head).tsym && ((Type)cl1.head).hasTag(TypeTag.CLASS) && ((Type)cl2.head).hasTag(TypeTag.CLASS)) {
            if (((Type)cl1.head).isParameterized() && ((Type)cl2.head).isParameterized()) {
                Type merge = this.merge((Type)cl1.head, (Type)cl2.head);
                return this.intersect(cl1.tail, cl2.tail).prepend(merge);
            }
            if (((Type)cl1.head).isRaw() || ((Type)cl2.head).isRaw()) {
                return this.intersect(cl1.tail, cl2.tail).prepend(this.erasure((Type)cl1.head));
            }
        }
        return this.intersect(cl1.tail, cl2.tail);
    }

    private Type merge(Type c1, Type c2) {
        Type.ClassType class1 = (Type.ClassType)c1;
        List act1 = class1.getTypeArguments();
        Type.ClassType class2 = (Type.ClassType)c2;
        List act2 = class2.getTypeArguments();
        ListBuffer merged = new ListBuffer();
        List<Type> typarams = class1.tsym.type.getTypeArguments();
        while (act1.nonEmpty() && act2.nonEmpty() && typarams.nonEmpty()) {
            if (this.containsType((Type)act1.head, (Type)act2.head)) {
                merged.append(act1.head);
            } else if (this.containsType((Type)act2.head, (Type)act1.head)) {
                merged.append(act2.head);
            } else {
                Type.WildcardType m;
                TypePair pair = new TypePair(c1, c2);
                if (this.mergeCache.add(pair)) {
                    m = new Type.WildcardType(this.lub(this.wildUpperBound((Type)act1.head), this.wildUpperBound((Type)act2.head)), BoundKind.EXTENDS, this.syms.boundClass);
                    this.mergeCache.remove(pair);
                } else {
                    m = new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
                }
                merged.append(((Type)m).withTypeVar((Type)typarams.head));
            }
            act1 = act1.tail;
            act2 = act2.tail;
            typarams = typarams.tail;
        }
        Assert.check(act1.isEmpty() && act2.isEmpty() && typarams.isEmpty());
        return new Type.ClassType(class1.getEnclosingType(), merged.toList(), class1.tsym);
    }

    private Type compoundMin(List<Type> cl) {
        if (cl.isEmpty()) {
            return this.syms.objectType;
        }
        List<Type> compound = this.closureMin(cl);
        if (compound.isEmpty()) {
            return null;
        }
        if (compound.tail.isEmpty()) {
            return (Type)compound.head;
        }
        return this.makeCompoundType(compound);
    }

    private List<Type> closureMin(List<Type> cl) {
        ListBuffer<Type> classes = new ListBuffer<Type>();
        ListBuffer<Type> interfaces = new ListBuffer<Type>();
        HashSet<Type> toSkip = new HashSet<Type>();
        while (!cl.isEmpty()) {
            boolean keep;
            Type current = (Type)cl.head;
            boolean bl = keep = !toSkip.contains(current);
            if (keep && current.hasTag(TypeTag.TYPEVAR)) {
                for (Type t : cl.tail) {
                    if (!this.isSubtypeNoCapture(t, current)) continue;
                    keep = false;
                    break;
                }
            }
            if (keep) {
                if (current.isInterface()) {
                    interfaces.append(current);
                } else {
                    classes.append(current);
                }
                for (Type t : cl.tail) {
                    if (!this.isSubtypeNoCapture(current, t)) continue;
                    toSkip.add(t);
                }
            }
            cl = cl.tail;
        }
        return classes.appendList(interfaces).toList();
    }

    public Type lub(Type t1, Type t2) {
        return this.lub(List.of(t1, t2));
    }

    /*
     * WARNING - void declaration
     */
    public Type lub(List<Type> ts) {
        boolean ARRAY_BOUND = true;
        int CLASS_BOUND = 2;
        int boundkind = 0;
        block10: for (Type type : ts) {
            switch (type.getTag()) {
                case CLASS: {
                    boundkind |= 2;
                    continue block10;
                }
                case ARRAY: {
                    boundkind |= 1;
                    continue block10;
                }
                case TYPEVAR: {
                    void var6_6;
                    Type type2;
                    while ((type2 = var6_6.getUpperBound()).hasTag(TypeTag.TYPEVAR)) {
                    }
                    if (type2.hasTag(TypeTag.ARRAY)) {
                        boundkind |= 1;
                        continue block10;
                    }
                    boundkind |= 2;
                    continue block10;
                }
            }
            if (!type.isPrimitive()) continue;
            return this.syms.errType;
        }
        switch (boundkind) {
            case 0: {
                return this.syms.botType;
            }
            case 1: {
                List<Type> elements = Type.map(ts, this.elemTypeFun);
                for (Type t : elements) {
                    if (!t.isPrimitive()) continue;
                    Type first = (Type)ts.head;
                    for (Type s : ts.tail) {
                        if (this.isSameType(first, s)) continue;
                        return this.arraySuperType();
                    }
                    return first;
                }
                return new Type.ArrayType(this.lub(elements), this.syms.arrayClass);
            }
            case 2: {
                void var6_11;
                while (!((Type)ts.head).hasTag(TypeTag.CLASS) && !((Type)ts.head).hasTag(TypeTag.TYPEVAR)) {
                    ts = ts.tail;
                }
                Assert.check(!ts.isEmpty());
                List<Type> list = this.erasedSupertypes((Type)ts.head);
                for (Type t : ts.tail) {
                    if (!t.hasTag(TypeTag.CLASS) && !t.hasTag(TypeTag.TYPEVAR)) continue;
                    List<Type> list2 = this.intersect((List<Type>)var6_11, this.erasedSupertypes(t));
                }
                List<Type> mec = this.closureMin((List<Type>)var6_11);
                List<Type> candidates = List.nil();
                for (Type erasedSupertype : mec) {
                    List<Type> lci = List.of(this.asSuper((Type)ts.head, erasedSupertype.tsym));
                    for (Type t : ts) {
                        lci = this.intersect(lci, List.of(this.asSuper(t, erasedSupertype.tsym)));
                    }
                    candidates = candidates.appendList(lci);
                }
                return this.compoundMin(candidates);
            }
        }
        List<Type> classes = List.of(this.arraySuperType());
        for (Type t : ts) {
            if (t.hasTag(TypeTag.ARRAY)) continue;
            classes = classes.prepend(t);
        }
        return this.lub(classes);
    }

    List<Type> erasedSupertypes(Type t) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type sup : this.closure(t)) {
            if (sup.hasTag(TypeTag.TYPEVAR)) {
                buf.append(sup);
                continue;
            }
            buf.append(this.erasure(sup));
        }
        return buf.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type arraySuperType() {
        if (this.arraySuperType == null) {
            Types types = this;
            synchronized (types) {
                if (this.arraySuperType == null) {
                    this.arraySuperType = this.makeCompoundType(List.of(this.syms.serializableType, this.syms.cloneableType), true);
                }
            }
        }
        return this.arraySuperType;
    }

    public Type glb(List<Type> ts) {
        Type t1 = (Type)ts.head;
        for (Type t2 : ts.tail) {
            if (t1.isErroneous()) {
                return t1;
            }
            t1 = this.glb(t1, t2);
        }
        return t1;
    }

    public Type glb(Type t, Type s) {
        if (s == null) {
            return t;
        }
        if (t.isPrimitive() || s.isPrimitive()) {
            return this.syms.errType;
        }
        if (this.isSubtypeNoCapture(t, s)) {
            return t;
        }
        if (this.isSubtypeNoCapture(s, t)) {
            return s;
        }
        List<Type> closure = this.union(this.closure(t), this.closure(s));
        return this.glbFlattened(closure, t);
    }

    private Type glbFlattened(List<Type> flatBounds, Type errT) {
        List<Type> bounds = this.closureMin(flatBounds);
        if (bounds.isEmpty()) {
            return this.syms.objectType;
        }
        if (bounds.tail.isEmpty()) {
            return (Type)bounds.head;
        }
        int classCount = 0;
        List<Type> lowers = List.nil();
        for (Type bound : bounds) {
            if (bound.isInterface()) continue;
            ++classCount;
            Type lower = this.cvarLowerBound(bound);
            if (bound == lower || lower.hasTag(TypeTag.BOT)) continue;
            lowers = this.insert(lowers, lower);
        }
        if (classCount > 1) {
            if (lowers.isEmpty()) {
                return this.createErrorType(errT);
            }
            return this.glbFlattened(this.union(bounds, lowers), errT);
        }
        return this.makeCompoundType(bounds);
    }

    public int hashCode(Type t) {
        return hashCode.visit(t);
    }

    public boolean resultSubtype(Type t, Type s, Warner warner) {
        List<Type> tvars = t.getTypeArguments();
        List<Type> svars = s.getTypeArguments();
        Type tres = t.getReturnType();
        Type sres = this.subst(s.getReturnType(), svars, tvars);
        return this.covariantReturnType(tres, sres, warner);
    }

    public boolean returnTypeSubstitutable(Type r1, Type r2) {
        if (this.hasSameArgs(r1, r2)) {
            return this.resultSubtype(r1, r2, this.noWarnings);
        }
        return this.covariantReturnType(r1.getReturnType(), this.erasure(r2.getReturnType()), this.noWarnings);
    }

    public boolean returnTypeSubstitutable(Type r1, Type r2, Type r2res, Warner warner) {
        if (this.isSameType(r1.getReturnType(), r2res)) {
            return true;
        }
        if (r1.getReturnType().isPrimitive() || r2res.isPrimitive()) {
            return false;
        }
        if (this.hasSameArgs(r1, r2)) {
            return this.covariantReturnType(r1.getReturnType(), r2res, warner);
        }
        if (!this.allowCovariantReturns) {
            return false;
        }
        if (this.isSubtypeUnchecked(r1.getReturnType(), r2res, warner)) {
            return true;
        }
        if (!this.isSubtype(r1.getReturnType(), this.erasure(r2res))) {
            return false;
        }
        warner.warn(Lint.LintCategory.UNCHECKED);
        return true;
    }

    public boolean covariantReturnType(Type t, Type s, Warner warner) {
        return this.isSameType(t, s) || this.allowCovariantReturns && !t.isPrimitive() && !s.isPrimitive() && this.isAssignable(t, s, warner);
    }

    public Symbol.ClassSymbol boxedClass(Type t) {
        return this.reader.enterClass(this.syms.boxedName[t.getTag().ordinal()]);
    }

    public Type boxedTypeOrType(Type t) {
        return t.isPrimitive() ? this.boxedClass((Type)t).type : t;
    }

    public Type unboxedType(Type t) {
        if (this.allowBoxing) {
            for (int i = 0; i < this.syms.boxedName.length; ++i) {
                Name box = this.syms.boxedName[i];
                if (box == null || this.asSuper(t, this.reader.enterClass(box)) == null) continue;
                return this.syms.typeOfTag[i];
            }
        }
        return Type.noType;
    }

    public Type unboxedTypeOrType(Type t) {
        Type unboxedType = this.unboxedType(t);
        return unboxedType.hasTag(TypeTag.NONE) ? t : unboxedType;
    }

    public List<Type> capture(List<Type> ts) {
        List<Type> buf = List.nil();
        for (Type t : ts) {
            buf = buf.prepend(this.capture(t));
        }
        return buf.reverse();
    }

    public Type capture(Type t) {
        Type.ClassType cls;
        Type capturedEncl;
        if (!t.hasTag(TypeTag.CLASS)) {
            return t;
        }
        if (t.getEnclosingType() != Type.noType && (capturedEncl = this.capture(t.getEnclosingType())) != t.getEnclosingType()) {
            Type type1 = this.memberType(capturedEncl, t.tsym);
            t = this.subst(type1, t.tsym.type.getTypeArguments(), t.getTypeArguments());
        }
        if ((cls = (Type.ClassType)(t = t.unannotatedType())).isRaw() || !cls.isParameterized()) {
            return cls;
        }
        Type.ClassType G = (Type.ClassType)((Symbol.TypeSymbol)cls.asElement()).asType();
        List<Type> A = G.getTypeArguments();
        List T = cls.getTypeArguments();
        List<Type> S = this.freshTypeVariables(T);
        List<Type> currentA = A;
        List currentT = T;
        List<Type> currentS = S;
        boolean captured = false;
        while (!(currentA.isEmpty() || currentT.isEmpty() || currentS.isEmpty())) {
            if (currentS.head != currentT.head) {
                Type tmpLower;
                captured = true;
                Type.WildcardType Ti = (Type.WildcardType)((Type)currentT.head).unannotatedType();
                Type Ui = ((Type)currentA.head).getUpperBound();
                Type.CapturedType Si = (Type.CapturedType)((Type)currentS.head).unannotatedType();
                if (Ui == null) {
                    Ui = this.syms.objectType;
                }
                switch (Ti.kind) {
                    case UNBOUND: {
                        Si.bound = this.subst(Ui, A, S);
                        Si.lower = this.syms.botType;
                        break;
                    }
                    case EXTENDS: {
                        Si.bound = this.glb(Ti.getExtendsBound(), this.subst(Ui, A, S));
                        Si.lower = this.syms.botType;
                        break;
                    }
                    case SUPER: {
                        Si.bound = this.subst(Ui, A, S);
                        Si.lower = Ti.getSuperBound();
                    }
                }
                Type tmpBound = Si.bound.hasTag(TypeTag.UNDETVAR) ? ((Type.UndetVar)Si.bound).qtype : Si.bound;
                Type type = tmpLower = Si.lower.hasTag(TypeTag.UNDETVAR) ? ((Type.UndetVar)Si.lower).qtype : Si.lower;
                if (!Si.bound.hasTag(TypeTag.ERROR) && !Si.lower.hasTag(TypeTag.ERROR) && this.isSameType(tmpBound, tmpLower, false)) {
                    currentS.head = Si.bound;
                }
            }
            currentA = currentA.tail;
            currentT = currentT.tail;
            currentS = currentS.tail;
        }
        if (!(currentA.isEmpty() && currentT.isEmpty() && currentS.isEmpty())) {
            return this.erasure(t);
        }
        if (captured) {
            return new Type.ClassType(cls.getEnclosingType(), S, cls.tsym);
        }
        return t;
    }

    public List<Type> freshTypeVariables(List<Type> types) {
        ListBuffer<Type> result = new ListBuffer<Type>();
        for (Type t : types) {
            if (t.hasTag(TypeTag.WILDCARD)) {
                Type bound = ((Type.WildcardType)(t = t.unannotatedType())).getExtendsBound();
                if (bound == null) {
                    bound = this.syms.objectType;
                }
                result.append(new Type.CapturedType(this.capturedName, this.syms.noSymbol, bound, this.syms.botType, (Type.WildcardType)t));
                continue;
            }
            result.append(t);
        }
        return result.toList();
    }

    private boolean sideCast(Type from, Type to, Warner warn) {
        boolean reverse = false;
        Type target = to;
        if ((to.tsym.flags() & 0x200L) == 0L) {
            Assert.check((from.tsym.flags() & 0x200L) != 0L);
            reverse = true;
            to = from;
            from = target;
        }
        List<Type> commonSupers = this.superClosure(to, this.erasure(from));
        boolean giveWarning = commonSupers.isEmpty();
        while (commonSupers.nonEmpty()) {
            Type t1 = this.asSuper(from, ((Type)commonSupers.head).tsym);
            Type t2 = (Type)commonSupers.head;
            if (this.disjointTypes(t1.getTypeArguments(), t2.getTypeArguments())) {
                return false;
            }
            giveWarning = giveWarning || (reverse ? this.giveWarning(t2, t1) : this.giveWarning(t1, t2));
            commonSupers = commonSupers.tail;
        }
        if (giveWarning && !this.isReifiable(reverse ? from : to)) {
            warn.warn(Lint.LintCategory.UNCHECKED);
        }
        if (!this.allowCovariantReturns) {
            this.chk.checkCompatibleAbstracts(warn.pos(), from, to);
        }
        return true;
    }

    private boolean sideCastFinal(Type from, Type to, Warner warn) {
        boolean reverse = false;
        Type target = to;
        if ((to.tsym.flags() & 0x200L) == 0L) {
            Assert.check((from.tsym.flags() & 0x200L) != 0L);
            reverse = true;
            to = from;
            from = target;
        }
        Assert.check((from.tsym.flags() & 0x10L) != 0L);
        Type t1 = this.asSuper(from, to.tsym);
        if (t1 == null) {
            return false;
        }
        Type t2 = to;
        if (this.disjointTypes(t1.getTypeArguments(), t2.getTypeArguments())) {
            return false;
        }
        if (!this.allowCovariantReturns) {
            this.chk.checkCompatibleAbstracts(warn.pos(), from, to);
        }
        if (!this.isReifiable(target) && (reverse ? this.giveWarning(t2, t1) : this.giveWarning(t1, t2))) {
            warn.warn(Lint.LintCategory.UNCHECKED);
        }
        return true;
    }

    private boolean giveWarning(Type from, Type to) {
        List<Type> bounds = to.isCompound() ? ((Type.IntersectionClassType)to.unannotatedType()).getComponents() : List.of(to);
        for (Type b : bounds) {
            Type subFrom = this.asSub(from, b.tsym);
            if (!b.isParameterized() || this.isUnbounded(b) || this.isSubtype(from, b) || subFrom != null && this.containsType(b.allparams(), subFrom.allparams())) continue;
            return true;
        }
        return false;
    }

    private List<Type> superClosure(Type t, Type s) {
        List<Type> cl = List.nil();
        List<Type> l = this.interfaces(t);
        while (l.nonEmpty()) {
            cl = this.isSubtype(s, this.erasure((Type)l.head)) ? this.insert(cl, (Type)l.head) : this.union(cl, this.superClosure((Type)l.head, s));
            l = l.tail;
        }
        return cl;
    }

    private boolean containsTypeEquivalent(Type t, Type s) {
        return this.isSameType(t, s) || this.containsType(t, s) && this.containsType(s, t);
    }

    public void adapt(Type source, Type target, ListBuffer<Type> from, ListBuffer<Type> to) throws AdaptFailure {
        new Adapter(from, to).adapt(source, target);
    }

    private void adaptSelf(Type t, ListBuffer<Type> from, ListBuffer<Type> to) {
        try {
            this.adapt(t.tsym.type, t, from, to);
        }
        catch (AdaptFailure ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private Type rewriteQuantifiers(Type t, boolean high, boolean rewriteTypeVars) {
        return (Type)new Rewriter(high, rewriteTypeVars).visit(t);
    }

    private Type.WildcardType makeExtendsWildcard(Type bound, Type.TypeVar formal) {
        if (bound == this.syms.objectType) {
            return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass, formal);
        }
        return new Type.WildcardType(bound, BoundKind.EXTENDS, this.syms.boundClass, formal);
    }

    private Type.WildcardType makeSuperWildcard(Type bound, Type.TypeVar formal) {
        if (bound.hasTag(TypeTag.BOT)) {
            return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass, formal);
        }
        return new Type.WildcardType(bound, BoundKind.SUPER, this.syms.boundClass, formal);
    }

    public Attribute.RetentionPolicy getRetention(Attribute.Compound a) {
        return this.getRetention(a.type.tsym);
    }

    public Attribute.RetentionPolicy getRetention(Symbol sym) {
        Attribute value;
        Attribute.RetentionPolicy vis = Attribute.RetentionPolicy.CLASS;
        Attribute.Compound c = sym.attribute(this.syms.retentionType.tsym);
        if (c != null && (value = c.member(this.names.value)) != null && value instanceof Attribute.Enum) {
            Name levelName = ((Attribute.Enum)value).value.name;
            if (levelName == this.names.SOURCE) {
                vis = Attribute.RetentionPolicy.SOURCE;
            } else if (levelName == this.names.CLASS) {
                vis = Attribute.RetentionPolicy.CLASS;
            } else if (levelName == this.names.RUNTIME) {
                vis = Attribute.RetentionPolicy.RUNTIME;
            }
        }
        return vis;
    }

    public static abstract class SignatureGenerator {
        private final Types types;

        protected abstract void append(char var1);

        protected abstract void append(byte[] var1);

        protected abstract void append(Name var1);

        protected void classReference(Symbol.ClassSymbol c) {
        }

        protected SignatureGenerator(Types types) {
            this.types = types;
        }

        public void assembleSig(Type type) {
            type = type.unannotatedType();
            block0 : switch (type.getTag()) {
                case BYTE: {
                    this.append('B');
                    break;
                }
                case SHORT: {
                    this.append('S');
                    break;
                }
                case CHAR: {
                    this.append('C');
                    break;
                }
                case INT: {
                    this.append('I');
                    break;
                }
                case LONG: {
                    this.append('J');
                    break;
                }
                case FLOAT: {
                    this.append('F');
                    break;
                }
                case DOUBLE: {
                    this.append('D');
                    break;
                }
                case BOOLEAN: {
                    this.append('Z');
                    break;
                }
                case VOID: {
                    this.append('V');
                    break;
                }
                case CLASS: {
                    this.append('L');
                    this.assembleClassSig(type);
                    this.append(';');
                    break;
                }
                case ARRAY: {
                    Type.ArrayType at = (Type.ArrayType)type;
                    this.append('[');
                    this.assembleSig(at.elemtype);
                    break;
                }
                case METHOD: {
                    Type.MethodType mt = (Type.MethodType)type;
                    this.append('(');
                    this.assembleSig(mt.argtypes);
                    this.append(')');
                    this.assembleSig(mt.restype);
                    if (!this.hasTypeVar(mt.thrown)) break;
                    List<Type> l = mt.thrown;
                    while (l.nonEmpty()) {
                        this.append('^');
                        this.assembleSig((Type)l.head);
                        l = l.tail;
                    }
                    break;
                }
                case WILDCARD: {
                    Type.WildcardType ta = (Type.WildcardType)type;
                    switch (ta.kind) {
                        case SUPER: {
                            this.append('-');
                            this.assembleSig(ta.type);
                            break block0;
                        }
                        case EXTENDS: {
                            this.append('+');
                            this.assembleSig(ta.type);
                            break block0;
                        }
                        case UNBOUND: {
                            this.append('*');
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)ta.kind);
                }
                case TYPEVAR: {
                    this.append('T');
                    this.append(type.tsym.name);
                    this.append(';');
                    break;
                }
                case FORALL: {
                    Type.ForAll ft = (Type.ForAll)type;
                    this.assembleParamsSig(ft.tvars);
                    this.assembleSig(ft.qtype);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("typeSig " + (Object)((Object)type.getTag())));
                }
            }
        }

        public boolean hasTypeVar(List<Type> l) {
            while (l.nonEmpty()) {
                if (((Type)l.head).hasTag(TypeTag.TYPEVAR)) {
                    return true;
                }
                l = l.tail;
            }
            return false;
        }

        public void assembleClassSig(Type type) {
            type = type.unannotatedType();
            Type.ClassType ct = (Type.ClassType)type;
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)ct.tsym;
            this.classReference(c);
            Type outer = ct.getEnclosingType();
            if (outer.allparams().nonEmpty()) {
                boolean rawOuter = c.owner.kind == 16 || c.name == this.types.names.empty;
                this.assembleClassSig(rawOuter ? this.types.erasure(outer) : outer);
                this.append(rawOuter ? (char)'$' : '.');
                Assert.check(c.flatname.startsWith(c.owner.enclClass().flatname));
                this.append(rawOuter ? c.flatname.subName(c.owner.enclClass().flatname.getByteLength() + 1, c.flatname.getByteLength()) : c.name);
            } else {
                this.append(ClassFile.externalize(c.flatname));
            }
            if (((List)ct.getTypeArguments()).nonEmpty()) {
                this.append('<');
                this.assembleSig((List<Type>)ct.getTypeArguments());
                this.append('>');
            }
        }

        public void assembleParamsSig(List<Type> typarams) {
            this.append('<');
            List<Type> ts = typarams;
            while (ts.nonEmpty()) {
                Type.TypeVar tvar = (Type.TypeVar)ts.head;
                this.append(tvar.tsym.name);
                List<Type> bounds = this.types.getBounds(tvar);
                if ((((Type)bounds.head).tsym.flags() & 0x200L) != 0L) {
                    this.append(':');
                }
                List<Type> l = bounds;
                while (l.nonEmpty()) {
                    this.append(':');
                    this.assembleSig((Type)l.head);
                    l = l.tail;
                }
                ts = ts.tail;
            }
            this.append('>');
        }

        private void assembleSig(List<Type> types) {
            List<Type> ts = types;
            while (ts.nonEmpty()) {
                this.assembleSig((Type)ts.head);
                ts = ts.tail;
            }
        }
    }

    public static class MapVisitor<S>
    extends DefaultTypeVisitor<Type, S> {
        public final Type visit(Type t) {
            return (Type)t.accept(this, null);
        }

        @Override
        public Type visitType(Type t, S s) {
            return t;
        }
    }

    public static abstract class UnaryVisitor<R>
    extends SimpleVisitor<R, Void> {
        public final R visit(Type t) {
            return t.accept(this, null);
        }
    }

    public static abstract class TypeRelation
    extends SimpleVisitor<Boolean, Type> {
    }

    public static abstract class SimpleVisitor<R, S>
    extends DefaultTypeVisitor<R, S> {
        @Override
        public R visitCapturedType(Type.CapturedType t, S s) {
            return this.visitTypeVar(t, s);
        }

        @Override
        public R visitForAll(Type.ForAll t, S s) {
            return this.visit(t.qtype, s);
        }

        @Override
        public R visitUndetVar(Type.UndetVar t, S s) {
            return this.visit(t.qtype, s);
        }
    }

    public static abstract class DefaultSymbolVisitor<R, S>
    implements Symbol.Visitor<R, S> {
        public final R visit(Symbol s, S arg) {
            return s.accept(this, arg);
        }

        @Override
        public R visitClassSymbol(Symbol.ClassSymbol s, S arg) {
            return this.visitSymbol(s, arg);
        }

        @Override
        public R visitMethodSymbol(Symbol.MethodSymbol s, S arg) {
            return this.visitSymbol(s, arg);
        }

        @Override
        public R visitOperatorSymbol(Symbol.OperatorSymbol s, S arg) {
            return this.visitSymbol(s, arg);
        }

        @Override
        public R visitPackageSymbol(Symbol.PackageSymbol s, S arg) {
            return this.visitSymbol(s, arg);
        }

        @Override
        public R visitTypeSymbol(Symbol.TypeSymbol s, S arg) {
            return this.visitSymbol(s, arg);
        }

        @Override
        public R visitVarSymbol(Symbol.VarSymbol s, S arg) {
            return this.visitSymbol(s, arg);
        }
    }

    public static abstract class DefaultTypeVisitor<R, S>
    implements Type.Visitor<R, S> {
        public final R visit(Type t, S s) {
            return t.accept(this, s);
        }

        @Override
        public R visitClassType(Type.ClassType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitWildcardType(Type.WildcardType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitArrayType(Type.ArrayType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitMethodType(Type.MethodType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitPackageType(Type.PackageType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitTypeVar(Type.TypeVar t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitCapturedType(Type.CapturedType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitForAll(Type.ForAll t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitUndetVar(Type.UndetVar t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitErrorType(Type.ErrorType t, S s) {
            return this.visitType(t, s);
        }

        @Override
        public R visitAnnotatedType(Type.AnnotatedType t, S s) {
            return this.visit(t.unannotatedType(), s);
        }
    }

    public static class UniqueType {
        public final Type type;
        final Types types;

        public UniqueType(Type type, Types types) {
            this.type = type;
            this.types = types;
        }

        public int hashCode() {
            return this.types.hashCode(this.type);
        }

        public boolean equals(Object obj) {
            return obj instanceof UniqueType && this.types.isSameAnnotatedType(this.type, ((UniqueType)obj).type);
        }

        public String toString() {
            return this.type.toString();
        }
    }

    class Rewriter
    extends UnaryVisitor<Type> {
        boolean high;
        boolean rewriteTypeVars;

        Rewriter(boolean high, boolean rewriteTypeVars) {
            this.high = high;
            this.rewriteTypeVars = rewriteTypeVars;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void s) {
            ListBuffer<Type> rewritten = new ListBuffer<Type>();
            boolean changed = false;
            for (Type arg : t.allparams()) {
                Type bound;
                if (arg != (bound = (Type)this.visit(arg))) {
                    changed = true;
                }
                rewritten.append(bound);
            }
            if (changed) {
                return Types.this.subst(t.tsym.type, t.tsym.type.allparams(), rewritten.toList());
            }
            return t;
        }

        @Override
        public Type visitType(Type t, Void s) {
            return t;
        }

        @Override
        public Type visitCapturedType(Type.CapturedType t, Void s) {
            Type w_bound = t.wildcard.type;
            Type bound = w_bound.contains(t) ? Types.this.erasure(w_bound) : (Type)this.visit(w_bound);
            return this.rewriteAsWildcardType((Type)this.visit(bound), t.wildcard.bound, t.wildcard.kind);
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void s) {
            if (this.rewriteTypeVars) {
                Type bound = t.bound.contains(t) ? Types.this.erasure(t.bound) : (Type)this.visit(t.bound);
                return this.rewriteAsWildcardType(bound, t, BoundKind.EXTENDS);
            }
            return t;
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void s) {
            Type bound2 = (Type)this.visit(t.type);
            return t.type == bound2 ? t : this.rewriteAsWildcardType(bound2, t.bound, t.kind);
        }

        private Type rewriteAsWildcardType(Type bound, Type.TypeVar formal, BoundKind bk) {
            switch (bk) {
                case EXTENDS: {
                    return this.high ? Types.this.makeExtendsWildcard(this.B(bound), formal) : Types.this.makeExtendsWildcard(Types.this.syms.objectType, formal);
                }
                case SUPER: {
                    return this.high ? Types.this.makeSuperWildcard(Types.this.syms.botType, formal) : Types.this.makeSuperWildcard(this.B(bound), formal);
                }
                case UNBOUND: {
                    return Types.this.makeExtendsWildcard(Types.this.syms.objectType, formal);
                }
            }
            Assert.error("Invalid bound kind " + (Object)((Object)bk));
            return null;
        }

        Type B(Type t) {
            while (t.hasTag(TypeTag.WILDCARD)) {
                Type.WildcardType w = (Type.WildcardType)t.unannotatedType();
                t = this.high ? w.getExtendsBound() : w.getSuperBound();
                if (t != null) continue;
                t = this.high ? Types.this.syms.objectType : Types.this.syms.botType;
            }
            return t;
        }
    }

    public static class AdaptFailure
    extends RuntimeException {
        static final long serialVersionUID = -7490231548272701566L;
    }

    class Adapter
    extends SimpleVisitor<Void, Type> {
        ListBuffer<Type> from;
        ListBuffer<Type> to;
        Map<Symbol, Type> mapping;
        private Set<TypePair> cache = new HashSet<TypePair>();

        Adapter(ListBuffer<Type> from, ListBuffer<Type> to) {
            this.from = from;
            this.to = to;
            this.mapping = new HashMap<Symbol, Type>();
        }

        public void adapt(Type source, Type target) throws AdaptFailure {
            this.visit(source, target);
            List<Type> fromList = this.from.toList();
            List<Type> toList = this.to.toList();
            while (!fromList.isEmpty()) {
                Type val = this.mapping.get(((Type)fromList.head).tsym);
                if (toList.head != val) {
                    toList.head = val;
                }
                fromList = fromList.tail;
                toList = toList.tail;
            }
        }

        @Override
        public Void visitClassType(Type.ClassType source, Type target) throws AdaptFailure {
            if (target.hasTag(TypeTag.CLASS)) {
                this.adaptRecursive(source.allparams(), target.allparams());
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType source, Type target) throws AdaptFailure {
            if (target.hasTag(TypeTag.ARRAY)) {
                this.adaptRecursive(Types.this.elemtype(source), Types.this.elemtype(target));
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType source, Type target) throws AdaptFailure {
            if (source.isExtendsBound()) {
                this.adaptRecursive(Types.this.wildUpperBound(source), Types.this.wildUpperBound(target));
            } else if (source.isSuperBound()) {
                this.adaptRecursive(Types.this.wildLowerBound(source), Types.this.wildLowerBound(target));
            }
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar source, Type target) throws AdaptFailure {
            Type val = this.mapping.get(source.tsym);
            if (val != null) {
                if (val.isSuperBound() && target.isSuperBound()) {
                    val = Types.this.isSubtype(Types.this.wildLowerBound(val), Types.this.wildLowerBound(target)) ? target : val;
                } else if (val.isExtendsBound() && target.isExtendsBound()) {
                    val = Types.this.isSubtype(Types.this.wildUpperBound(val), Types.this.wildUpperBound(target)) ? val : target;
                } else if (!Types.this.isSameType(val, target)) {
                    throw new AdaptFailure();
                }
            } else {
                val = target;
                this.from.append(source);
                this.to.append(target);
            }
            this.mapping.put(source.tsym, val);
            return null;
        }

        @Override
        public Void visitType(Type source, Type target) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adaptRecursive(Type source, Type target) {
            TypePair pair = new TypePair(source, target);
            if (this.cache.add(pair)) {
                try {
                    this.visit(source, target);
                }
                finally {
                    this.cache.remove(pair);
                }
            }
        }

        private void adaptRecursive(List<Type> source, List<Type> target) {
            if (source.length() == target.length()) {
                while (source.nonEmpty()) {
                    this.adaptRecursive((Type)source.head, (Type)target.head);
                    source = source.tail;
                    target = target.tail;
                }
            }
        }
    }

    class TypePair {
        final Type t1;
        final Type t2;
        boolean strict;

        TypePair(Type t1, Type t2) {
            this(t1, t2, false);
        }

        TypePair(Type t1, Type t2, boolean strict) {
            this.t1 = t1;
            this.t2 = t2;
            this.strict = strict;
        }

        public int hashCode() {
            return 127 * Types.this.hashCode(this.t1) + Types.this.hashCode(this.t2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair typePair = (TypePair)obj;
            return Types.this.isSameType(this.t1, typePair.t1, this.strict) && Types.this.isSameType(this.t2, typePair.t2, this.strict);
        }
    }

    private class Subst
    extends UnaryVisitor<Type> {
        List<Type> from;
        List<Type> to;

        public Subst(List<Type> from, List<Type> to) {
            int fromLength;
            int toLength = to.length();
            for (fromLength = from.length(); fromLength > toLength; --fromLength) {
                from = from.tail;
            }
            while (fromLength < toLength) {
                --toLength;
                to = to.tail;
            }
            this.from = from;
            this.to = to;
        }

        Type subst(Type t) {
            if (this.from.tail == null) {
                return t;
            }
            return (Type)this.visit(t);
        }

        List<Type> subst(List<Type> ts) {
            if (this.from.tail == null) {
                return ts;
            }
            boolean wild = false;
            if (ts.nonEmpty() && this.from.nonEmpty()) {
                Type head1 = this.subst((Type)ts.head);
                List<Type> tail1 = this.subst(ts.tail);
                if (head1 != ts.head || tail1 != ts.tail) {
                    return tail1.prepend(head1);
                }
            }
            return ts;
        }

        @Override
        public Type visitType(Type t, Void ignored) {
            return t;
        }

        @Override
        public Type visitMethodType(Type.MethodType t, Void ignored) {
            List<Type> argtypes = this.subst(t.argtypes);
            Type restype = this.subst(t.restype);
            List<Type> thrown = this.subst(t.thrown);
            if (argtypes == t.argtypes && restype == t.restype && thrown == t.thrown) {
                return t;
            }
            return new Type.MethodType(argtypes, restype, thrown, t.tsym);
        }

        @Override
        public Type visitTypeVar(Type.TypeVar t, Void ignored) {
            List<Type> from = this.from;
            List<Type> to = this.to;
            while (from.nonEmpty()) {
                if (t == from.head) {
                    return ((Type)to.head).withTypeVar(t);
                }
                from = from.tail;
                to = to.tail;
            }
            return t;
        }

        @Override
        public Type visitUndetVar(Type.UndetVar t, Void ignored) {
            return t;
        }

        @Override
        public Type visitClassType(Type.ClassType t, Void ignored) {
            if (!t.isCompound()) {
                java.util.List typarams = t.getTypeArguments();
                List<Type> typarams1 = this.subst((List<Type>)typarams);
                Type outer = t.getEnclosingType();
                Type outer1 = this.subst(outer);
                if (typarams1 == typarams && outer1 == outer) {
                    return t;
                }
                return new Type.ClassType(outer1, typarams1, t.tsym);
            }
            Type st = this.subst(Types.this.supertype(t));
            List<Type> is = this.subst(Types.this.interfaces(t));
            if (st == Types.this.supertype(t) && is == Types.this.interfaces(t)) {
                return t;
            }
            return Types.this.makeCompoundType(is.prepend(st));
        }

        @Override
        public Type visitWildcardType(Type.WildcardType t, Void ignored) {
            Type bound = t.type;
            if (t.kind != BoundKind.UNBOUND) {
                bound = this.subst(bound);
            }
            if (bound == t.type) {
                return t;
            }
            if (t.isExtendsBound() && bound.isExtendsBound()) {
                bound = Types.this.wildUpperBound(bound);
            }
            return new Type.WildcardType(bound, t.kind, Types.this.syms.boundClass, t.bound);
        }

        @Override
        public Type visitArrayType(Type.ArrayType t, Void ignored) {
            Type elemtype = this.subst(t.elemtype);
            if (elemtype == t.elemtype) {
                return t;
            }
            return new Type.ArrayType(elemtype, t.tsym);
        }

        @Override
        public Type visitForAll(Type.ForAll t, Void ignored) {
            if (Type.containsAny(this.to, t.tvars)) {
                List<Type> freevars = Types.this.newInstances(t.tvars);
                t = new Type.ForAll(freevars, Types.this.subst(t.qtype, t.tvars, freevars));
            }
            List<Type> tvars1 = Types.this.substBounds(t.tvars, this.from, this.to);
            Type qtype1 = this.subst(t.qtype);
            if (tvars1 == t.tvars && qtype1 == t.qtype) {
                return t;
            }
            if (tvars1 == t.tvars) {
                return new Type.ForAll(tvars1, qtype1);
            }
            return new Type.ForAll(tvars1, Types.this.subst(qtype1, t.tvars, tvars1));
        }

        @Override
        public Type visitErrorType(Type.ErrorType t, Void ignored) {
            return t;
        }
    }

    private class HasSameArgs
    extends TypeRelation {
        boolean strict;

        public HasSameArgs(boolean strict) {
            this.strict = strict;
        }

        @Override
        public Boolean visitType(Type t, Type s) {
            throw new AssertionError();
        }

        @Override
        public Boolean visitMethodType(Type.MethodType t, Type s) {
            return s.hasTag(TypeTag.METHOD) && Types.this.containsTypeEquivalent(t.argtypes, s.getParameterTypes());
        }

        @Override
        public Boolean visitForAll(Type.ForAll t, Type s) {
            if (!s.hasTag(TypeTag.FORALL)) {
                return this.strict ? false : this.visitMethodType(t.asMethodType(), s);
            }
            Type.ForAll forAll = (Type.ForAll)s;
            return Types.this.hasSameBounds(t, forAll) && (Boolean)this.visit(t.qtype, Types.this.subst(forAll.qtype, forAll.tvars, t.tvars)) != false;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return false;
        }
    }

    private class MethodFilter
    implements Filter<Symbol> {
        Symbol msym;
        Type site;

        MethodFilter(Symbol msym, Type site) {
            this.msym = msym;
            this.site = site;
        }

        @Override
        public boolean accepts(Symbol s) {
            return s.kind == 16 && s.name == this.msym.name && (s.flags() & 0x1000L) == 0L && s.isInheritedIn(this.site.tsym, Types.this) && Types.this.overrideEquivalent(Types.this.memberType(this.site, s), Types.this.memberType(this.site, this.msym));
        }
    }

    class MembersClosureCache
    extends SimpleVisitor<Scope.CompoundScope, Boolean> {
        private WeakHashMap<Symbol.TypeSymbol, Entry> _map = new WeakHashMap();
        List<Symbol.TypeSymbol> seenTypes = List.nil();

        MembersClosureCache() {
        }

        @Override
        public Scope.CompoundScope visitType(Type t, Boolean skipInterface) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Scope.CompoundScope visitClassType(Type.ClassType t, Boolean skipInterface) {
            if (this.seenTypes.contains(t.tsym)) {
                return new Scope.CompoundScope(t.tsym);
            }
            try {
                this.seenTypes = this.seenTypes.prepend(t.tsym);
                Symbol.ClassSymbol csym = (Symbol.ClassSymbol)t.tsym;
                Entry e = this._map.get(csym);
                if (e == null || !e.matches(skipInterface)) {
                    Scope.CompoundScope membersClosure = new Scope.CompoundScope(csym);
                    if (!skipInterface.booleanValue()) {
                        for (Type i : Types.this.interfaces(t)) {
                            membersClosure.addSubScope((Scope)this.visit(i, skipInterface));
                        }
                    }
                    membersClosure.addSubScope((Scope)this.visit(Types.this.supertype(t), skipInterface));
                    membersClosure.addSubScope(csym.members());
                    e = new Entry(skipInterface, membersClosure);
                    this._map.put(csym, e);
                }
                Scope.CompoundScope compoundScope = e.compoundScope;
                return compoundScope;
            }
            finally {
                this.seenTypes = this.seenTypes.tail;
            }
        }

        @Override
        public Scope.CompoundScope visitTypeVar(Type.TypeVar t, Boolean skipInterface) {
            return (Scope.CompoundScope)this.visit(t.getUpperBound(), skipInterface);
        }

        class Entry {
            final boolean skipInterfaces;
            final Scope.CompoundScope compoundScope;

            public Entry(boolean skipInterfaces, Scope.CompoundScope compoundScope) {
                this.skipInterfaces = skipInterfaces;
                this.compoundScope = compoundScope;
            }

            boolean matches(boolean skipInterfaces) {
                return this.skipInterfaces == skipInterfaces;
            }
        }
    }

    class ImplementationCache {
        private WeakHashMap<Symbol.MethodSymbol, SoftReference<Map<Symbol.TypeSymbol, Entry>>> _map = new WeakHashMap();

        ImplementationCache() {
        }

        Symbol.MethodSymbol get(Symbol.MethodSymbol ms, Symbol.TypeSymbol origin, boolean checkResult, Filter<Symbol> implFilter) {
            Map<Symbol.TypeSymbol, Entry> cache;
            SoftReference<Map<Symbol.TypeSymbol, Entry>> ref_cache = this._map.get(ms);
            Map<Symbol.TypeSymbol, Entry> map = cache = ref_cache != null ? ref_cache.get() : null;
            if (cache == null) {
                cache = new HashMap<Symbol.TypeSymbol, Entry>();
                this._map.put(ms, new SoftReference<Map<Symbol.TypeSymbol, Entry>>(cache));
            }
            Entry e = cache.get(origin);
            Scope.CompoundScope members = Types.this.membersClosure(origin.type, true);
            if (e == null || !e.matches(implFilter, checkResult, members.getMark())) {
                Symbol.MethodSymbol impl = this.implementationInternal(ms, origin, checkResult, implFilter);
                cache.put(origin, new Entry(impl, implFilter, checkResult, members.getMark()));
                return impl;
            }
            return e.cachedImpl;
        }

        private Symbol.MethodSymbol implementationInternal(Symbol.MethodSymbol ms, Symbol.TypeSymbol origin, boolean checkResult, Filter<Symbol> implFilter) {
            Type t = origin.type;
            while (t.hasTag(TypeTag.CLASS) || t.hasTag(TypeTag.TYPEVAR)) {
                while (t.hasTag(TypeTag.TYPEVAR)) {
                    t = t.getUpperBound();
                }
                Symbol.TypeSymbol c = t.tsym;
                Scope.Entry e = c.members().lookup(ms.name, implFilter);
                while (e.scope != null) {
                    if (e.sym != null && e.sym.overrides(ms, origin, Types.this, checkResult)) {
                        return (Symbol.MethodSymbol)e.sym;
                    }
                    e = e.next(implFilter);
                }
                t = Types.this.supertype(t);
            }
            return null;
        }

        class Entry {
            final Symbol.MethodSymbol cachedImpl;
            final Filter<Symbol> implFilter;
            final boolean checkResult;
            final int prevMark;

            public Entry(Symbol.MethodSymbol cachedImpl, Filter<Symbol> scopeFilter, boolean checkResult, int prevMark) {
                this.cachedImpl = cachedImpl;
                this.implFilter = scopeFilter;
                this.checkResult = checkResult;
                this.prevMark = prevMark;
            }

            boolean matches(Filter<Symbol> scopeFilter, boolean checkResult, int mark) {
                return this.implFilter == scopeFilter && this.checkResult == checkResult && this.prevMark == mark;
            }
        }
    }

    private class LooseSameTypeVisitor
    extends SameTypeVisitor {
        private Set<TypePair> cache;

        private LooseSameTypeVisitor() {
            this.cache = new HashSet<TypePair>();
        }

        @Override
        boolean sameTypeVars(Type.TypeVar tv1, Type.TypeVar tv2) {
            return tv1.tsym == tv2.tsym && this.checkSameBounds(tv1, tv2);
        }

        @Override
        protected boolean containsTypes(List<Type> ts1, List<Type> ts2) {
            return Types.this.containsTypeEquivalent(ts1, ts2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkSameBounds(Type.TypeVar tv1, Type.TypeVar tv2) {
            TypePair p = new TypePair(tv1, tv2, true);
            if (this.cache.add(p)) {
                try {
                    boolean bl = (Boolean)this.visit(tv1.getUpperBound(), tv2.getUpperBound());
                    return bl;
                }
                finally {
                    this.cache.remove(p);
                }
            }
            return false;
        }
    }

    abstract class SameTypeVisitor
    extends TypeRelation {
        SameTypeVisitor() {
        }

        @Override
        public Boolean visitType(Type t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            switch (t.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case BOT: 
                case NONE: {
                    return t.hasTag(s.getTag());
                }
                case TYPEVAR: {
                    if (s.hasTag(TypeTag.TYPEVAR)) {
                        return this.sameTypeVars((Type.TypeVar)t.unannotatedType(), (Type.TypeVar)s.unannotatedType());
                    }
                    return s.isSuperBound() && !s.isExtendsBound() && (Boolean)this.visit(t, Types.this.wildUpperBound(s)) != false;
                }
            }
            throw new AssertionError((Object)("isSameType " + (Object)((Object)t.getTag())));
        }

        abstract boolean sameTypeVars(Type.TypeVar var1, Type.TypeVar var2);

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Type s) {
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            return false;
        }

        @Override
        public Boolean visitClassType(Type.ClassType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            if (s.isSuperBound() && !s.isExtendsBound()) {
                return (Boolean)this.visit(t, Types.this.wildUpperBound(s)) != false && (Boolean)this.visit(t, Types.this.wildLowerBound(s)) != false;
            }
            if (t.isCompound() && s.isCompound()) {
                if (!((Boolean)this.visit(Types.this.supertype(t), Types.this.supertype(s))).booleanValue()) {
                    return false;
                }
                HashSet<UniqueType> set = new HashSet<UniqueType>();
                for (Type x : Types.this.interfaces(t)) {
                    set.add(new UniqueType(x.unannotatedType(), Types.this));
                }
                for (Type x : Types.this.interfaces(s)) {
                    if (set.remove(new UniqueType(x.unannotatedType(), Types.this))) continue;
                    return false;
                }
                return set.isEmpty();
            }
            return t.tsym == s.tsym && (Boolean)this.visit(t.getEnclosingType(), s.getEnclosingType()) != false && this.containsTypes((List<Type>)t.getTypeArguments(), s.getTypeArguments());
        }

        protected abstract boolean containsTypes(List<Type> var1, List<Type> var2);

        @Override
        public Boolean visitArrayType(Type.ArrayType t, Type s) {
            if (t == s) {
                return true;
            }
            if (s.isPartial()) {
                return (Boolean)this.visit(s, t);
            }
            return s.hasTag(TypeTag.ARRAY) && Types.this.containsTypeEquivalent(t.elemtype, Types.this.elemtype(s));
        }

        @Override
        public Boolean visitMethodType(Type.MethodType t, Type s) {
            return Types.this.hasSameArgs(t, s) && (Boolean)this.visit(t.getReturnType(), s.getReturnType()) != false;
        }

        @Override
        public Boolean visitPackageType(Type.PackageType t, Type s) {
            return t == s;
        }

        @Override
        public Boolean visitForAll(Type.ForAll t, Type s) {
            if (!s.hasTag(TypeTag.FORALL)) {
                return false;
            }
            Type.ForAll forAll = (Type.ForAll)s;
            return Types.this.hasSameBounds(t, forAll) && (Boolean)this.visit(t.qtype, Types.this.subst(forAll.qtype, forAll.tvars, t.tvars)) != false;
        }

        @Override
        public Boolean visitUndetVar(Type.UndetVar t, Type s) {
            if (s.hasTag(TypeTag.WILDCARD)) {
                return false;
            }
            if (t == s || t.qtype == s || s.hasTag(TypeTag.ERROR) || s.hasTag(TypeTag.UNKNOWN)) {
                return true;
            }
            t.addBound(Type.UndetVar.InferenceBound.EQ, s, Types.this);
            return true;
        }

        @Override
        public Boolean visitErrorType(Type.ErrorType t, Type s) {
            return true;
        }
    }

    class DescriptorFilter
    implements Filter<Symbol> {
        Symbol.TypeSymbol origin;

        DescriptorFilter(Symbol.TypeSymbol origin) {
            this.origin = origin;
        }

        @Override
        public boolean accepts(Symbol sym) {
            return sym.kind == 16 && (sym.flags() & 0x80000000400L) == 1024L && !Types.this.overridesObjectMethod(this.origin, sym) && (((Symbol.MethodSymbol)Types.this.interfaceCandidates((Type)this.origin.type, (Symbol.MethodSymbol)((Symbol.MethodSymbol)sym)).head).flags() & 0x80000000000L) == 0L;
        }
    }

    class DescriptorCache {
        private WeakHashMap<Symbol.TypeSymbol, Entry> _map = new WeakHashMap();

        DescriptorCache() {
        }

        FunctionDescriptor get(Symbol.TypeSymbol origin) throws FunctionDescriptorLookupError {
            Entry e = this._map.get(origin);
            Scope.CompoundScope members = Types.this.membersClosure(origin.type, false);
            if (e == null || !e.matches(members.getMark())) {
                FunctionDescriptor descRes = this.findDescriptorInternal(origin, members);
                this._map.put(origin, new Entry(descRes, members.getMark()));
                return descRes;
            }
            return e.cachedDescRes;
        }

        public FunctionDescriptor findDescriptorInternal(Symbol.TypeSymbol origin, Scope.CompoundScope membersCache) throws FunctionDescriptorLookupError {
            if (!origin.isInterface() || (origin.flags() & 0x2000L) != 0L) {
                throw this.failure("not.a.functional.intf", origin);
            }
            ListBuffer<Symbol> abstracts = new ListBuffer<Symbol>();
            for (Symbol sym : membersCache.getElements(new DescriptorFilter(origin))) {
                Type mtype = Types.this.memberType(origin.type, sym);
                if (abstracts.isEmpty() || sym.name == ((Symbol)abstracts.first()).name && Types.this.overrideEquivalent(mtype, Types.this.memberType(origin.type, (Symbol)abstracts.first()))) {
                    abstracts.append(sym);
                    continue;
                }
                throw this.failure("not.a.functional.intf.1", origin, Types.this.diags.fragment("incompatible.abstracts", Kinds.kindName(origin), origin));
            }
            if (abstracts.isEmpty()) {
                throw this.failure("not.a.functional.intf.1", origin, Types.this.diags.fragment("no.abstracts", Kinds.kindName(origin), origin));
            }
            if (abstracts.size() == 1) {
                return new FunctionDescriptor((Symbol)abstracts.first());
            }
            FunctionDescriptor descRes = this.mergeDescriptors(origin, abstracts.toList());
            if (descRes == null) {
                ListBuffer<JCDiagnostic> descriptors = new ListBuffer<JCDiagnostic>();
                for (Symbol desc : abstracts) {
                    String key = desc.type.getThrownTypes().nonEmpty() ? "descriptor.throws" : "descriptor";
                    descriptors.append(Types.this.diags.fragment(key, desc.name, desc.type.getParameterTypes(), desc.type.getReturnType(), desc.type.getThrownTypes()));
                }
                JCDiagnostic.MultilineDiagnostic incompatibleDescriptors = new JCDiagnostic.MultilineDiagnostic(Types.this.diags.fragment("incompatible.descs.in.functional.intf", Kinds.kindName(origin), origin), descriptors.toList());
                throw this.failure(incompatibleDescriptors);
            }
            return descRes;
        }

        private FunctionDescriptor mergeDescriptors(Symbol.TypeSymbol origin, List<Symbol> methodSyms) {
            Type mt2;
            Type mt1;
            List<Symbol> mostSpecific = List.nil();
            block0: for (Symbol msym1 : methodSyms) {
                Type mt12 = Types.this.memberType(origin.type, msym1);
                for (Symbol msym2 : methodSyms) {
                    Type mt22 = Types.this.memberType(origin.type, msym2);
                    if (Types.this.isSubSignature(mt12, mt22)) continue;
                    continue block0;
                }
                mostSpecific = mostSpecific.prepend(msym1);
            }
            if (mostSpecific.isEmpty()) {
                return null;
            }
            boolean phase2 = false;
            Symbol bestSoFar = null;
            while (bestSoFar == null) {
                block3: for (Symbol msym1 : mostSpecific) {
                    mt1 = Types.this.memberType(origin.type, msym1);
                    for (Symbol msym2 : methodSyms) {
                        mt2 = Types.this.memberType(origin.type, msym2);
                        if (!(phase2 ? !Types.this.returnTypeSubstitutable(mt1, mt2) : !this.isSubtypeInternal(mt1.getReturnType(), mt2.getReturnType()))) continue;
                        continue block3;
                    }
                    bestSoFar = msym1;
                }
                if (phase2) break;
                phase2 = true;
            }
            if (bestSoFar == null) {
                return null;
            }
            boolean toErase = !bestSoFar.type.hasTag(TypeTag.FORALL);
            List<Type> thrown = null;
            mt1 = Types.this.memberType(origin.type, bestSoFar);
            for (Symbol msym2 : methodSyms) {
                mt2 = Types.this.memberType(origin.type, msym2);
                List<Type> thrown_mt2 = mt2.getThrownTypes();
                if (toErase) {
                    thrown_mt2 = Types.this.erasure(thrown_mt2);
                } else {
                    Type.ForAll fa1 = (Type.ForAll)mt1;
                    Type.ForAll fa2 = (Type.ForAll)mt2;
                    thrown_mt2 = Types.this.subst(thrown_mt2, fa2.tvars, fa1.tvars);
                }
                thrown = thrown == null ? thrown_mt2 : Types.this.chk.intersect(thrown_mt2, thrown);
            }
            final List<Type> thrown1 = thrown;
            return new FunctionDescriptor(bestSoFar){

                @Override
                public Type getType(Type origin) {
                    Type mt = Types.this.memberType(origin, this.getSymbol());
                    return Types.this.createMethodTypeWithThrown(mt, thrown1);
                }
            };
        }

        boolean isSubtypeInternal(Type s, Type t) {
            return s.isPrimitive() && t.isPrimitive() ? Types.this.isSameType(t, s) : Types.this.isSubtype(s, t);
        }

        FunctionDescriptorLookupError failure(String msg, Object ... args) {
            return this.failure(Types.this.diags.fragment(msg, args));
        }

        FunctionDescriptorLookupError failure(JCDiagnostic diag) {
            return Types.this.functionDescriptorLookupError.setMessage(diag);
        }

        class Entry {
            final FunctionDescriptor cachedDescRes;
            final int prevMark;

            public Entry(FunctionDescriptor cachedDescRes, int prevMark) {
                this.cachedDescRes = cachedDescRes;
                this.prevMark = prevMark;
            }

            boolean matches(int mark) {
                return this.prevMark == mark;
            }
        }

        class FunctionDescriptor {
            Symbol descSym;

            FunctionDescriptor(Symbol descSym) {
                this.descSym = descSym;
            }

            public Symbol getSymbol() {
                return this.descSym;
            }

            public Type getType(Type site) {
                if (!Types.this.chk.checkValidGenericType(site = Types.this.removeWildcards(site))) {
                    throw DescriptorCache.this.failure(Types.this.diags.fragment("no.suitable.functional.intf.inst", site));
                }
                return Types.this.memberType(site, this.descSym);
            }
        }
    }

    public static class FunctionDescriptorLookupError
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        JCDiagnostic diagnostic = null;

        FunctionDescriptorLookupError() {
        }

        FunctionDescriptorLookupError setMessage(JCDiagnostic diag) {
            this.diagnostic = diag;
            return this;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }
}

