/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Warner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DeferredAttr
extends JCTree.Visitor {
    protected static final Context.Key<DeferredAttr> deferredAttrKey = new Context.Key();
    final Attr attr;
    final Check chk;
    final JCDiagnostic.Factory diags;
    final Enter enter;
    final Infer infer;
    final Resolve rs;
    final Log log;
    final Symtab syms;
    final TreeMaker make;
    final Types types;
    final Flow flow;
    final Names names;
    final JCTree stuckTree;
    DeferredTypeCompleter basicCompleter = new DeferredTypeCompleter(){

        @Override
        public Type complete(DeferredType dt, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    Assert.check(dt.mode == null || dt.mode == AttrMode.SPECULATIVE);
                    JCTree speculativeTree = DeferredAttr.this.attribSpeculative(dt.tree, dt.env, resultInfo);
                    dt.speculativeCache.put(speculativeTree, resultInfo);
                    return speculativeTree.type;
                }
                case CHECK: {
                    Assert.check(dt.mode != null);
                    return DeferredAttr.this.attr.attribTree(dt.tree, dt.env, resultInfo);
                }
            }
            Assert.error();
            return null;
        }
    };
    DeferredTypeCompleter dummyCompleter = new DeferredTypeCompleter(){

        @Override
        public Type complete(DeferredType dt, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            Assert.check(deferredAttrContext.mode == AttrMode.CHECK);
            dt.tree.type = Type.stuckType;
            return dt.tree.type;
        }
    };
    DeferredStuckPolicy dummyStuckPolicy = new DeferredStuckPolicy(){

        @Override
        public boolean isStuck() {
            return false;
        }

        @Override
        public Set<Type> stuckVars() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> depVars() {
            return Collections.emptySet();
        }
    };
    protected UnenterScanner unenterScanner = new UnenterScanner();
    final DeferredAttrContext emptyDeferredAttrContext;
    private EnumSet<JCTree.Tag> deferredCheckerTags = EnumSet.of(JCTree.Tag.LAMBDA, new JCTree.Tag[]{JCTree.Tag.REFERENCE, JCTree.Tag.PARENS, JCTree.Tag.TYPECAST, JCTree.Tag.CONDEXPR, JCTree.Tag.NEWCLASS, JCTree.Tag.APPLY, JCTree.Tag.LITERAL});

    public static DeferredAttr instance(Context context) {
        DeferredAttr instance = context.get(deferredAttrKey);
        if (instance == null) {
            instance = new DeferredAttr(context);
        }
        return instance;
    }

    protected DeferredAttr(Context context) {
        context.put(deferredAttrKey, this);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.enter = Enter.instance(context);
        this.infer = Infer.instance(context);
        this.rs = Resolve.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.flow = Flow.instance(context);
        this.names = Names.instance(context);
        this.stuckTree = this.make.Ident(this.names.empty).setType(Type.stuckType);
        this.emptyDeferredAttrContext = new DeferredAttrContext(AttrMode.CHECK, null, Resolve.MethodResolutionPhase.BOX, this.infer.emptyContext, null, null){

            @Override
            void addDeferredAttrNode(DeferredType dt, Attr.ResultInfo ri, DeferredStuckPolicy deferredStuckPolicy) {
                Assert.error("Empty deferred context!");
            }

            @Override
            void complete() {
                Assert.error("Empty deferred context!");
            }

            public String toString() {
                return "Empty deferred context!";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        final JCTree newTree = new TreeCopier(this.make).copy(tree);
        Env<AttrContext> speculativeEnv = env.dup(newTree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared()));
        ((AttrContext)speculativeEnv.info).scope.owner = ((AttrContext)env.info).scope.owner;
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.log, new Filter<JCDiagnostic>(){

            @Override
            public boolean accepts(final JCDiagnostic d) {
                class PosScanner
                extends TreeScanner {
                    boolean found = false;

                    PosScanner() {
                    }

                    @Override
                    public void scan(JCTree tree) {
                        if (tree != null && tree.pos() == d.getDiagnosticPosition()) {
                            this.found = true;
                        }
                        super.scan(tree);
                    }
                }
                PosScanner posScanner = new PosScanner();
                posScanner.scan(newTree);
                return posScanner.found;
            }
        });
        try {
            this.attr.attribTree(newTree, speculativeEnv, resultInfo);
            this.unenterScanner.scan(newTree);
            JCTree jCTree = newTree;
            return jCTree;
        }
        finally {
            this.unenterScanner.scan(newTree);
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
    }

    boolean isDeferred(Env<AttrContext> env, JCTree.JCExpression expr) {
        DeferredChecker dc = new DeferredChecker(env);
        dc.scan(expr);
        return dc.result.isPoly();
    }

    final class DeferredChecker
    extends FilterScanner {
        Env<AttrContext> env;
        ArgumentExpressionKind result;

        public DeferredChecker(Env<AttrContext> env) {
            super(DeferredAttr.this.deferredCheckerTags);
            this.env = env;
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            this.result = ArgumentExpressionKind.POLY;
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            Symbol res;
            Env<AttrContext> localEnv = this.env.dup(tree);
            JCTree.JCExpression exprTree = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(tree.getQualifierExpression(), localEnv, DeferredAttr.this.attr.memberReferenceQualifierResult(tree));
            JCTree.JCMemberReference mref2 = new TreeCopier(DeferredAttr.this.make).copy(tree);
            mref2.expr = exprTree;
            tree.sym = res = DeferredAttr.this.rs.getMemberReference(tree, localEnv, mref2, exprTree.type, tree.name);
            tree.overloadKind = res.kind >= 128 || res.type.hasTag(TypeTag.FORALL) || (res.flags() & 0x400000000L) != 0L || TreeInfo.isStaticSelector(exprTree, tree.name.table.names) && exprTree.type.isRaw() ? JCTree.JCMemberReference.OverloadKind.OVERLOADED : JCTree.JCMemberReference.OverloadKind.UNOVERLOADED;
            this.result = ArgumentExpressionKind.POLY;
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            this.result = ArgumentExpressionKind.NO_POLY;
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            this.scan(tree.truepart);
            if (!this.result.isPrimitive()) {
                this.result = ArgumentExpressionKind.POLY;
                return;
            }
            this.scan(tree.falsepart);
            this.result = this.reduce(ArgumentExpressionKind.PRIMITIVE);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.result = TreeInfo.isDiamond(tree) || DeferredAttr.this.attr.findDiamonds ? ArgumentExpressionKind.POLY : ArgumentExpressionKind.NO_POLY;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            Type site;
            JCTree.JCExpression rec;
            Name name = TreeInfo.name(tree.meth);
            if (tree.typeargs.nonEmpty() || name == name.table.names._this || name == name.table.names._super) {
                this.result = ArgumentExpressionKind.NO_POLY;
                return;
            }
            JCTree.JCExpression jCExpression = rec = tree.meth.hasTag(JCTree.Tag.SELECT) ? ((JCTree.JCFieldAccess)tree.meth).selected : null;
            if (rec != null && !this.isSimpleReceiver(rec)) {
                this.result = ArgumentExpressionKind.POLY;
                return;
            }
            Type type = site = rec != null ? DeferredAttr.this.attribSpeculative((JCTree)rec, this.env, (Attr.ResultInfo)DeferredAttr.this.attr.unknownTypeExprInfo).type : this.env.enclClass.sym.type;
            while (site.hasTag(TypeTag.TYPEVAR)) {
                site = site.getUpperBound();
            }
            List<Type> args = DeferredAttr.this.rs.dummyArgs(tree.args.length());
            Resolve resolve = DeferredAttr.this.rs;
            resolve.getClass();
            Resolve.LookupHelper lh = new Resolve.LookupHelper(resolve, name, site, args, List.nil(), Resolve.MethodResolutionPhase.VARARITY){
                {
                    Resolve resolve = x0;
                    resolve.getClass();
                    super(resolve, name, site, argtypes, typeargtypes, maxPhase);
                }

                @Override
                Symbol lookup(Env<AttrContext> env, Resolve.MethodResolutionPhase phase) {
                    return rec == null ? DeferredAttr.this.rs.findFun(env, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired()) : DeferredAttr.this.rs.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired(), false);
                }

                @Override
                Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
                    return sym;
                }
            };
            Symbol sym = DeferredAttr.this.rs.lookupMethod(this.env, (JCDiagnostic.DiagnosticPosition)tree, (Symbol)site.tsym, DeferredAttr.this.rs.arityMethodCheck, lh);
            if (sym.kind == 129) {
                Resolve.AmbiguityError err = (Resolve.AmbiguityError)sym.baseSymbol();
                this.result = ArgumentExpressionKind.PRIMITIVE;
                for (Symbol s : err.ambiguousSyms) {
                    if (!this.result.isPoly()) {
                        if (s.kind != 16) continue;
                        this.result = this.reduce(ArgumentExpressionKind.methodKind(s, DeferredAttr.this.types));
                        continue;
                    }
                    break;
                }
            } else {
                this.result = sym.kind == 16 ? ArgumentExpressionKind.methodKind(sym, DeferredAttr.this.types) : ArgumentExpressionKind.NO_POLY;
            }
        }

        private boolean isSimpleReceiver(JCTree rec) {
            switch (rec.getTag()) {
                case IDENT: {
                    return true;
                }
                case SELECT: {
                    return this.isSimpleReceiver(((JCTree.JCFieldAccess)rec).selected);
                }
                case TYPEAPPLY: 
                case TYPEARRAY: {
                    return true;
                }
                case ANNOTATED_TYPE: {
                    return this.isSimpleReceiver(((JCTree.JCAnnotatedType)rec).underlyingType);
                }
            }
            return false;
        }

        private ArgumentExpressionKind reduce(ArgumentExpressionKind kind) {
            switch (this.result) {
                case PRIMITIVE: {
                    return kind;
                }
                case NO_POLY: {
                    return kind.isPoly() ? kind : this.result;
                }
                case POLY: {
                    return this.result;
                }
            }
            Assert.error();
            return null;
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral tree) {
            Type litType = DeferredAttr.this.attr.litType(tree.typetag);
            this.result = ArgumentExpressionKind.standaloneKind(litType, DeferredAttr.this.types);
        }

        @Override
        void skip(JCTree tree) {
            this.result = ArgumentExpressionKind.NO_POLY;
        }
    }

    static enum ArgumentExpressionKind {
        POLY,
        NO_POLY,
        PRIMITIVE;


        public final boolean isPoly() {
            return this == POLY;
        }

        public final boolean isPrimitive() {
            return this == PRIMITIVE;
        }

        static ArgumentExpressionKind standaloneKind(Type type, Types types) {
            return types.unboxedTypeOrType(type).isPrimitive() ? PRIMITIVE : NO_POLY;
        }

        static ArgumentExpressionKind methodKind(Symbol sym, Types types) {
            Type restype = sym.type.getReturnType();
            if (sym.type.hasTag(TypeTag.FORALL) && restype.containsAny(((Type.ForAll)sym.type).tvars)) {
                return POLY;
            }
            return ArgumentExpressionKind.standaloneKind(restype, types);
        }
    }

    class OverloadStuckPolicy
    extends CheckStuckPolicy
    implements DeferredStuckPolicy {
        boolean stuck;

        @Override
        public boolean isStuck() {
            return super.isStuck() || this.stuck;
        }

        public OverloadStuckPolicy(Attr.ResultInfo resultInfo, DeferredType dt) {
            super(resultInfo, dt);
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            super.visitLambda(tree);
            if (tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                this.stuck = true;
            }
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            super.visitReference(tree);
            if (tree.overloadKind == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuck = true;
            }
        }
    }

    class CheckStuckPolicy
    extends PolyScanner
    implements DeferredStuckPolicy,
    Infer.FreeTypeListener {
        Type pt;
        Infer.InferenceContext inferenceContext;
        Set<Type> stuckVars = new LinkedHashSet<Type>();
        Set<Type> depVars = new LinkedHashSet<Type>();

        @Override
        public boolean isStuck() {
            return !this.stuckVars.isEmpty();
        }

        @Override
        public Set<Type> stuckVars() {
            return this.stuckVars;
        }

        @Override
        public Set<Type> depVars() {
            return this.depVars;
        }

        public CheckStuckPolicy(Attr.ResultInfo resultInfo, DeferredType dt) {
            this.pt = resultInfo.pt;
            this.inferenceContext = resultInfo.checkContext.inferenceContext();
            this.scan(dt.tree);
            if (!this.stuckVars.isEmpty()) {
                resultInfo.checkContext.inferenceContext().addFreeTypeListener(List.from(this.stuckVars), this);
            }
        }

        @Override
        public void typesInferred(Infer.InferenceContext inferenceContext) {
            this.stuckVars.clear();
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type descType = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> freeArgVars = this.inferenceContext.freeVarsIn(descType.getParameterTypes());
            if (tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT && freeArgVars.nonEmpty()) {
                this.stuckVars.addAll(freeArgVars);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getReturnType()));
            }
            this.scanLambdaBody(tree, descType.getReturnType());
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            this.scan(tree.expr);
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
                return;
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type descType = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> freeArgVars = this.inferenceContext.freeVarsIn(descType.getParameterTypes());
            if (freeArgVars.nonEmpty() && tree.overloadKind == JCTree.JCMemberReference.OverloadKind.OVERLOADED) {
                this.stuckVars.addAll(freeArgVars);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getReturnType()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scanLambdaBody(JCTree.JCLambda lambda, final Type pt) {
            if (lambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                Type prevPt = this.pt;
                try {
                    this.pt = pt;
                    this.scan(lambda.body);
                }
                finally {
                    this.pt = prevPt;
                }
            } else {
                LambdaReturnScanner lambdaScanner = new LambdaReturnScanner(){

                    @Override
                    public void visitReturn(JCTree.JCReturn tree) {
                        if (tree.expr != null) {
                            Type prevPt = CheckStuckPolicy.this.pt;
                            try {
                                CheckStuckPolicy.this.pt = pt;
                                CheckStuckPolicy.this.scan(tree.expr);
                            }
                            finally {
                                CheckStuckPolicy.this.pt = prevPt;
                            }
                        }
                    }
                };
                lambdaScanner.scan(lambda.body);
            }
        }
    }

    static class LambdaReturnScanner
    extends FilterScanner {
        LambdaReturnScanner() {
            super(EnumSet.of(JCTree.Tag.BLOCK, new JCTree.Tag[]{JCTree.Tag.CASE, JCTree.Tag.CATCH, JCTree.Tag.DOLOOP, JCTree.Tag.FOREACHLOOP, JCTree.Tag.FORLOOP, JCTree.Tag.RETURN, JCTree.Tag.SYNCHRONIZED, JCTree.Tag.SWITCH, JCTree.Tag.TRY, JCTree.Tag.WHILELOOP}));
        }
    }

    static class PolyScanner
    extends FilterScanner {
        PolyScanner() {
            super(EnumSet.of(JCTree.Tag.CONDEXPR, JCTree.Tag.PARENS, JCTree.Tag.LAMBDA, JCTree.Tag.REFERENCE));
        }
    }

    static abstract class FilterScanner
    extends TreeScanner {
        final Filter<JCTree> treeFilter;

        FilterScanner(final Set<JCTree.Tag> validTags) {
            this.treeFilter = new Filter<JCTree>(){

                @Override
                public boolean accepts(JCTree t) {
                    return validTags.contains((Object)t.getTag());
                }
            };
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null) {
                if (this.treeFilter.accepts(tree)) {
                    super.scan(tree);
                } else {
                    this.skip(tree);
                }
            }
        }

        void skip(JCTree tree) {
        }
    }

    public class RecoveryDeferredTypeMap
    extends DeferredTypeMap {
        public RecoveryDeferredTypeMap(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase) {
            super(mode, msym, phase != null ? phase : Resolve.MethodResolutionPhase.BOX);
        }

        @Override
        protected Type typeOf(DeferredType dt) {
            Type owntype = super.typeOf(dt);
            return owntype == Type.noType ? this.recover(dt) : owntype;
        }

        private Type recover(DeferredType dt) {
            Attr attr = DeferredAttr.this.attr;
            attr.getClass();
            dt.check(new Attr.RecoveryInfo(attr, this.deferredAttrContext){
                {
                    Attr attr = x0;
                    attr.getClass();
                    super(deferredAttrContext);
                }

                @Override
                protected Type check(JCDiagnostic.DiagnosticPosition pos, Type found) {
                    return DeferredAttr.this.chk.checkNonVoid(pos, super.check(pos, found));
                }
            });
            return super.apply(dt);
        }
    }

    class DeferredTypeMap
    extends Type.Mapping {
        DeferredAttrContext deferredAttrContext;

        protected DeferredTypeMap(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase) {
            super(String.format("deferredTypeMap[%s]", new Object[]{mode}));
            this.deferredAttrContext = new DeferredAttrContext(mode, msym, phase, DeferredAttr.this.infer.emptyContext, DeferredAttr.this.emptyDeferredAttrContext, DeferredAttr.this.types.noWarnings);
        }

        @Override
        public Type apply(Type t) {
            if (!t.hasTag(TypeTag.DEFERRED)) {
                return t.map(this);
            }
            DeferredType dt = (DeferredType)t;
            return this.typeOf(dt);
        }

        protected Type typeOf(DeferredType dt) {
            switch (this.deferredAttrContext.mode) {
                case CHECK: {
                    return dt.tree.type == null ? Type.noType : dt.tree.type;
                }
                case SPECULATIVE: {
                    return dt.speculativeType(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                }
            }
            Assert.error();
            return null;
        }
    }

    class DeferredAttrNode {
        DeferredType dt;
        Attr.ResultInfo resultInfo;
        DeferredStuckPolicy deferredStuckPolicy;

        DeferredAttrNode(DeferredType dt, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.dt = dt;
            this.resultInfo = resultInfo;
            this.deferredStuckPolicy = deferredStuckPolicy;
        }

        boolean process(final DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode) {
                case SPECULATIVE: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        this.dt.check(this.resultInfo, DeferredAttr.this.dummyStuckPolicy, new StructuralStuckChecker());
                        return true;
                    }
                    Assert.error("Cannot get here");
                }
                case CHECK: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        if (deferredAttrContext.parent != DeferredAttr.this.emptyDeferredAttrContext && Type.containsAny(deferredAttrContext.parent.inferenceContext.inferencevars, List.from(this.deferredStuckPolicy.stuckVars()))) {
                            deferredAttrContext.parent.addDeferredAttrNode(this.dt, this.resultInfo.dup(new Check.NestedCheckContext(this.resultInfo.checkContext){

                                @Override
                                public Infer.InferenceContext inferenceContext() {
                                    return deferredAttrContext.parent.inferenceContext;
                                }

                                @Override
                                public DeferredAttrContext deferredAttrContext() {
                                    return deferredAttrContext.parent;
                                }
                            }), this.deferredStuckPolicy);
                            this.dt.tree.type = Type.stuckType;
                            return true;
                        }
                        return false;
                    }
                    Attr.ResultInfo instResultInfo = this.resultInfo.dup(deferredAttrContext.inferenceContext.asInstType(this.resultInfo.pt));
                    this.dt.check(instResultInfo, DeferredAttr.this.dummyStuckPolicy, DeferredAttr.this.basicCompleter);
                    return true;
                }
            }
            throw new AssertionError((Object)"Bad mode");
        }

        class LambdaBodyStructChecker
        extends TreeScanner {
            boolean isVoidCompatible = true;
            boolean isPotentiallyValueCompatible = true;

            LambdaBodyStructChecker() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
            }

            @Override
            public void visitReturn(JCTree.JCReturn tree) {
                if (tree.expr != null) {
                    this.isVoidCompatible = false;
                } else {
                    this.isPotentiallyValueCompatible = false;
                }
            }
        }

        class StructuralStuckChecker
        extends TreeScanner
        implements DeferredTypeCompleter {
            Attr.ResultInfo resultInfo;
            Infer.InferenceContext inferenceContext;
            Env<AttrContext> env;

            StructuralStuckChecker() {
            }

            @Override
            public Type complete(DeferredType dt, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
                this.resultInfo = resultInfo;
                this.inferenceContext = deferredAttrContext.inferenceContext;
                this.env = dt.env;
                dt.tree.accept(this);
                dt.speculativeCache.put(DeferredAttr.this.stuckTree, resultInfo);
                return Type.noType;
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type pt = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(pt)) {
                    Type descriptorType = null;
                    try {
                        descriptorType = DeferredAttr.this.types.findDescriptorType(pt);
                    }
                    catch (Types.FunctionDescriptorLookupError ex) {
                        checkContext.report(null, ex.getDiagnostic());
                    }
                    if (descriptorType.getParameterTypes().length() != tree.params.length()) {
                        checkContext.report(tree, DeferredAttr.this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
                    }
                    Type currentReturnType = descriptorType.getReturnType();
                    boolean returnTypeIsVoid = currentReturnType.hasTag(TypeTag.VOID);
                    if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        boolean isExpressionCompatible;
                        boolean bl = isExpressionCompatible = !returnTypeIsVoid || TreeInfo.isExpressionStatement((JCTree.JCExpression)tree.getBody());
                        if (!isExpressionCompatible) {
                            this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", currentReturnType)));
                        }
                    } else {
                        LambdaBodyStructChecker lambdaBodyChecker = new LambdaBodyStructChecker();
                        tree.body.accept(lambdaBodyChecker);
                        boolean isVoidCompatible = lambdaBodyChecker.isVoidCompatible;
                        if (returnTypeIsVoid) {
                            if (!isVoidCompatible) {
                                this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment("unexpected.ret.val", new Object[0]));
                            }
                        } else {
                            boolean isValueCompatible;
                            boolean bl = isValueCompatible = lambdaBodyChecker.isPotentiallyValueCompatible && !this.canLambdaBodyCompleteNormally(tree);
                            if (!isValueCompatible && !isVoidCompatible) {
                                DeferredAttr.this.log.error(tree.body.pos(), "lambda.body.neither.value.nor.void.compatible", new Object[0]);
                            }
                            if (!isValueCompatible) {
                                this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment("incompatible.ret.type.in.lambda", DeferredAttr.this.diags.fragment("missing.ret.val", currentReturnType)));
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean canLambdaBodyCompleteNormally(JCTree.JCLambda tree) {
                boolean bl;
                JCTree.JCLambda newTree = new TreeCopier(DeferredAttr.this.make).copy(tree);
                Env<AttrContext> localEnv = DeferredAttr.this.attr.lambdaEnv(newTree, this.env);
                try {
                    Attr.ResultInfo bodyResultInfo;
                    List<JCTree.JCVariableDecl> tmpParams = newTree.params;
                    while (tmpParams.nonEmpty()) {
                        ((JCTree.JCVariableDecl)tmpParams.head).vartype = DeferredAttr.this.make.at((JCDiagnostic.DiagnosticPosition)tmpParams.head).Type(DeferredAttr.this.syms.errType);
                        tmpParams = tmpParams.tail;
                    }
                    DeferredAttr.this.attr.attribStats(newTree.params, localEnv);
                    Attr attr = DeferredAttr.this.attr;
                    attr.getClass();
                    ((AttrContext)localEnv.info).returnResult = bodyResultInfo = attr.new Attr.ResultInfo(12, Type.noType);
                    Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(DeferredAttr.this.log);
                    try {
                        JCTree.JCBlock body = (JCTree.JCBlock)newTree.body;
                        DeferredAttr.this.attr.attribStats(body.stats, localEnv);
                        DeferredAttr.this.attr.preFlow(newTree);
                        DeferredAttr.this.flow.analyzeLambda(localEnv, newTree, DeferredAttr.this.make, true);
                    }
                    finally {
                        DeferredAttr.this.log.popDiagnosticHandler(diagHandler);
                    }
                    bl = newTree.canCompleteNormally;
                }
                catch (Throwable throwable) {
                    JCTree.JCBlock body = (JCTree.JCBlock)newTree.body;
                    DeferredAttr.this.unenterScanner.scan(body.stats);
                    ((AttrContext)localEnv.info).scope.leave();
                    throw throwable;
                }
                JCTree.JCBlock body = (JCTree.JCBlock)newTree.body;
                DeferredAttr.this.unenterScanner.scan(body.stats);
                ((AttrContext)localEnv.info).scope.leave();
                return bl;
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
            }

            @Override
            public void visitReference(JCTree.JCMemberReference tree) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type pt = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(pt)) {
                    try {
                        DeferredAttr.this.types.findDescriptorType(pt);
                    }
                    catch (Types.FunctionDescriptorLookupError ex) {
                        checkContext.report(null, ex.getDiagnostic());
                    }
                    Env<AttrContext> localEnv = this.env.dup(tree);
                    JCTree.JCExpression exprTree = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(tree.getQualifierExpression(), localEnv, DeferredAttr.this.attr.memberReferenceQualifierResult(tree));
                    ListBuffer<Type.JCNoType> argtypes = new ListBuffer<Type.JCNoType>();
                    for (Type t : DeferredAttr.this.types.findDescriptorType(pt).getParameterTypes()) {
                        argtypes.append(Type.noType);
                    }
                    JCTree.JCMemberReference mref2 = new TreeCopier(DeferredAttr.this.make).copy(tree);
                    mref2.expr = exprTree;
                    Symbol lookupSym = DeferredAttr.this.rs.resolveMemberReferenceByArity(localEnv, mref2, exprTree.type, tree.name, argtypes.toList(), this.inferenceContext);
                    switch (lookupSym.kind) {
                        case 134: 
                        case 135: 
                        case 136: 
                        case 138: {
                            checkContext.report(tree, DeferredAttr.this.diags.fragment("incompatible.arg.types.in.mref", new Object[0]));
                        }
                    }
                }
            }
        }
    }

    class DeferredAttrContext {
        final AttrMode mode;
        final Symbol msym;
        final Resolve.MethodResolutionPhase phase;
        final Infer.InferenceContext inferenceContext;
        final DeferredAttrContext parent;
        final Warner warn;
        ArrayList<DeferredAttrNode> deferredAttrNodes = new ArrayList();

        DeferredAttrContext(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase, Infer.InferenceContext inferenceContext, DeferredAttrContext parent, Warner warn) {
            this.mode = mode;
            this.msym = msym;
            this.phase = phase;
            this.parent = parent;
            this.warn = warn;
            this.inferenceContext = inferenceContext;
        }

        void addDeferredAttrNode(DeferredType dt, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.deferredAttrNodes.add(new DeferredAttrNode(dt, resultInfo, deferredStuckPolicy));
        }

        void complete() {
            while (!this.deferredAttrNodes.isEmpty()) {
                LinkedHashMap<Type, Set<Type>> depVarsMap = new LinkedHashMap<Type, Set<Type>>();
                List<Type> stuckVars = List.nil();
                boolean progress = false;
                for (DeferredAttrNode deferredAttrNode : List.from(this.deferredAttrNodes)) {
                    if (!deferredAttrNode.process(this)) {
                        List<Type> restStuckVars = List.from(deferredAttrNode.deferredStuckPolicy.stuckVars()).intersect(this.inferenceContext.restvars());
                        stuckVars = stuckVars.prependList(restStuckVars);
                        for (Type t : List.from(deferredAttrNode.deferredStuckPolicy.depVars()).intersect(this.inferenceContext.restvars())) {
                            LinkedHashSet<Type> prevDeps = (LinkedHashSet<Type>)depVarsMap.get(t);
                            if (prevDeps == null) {
                                prevDeps = new LinkedHashSet<Type>();
                                depVarsMap.put(t, prevDeps);
                            }
                            prevDeps.addAll(restStuckVars);
                        }
                        continue;
                    }
                    this.deferredAttrNodes.remove(deferredAttrNode);
                    progress = true;
                }
                if (progress) continue;
                DeferredAttrContext dac = this;
                while (dac != DeferredAttr.this.emptyDeferredAttrContext && dac.mode != AttrMode.SPECULATIVE) {
                    dac = dac.parent;
                }
                try {
                    this.inferenceContext.solveAny(stuckVars, depVarsMap, this.warn);
                    this.inferenceContext.notifyChange();
                }
                catch (Infer.GraphStrategy.NodeNotFoundException ex) {
                    break;
                }
            }
        }
    }

    class UnenterScanner
    extends TreeScanner {
        UnenterScanner() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            Symbol.ClassSymbol csym = tree.sym;
            if (csym == null) {
                return;
            }
            DeferredAttr.this.enter.typeEnvs.remove(csym);
            DeferredAttr.this.chk.compiled.remove(csym.flatname);
            DeferredAttr.this.syms.classes.remove(csym.flatname);
            super.visitClassDef(tree);
        }
    }

    public static enum AttrMode {
        SPECULATIVE,
        CHECK;

    }

    static interface DeferredStuckPolicy {
        public boolean isStuck();

        public Set<Type> stuckVars();

        public Set<Type> depVars();
    }

    static interface DeferredTypeCompleter {
        public Type complete(DeferredType var1, Attr.ResultInfo var2, DeferredAttrContext var3);
    }

    public class DeferredType
    extends Type {
        public JCTree.JCExpression tree;
        Env<AttrContext> env;
        AttrMode mode;
        SpeculativeCache speculativeCache;

        DeferredType(JCTree.JCExpression tree, Env<AttrContext> env) {
            super(null, noAnnotations);
            this.tree = tree;
            this.env = DeferredAttr.this.attr.copyEnv(env);
            this.speculativeCache = new SpeculativeCache();
        }

        @Override
        public DeferredType annotatedType(List<Attribute.TypeCompound> typeAnnotations) {
            throw new AssertionError((Object)"Cannot annotate a deferred type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.DEFERRED;
        }

        @Override
        public String toString() {
            return "DeferredType";
        }

        Type speculativeType(Symbol msym, Resolve.MethodResolutionPhase phase) {
            SpeculativeCache.Entry e = this.speculativeCache.get(msym, phase);
            return e != null ? e.speculativeTree.type : Type.noType;
        }

        Type check(Attr.ResultInfo resultInfo) {
            DeferredStuckPolicy deferredStuckPolicy = resultInfo.pt.hasTag(TypeTag.NONE) || resultInfo.pt.isErroneous() ? DeferredAttr.this.dummyStuckPolicy : (resultInfo.checkContext.deferredAttrContext().mode == AttrMode.SPECULATIVE ? new OverloadStuckPolicy(resultInfo, this) : new CheckStuckPolicy(resultInfo, this));
            return this.check(resultInfo, deferredStuckPolicy, DeferredAttr.this.basicCompleter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Type check(Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy, DeferredTypeCompleter deferredTypeCompleter) {
            DeferredAttrContext deferredAttrContext = resultInfo.checkContext.deferredAttrContext();
            Assert.check(deferredAttrContext != DeferredAttr.this.emptyDeferredAttrContext);
            if (deferredStuckPolicy.isStuck()) {
                deferredAttrContext.addDeferredAttrNode(this, resultInfo, deferredStuckPolicy);
                return Type.noType;
            }
            try {
                Type type = deferredTypeCompleter.complete(this, resultInfo, deferredAttrContext);
                return type;
            }
            finally {
                this.mode = deferredAttrContext.mode;
            }
        }

        class SpeculativeCache {
            private Map<Symbol, List<Entry>> cache = new WeakHashMap<Symbol, List<Entry>>();

            SpeculativeCache() {
            }

            Entry get(Symbol msym, Resolve.MethodResolutionPhase phase) {
                List<Entry> entries = this.cache.get(msym);
                if (entries == null) {
                    return null;
                }
                for (Entry e : entries) {
                    if (!e.matches(phase)) continue;
                    return e;
                }
                return null;
            }

            void put(JCTree speculativeTree, Attr.ResultInfo resultInfo) {
                Symbol msym = resultInfo.checkContext.deferredAttrContext().msym;
                List<Entry> entries = this.cache.get(msym);
                if (entries == null) {
                    entries = List.nil();
                }
                this.cache.put(msym, entries.prepend(new Entry(speculativeTree, resultInfo)));
            }

            class Entry {
                JCTree speculativeTree;
                Attr.ResultInfo resultInfo;

                public Entry(JCTree speculativeTree, Attr.ResultInfo resultInfo) {
                    this.speculativeTree = speculativeTree;
                    this.resultInfo = resultInfo;
                }

                boolean matches(Resolve.MethodResolutionPhase phase) {
                    return this.resultInfo.checkContext.deferredAttrContext().phase == phase;
                }
            }
        }
    }
}

