/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public enum Target {
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JDK1_5("1.5", 49, 0),
    JDK1_6("1.6", 50, 0),
    JDK1_7("1.7", 51, 0),
    JDK1_8("1.8", 52, 0);

    private static final Context.Key<Target> targetKey;
    private static final Target MIN;
    private static final Target MAX;
    private static final Map<String, Target> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final Target DEFAULT;

    public static Target instance(Context context) {
        Target instance = context.get(targetKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String targetString = options.get(Option.TARGET);
            if (targetString != null) {
                instance = Target.lookup(targetString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(targetKey, instance);
        }
        return instance;
    }

    public static Target MIN() {
        return MIN;
    }

    public static Target MAX() {
        return MAX;
    }

    private Target(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static Target lookup(String name) {
        return tab.get(name);
    }

    public boolean requiresIproxy() {
        return this.compareTo(JDK1_1) <= 0;
    }

    public boolean initializeFieldsBeforeSuper() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean obeyBinaryCompatibility() {
        return this.compareTo(JDK1_2) >= 0;
    }

    public boolean arrayBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean interfaceFieldsBinaryCompatibility() {
        return this.compareTo(JDK1_2) > 0;
    }

    public boolean interfaceObjectOverridesBinaryCompatibility() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean usePrivateSyntheticFields() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean useInnerCacheClass() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean generateCLDCStackmap() {
        return false;
    }

    public boolean generateStackMapTable() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean isPackageInfoSynthetic() {
        return this.compareTo(JDK1_6) >= 0;
    }

    public boolean generateEmptyAfterBig() {
        return false;
    }

    public boolean useStringBuilder() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useSyntheticFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useEnumFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useAnnotationFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useVarargsFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean useBridgeFlag() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasClassLiterals() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasInvokedynamic() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean hasMethodHandles() {
        return this.hasInvokedynamic();
    }

    public boolean classLiteralsNoInit() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasInitCause() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean boxWithConstructors() {
        return this.compareTo(JDK1_5) < 0;
    }

    public boolean hasIterable() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean hasEnclosingMethodAttribute() {
        return this.compareTo(JDK1_5) >= 0;
    }

    static {
        targetKey = new Context.Key();
        MIN = Target.values()[0];
        MAX = Target.values()[Target.values().length - 1];
        tab = new HashMap<String, Target>();
        for (Target t : Target.values()) {
            tab.put(t.name, t);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        tab.put("8", JDK1_8);
        DEFAULT = JDK1_8;
    }
}

