/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.processing;

import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.processing.JavacFiler;
import com.sun.tools.javac.processing.JavacMessager;
import com.sun.tools.javac.processing.JavacRoundEnvironment;
import com.sun.tools.javac.processing.PrintingProcessor;
import com.sun.tools.javac.processing.ServiceProxy;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.ServiceLoader;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner8;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacProcessingEnvironment
implements ProcessingEnvironment,
Closeable {
    private final Options options;
    private final boolean printProcessorInfo;
    private final boolean printRounds;
    private final boolean verbose;
    private final boolean lint;
    private final boolean fatalErrors;
    private final boolean werror;
    private final boolean showResolveErrors;
    private final JavacFiler filer;
    private final JavacMessager messager;
    private final JavacElements elementUtils;
    private final JavacTypes typeUtils;
    private final Types types;
    private final JavaCompiler compiler;
    private DiscoveredProcessors discoveredProcs;
    private final Map<String, String> processorOptions;
    private final Set<String> unmatchedProcessorOptions;
    private final Set<String> platformAnnotations;
    private Set<Symbol.PackageSymbol> specifiedPackages = Collections.emptySet();
    final Log log;
    JCDiagnostic.Factory diags;
    Source source;
    private ClassLoader processorClassLoader;
    private SecurityException processorClassLoaderException;
    private JavacMessages messages;
    private MultiTaskListener taskListener;
    private final Symtab symtab;
    private final Names names;
    private final Enter enter;
    private final Symbol.Completer initialCompleter;
    private final Check chk;
    private final Context context;
    private final TreeScanner treeCleaner = new TreeScanner(){
        JCTree.JCCompilationUnit topLevel;

        @Override
        public void scan(JCTree node) {
            super.scan(node);
            if (node != null) {
                node.type = null;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit node) {
            if (node.packge != null) {
                if (node.packge.package_info != null) {
                    node.packge.package_info.reset();
                }
                node.packge.reset();
            }
            node.packge = null;
            this.topLevel = node;
            try {
                super.visitTopLevel(node);
            }
            finally {
                this.topLevel = null;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl node) {
            if (node.sym != null) {
                node.sym.reset();
                node.sym.completer = new ImplicitCompleter(this.topLevel);
            }
            node.sym = null;
            super.visitClassDef(node);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl node) {
            node.sym = null;
            super.visitMethodDef(node);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl node) {
            node.sym = null;
            super.visitVarDef(node);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass node) {
            node.constructor = null;
            super.visitNewClass(node);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp node) {
            node.operator = null;
            super.visitAssignop(node);
        }

        @Override
        public void visitUnary(JCTree.JCUnary node) {
            node.operator = null;
            super.visitUnary(node);
        }

        @Override
        public void visitBinary(JCTree.JCBinary node) {
            node.operator = null;
            super.visitBinary(node);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess node) {
            node.sym = null;
            super.visitSelect(node);
        }

        @Override
        public void visitIdent(JCTree.JCIdent node) {
            node.sym = null;
            super.visitIdent(node);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation node) {
            node.attribute = null;
            super.visitAnnotation(node);
        }
    };
    private static final Pattern allMatches = Pattern.compile(".*");
    public static final Pattern noMatches = Pattern.compile("(\\P{all})+");

    public static JavacProcessingEnvironment instance(Context context) {
        JavacProcessingEnvironment instance = context.get(JavacProcessingEnvironment.class);
        if (instance == null) {
            instance = new JavacProcessingEnvironment(context);
        }
        return instance;
    }

    protected JavacProcessingEnvironment(Context context) {
        this.context = context;
        context.put(JavacProcessingEnvironment.class, this);
        this.log = Log.instance(context);
        this.source = Source.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.options = Options.instance(context);
        this.printProcessorInfo = this.options.isSet(Option.XPRINTPROCESSORINFO);
        this.printRounds = this.options.isSet(Option.XPRINTROUNDS);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.lint = Lint.instance(context).isEnabled(Lint.LintCategory.PROCESSING);
        this.compiler = JavaCompiler.instance(context);
        if (this.options.isSet(Option.PROC, "only") || this.options.isSet(Option.XPRINT)) {
            this.compiler.shouldStopPolicyIfNoError = CompileStates.CompileState.PROCESS;
        }
        this.fatalErrors = this.options.isSet("fatalEnterError");
        this.showResolveErrors = this.options.isSet("showResolveErrors");
        this.werror = this.options.isSet(Option.WERROR);
        this.platformAnnotations = this.initPlatformAnnotations();
        this.filer = new JavacFiler(context);
        this.messager = new JavacMessager(context, this);
        this.elementUtils = JavacElements.instance(context);
        this.typeUtils = JavacTypes.instance(context);
        this.types = Types.instance(context);
        this.processorOptions = this.initProcessorOptions();
        this.unmatchedProcessorOptions = this.initUnmatchedProcessorOptions();
        this.messages = JavacMessages.instance(context);
        this.taskListener = MultiTaskListener.instance(context);
        this.symtab = Symtab.instance(context);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.initialCompleter = ClassReader.instance(context).getCompleter();
        this.chk = Check.instance(context);
        this.initProcessorClassLoader();
    }

    public void setProcessors(Iterable<? extends Processor> processors) {
        Assert.checkNull(this.discoveredProcs);
        this.initProcessorIterator(processors);
    }

    private Set<String> initPlatformAnnotations() {
        HashSet<String> platformAnnotations = new HashSet<String>();
        platformAnnotations.add("java.lang.Deprecated");
        platformAnnotations.add("java.lang.Override");
        platformAnnotations.add("java.lang.SuppressWarnings");
        platformAnnotations.add("java.lang.annotation.Documented");
        platformAnnotations.add("java.lang.annotation.Inherited");
        platformAnnotations.add("java.lang.annotation.Retention");
        platformAnnotations.add("java.lang.annotation.Target");
        return Collections.unmodifiableSet(platformAnnotations);
    }

    private void initProcessorClassLoader() {
        JavaFileManager fileManager = this.context.get(JavaFileManager.class);
        try {
            ClassLoader classLoader = this.processorClassLoader = fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH) : fileManager.getClassLoader(StandardLocation.CLASS_PATH);
            if (this.processorClassLoader != null && this.processorClassLoader instanceof Closeable) {
                this.compiler.closeables = this.compiler.closeables.prepend((Closeable)((Object)this.processorClassLoader));
            }
        }
        catch (SecurityException e) {
            this.processorClassLoaderException = e;
        }
    }

    private void initProcessorIterator(Iterable<? extends Processor> processors) {
        Iterator<Processor> processorIterator;
        if (this.options.isSet(Option.XPRINT)) {
            try {
                Processor processor = (Processor)PrintingProcessor.class.newInstance();
                processorIterator = List.of(processor).iterator();
            }
            catch (Throwable t) {
                AssertionError assertError = new AssertionError((Object)"Problem instantiating PrintingProcessor.");
                ((Throwable)((Object)assertError)).initCause(t);
                throw assertError;
            }
        } else if (processors != null) {
            processorIterator = processors.iterator();
        } else {
            String processorNames = this.options.get(Option.PROCESSOR);
            processorIterator = this.processorClassLoaderException == null ? (processorNames != null ? new NameProcessIterator(processorNames, this.processorClassLoader, this.log) : new ServiceIterator(this.processorClassLoader, this.log)) : this.handleServiceLoaderUnavailability("proc.cant.create.loader", this.processorClassLoaderException);
        }
        this.discoveredProcs = new DiscoveredProcessors(processorIterator);
    }

    private Iterator<Processor> handleServiceLoaderUnavailability(String key, Exception e) {
        JavaFileManager fileManager = this.context.get(JavaFileManager.class);
        if (fileManager instanceof JavacFileManager) {
            Iterable<? extends File> workingPath;
            JavacFileManager standardFileManager = (JavacFileManager)fileManager;
            Iterable<? extends File> iterable = workingPath = fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) ? standardFileManager.getLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH) : standardFileManager.getLocation(StandardLocation.CLASS_PATH);
            if (this.needClassLoader(this.options.get(Option.PROCESSOR), workingPath)) {
                this.handleException(key, e);
            }
        } else {
            this.handleException(key, e);
        }
        java.util.List pl = Collections.emptyList();
        return pl.iterator();
    }

    private void handleException(String key, Exception e) {
        if (e != null) {
            this.log.error(key, e.getLocalizedMessage());
            throw new Abort(e);
        }
        this.log.error(key, new Object[0]);
        throw new Abort();
    }

    public boolean atLeastOneProcessor() {
        return this.discoveredProcs.iterator().hasNext();
    }

    private Map<String, String> initProcessorOptions() {
        Set<String> keySet = this.options.keySet();
        LinkedHashMap<String, String> tempOptions = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            if (!key.startsWith("-A") || key.length() <= 2) continue;
            int sepIndex = key.indexOf(61);
            String candidateKey = null;
            String candidateValue = null;
            if (sepIndex == -1) {
                candidateKey = key.substring(2);
            } else if (sepIndex >= 3) {
                candidateKey = key.substring(2, sepIndex);
                candidateValue = sepIndex < key.length() - 1 ? key.substring(sepIndex + 1) : null;
            }
            tempOptions.put(candidateKey, candidateValue);
        }
        return Collections.unmodifiableMap(tempOptions);
    }

    private Set<String> initUnmatchedProcessorOptions() {
        HashSet<String> unmatchedProcessorOptions = new HashSet<String>();
        unmatchedProcessorOptions.addAll(this.processorOptions.keySet());
        return unmatchedProcessorOptions;
    }

    private void discoverAndRunProcs(Set<TypeElement> annotationsPresent, List<Symbol.ClassSymbol> topLevelClasses, List<Symbol.PackageSymbol> packageInfoFiles) {
        HashMap<String, TypeElement> unmatchedAnnotations = new HashMap<String, TypeElement>(annotationsPresent.size());
        for (TypeElement a : annotationsPresent) {
            unmatchedAnnotations.put(a.getQualifiedName().toString(), a);
        }
        if (unmatchedAnnotations.size() == 0) {
            unmatchedAnnotations.put("", null);
        }
        DiscoveredProcessors.ProcessorStateIterator psi = this.discoveredProcs.iterator();
        Set<Symbol.TypeSymbol> rootElements = new LinkedHashSet<Symbol.TypeSymbol>();
        rootElements.addAll(topLevelClasses);
        rootElements.addAll(packageInfoFiles);
        rootElements = Collections.unmodifiableSet(rootElements);
        JavacRoundEnvironment renv = new JavacRoundEnvironment(false, false, rootElements, this);
        while (unmatchedAnnotations.size() > 0 && psi.hasNext()) {
            ProcessorState ps = psi.next();
            HashSet<String> matchedNames = new HashSet<String>();
            LinkedHashSet<TypeElement> typeElements = new LinkedHashSet<TypeElement>();
            for (Map.Entry entry : unmatchedAnnotations.entrySet()) {
                String unmatchedAnnotationName = (String)entry.getKey();
                if (!ps.annotationSupported(unmatchedAnnotationName)) continue;
                matchedNames.add(unmatchedAnnotationName);
                TypeElement te = (TypeElement)entry.getValue();
                if (te == null) continue;
                typeElements.add(te);
            }
            if (matchedNames.size() <= 0 && !ps.contributed) continue;
            boolean processingResult = this.callProcessor(ps.processor, typeElements, renv);
            ps.contributed = true;
            ps.removeSupportedOptions(this.unmatchedProcessorOptions);
            if (this.printProcessorInfo || this.verbose) {
                this.log.printLines("x.print.processor.info", ps.processor.getClass().getName(), ((Object)matchedNames).toString(), processingResult);
            }
            if (!processingResult) continue;
            unmatchedAnnotations.keySet().removeAll(matchedNames);
        }
        unmatchedAnnotations.remove("");
        if (this.lint && unmatchedAnnotations.size() > 0) {
            unmatchedAnnotations.keySet().removeAll(this.platformAnnotations);
            if (unmatchedAnnotations.size() > 0) {
                this.log.warning("proc.annotations.without.processors", unmatchedAnnotations.keySet());
            }
        }
        psi.runContributingProcs(renv);
        if (this.options.isSet("displayFilerState")) {
            this.filer.displayState();
        }
    }

    private boolean callProcessor(Processor proc, Set<? extends TypeElement> tes, RoundEnvironment renv) {
        try {
            return proc.process(tes, renv);
        }
        catch (ClassReader.BadClassFile ex) {
            this.log.error("proc.cant.access.1", ex.sym, ex.getDetailValue());
            return false;
        }
        catch (Symbol.CompletionFailure ex) {
            StringWriter out = new StringWriter();
            ex.printStackTrace(new PrintWriter(out));
            this.log.error("proc.cant.access", ex.sym, ex.getDetailValue(), out.toString());
            return false;
        }
        catch (ClientCodeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AnnotationProcessingError(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean doProcessing(List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols, Iterable<? extends Symbol.PackageSymbol> pckSymbols, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
        boolean bl;
        boolean bl2;
        Round round;
        boolean bl3;
        boolean moreToDo;
        Set<JCTree.JCCompilationUnit> treesToClean = Collections.newSetFromMap(new IdentityHashMap());
        for (Env<AttrContext> env : this.enter.getEnvs()) {
            treesToClean.add(env.toplevel);
        }
        LinkedHashSet<Symbol.PackageSymbol> specifiedPackages = new LinkedHashSet<Symbol.PackageSymbol>();
        for (Symbol.PackageSymbol packageSymbol : pckSymbols) {
            specifiedPackages.add(packageSymbol);
        }
        this.specifiedPackages = Collections.unmodifiableSet(specifiedPackages);
        Round round2 = new Round(roots, classSymbols, treesToClean, deferredDiagnosticHandler);
        do {
            void var7_10;
            var7_10.run(false, false);
            bl3 = var7_10.unrecoverableError();
            moreToDo = this.moreToDo();
            var7_10.showDiagnostics(bl3 || this.showResolveErrors);
            round = var7_10.next(new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects()), new LinkedHashMap<String, JavaFileObject>(this.filer.getGeneratedClasses()));
            if (!round.unrecoverableError()) continue;
            bl3 = true;
        } while (moreToDo && !bl3);
        round.run(true, bl3);
        round.showDiagnostics(true);
        this.filer.warnIfUnclosedFiles();
        this.warnIfUnmatchedOptions();
        if (this.messager.errorRaised() || this.werror && round.warningCount() > 0 && round.errorCount() > 0) {
            bl2 = true;
        }
        LinkedHashSet<JavaFileObject> newSourceFiles = new LinkedHashSet<JavaFileObject>(this.filer.getGeneratedSourceFileObjects());
        roots = round.roots;
        boolean bl4 = bl = bl2 || this.compiler.errorCount() > 0;
        if (!bl) {
            round.finalCompiler();
        }
        if (newSourceFiles.size() > 0) {
            roots = roots.appendList(this.compiler.parseFiles(newSourceFiles));
        }
        boolean bl5 = bl || this.compiler.errorCount() > 0;
        this.close();
        if (!this.taskListener.isEmpty()) {
            this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING));
        }
        if (bl5) {
            if (this.compiler.errorCount() == 0) {
                ++this.compiler.log.nerrors;
            }
            return true;
        }
        this.compiler.enterTreesIfNeeded(roots);
        return true;
    }

    private void warnIfUnmatchedOptions() {
        if (!this.unmatchedProcessorOptions.isEmpty()) {
            this.log.warning("proc.unmatched.processor.options", this.unmatchedProcessorOptions.toString());
        }
    }

    @Override
    public void close() {
        this.filer.close();
        if (this.discoveredProcs != null) {
            this.discoveredProcs.close();
        }
        this.discoveredProcs = null;
    }

    private List<Symbol.ClassSymbol> getTopLevelClasses(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            for (JCTree node : jCCompilationUnit.defs) {
                if (!node.hasTag(JCTree.Tag.CLASSDEF)) continue;
                Symbol.ClassSymbol sym = ((JCTree.JCClassDecl)node).sym;
                Assert.checkNonNull(sym);
                classes = classes.prepend(sym);
            }
        }
        return classes.reverse();
    }

    private List<Symbol.ClassSymbol> getTopLevelClassesFromClasses(List<? extends Symbol.ClassSymbol> syms) {
        List<Symbol.ClassSymbol> classes = List.nil();
        for (Symbol.ClassSymbol classSymbol : syms) {
            if (this.isPkgInfo(classSymbol)) continue;
            classes = classes.prepend(classSymbol);
        }
        return classes.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFiles(List<? extends JCTree.JCCompilationUnit> units) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (JCTree.JCCompilationUnit jCCompilationUnit : units) {
            if (!this.isPkgInfo(jCCompilationUnit.sourcefile, JavaFileObject.Kind.SOURCE)) continue;
            packages = packages.prepend(jCCompilationUnit.packge);
        }
        return packages.reverse();
    }

    private List<Symbol.PackageSymbol> getPackageInfoFilesFromClasses(List<? extends Symbol.ClassSymbol> syms) {
        List<Symbol.PackageSymbol> packages = List.nil();
        for (Symbol.ClassSymbol classSymbol : syms) {
            if (!this.isPkgInfo(classSymbol)) continue;
            packages = packages.prepend((Symbol.PackageSymbol)classSymbol.owner);
        }
        return packages.reverse();
    }

    private static <T> List<T> join(List<T> list1, List<T> list2) {
        return list1.appendList(list2);
    }

    private boolean isPkgInfo(JavaFileObject fo, JavaFileObject.Kind kind) {
        return fo.isNameCompatible("package-info", kind);
    }

    private boolean isPkgInfo(Symbol.ClassSymbol sym) {
        return this.isPkgInfo(sym.classfile, JavaFileObject.Kind.CLASS) && sym.packge().package_info == sym;
    }

    private boolean needClassLoader(String procNames, Iterable<? extends File> workingpath) {
        if (procNames != null) {
            return true;
        }
        URL[] urls = new URL[1];
        for (File file : workingpath) {
            try {
                urls[0] = file.toURI().toURL();
                if (!ServiceProxy.hasService(Processor.class, urls)) continue;
                return true;
            }
            catch (MalformedURLException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (ServiceProxy.ServiceConfigurationError e) {
                this.log.error("proc.bad.config.file", e.getLocalizedMessage());
                return true;
            }
        }
        return false;
    }

    private boolean moreToDo() {
        return this.filer.newFiles();
    }

    @Override
    public Map<String, String> getOptions() {
        return this.processorOptions;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public Filer getFiler() {
        return this.filer;
    }

    @Override
    public JavacElements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public JavacTypes getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.source);
    }

    @Override
    public Locale getLocale() {
        return this.messages.getCurrentLocale();
    }

    public Set<Symbol.PackageSymbol> getSpecifiedPackages() {
        return this.specifiedPackages;
    }

    private static Pattern importStringToPattern(String s, Processor p, Log log) {
        if (JavacProcessingEnvironment.isValidImportString(s)) {
            return JavacProcessingEnvironment.validImportStringToPattern(s);
        }
        log.warning("proc.malformed.supported.string", s, p.getClass().getName());
        return noMatches;
    }

    public static boolean isValidImportString(String s) {
        if (s.equals("*")) {
            return true;
        }
        boolean valid = true;
        String t = s;
        int index = t.indexOf(42);
        if (index != -1) {
            if (index == t.length() - 1) {
                if (index - 1 >= 0) {
                    valid = t.charAt(index - 1) == '.';
                    t = t.substring(0, t.length() - 2);
                }
            } else {
                return false;
            }
        }
        if (valid) {
            String[] javaIds;
            for (String javaId : javaIds = t.split("\\.", t.length() + 2)) {
                valid &= SourceVersion.isIdentifier(javaId);
            }
        }
        return valid;
    }

    public static Pattern validImportStringToPattern(String s) {
        if (s.equals("*")) {
            return allMatches;
        }
        String s_prime = s.replace(".", "\\.");
        if (s_prime.endsWith("*")) {
            s_prime = s_prime.substring(0, s_prime.length() - 1) + ".+";
        }
        return Pattern.compile(s_prime);
    }

    public Context getContext() {
        return this.context;
    }

    public ClassLoader getProcessorClassLoader() {
        return this.processorClassLoader;
    }

    public String toString() {
        return "javac ProcessingEnvironment";
    }

    public static boolean isValidOptionName(String optionName) {
        for (String s : optionName.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    class ImplicitCompleter
    implements Symbol.Completer {
        private final JCTree.JCCompilationUnit topLevel;

        public ImplicitCompleter(JCTree.JCCompilationUnit topLevel) {
            this.topLevel = topLevel;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            JavacProcessingEnvironment.this.compiler.complete(this.topLevel, (Symbol.ClassSymbol)sym);
        }
    }

    class Round {
        final int number;
        final Log.DeferredDiagnosticHandler deferredDiagnosticHandler;
        List<JCTree.JCCompilationUnit> roots;
        Set<JCTree.JCCompilationUnit> treesToClean;
        Map<String, JavaFileObject> genClassFiles;
        Set<TypeElement> annotationsPresent;
        List<Symbol.ClassSymbol> topLevelClasses;
        List<Symbol.PackageSymbol> packageInfoFiles;

        private Round(int number, Set<JCTree.JCCompilationUnit> treesToClean, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this.number = number;
            if (number == 1) {
                Assert.checkNonNull(deferredDiagnosticHandler);
                this.deferredDiagnosticHandler = deferredDiagnosticHandler;
            } else {
                this.deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(JavacProcessingEnvironment.this.log);
                JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(this.deferredDiagnosticHandler);
            }
            this.topLevelClasses = List.nil();
            this.packageInfoFiles = List.nil();
            this.treesToClean = treesToClean;
        }

        Round(List<JCTree.JCCompilationUnit> roots, List<Symbol.ClassSymbol> classSymbols, Set<JCTree.JCCompilationUnit> treesToClean, Log.DeferredDiagnosticHandler deferredDiagnosticHandler) {
            this(1, treesToClean, deferredDiagnosticHandler);
            this.roots = roots;
            this.genClassFiles = new HashMap<String, JavaFileObject>();
            this.topLevelClasses = this$0.getTopLevelClasses(roots).prependList(classSymbols.reverse());
            this.packageInfoFiles = this$0.getPackageInfoFiles(roots);
            this.findAnnotationsPresent();
        }

        private Round(Round prev, Set<JavaFileObject> newSourceFiles, Map<String, JavaFileObject> newClassFiles) {
            this(prev.number + 1, prev.treesToClean, null);
            prev.newRound();
            this.genClassFiles = prev.genClassFiles;
            List<JCTree.JCCompilationUnit> parsedFiles = this$0.compiler.parseFiles(newSourceFiles);
            this.roots = prev.roots.appendList(parsedFiles);
            if (this.unrecoverableError()) {
                return;
            }
            this.enterClassFiles(this.genClassFiles);
            List<Symbol.ClassSymbol> newClasses = this.enterClassFiles(newClassFiles);
            this.genClassFiles.putAll(newClassFiles);
            this.enterTrees(this.roots);
            if (this.unrecoverableError()) {
                return;
            }
            this.topLevelClasses = JavacProcessingEnvironment.join(this$0.getTopLevelClasses(parsedFiles), this$0.getTopLevelClassesFromClasses(newClasses));
            this.packageInfoFiles = JavacProcessingEnvironment.join(this$0.getPackageInfoFiles(parsedFiles), this$0.getPackageInfoFilesFromClasses(newClasses));
            this.findAnnotationsPresent();
        }

        Round next(Set<JavaFileObject> newSourceFiles, Map<String, JavaFileObject> newClassFiles) {
            return new Round(this, newSourceFiles, newClassFiles);
        }

        void finalCompiler() {
            this.newRound();
        }

        int errorCount() {
            return JavacProcessingEnvironment.this.compiler.errorCount();
        }

        int warningCount() {
            return JavacProcessingEnvironment.this.compiler.warningCount();
        }

        boolean unrecoverableError() {
            if (JavacProcessingEnvironment.this.messager.errorRaised()) {
                return true;
            }
            for (JCDiagnostic d : this.deferredDiagnosticHandler.getDiagnostics()) {
                switch (d.getKind()) {
                    case WARNING: {
                        if (!JavacProcessingEnvironment.this.werror) break;
                        return true;
                    }
                    case ERROR: {
                        if (!JavacProcessingEnvironment.this.fatalErrors && d.isFlagSet(JCDiagnostic.DiagnosticFlag.RECOVERABLE)) break;
                        return true;
                    }
                }
            }
            return false;
        }

        void findAnnotationsPresent() {
            ComputeAnnotationSet annotationComputer = new ComputeAnnotationSet(JavacProcessingEnvironment.this.elementUtils);
            this.annotationsPresent = new LinkedHashSet<TypeElement>();
            for (Symbol.ClassSymbol classSym : this.topLevelClasses) {
                annotationComputer.scan((Element)classSym, this.annotationsPresent);
            }
            for (Symbol.PackageSymbol pkgSym : this.packageInfoFiles) {
                annotationComputer.scan((Element)pkgSym, this.annotationsPresent);
            }
        }

        private List<Symbol.ClassSymbol> enterClassFiles(Map<String, JavaFileObject> classFiles) {
            List<Symbol.ClassSymbol> list = List.nil();
            for (Map.Entry<String, JavaFileObject> entry : classFiles.entrySet()) {
                Symbol.ClassSymbol cs;
                Name name = JavacProcessingEnvironment.this.names.fromString(entry.getKey());
                JavaFileObject file = entry.getValue();
                if (file.getKind() != JavaFileObject.Kind.CLASS) {
                    throw new AssertionError(file);
                }
                if (JavacProcessingEnvironment.this.isPkgInfo(file, JavaFileObject.Kind.CLASS)) {
                    Name packageName = Convert.packagePart(name);
                    Symbol.PackageSymbol p = JavacProcessingEnvironment.this.symtab.enterPackage(packageName);
                    if (p.package_info == null) {
                        p.package_info = JavacProcessingEnvironment.this.symtab.enterClass(Convert.shortName(name), p);
                    }
                    cs = p.package_info;
                    cs.reset();
                    if (cs.classfile == null) {
                        cs.classfile = file;
                    }
                    cs.completer = JavacProcessingEnvironment.this.initialCompleter;
                } else {
                    cs = JavacProcessingEnvironment.this.symtab.enterClass(name);
                    cs.reset();
                    cs.classfile = file;
                    cs.completer = JavacProcessingEnvironment.this.initialCompleter;
                }
                list = list.prepend(cs);
            }
            return list.reverse();
        }

        private void enterTrees(List<JCTree.JCCompilationUnit> roots) {
            JavacProcessingEnvironment.this.compiler.enterTrees(roots);
        }

        void run(boolean lastRound, boolean errorStatus) {
            this.printRoundInfo(lastRound);
            if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                JavacProcessingEnvironment.this.taskListener.started(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
            }
            try {
                if (lastRound) {
                    JavacProcessingEnvironment.this.filer.setLastRound(true);
                    Set emptyRootElements = Collections.emptySet();
                    JavacRoundEnvironment renv = new JavacRoundEnvironment(true, errorStatus, emptyRootElements, JavacProcessingEnvironment.this);
                    JavacProcessingEnvironment.this.discoveredProcs.iterator().runContributingProcs(renv);
                } else {
                    JavacProcessingEnvironment.this.discoverAndRunProcs(this.annotationsPresent, this.topLevelClasses, this.packageInfoFiles);
                }
            }
            catch (Throwable t) {
                this.deferredDiagnosticHandler.reportDeferredDiagnostics();
                JavacProcessingEnvironment.this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
                JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(null);
                throw t;
            }
            finally {
                if (!JavacProcessingEnvironment.this.taskListener.isEmpty()) {
                    JavacProcessingEnvironment.this.taskListener.finished(new TaskEvent(TaskEvent.Kind.ANNOTATION_PROCESSING_ROUND));
                }
            }
        }

        void showDiagnostics(boolean showAll) {
            EnumSet<Diagnostic.Kind> kinds = EnumSet.allOf(Diagnostic.Kind.class);
            if (!showAll) {
                kinds.remove((Object)Diagnostic.Kind.ERROR);
            }
            this.deferredDiagnosticHandler.reportDeferredDiagnostics(kinds);
            JavacProcessingEnvironment.this.log.popDiagnosticHandler(this.deferredDiagnosticHandler);
            JavacProcessingEnvironment.this.compiler.setDeferredDiagnosticHandler(null);
        }

        private void printRoundInfo(boolean lastRound) {
            if (JavacProcessingEnvironment.this.printRounds || JavacProcessingEnvironment.this.verbose) {
                List<Object> tlc = lastRound ? List.nil() : this.topLevelClasses;
                Set<Object> ap = lastRound ? Collections.emptySet() : this.annotationsPresent;
                JavacProcessingEnvironment.this.log.printLines("x.print.rounds", this.number, "{" + tlc.toString(", ") + "}", ap, lastRound);
            }
        }

        private void newRound() {
            for (Env<AttrContext> env : JavacProcessingEnvironment.this.enter.getEnvs()) {
                this.treesToClean.add(env.toplevel);
            }
            for (JCTree.JCCompilationUnit node : this.treesToClean) {
                JavacProcessingEnvironment.this.treeCleaner.scan(node);
            }
            JavacProcessingEnvironment.this.chk.newRound();
            JavacProcessingEnvironment.this.enter.newRound();
            JavacProcessingEnvironment.this.filer.newRound();
            JavacProcessingEnvironment.this.messager.newRound();
            JavacProcessingEnvironment.this.compiler.newRound();
            JavacProcessingEnvironment.this.types.newRound();
            boolean foundError = false;
            for (Symbol.ClassSymbol cs : ((JavacProcessingEnvironment)JavacProcessingEnvironment.this).symtab.classes.values()) {
                if (cs.kind != 63) continue;
                foundError = true;
                break;
            }
            if (foundError) {
                for (Symbol.ClassSymbol cs : ((JavacProcessingEnvironment)JavacProcessingEnvironment.this).symtab.classes.values()) {
                    if (cs.classfile == null && cs.kind != 63) continue;
                    cs.reset();
                    cs.type = new Type.ClassType(cs.type.getEnclosingType(), null, cs);
                    if (cs.completer != null) continue;
                    cs.completer = JavacProcessingEnvironment.this.initialCompleter;
                }
            }
        }
    }

    public static class ComputeAnnotationSet
    extends ElementScanner8<Set<TypeElement>, Set<TypeElement>> {
        final Elements elements;

        public ComputeAnnotationSet(Elements elements) {
            this.elements = elements;
        }

        @Override
        public Set<TypeElement> visitPackage(PackageElement e, Set<TypeElement> p) {
            return p;
        }

        @Override
        public Set<TypeElement> visitType(TypeElement e, Set<TypeElement> p) {
            this.scan(e.getTypeParameters(), p);
            return (Set)super.visitType(e, p);
        }

        @Override
        public Set<TypeElement> visitExecutable(ExecutableElement e, Set<TypeElement> p) {
            this.scan(e.getTypeParameters(), p);
            return (Set)super.visitExecutable(e, p);
        }

        void addAnnotations(Element e, Set<TypeElement> p) {
            for (AnnotationMirror annotationMirror : this.elements.getAllAnnotationMirrors(e)) {
                Element e2 = annotationMirror.getAnnotationType().asElement();
                p.add((TypeElement)e2);
            }
        }

        @Override
        public Set<TypeElement> scan(Element e, Set<TypeElement> p) {
            this.addAnnotations(e, p);
            return (Set)super.scan(e, p);
        }
    }

    class DiscoveredProcessors
    implements Iterable<ProcessorState> {
        Iterator<? extends Processor> processorIterator;
        ArrayList<ProcessorState> procStateList;

        public ProcessorStateIterator iterator() {
            return new ProcessorStateIterator(this);
        }

        DiscoveredProcessors(Iterator<? extends Processor> processorIterator) {
            this.processorIterator = processorIterator;
            this.procStateList = new ArrayList();
        }

        public void close() {
            if (this.processorIterator != null && this.processorIterator instanceof ServiceIterator) {
                ((ServiceIterator)this.processorIterator).close();
            }
        }

        class ProcessorStateIterator
        implements Iterator<ProcessorState> {
            DiscoveredProcessors psi;
            Iterator<ProcessorState> innerIter;
            boolean onProcInterator;

            ProcessorStateIterator(DiscoveredProcessors psi) {
                this.psi = psi;
                this.innerIter = psi.procStateList.iterator();
                this.onProcInterator = false;
            }

            @Override
            public ProcessorState next() {
                if (!this.onProcInterator) {
                    if (this.innerIter.hasNext()) {
                        return this.innerIter.next();
                    }
                    this.onProcInterator = true;
                }
                if (this.psi.processorIterator.hasNext()) {
                    ProcessorState ps = new ProcessorState(this.psi.processorIterator.next(), JavacProcessingEnvironment.this.log, JavacProcessingEnvironment.this.source, JavacProcessingEnvironment.this);
                    this.psi.procStateList.add(ps);
                    return ps;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.onProcInterator) {
                    return this.psi.processorIterator.hasNext();
                }
                return this.innerIter.hasNext() || this.psi.processorIterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void runContributingProcs(RoundEnvironment re) {
                if (!this.onProcInterator) {
                    Set emptyTypeElements = Collections.emptySet();
                    while (this.innerIter.hasNext()) {
                        ProcessorState ps = this.innerIter.next();
                        if (!ps.contributed) continue;
                        JavacProcessingEnvironment.this.callProcessor(ps.processor, emptyTypeElements, re);
                    }
                }
            }
        }
    }

    static class ProcessorState {
        public Processor processor;
        public boolean contributed;
        private ArrayList<Pattern> supportedAnnotationPatterns;
        private ArrayList<String> supportedOptionNames;

        ProcessorState(Processor p, Log log, Source source, ProcessingEnvironment env) {
            this.processor = p;
            this.contributed = false;
            try {
                this.processor.init(env);
                this.checkSourceVersionCompatibility(source, log);
                this.supportedAnnotationPatterns = new ArrayList();
                for (String importString : this.processor.getSupportedAnnotationTypes()) {
                    this.supportedAnnotationPatterns.add(JavacProcessingEnvironment.importStringToPattern(importString, this.processor, log));
                }
                this.supportedOptionNames = new ArrayList();
                for (String optionName : this.processor.getSupportedOptions()) {
                    if (!this.checkOptionName(optionName, log)) continue;
                    this.supportedOptionNames.add(optionName);
                }
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
        }

        private void checkSourceVersionCompatibility(Source source, Log log) {
            SourceVersion procSourceVersion = this.processor.getSupportedSourceVersion();
            if (procSourceVersion.compareTo(Source.toSourceVersion(source)) < 0) {
                log.warning("proc.processor.incompatible.source.version", new Object[]{procSourceVersion, this.processor.getClass().getName(), source.name});
            }
        }

        private boolean checkOptionName(String optionName, Log log) {
            boolean valid = JavacProcessingEnvironment.isValidOptionName(optionName);
            if (!valid) {
                log.error("proc.processor.bad.option.name", optionName, this.processor.getClass().getName());
            }
            return valid;
        }

        public boolean annotationSupported(String annotationName) {
            for (Pattern p : this.supportedAnnotationPatterns) {
                if (!p.matcher(annotationName).matches()) continue;
                return true;
            }
            return false;
        }

        public void removeSupportedOptions(Set<String> unmatchedProcessorOptions) {
            unmatchedProcessorOptions.removeAll(this.supportedOptionNames);
        }
    }

    private static class NameProcessIterator
    implements Iterator<Processor> {
        Processor nextProc = null;
        Iterator<String> names;
        ClassLoader processorCL;
        Log log;

        NameProcessIterator(String names, ClassLoader processorCL, Log log) {
            this.names = Arrays.asList(names.split(",")).iterator();
            this.processorCL = processorCL;
            this.log = log;
        }

        @Override
        public boolean hasNext() {
            Processor processor;
            if (this.nextProc != null) {
                return true;
            }
            if (!this.names.hasNext()) {
                return false;
            }
            String processorName = this.names.next();
            try {
                try {
                    processor = (Processor)this.processorCL.loadClass(processorName).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.error("proc.processor.not.found", processorName);
                    return false;
                }
                catch (ClassCastException cce) {
                    this.log.error("proc.processor.wrong.type", processorName);
                    return false;
                }
                catch (Exception e) {
                    this.log.error("proc.processor.cant.instantiate", processorName);
                    return false;
                }
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AnnotationProcessingError(t);
            }
            this.nextProc = processor;
            return true;
        }

        @Override
        public Processor next() {
            if (this.hasNext()) {
                Processor p = this.nextProc;
                this.nextProc = null;
                return p;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ServiceIterator
    implements Iterator<Processor> {
        private Iterator<Processor> iterator;
        private Log log;
        private ServiceLoader<Processor> loader;

        ServiceIterator(ClassLoader classLoader, Log log) {
            this.log = log;
            try {
                try {
                    this.loader = ServiceLoader.load(Processor.class, classLoader);
                    this.iterator = this.loader.iterator();
                }
                catch (Exception e) {
                    this.iterator = JavacProcessingEnvironment.this.handleServiceLoaderUnavailability("proc.no.service", null);
                }
            }
            catch (Throwable t) {
                log.error("proc.service.problem", new Object[0]);
                throw new Abort(t);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (ServiceConfigurationError sce) {
                this.log.error("proc.bad.config.file", sce.getLocalizedMessage());
                throw new Abort(sce);
            }
            catch (Throwable t) {
                throw new Abort(t);
            }
        }

        @Override
        public Processor next() {
            try {
                return this.iterator.next();
            }
            catch (ServiceConfigurationError sce) {
                this.log.error("proc.bad.config.file", sce.getLocalizedMessage());
                throw new Abort(sce);
            }
            catch (Throwable t) {
                throw new Abort(t);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            if (this.loader != null) {
                try {
                    this.loader.reload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

