/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.util.ByteSequence;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackConsumer,
StackProducer {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] match;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] indices;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] targets;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int fixed_length;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int match_length;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int padding = 0;

    Select() {
    }

    Select(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] match, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] targets, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle defaultTarget) {
        super(opcode, null);
        this.match = match;
        this.targets = targets;
        this.setTarget(defaultTarget);
        for (InstructionHandle target2 : targets) {
            Select.notifyTarget(null, target2, this);
        }
        this.match_length = match.length;
        if (this.match_length != targets.length) {
            throw new ClassGenException("Match and target array have not the same length: Match length: " + match.length + " Target length: " + targets.length);
        }
        this.indices = new int[this.match_length];
    }

    @Override
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int updatePosition(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int offset, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int max_offset) {
        this.setPosition(this.getPosition() + offset);
        short old_length = (short)super.getLength();
        this.padding = (4 - (this.getPosition() + 1) % 4) % 4;
        super.setLength((short)(this.fixed_length + this.padding));
        return super.getLength() - old_length;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        out.writeByte(super.getOpcode());
        for (int i = 0; i < this.padding; ++i) {
            out.writeByte(0);
        }
        super.setIndex(this.getTargetOffset());
        out.writeInt(super.getIndex());
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        for (int i = 0; i < this.padding; ++i) {
            bytes.readByte();
        }
        super.setIndex(bytes.readInt());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        StringBuilder buf = new StringBuilder(super.toString(verbose));
        if (verbose) {
            for (int i = 0; i < this.match_length; ++i) {
                String s = "null";
                if (this.targets[i] != null) {
                    s = this.targets[i].getInstruction().toString();
                }
                buf.append("(").append(this.match[i]).append(", ").append(s).append(" = {").append(this.indices[i]).append("})");
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    public void setTarget(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
        Select.notifyTarget(this.targets[i], target, this);
        this.targets[i] = target;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle new_ih) {
        boolean targeted = false;
        if (super.getTarget() == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        for (int i = 0; i < this.targets.length; ++i) {
            if (this.targets[i] != old_ih) continue;
            targeted = true;
            this.setTarget(i, new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle ih) {
        if (super.getTarget() == ih) {
            return true;
        }
        for (InstructionHandle target2 : this.targets) {
            if (target2 != ih) continue;
            return true;
        }
        return false;
    }

    @SideEffectFree
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CloneNotSupportedException {
        Select copy = (Select)super.clone();
        copy.match = (int[])this.match.clone();
        copy.indices = (int[])this.indices.clone();
        copy.targets = (InstructionHandle[])this.targets.clone();
        return copy;
    }

    @Override
    void dispose() {
        super.dispose();
        for (InstructionHandle target2 : this.targets) {
            target2.removeTargeter(this);
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getMatchs() {
        return this.match;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getIndices() {
        return this.indices;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getTargets() {
        return this.targets;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMatch(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        return this.match[index];
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndices(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        return this.indices[index];
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle getTarget(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        return this.targets[index];
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getFixed_length() {
        return this.fixed_length;
    }

    final void setFixed_length(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int fixed_length) {
        this.fixed_length = fixed_length;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMatch_length() {
        return this.match_length;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int setMatch_length(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int match_length) {
        this.match_length = match_length;
        return match_length;
    }

    final void setMatch(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int value) {
        this.match[index] = value;
    }

    final void setIndices(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] array) {
        this.indices = array;
    }

    final void setMatches(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] array) {
        this.match = array;
    }

    final void setTargets(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] array) {
        this.targets = array;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getPadding() {
        return this.padding;
    }

    final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int setIndices(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int value) {
        this.indices[i] = value;
        return value;
    }
}

