/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ClassElementValue
extends ElementValue {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx;

    public ClassElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) {
        super(type, cpool);
        this.idx = idx;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.idx;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getClassString() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.idx, (byte)1);
        return c.getBytes();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String stringifyValue() {
        ConstantUtf8 cu8 = (ConstantUtf8)super.getConstantPool().getConstant(this.idx, (byte)1);
        return cu8.getBytes();
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.idx);
    }
}

