/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel;

import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.SyntheticRepository;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class Repository {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown org.apache.bcel.util.Repository repository = SyntheticRepository.getInstance();

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown org.apache.bcel.util.Repository getRepository() {
        return repository;
    }

    public static void setRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown org.apache.bcel.util.Repository rep) {
        repository = rep;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass lookupClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return repository.loadClass(class_name);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass lookupClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @InternedDistinct @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return repository.loadClass(clazz);
    }

    public static @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassPath.ClassFile lookupClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) {
        try {
            ClassPath path = repository.getClassPath();
            if (path == null) {
                return null;
            }
            return path.getClassFile(class_name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void clearCache() {
        repository.clear();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass addClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        JavaClass old = repository.findClass(clazz.getClassName());
        repository.storeClass(clazz);
        return old;
    }

    public static void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String clazz) {
        repository.removeClass(repository.findClass(clazz));
    }

    public static void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        repository.removeClass(clazz);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getSuperClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return clazz.getSuperClasses();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getSuperClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        JavaClass jc = Repository.lookupClass(class_name);
        return Repository.getSuperClasses(jc);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaces(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return clazz.getAllInterfaces();
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaces(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.getInterfaces(Repository.lookupClass(class_name));
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean instanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass super_class) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return clazz.instanceOf(super_class);
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean instanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String super_class) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.instanceOf(Repository.lookupClass(clazz), Repository.lookupClass(super_class));
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean instanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String super_class) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.instanceOf(clazz, Repository.lookupClass(super_class));
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean instanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass super_class) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.instanceOf(Repository.lookupClass(clazz), super_class);
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean implementationOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass inter) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return clazz.implementationOf(inter);
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean implementationOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String inter) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.implementationOf(Repository.lookupClass(clazz), Repository.lookupClass(inter));
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean implementationOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String inter) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.implementationOf(clazz, Repository.lookupClass(inter));
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean implementationOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass inter) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        return Repository.implementationOf(Repository.lookupClass(clazz), inter);
    }
}

