/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.mavenplugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathUtils {
    private static final String CHECKER_FRAMEWORK_GROUPD_ID = "org.checkerframework";
    private static final String DEFAULT_INCLUSION_PATTERN = "**/*.java";

    public static File getFrameworkJar(String artifactId, String checkerFrameworkVersion, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, List<?> remoteArtifactRepositories, ArtifactRepository localRepository) throws MojoExecutionException {
        Artifact checkersArtifact;
        try {
            checkersArtifact = artifactFactory.createExtensionArtifact(CHECKER_FRAMEWORK_GROUPD_ID, artifactId, VersionRange.createFromVersionSpec((String)checkerFrameworkVersion));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Wrong version: " + checkerFrameworkVersion + " of Checker Framework specified.", (Exception)((Object)e));
        }
        try {
            artifactResolver.resolve(checkersArtifact, remoteArtifactRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to find version " + checkerFrameworkVersion + " of Checker Framework.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to resolve version " + checkerFrameworkVersion + " of Checker Framework.", (Exception)((Object)e));
        }
        return checkersArtifact.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVersion(File versionFile, String version) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(versionFile));
            bw.write(version);
            bw.newLine();
            bw.flush();
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readVersion(File versionFile) throws IOException {
        String line;
        if (!versionFile.exists() || versionFile.length() == 0L) {
            return null;
        }
        BufferedReader vfReader = new BufferedReader(new FileReader(versionFile));
        try {
            line = vfReader.readLine();
            if (line == null) {
                String string = null;
                return string;
            }
        }
        finally {
            vfReader.close();
        }
        return line;
    }

    public static String getExecutablePath(String executable, ToolchainManager toolchainManager, MavenSession session) {
        File execFile = new File(executable);
        if (execFile.exists()) {
            return execFile.getAbsolutePath();
        }
        Toolchain tc = toolchainManager.getToolchainFromBuildContext("jdk", session);
        if (tc != null) {
            executable = tc.findTool(executable);
        }
        return executable;
    }

    public static List<String> scanForSources(List<?> compileSourceRoots, Set<String> sourceIncludes, Set<String> sourceExcludes) {
        if (sourceIncludes.isEmpty()) {
            sourceIncludes.add(DEFAULT_INCLUSION_PATTERN);
        }
        ArrayList<String> sources = new ArrayList<String>();
        for (Object compileSourceRoot : compileSourceRoots) {
            String[] sourcesFromSourceRoot;
            File compileSourceRootFile = new File(compileSourceRoot.toString());
            for (String sourceFromSourceRoot : sourcesFromSourceRoot = PathUtils.scanForSources(compileSourceRootFile, sourceIncludes, sourceExcludes)) {
                sources.add(new File(compileSourceRootFile, sourceFromSourceRoot).getAbsolutePath());
            }
        }
        return sources;
    }

    private static String[] scanForSources(File sourceDir, Set<String> sourceIncludes, Set<String> sourceExcludes) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setFollowSymlinks(true);
        ds.setBasedir(sourceDir);
        ds.setIncludes(sourceIncludes.toArray(new String[sourceIncludes.size()]));
        ds.setExcludes(sourceExcludes.toArray(new String[sourceExcludes.size()]));
        ds.addDefaultExcludes();
        try {
            ds.scan();
        }
        catch (IllegalStateException e) {
            return new String[0];
        }
        return ds.getIncludedFiles();
    }

    public static final void copyFiles(File dest, List<File> inputFiles, List<String> outputFileNames) throws IOException {
        if (inputFiles.size() != outputFileNames.size()) {
            String inputFilePaths = PathUtils.joinFilePaths(inputFiles);
            String outputFileNamesStr = StringUtils.join(outputFileNames.iterator(), (String)", ");
            throw new RuntimeException("Number of input files and file names must be equal! Dest Dir( " + dest.getAbsolutePath() + ") Input Files (" + inputFilePaths + " ) OutputFileNames (" + outputFileNamesStr + ")");
        }
        for (int i = 0; i < inputFiles.size(); ++i) {
            FileUtils.copyFile((File)inputFiles.get(i), (File)new File(dest, outputFileNames.get(i)));
        }
    }

    public static String joinFilePaths(List<File> files) {
        String inputFilePaths = "";
        boolean comma = false;
        for (File file : files) {
            if (comma) {
                inputFilePaths = inputFilePaths + ", ";
            } else {
                comma = true;
            }
            inputFilePaths = inputFilePaths + file.getAbsolutePath();
        }
        return inputFilePaths;
    }
}

