/*
 * Copyright (c) 2001, 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.io;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "index", "interning" })
@UsesObjectEquals
class Bits {

    static boolean getBoolean(byte[] b, int off);

    static char getChar(byte[] b, int off);

    static short getShort(byte[] b, int off);

    static int getInt(byte[] b, int off);

    static float getFloat(byte[] b, int off);

    static long getLong(byte[] b, int off);

    static double getDouble(byte[] b, int off);

    static void putBoolean(byte[] b, int off, boolean val);

    static void putChar(byte[] b, int off, char val);

    static void putShort(byte[] b, int off, short val);

    static void putInt(byte[] b, int off, int val);

    static void putFloat(byte[] b, int off, float val);

    static void putLong(byte[] b, int off, long val);

    static void putDouble(byte[] b, int off, double val);
}
