/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.formats.html;

import org.checkerframework.dataflow.qual.Pure;
import jdk.javadoc.internal.doclets.formats.html.markup.Table;
import jdk.javadoc.internal.doclets.formats.html.markup.TableHeader;
import java.util.*;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import com.sun.source.doctree.DocTree;
import jdk.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.Links;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import jdk.javadoc.internal.doclets.toolkit.Resources;
import jdk.javadoc.internal.doclets.toolkit.taglets.DeprecatedTaglet;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import static javax.lang.model.element.Modifier.*;

public abstract class AbstractMemberWriter implements MemberSummaryWriter {

    protected final HtmlConfiguration configuration;

    protected final Utils utils;

    protected final SubWriterHolderWriter writer;

    protected final Contents contents;

    protected final Resources resources;

    protected final Links links;

    protected final TypeElement typeElement;

    public final boolean nodepr;

    protected boolean printedSummaryHeader;

    public AbstractMemberWriter(SubWriterHolderWriter writer, TypeElement typeElement) {
    }

    public AbstractMemberWriter(SubWriterHolderWriter writer) {
    }

    public abstract void addSummaryLabel(Content memberTree);

    public abstract TableHeader getSummaryTableHeader(Element member);

    protected abstract Table createSummaryTable();

    public abstract void addInheritedSummaryLabel(TypeElement typeElement, Content inheritedTree);

    public abstract void addSummaryAnchor(TypeElement typeElement, Content memberTree);

    public abstract void addInheritedSummaryAnchor(TypeElement typeElement, Content inheritedTree);

    protected abstract void addSummaryType(Element member, Content tdSummaryType);

    protected void addSummaryLink(TypeElement typeElement, Element member, Content tdSummary);

    protected abstract void addSummaryLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element member, Content tdSummary);

    protected abstract void addInheritedSummaryLink(TypeElement typeElement, Element member, Content linksTree);

    protected abstract Content getDeprecatedLink(Element member);

    protected void addName(String name, Content htmltree);

    protected void addModifiers(Element member, Content htmltree);

    protected CharSequence makeSpace(int len);

    protected void addModifierAndType(Element member, TypeMirror type, Content tdSummaryType);

    protected void addDeprecatedInfo(Element member, Content contentTree);

    protected void addComment(Element member, Content htmltree);

    protected String name(Element member);

    protected Content getHead(Element member);

    @Pure
    protected boolean isInherited(Element ped);

    protected void addUseInfo(List<? extends Element> mems, Content heading, String tableSummary, Content contentTree);

    protected void serialWarning(Element e, String key, String a1, String a2);

    @Override
    public void addMemberSummary(TypeElement tElement, Element member, List<? extends DocTree> firstSentenceTags);

    @Override
    public void addInheritedMemberSummary(TypeElement tElement, Element nestedClass, boolean isFirst, boolean isLast, Content linksTree);

    @Override
    public Content getInheritedSummaryHeader(TypeElement tElement);

    @Override
    public Content getInheritedSummaryLinksTree();

    @Override
    public Content getSummaryTableTree(TypeElement tElement);

    @Override
    public Content getMemberTree(Content memberTree);

    public Content getMemberTree(Content memberTree, boolean isLastContent);
}
