/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.dataflow.qual.Pure;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.CollationKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.FileObject;
import com.sun.javadoc.*;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.JCTree.JCCompilationUnit;
import com.sun.tools.javac.util.Position;

@Deprecated()
@SuppressWarnings("removal")
public abstract class DocImpl implements Doc, Comparable<Object> {

    protected final DocEnv env;

    protected TreePath treePath;

    protected String documentation;

    protected String documentation();

    Comment comment();

    public String commentText();

    public Tag[] tags();

    public Tag[] tags(String tagname);

    public SeeTag[] seeTags();

    public Tag[] inlineTags();

    public Tag[] firstSentenceTags();

    String readHTMLDocumentation(InputStream input, FileObject filename) throws IOException;

    public String getRawCommentText();

    public void setRawCommentText(String rawDocumentation);

    void setTreePath(TreePath treePath);

    CollationKey key();

    CollationKey generateKey();

    @Override
    public String toString();

    public abstract String name();

    @BinaryName
    public abstract String qualifiedName();

    public int compareTo(Object obj);

    @Pure
    public boolean isField();

    @Pure
    public boolean isEnumConstant();

    @Pure
    public boolean isConstructor();

    @Pure
    public boolean isMethod();

    @Pure
    public boolean isAnnotationTypeElement();

    @Pure
    public boolean isInterface();

    @Pure
    public boolean isException();

    @Pure
    public boolean isError();

    @Pure
    public boolean isEnum();

    @Pure
    public boolean isAnnotationType();

    @Pure
    public boolean isOrdinaryClass();

    @Pure
    public boolean isClass();

    public abstract boolean isIncluded();

    public SourcePosition position();
}
