/*
 * Copyright (c) 2001, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.java.util.jar.pack;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.util.Arrays;
import static com.sun.java.util.jar.pack.Constants.*;

class Instruction {

    protected byte[] bytes;

    protected int pc;

    protected int bc;

    protected int w;

    protected int length;

    protected boolean special;

    protected Instruction(byte[] bytes, int pc, int bc, int w, int length) {
    }

    public int getBC();

    public boolean isWide();

    public byte[] getBytes();

    public int getPC();

    public int getLength();

    public int getNextPC();

    public Instruction next();

    public boolean isNonstandard();

    public void setNonstandardLength(int length);

    public Instruction forceNextPC(int nextpc);

    public static Instruction at(byte[] bytes, int pc);

    public static Instruction at(byte[] bytes, int pc, Instruction reuse);

    public byte getCPTag();

    public int getCPIndex();

    public void setCPIndex(int cpi);

    public ConstantPool.Entry getCPRef(ConstantPool.Entry[] cpMap);

    public int getLocalSlot();

    public int getBranchLabel();

    public void setBranchLabel(int targetPC);

    public int getConstant();

    public void setConstant(int con);

    public abstract static class Switch extends Instruction {

        public abstract int getCaseCount();

        public abstract int getCaseValue(int n);

        public abstract int getCaseLabel(int n);

        public abstract void setCaseCount(int caseCount);

        public abstract void setCaseValue(int n, int value);

        public abstract void setCaseLabel(int n, int targetPC);

        protected abstract int getLength(int caseCount);

        public int getDefaultLabel();

        public void setDefaultLabel(int targetPC);

        protected int apc;

        protected int intAt(int n);

        protected void setIntAt(int n, int x);

        protected Switch(byte[] bytes, int pc, int bc) {
        }

        public int getAlignedPC();

        public String toString();

        public static int alignPC(int apc);
    }

    public static class TableSwitch extends Switch {

        public int getLowCase();

        public int getHighCase();

        public int getCaseCount();

        public int getCaseValue(int n);

        public int getCaseLabel(int n);

        public void setLowCase(int val);

        public void setHighCase(int val);

        public void setCaseLabel(int n, int tpc);

        public void setCaseCount(int caseCount);

        public void setCaseValue(int n, int val);

        protected int getLength(int caseCount);
    }

    public static class LookupSwitch extends Switch {

        public int getCaseCount();

        public int getCaseValue(int n);

        public int getCaseLabel(int n);

        public void setCaseCount(int caseCount);

        public void setCaseValue(int n, int val);

        public void setCaseLabel(int n, int tpc);

        protected int getLength(int caseCount);
    }

    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object o);

    public int hashCode();

    public boolean equals(Instruction that);

    static String labstr(int pc);

    public String toString();

    public String toString(ConstantPool.Entry[] cpMap);

    public int getIntAt(int off);

    public int getShortAt(int off);

    public int getByteAt(int off);

    public static int getInt(byte[] bytes, int pc);

    public static int getShort(byte[] bytes, int pc);

    public static int getByte(byte[] bytes, int pc);

    public static void setInt(byte[] bytes, int pc, int x);

    public static void setShort(byte[] bytes, int pc, int x);

    public static void setByte(byte[] bytes, int pc, int x);

    public static boolean isNonstandard(int bc);

    public static int opLength(int bc);

    public static int opWideLength(int bc);

    public static boolean isLocalSlotOp(int bc);

    public static boolean isBranchOp(int bc);

    public static boolean isCPRefOp(int bc);

    public static byte getCPRefOpTag(int bc);

    public static boolean isFieldOp(int bc);

    public static boolean isInvokeInitOp(int bc);

    public static boolean isSelfLinkerOp(int bc);

    public static String byteName(int bc);

    public static void opcodeChecker(byte[] code, ConstantPool.Entry[] cpMap, Package.Version clsVersion) throws FormatException;

    static class FormatException extends IOException {
    }
}
