/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.AssignExpression;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.ConditionalExpression;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldUpdater;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.LengthExpression;
import sun.tools.tree.MethodExpression;
import sun.tools.tree.NotEqualExpression;
import sun.tools.tree.NullExpression;
import sun.tools.tree.StringExpression;
import sun.tools.tree.SuperExpression;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.Vset;

public class FieldExpression
extends UnaryExpression {
    Identifier id;
    MemberDefinition field;
    Expression implementation;
    ClassDefinition clazz;
    private ClassDefinition superBase;

    public FieldExpression(long l, Expression expression, Identifier identifier) {
        super(46, l, Type.tError, expression);
        this.id = identifier;
    }

    public FieldExpression(long l, Expression expression, MemberDefinition memberDefinition) {
        super(46, l, memberDefinition.getType(), expression);
        this.id = memberDefinition.getName();
        this.field = memberDefinition;
    }

    @Override
    public Expression getImplementation() {
        if (this.implementation != null) {
            return this.implementation;
        }
        return this;
    }

    private boolean isQualSuper() {
        return this.superBase != null;
    }

    public static Identifier toIdentifier(Expression expression) {
        StringBuffer stringBuffer = new StringBuffer();
        while (expression.op == 46) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            if (fieldExpression.id == idThis || fieldExpression.id == idClass) {
                return null;
            }
            stringBuffer.insert(0, fieldExpression.id);
            stringBuffer.insert(0, '.');
            expression = fieldExpression.right;
        }
        if (expression.op != 60) {
            return null;
        }
        stringBuffer.insert(0, ((IdentifierExpression)expression).id);
        return Identifier.lookup(stringBuffer.toString());
    }

    @Override
    Type toType(Environment environment, Context context) {
        Identifier identifier = FieldExpression.toIdentifier(this);
        if (identifier == null) {
            environment.error(this.where, "invalid.type.expr");
            return Type.tError;
        }
        Type type = Type.tClass(context.resolveName(environment, identifier));
        if (environment.resolve(this.where, context.field.getClassDefinition(), type)) {
            return type;
        }
        return Type.tError;
    }

    @Override
    public Vset checkAmbigName(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        if (this.id == idThis || this.id == idClass) {
            unaryExpression = null;
        }
        return this.checkCommon(environment, context, vset, hashtable, unaryExpression, false);
    }

    @Override
    public Vset checkValue(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        vset = this.checkCommon(environment, context, vset, hashtable, null, false);
        if (this.id == idSuper && this.type != Type.tError) {
            environment.error(this.where, "undef.var.super", idSuper);
        }
        return vset;
    }

    static void reportFailedPackagePrefix(Environment environment, Expression expression) {
        FieldExpression.reportFailedPackagePrefix(environment, expression, false);
    }

    static void reportFailedPackagePrefix(Environment environment, Expression expression, boolean bl) {
        Expression expression2 = expression;
        while (expression2 instanceof UnaryExpression) {
            expression2 = ((UnaryExpression)expression2).right;
        }
        IdentifierExpression identifierExpression = (IdentifierExpression)expression2;
        try {
            environment.resolve(identifierExpression.id);
        }
        catch (AmbiguousClass ambiguousClass) {
            environment.error(expression.where, "ambig.class", ambiguousClass.name1, ambiguousClass.name2);
            return;
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        if (expression2 == expression) {
            if (bl) {
                environment.error(identifierExpression.where, "undef.class", identifierExpression.id);
            } else {
                environment.error(identifierExpression.where, "undef.var.or.class", identifierExpression.id);
            }
        } else if (bl) {
            environment.error(identifierExpression.where, "undef.class.or.package", identifierExpression.id);
        } else {
            environment.error(identifierExpression.where, "undef.var.class.or.package", identifierExpression.id);
        }
    }

    private Expression implementFieldAccess(Environment environment, Context context, Expression expression, boolean bl) {
        ClassDefinition classDefinition = this.accessBase(environment, context);
        if (classDefinition != null) {
            Constants constants;
            if (this.field.isFinal() && (constants = (Expression)this.field.getValue()) != null && ((Expression)constants).isConstant() && !bl) {
                return ((Expression)constants).copyInline(context);
            }
            constants = classDefinition.getAccessMember(environment, context, this.field, this.isQualSuper());
            if (!bl) {
                if (this.field.isStatic()) {
                    Expression[] expressionArray = new Expression[]{};
                    MethodExpression methodExpression = new MethodExpression(this.where, null, (MemberDefinition)constants, expressionArray);
                    return new CommaExpression(this.where, expression, methodExpression);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new MethodExpression(this.where, null, (MemberDefinition)constants, expressionArray);
            }
        }
        return null;
    }

    private ClassDefinition accessBase(Environment environment, Context context) {
        if (this.field.isPrivate()) {
            ClassDefinition classDefinition;
            ClassDefinition classDefinition2 = this.field.getClassDefinition();
            if (classDefinition2 == (classDefinition = context.field.getClassDefinition())) {
                return null;
            }
            return classDefinition2;
        }
        if (this.field.isProtected()) {
            ClassDefinition classDefinition;
            if (this.superBase == null) {
                return null;
            }
            ClassDefinition classDefinition3 = this.field.getClassDefinition();
            if (classDefinition3.inSamePackage(classDefinition = context.field.getClassDefinition())) {
                return null;
            }
            return this.superBase;
        }
        return null;
    }

    static boolean isTypeAccessible(long l, Environment environment, Type type, ClassDefinition classDefinition) {
        switch (type.getTypeCode()) {
            case 10: {
                try {
                    Identifier identifier = type.getClassName();
                    ClassDefinition classDefinition2 = environment.getClassDefinition(type);
                    return classDefinition.canAccess(environment, classDefinition2.getClassDeclaration());
                }
                catch (ClassNotFound classNotFound) {
                    return true;
                }
            }
            case 9: {
                return FieldExpression.isTypeAccessible(l, environment, type.getElementType(), classDefinition);
            }
        }
        return true;
    }

    private Vset checkCommon(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression, boolean bl) {
        if (this.id == idClass) {
            Type type = this.right.toType(environment, context);
            if (!type.isType(10) && !type.isType(9)) {
                if (type.isType(13)) {
                    this.type = Type.tClassDesc;
                    return vset;
                }
                String string = null;
                switch (type.getTypeCode()) {
                    case 11: {
                        string = "Void";
                        break;
                    }
                    case 0: {
                        string = "Boolean";
                        break;
                    }
                    case 1: {
                        string = "Byte";
                        break;
                    }
                    case 2: {
                        string = "Character";
                        break;
                    }
                    case 3: {
                        string = "Short";
                        break;
                    }
                    case 4: {
                        string = "Integer";
                        break;
                    }
                    case 6: {
                        string = "Float";
                        break;
                    }
                    case 5: {
                        string = "Long";
                        break;
                    }
                    case 7: {
                        string = "Double";
                        break;
                    }
                    default: {
                        environment.error(this.right.where, "invalid.type.expr");
                        return vset;
                    }
                }
                Identifier identifier = Identifier.lookup(idJavaLang + "." + string);
                TypeExpression typeExpression = new TypeExpression(this.where, Type.tClass(identifier));
                this.implementation = new FieldExpression(this.where, (Expression)typeExpression, idTYPE);
                vset = this.implementation.checkValue(environment, context, vset, hashtable);
                this.type = this.implementation.type;
                return vset;
            }
            if (type.isVoidArray()) {
                this.type = Type.tClassDesc;
                environment.error(this.right.where, "void.array");
                return vset;
            }
            long l = context.field.getWhere();
            ClassDefinition classDefinition = context.field.getClassDefinition();
            MemberDefinition memberDefinition = classDefinition.getClassLiteralLookup(l);
            String string = type.getTypeSignature();
            String string2 = type.isType(10) ? string.substring(1, string.length() - 1).replace('/', '.') : string.replace('/', '.');
            if (classDefinition.isInterface()) {
                this.implementation = this.makeClassLiteralInlineRef(environment, context, memberDefinition, string2);
            } else {
                ClassDefinition classDefinition2 = memberDefinition.getClassDefinition();
                MemberDefinition memberDefinition2 = FieldExpression.getClassLiteralCache(environment, context, string2, classDefinition2);
                this.implementation = this.makeClassLiteralCacheRef(environment, context, memberDefinition, memberDefinition2, string2);
            }
            vset = this.implementation.checkValue(environment, context, vset, hashtable);
            this.type = this.implementation.type;
            return vset;
        }
        if (this.field != null) {
            this.implementation = this.implementFieldAccess(environment, context, this.right, bl);
            return this.right == null ? vset : this.right.checkAmbigName(environment, context, vset, hashtable, this);
        }
        vset = this.right.checkAmbigName(environment, context, vset, hashtable, this);
        if (this.right.type == Type.tPackage) {
            if (unaryExpression == null) {
                FieldExpression.reportFailedPackagePrefix(environment, this.right);
                return vset;
            }
            Identifier identifier = FieldExpression.toIdentifier(this);
            if (identifier != null && environment.classExists(identifier)) {
                unaryExpression.right = new TypeExpression(this.where, Type.tClass(identifier));
                ClassDefinition classDefinition = context.field.getClassDefinition();
                environment.resolve(this.where, classDefinition, unaryExpression.right.type);
                return vset;
            }
            this.type = Type.tPackage;
            return vset;
        }
        ClassDefinition classDefinition = context.field.getClassDefinition();
        boolean bl2 = this.right instanceof TypeExpression;
        try {
            Constants constants;
            if (!this.right.type.isType(10)) {
                if (this.right.type.isType(9) && this.id.equals(idLength)) {
                    if (!FieldExpression.isTypeAccessible(this.where, environment, this.right.type, classDefinition)) {
                        ClassDeclaration classDeclaration = classDefinition.getClassDeclaration();
                        if (bl2) {
                            environment.error(this.where, "no.type.access", this.id, this.right.type.toString(), classDeclaration);
                        } else {
                            environment.error(this.where, "cant.access.member.type", this.id, this.right.type.toString(), classDeclaration);
                        }
                    }
                    this.type = Type.tInt;
                    this.implementation = new LengthExpression(this.where, this.right);
                    return vset;
                }
                if (!this.right.type.isType(13)) {
                    environment.error(this.where, "invalid.field.reference", this.id, this.right.type);
                }
                return vset;
            }
            ClassDefinition classDefinition3 = classDefinition;
            if (this.right instanceof FieldExpression) {
                constants = ((FieldExpression)this.right).id;
                if (constants == idThis) {
                    classDefinition3 = ((FieldExpression)this.right).clazz;
                } else if (constants == idSuper) {
                    this.superBase = classDefinition3 = ((FieldExpression)this.right).clazz;
                }
            }
            this.clazz = environment.getClassDefinition(this.right.type);
            if (this.id == idThis || this.id == idSuper) {
                if (!bl2) {
                    environment.error(this.right.where, "invalid.type.expr");
                }
                if (context.field.isSynthetic()) {
                    throw new CompilerError("synthetic qualified this");
                }
                this.implementation = context.findOuterLink(environment, this.where, this.clazz, null, true);
                vset = this.implementation.checkValue(environment, context, vset, hashtable);
                this.type = this.id == idSuper ? this.clazz.getSuperClass().getType() : this.clazz.getType();
                return vset;
            }
            this.field = this.clazz.getVariable(environment, this.id, classDefinition3);
            if (this.field == null && bl2 && unaryExpression != null) {
                this.field = this.clazz.getInnerClass(environment, this.id);
                if (this.field != null) {
                    return this.checkInnerClass(environment, context, vset, hashtable, unaryExpression);
                }
            }
            if (this.field == null) {
                this.field = this.clazz.findAnyMethod(environment, this.id);
                if (this.field != null) {
                    environment.error(this.where, "invalid.field", this.id, this.field.getClassDeclaration());
                } else {
                    environment.error(this.where, "no.such.field", this.id, this.clazz);
                }
                return vset;
            }
            if (!FieldExpression.isTypeAccessible(this.where, environment, this.right.type, classDefinition3)) {
                constants = classDefinition3.getClassDeclaration();
                if (bl2) {
                    environment.error(this.where, "no.type.access", this.id, this.right.type.toString(), constants);
                } else {
                    environment.error(this.where, "cant.access.member.type", this.id, this.right.type.toString(), constants);
                }
            }
            this.type = this.field.getType();
            if (!classDefinition3.canAccess(environment, this.field)) {
                environment.error(this.where, "no.field.access", this.id, this.clazz, classDefinition3.getClassDeclaration());
                return vset;
            }
            if (bl2 && !this.field.isStatic()) {
                environment.error(this.where, "no.static.field.access", this.id, this.clazz);
                return vset;
            }
            this.implementation = this.implementFieldAccess(environment, context, this.right, bl);
            if (!(!this.field.isProtected() || this.right instanceof SuperExpression || this.right instanceof FieldExpression && ((FieldExpression)this.right).id == idSuper || classDefinition3.protectedAccess(environment, this.field, this.right.type))) {
                environment.error(this.where, "invalid.protected.field.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            if (!this.field.isStatic() && this.right.op == 82 && !vset.testVar(context.getThisNumber())) {
                environment.error(this.where, "access.inst.before.super", this.id);
            }
            if (this.field.reportDeprecated(environment)) {
                environment.error(this.where, "warn.field.is.deprecated", this.id, this.field.getClassDefinition());
            }
            if (classDefinition3 == classDefinition && ((ClassDefinition)(constants = this.field.getClassDefinition())).isPackagePrivate() && !((ClassDefinition)constants).getName().getQualifier().equals(classDefinition3.getName().getQualifier())) {
                this.field = MemberDefinition.makeProxyMember(this.field, this.clazz, environment);
            }
            classDefinition3.addDependency(this.field.getClassDeclaration());
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        catch (AmbiguousMember ambiguousMember) {
            environment.error(this.where, "ambig.field", this.id, ambiguousMember.field1.getClassDeclaration(), ambiguousMember.field2.getClassDeclaration());
        }
        return vset;
    }

    @Override
    public FieldUpdater getAssigner(Environment environment, Context context) {
        if (this.field == null) {
            return null;
        }
        ClassDefinition classDefinition = this.accessBase(environment, context);
        if (classDefinition != null) {
            MemberDefinition memberDefinition = classDefinition.getUpdateMember(environment, context, this.field, this.isQualSuper());
            Expression expression = this.right == null ? null : this.right.copyInline(context);
            return new FieldUpdater(this.where, this.field, expression, null, memberDefinition);
        }
        return null;
    }

    @Override
    public FieldUpdater getUpdater(Environment environment, Context context) {
        if (this.field == null) {
            return null;
        }
        ClassDefinition classDefinition = this.accessBase(environment, context);
        if (classDefinition != null) {
            MemberDefinition memberDefinition = classDefinition.getAccessMember(environment, context, this.field, this.isQualSuper());
            MemberDefinition memberDefinition2 = classDefinition.getUpdateMember(environment, context, this.field, this.isQualSuper());
            Expression expression = this.right == null ? null : this.right.copyInline(context);
            return new FieldUpdater(this.where, this.field, expression, memberDefinition, memberDefinition2);
        }
        return null;
    }

    private Vset checkInnerClass(Environment environment, Context context, Vset vset, Hashtable hashtable, UnaryExpression unaryExpression) {
        ClassDefinition classDefinition = this.field.getInnerClass();
        this.type = classDefinition.getType();
        if (!classDefinition.isTopLevel()) {
            environment.error(this.where, "inner.static.ref", classDefinition.getName());
        }
        TypeExpression typeExpression = new TypeExpression(this.where, this.type);
        ClassDefinition classDefinition2 = context.field.getClassDefinition();
        try {
            if (!classDefinition2.canAccess(environment, this.field)) {
                ClassDefinition classDefinition3 = environment.getClassDefinition(this.right.type);
                environment.error(this.where, "no.type.access", this.id, classDefinition3, classDefinition2.getClassDeclaration());
                return vset;
            }
            if (!(!this.field.isProtected() || this.right instanceof SuperExpression || this.right instanceof FieldExpression && ((FieldExpression)this.right).id == idSuper || classDefinition2.protectedAccess(environment, this.field, this.right.type))) {
                environment.error(this.where, "invalid.protected.field.use", this.field.getName(), this.field.getClassDeclaration(), this.right.type);
                return vset;
            }
            classDefinition.noteUsedBy(classDefinition2, this.where, environment);
        }
        catch (ClassNotFound classNotFound) {
            environment.error(this.where, "class.not.found", classNotFound.name, context.field);
        }
        classDefinition2.addDependency(this.field.getClassDeclaration());
        if (unaryExpression == null) {
            return ((Expression)typeExpression).checkValue(environment, context, vset, hashtable);
        }
        unaryExpression.right = typeExpression;
        return vset;
    }

    @Override
    public Vset checkLHS(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        boolean bl = this.field != null;
        this.checkCommon(environment, context, vset, hashtable, null, true);
        if (this.implementation != null) {
            return super.checkLHS(environment, context, vset, hashtable);
        }
        if (this.field != null && this.field.isFinal() && !bl) {
            if (this.field.isBlankFinal()) {
                if (this.field.isStatic()) {
                    if (this.right != null) {
                        environment.error(this.where, "qualified.static.final.assign");
                    }
                } else if (this.right != null && this.right.op != 82) {
                    environment.error(this.where, "bad.qualified.final.assign", this.field.getName());
                    return vset;
                }
                vset = FieldExpression.checkFinalAssign(environment, context, vset, this.where, this.field);
            } else {
                environment.error(this.where, "assign.to.final", this.id);
            }
        }
        return vset;
    }

    @Override
    public Vset checkAssignOp(Environment environment, Context context, Vset vset, Hashtable hashtable, Expression expression) {
        this.checkCommon(environment, context, vset, hashtable, null, true);
        if (this.implementation != null) {
            return super.checkLHS(environment, context, vset, hashtable);
        }
        if (this.field != null && this.field.isFinal()) {
            environment.error(this.where, "assign.to.final", this.id);
        }
        return vset;
    }

    public static Vset checkFinalAssign(Environment environment, Context context, Vset vset, long l, MemberDefinition memberDefinition) {
        if (memberDefinition.isBlankFinal() && memberDefinition.getClassDefinition() == context.field.getClassDefinition()) {
            int n = context.getFieldNumber(memberDefinition);
            if (n >= 0 && vset.testVarUnassigned(n)) {
                vset = vset.addVar(n);
            } else {
                Identifier identifier = memberDefinition.getName();
                environment.error(l, "assign.to.blank.final", identifier);
            }
        } else {
            Identifier identifier = memberDefinition.getName();
            environment.error(l, "assign.to.final", identifier);
        }
        return vset;
    }

    private static MemberDefinition getClassLiteralCache(Environment environment, Context context, String string, ClassDefinition classDefinition) {
        MemberDefinition memberDefinition;
        String string2;
        if (!string.startsWith("[")) {
            string2 = "class$" + string.replace('.', '$');
        } else {
            string2 = "array$" + string.substring(1);
            string2 = string2.replace('[', '$');
            if (string.endsWith(";")) {
                string2 = string2.substring(0, string2.length() - 1);
                string2 = string2.replace('.', '$');
            }
        }
        Identifier identifier = Identifier.lookup(string2);
        try {
            memberDefinition = classDefinition.getVariable(environment, identifier, classDefinition);
        }
        catch (ClassNotFound classNotFound) {
            return null;
        }
        catch (AmbiguousMember ambiguousMember) {
            return null;
        }
        if (memberDefinition != null && memberDefinition.getClassDefinition() == classDefinition) {
            return memberDefinition;
        }
        return environment.makeMemberDefinition(environment, classDefinition.getWhere(), classDefinition, null, 524296, Type.tClassDesc, identifier, null, null, null);
    }

    private Expression makeClassLiteralCacheRef(Environment environment, Context context, MemberDefinition memberDefinition, MemberDefinition memberDefinition2, String string) {
        TypeExpression typeExpression = new TypeExpression(this.where, memberDefinition2.getClassDefinition().getType());
        FieldExpression fieldExpression = new FieldExpression(this.where, (Expression)typeExpression, memberDefinition2);
        NotEqualExpression notEqualExpression = new NotEqualExpression(this.where, ((Expression)fieldExpression).copyInline(context), new NullExpression(this.where));
        TypeExpression typeExpression2 = new TypeExpression(this.where, memberDefinition.getClassDefinition().getType());
        StringExpression stringExpression = new StringExpression(this.where, string);
        Expression[] expressionArray = new Expression[]{stringExpression};
        UnaryExpression unaryExpression = new MethodExpression(this.where, (Expression)typeExpression2, memberDefinition, expressionArray);
        unaryExpression = new AssignExpression(this.where, ((Expression)fieldExpression).copyInline(context), unaryExpression);
        return new ConditionalExpression(this.where, notEqualExpression, fieldExpression, (Expression)unaryExpression);
    }

    private Expression makeClassLiteralInlineRef(Environment environment, Context context, MemberDefinition memberDefinition, String string) {
        TypeExpression typeExpression = new TypeExpression(this.where, memberDefinition.getClassDefinition().getType());
        StringExpression stringExpression = new StringExpression(this.where, string);
        Expression[] expressionArray = new Expression[]{stringExpression};
        MethodExpression methodExpression = new MethodExpression(this.where, (Expression)typeExpression, memberDefinition, expressionArray);
        return methodExpression;
    }

    @Override
    public boolean isConstant() {
        if (this.implementation != null) {
            return this.implementation.isConstant();
        }
        if (this.field != null && (this.right == null || this.right instanceof TypeExpression || this.right.op == 82 && this.right.where == this.where)) {
            return this.field.isConstant();
        }
        return false;
    }

    @Override
    public Expression inline(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inline(environment, context);
        }
        Expression expression = this.inlineValue(environment, context);
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            if (fieldExpression.right != null && fieldExpression.right.op == 82) {
                return null;
            }
        }
        return expression;
    }

    @Override
    public Expression inlineValue(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineValue(environment, context);
        }
        try {
            Expression expression;
            if (this.field == null) {
                return this;
            }
            if (this.field.isFinal() && (expression = (Expression)this.field.getValue(environment)) != null && expression.isConstant()) {
                expression = expression.copyInline(context);
                expression.where = this.where;
                return new CommaExpression(this.where, this.right, expression).inlineValue(environment, context);
            }
            if (this.right != null) {
                if (this.field.isStatic()) {
                    expression = this.right.inline(environment, context);
                    this.right = null;
                    if (expression != null) {
                        return new CommaExpression(this.where, expression, this);
                    }
                } else {
                    this.right = this.right.inlineValue(environment, context);
                }
            }
            return this;
        }
        catch (ClassNotFound classNotFound) {
            throw new CompilerError(classNotFound);
        }
    }

    @Override
    public Expression inlineLHS(Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.inlineLHS(environment, context);
        }
        if (this.right != null) {
            if (this.field.isStatic()) {
                Expression expression = this.right.inline(environment, context);
                this.right = null;
                if (expression != null) {
                    return new CommaExpression(this.where, expression, this);
                }
            } else {
                this.right = this.right.inlineValue(environment, context);
            }
        }
        return this;
    }

    @Override
    public Expression copyInline(Context context) {
        if (this.implementation != null) {
            return this.implementation.copyInline(context);
        }
        return super.copyInline(context);
    }

    @Override
    public int costInline(int n, Environment environment, Context context) {
        if (this.implementation != null) {
            return this.implementation.costInline(n, environment, context);
        }
        if (context == null) {
            return 3 + (this.right == null ? 0 : this.right.costInline(n, environment, context));
        }
        ClassDefinition classDefinition = context.field.getClassDefinition();
        try {
            if (classDefinition.permitInlinedAccess(environment, this.field.getClassDeclaration()) && classDefinition.permitInlinedAccess(environment, this.field)) {
                if (this.right == null) {
                    return 3;
                }
                ClassDeclaration classDeclaration = environment.getClassDeclaration(this.right.type);
                if (classDefinition.permitInlinedAccess(environment, classDeclaration)) {
                    return 3 + this.right.costInline(n, environment, context);
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        return n;
    }

    @Override
    int codeLValue(Environment environment, Context context, Assembler assembler) {
        if (this.implementation != null) {
            throw new CompilerError("codeLValue");
        }
        if (this.field.isStatic()) {
            if (this.right != null) {
                this.right.code(environment, context, assembler);
                return 1;
            }
            return 0;
        }
        this.right.codeValue(environment, context, assembler);
        return 1;
    }

    @Override
    void codeLoad(Environment environment, Context context, Assembler assembler) {
        if (this.field == null) {
            throw new CompilerError("should not be null");
        }
        if (this.field.isStatic()) {
            assembler.add(this.where, 178, this.field);
        } else {
            assembler.add(this.where, 180, this.field);
        }
    }

    @Override
    void codeStore(Environment environment, Context context, Assembler assembler) {
        if (this.field.isStatic()) {
            assembler.add(this.where, 179, this.field);
        } else {
            assembler.add(this.where, 181, this.field);
        }
    }

    @Override
    public void codeValue(Environment environment, Context context, Assembler assembler) {
        this.codeLValue(environment, context, assembler);
        this.codeLoad(environment, context, assembler);
    }

    @Override
    public void print(PrintStream printStream) {
        printStream.print("(");
        if (this.right != null) {
            this.right.print(printStream);
        } else {
            printStream.print("<empty>");
        }
        printStream.print("." + this.id + ")");
        if (this.implementation != null) {
            printStream.print("/IMPL=");
            this.implementation.print(printStream);
        }
    }
}

