/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import sun.tools.jstat.ColumnFormat;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.Parser;
import sun.tools.jstat.ParserException;

public class OptionFinder {
    private static final boolean debug = false;
    List<URL> optionsSources;

    public OptionFinder(List<URL> list) {
        this.optionsSources = list;
    }

    public OptionFormat getOptionFormat(String string, boolean bl) {
        OptionFormat optionFormat = this.getOptionFormat(string, this.optionsSources);
        OptionFormat optionFormat2 = null;
        if (optionFormat != null && bl && (optionFormat2 = this.getOptionFormat("timestamp", this.optionsSources)) != null) {
            ColumnFormat columnFormat = (ColumnFormat)optionFormat2.getSubFormat(0);
            optionFormat.insertSubFormat(0, columnFormat);
        }
        return optionFormat;
    }

    protected OptionFormat getOptionFormat(String string, List<URL> list) {
        OptionFormat optionFormat = null;
        for (URL uRL : list) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                optionFormat = new Parser(bufferedReader).parse(string);
                if (optionFormat == null) continue;
                break;
            }
            catch (IOException iOException) {
            }
            catch (ParserException parserException) {
                System.err.println(uRL + ": " + parserException.getMessage());
                System.err.println("Parsing of " + uRL + " aborted");
            }
        }
        return optionFormat;
    }
}

