/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io;

import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.DefCollector;
import scenelib.annotations.el.DefException;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.field.AnnotationAFT;
import scenelib.annotations.field.AnnotationFieldType;
import scenelib.annotations.field.ArrayAFT;
import scenelib.annotations.field.BasicAFT;
import scenelib.annotations.field.ClassTokenAFT;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.IOUtils;
import scenelib.annotations.util.Strings;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public final class IndexFileWriter {
    final AScene scene;
    private static final String INDENT = "    ";
    final PrintWriter pw;

    void printAnnotationDefBody(AnnotationDef d) {
        for (Map.Entry<String, AnnotationFieldType> f : d.fieldTypes.entrySet()) {
            String fieldname = f.getKey();
            AnnotationFieldType fieldType = f.getValue();
            this.pw.println(INDENT + fieldType + " " + fieldname);
        }
        this.pw.println();
    }

    private void printValue(AnnotationFieldType aft, Object o) {
        if (aft instanceof AnnotationAFT) {
            this.printAnnotation((Annotation)o);
        } else if (aft instanceof ArrayAFT) {
            ArrayAFT aaft = (ArrayAFT)aft;
            this.pw.print('{');
            if (!(o instanceof List)) {
                this.printValue(aaft.elementType, o);
            } else {
                List l = (List)o;
                if (aaft.elementType == null) {
                    if (l.size() != 0) {
                        throw new AssertionError();
                    }
                } else {
                    boolean first = true;
                    for (Object o2 : l) {
                        if (!first) {
                            this.pw.print(',');
                        }
                        this.printValue(aaft.elementType, o2);
                        first = false;
                    }
                }
            }
            this.pw.print('}');
        } else if (aft instanceof ClassTokenAFT) {
            this.pw.print(aft.format(o));
        } else if (aft instanceof BasicAFT && o instanceof String) {
            this.pw.print(Strings.escape((String)o));
        } else {
            this.pw.print(o.toString());
        }
    }

    private void printAnnotation(Annotation a) {
        this.pw.print("@" + a.def().name);
        if (!a.fieldValues.isEmpty()) {
            this.pw.print('(');
            boolean first = true;
            for (Map.Entry<String, Object> f : a.fieldValues.entrySet()) {
                if (!first) {
                    this.pw.print(',');
                }
                this.pw.print(f.getKey() + "=");
                this.printValue(a.def().fieldTypes.get(f.getKey()), f.getValue());
                first = false;
            }
            this.pw.print(')');
        }
    }

    private void printAnnotations(Collection<? extends Annotation> annos) {
        for (Annotation annotation2 : annos) {
            this.pw.print(' ');
            this.printAnnotation(annotation2);
        }
    }

    private void printAnnotations(AElement e) {
        this.printAnnotations(e.tlAnnotationsHere);
    }

    private void printElement(String indentation, String desc, AElement e) {
        this.pw.print(indentation + desc + ":");
        this.printAnnotations(e);
        this.pw.println();
    }

    private void printElementAndInnerTypes(String indentation, String desc, AElement e) {
        if (e.type != null) {
            this.printElement(indentation, desc, e.type);
            if (!e.type.innerTypes.isEmpty()) {
                this.printInnerTypes(indentation + INDENT, e.type);
            }
        }
    }

    private void printTypeElementAndInnerTypes(String indentation, String desc, ATypeElement e) {
        if (e.tlAnnotationsHere.isEmpty() && e.innerTypes.isEmpty() && desc.equals("type")) {
            return;
        }
        this.printElement(indentation, desc, e);
        this.printInnerTypes(indentation + INDENT, e);
    }

    private void printInnerTypes(String indentation, ATypeElement e) {
        for (Map.Entry ite : e.innerTypes.entrySet()) {
            InnerTypeLocation loc = (InnerTypeLocation)ite.getKey();
            AElement it = (AElement)ite.getValue();
            this.pw.print(indentation + "inner-type");
            int sep = 32;
            for (TypeAnnotationPosition.TypePathEntry l : loc.location) {
                this.pw.print((char)sep);
                this.pw.print(this.typePathEntryToString(l));
                sep = 44;
            }
            this.pw.print(':');
            this.printAnnotations(it);
            this.pw.println();
        }
    }

    private void printInnerTypes(String indentation, ATypeElement e, ASTPath path) {
        for (Map.Entry ite : e.innerTypes.entrySet()) {
            InnerTypeLocation loc = (InnerTypeLocation)ite.getKey();
            AElement it = (AElement)ite.getValue();
            this.pw.print(indentation + "inner-type");
            int sep = 32;
            for (TypeAnnotationPosition.TypePathEntry l : loc.location) {
                this.pw.print((char)sep);
                this.pw.print(this.typePathEntryToString(l));
                sep = 44;
            }
            this.pw.print(':');
            this.printAnnotations(it);
            this.pw.println();
        }
    }

    private String typePathEntryToString(TypeAnnotationPosition.TypePathEntry t) {
        return t.tag.tag + ", " + t.arg;
    }

    private void printNumberedAmbigiousElements(String indentation, String desc, Map<Integer, ? extends AElement> nels) {
        for (Map.Entry<Integer, ? extends AElement> te : nels.entrySet()) {
            AElement t = te.getValue();
            this.printAmbElementAndInnerTypes(indentation, desc + " #" + te.getKey(), t);
        }
    }

    private void printAmbElementAndInnerTypes(String indentation, String desc, AElement e) {
        this.printElement(indentation, desc, e);
        if (e.type.tlAnnotationsHere.isEmpty() && e.type.innerTypes.isEmpty()) {
            return;
        }
        this.printElement(indentation + INDENT, "type", e.type);
        for (Map.Entry ite : e.type.innerTypes.entrySet()) {
            InnerTypeLocation loc = (InnerTypeLocation)ite.getKey();
            AElement it = (AElement)ite.getValue();
            this.pw.print(indentation + INDENT + INDENT + "inner-type");
            boolean first = true;
            for (TypeAnnotationPosition.TypePathEntry l : loc.location) {
                if (first) {
                    this.pw.print(' ');
                } else {
                    this.pw.print(',');
                }
                this.pw.print(this.typePathEntryToString(l));
                first = false;
            }
            this.pw.print(':');
            this.printAnnotations(it);
            this.pw.println();
        }
    }

    private void printRelativeElements(String indentation, String desc, Map<RelativeLocation, ATypeElement> nels) {
        for (Map.Entry<RelativeLocation, ATypeElement> te : nels.entrySet()) {
            ATypeElement t = te.getValue();
            this.printTypeElementAndInnerTypes(indentation, desc + " " + te.getKey().getLocationString(), t);
        }
    }

    private void printRelativeElements(String indentation, String desc1, String desc2, Map<RelativeLocation, ATypeElement> nels) {
        RelativeLocation prev = null;
        for (Map.Entry<RelativeLocation, ATypeElement> te : nels.entrySet()) {
            boolean isOffset;
            ATypeElement t = te.getValue();
            RelativeLocation loc = te.getKey();
            boolean bl = isOffset = loc.index < 0;
            if (prev == null || loc.type_index < 0 || (isOffset ? loc.offset != prev.offset : loc.index != prev.index)) {
                this.pw.print(indentation + desc1 + " ");
                this.pw.print(isOffset ? "#" + loc.offset : "*" + loc.index);
                this.pw.print(":");
                if (loc.type_index <= 0) {
                    this.printAnnotations(t);
                }
                this.pw.println();
                this.printInnerTypes(indentation + INDENT, t);
            }
            if (loc.type_index > 0) {
                this.printTypeElementAndInnerTypes(indentation + INDENT, desc2 + " " + loc.type_index, t);
            }
            prev = loc;
        }
    }

    private void printBounds(String indentation, Map<BoundLocation, ATypeElement> bounds) {
        for (Map.Entry<BoundLocation, ATypeElement> be : bounds.entrySet()) {
            BoundLocation bl = be.getKey();
            ATypeElement b = be.getValue();
            if (bl.boundIndex == -1) {
                this.printTypeElementAndInnerTypes(indentation, "typeparam " + bl.paramIndex, b);
                continue;
            }
            this.printTypeElementAndInnerTypes(indentation, "bound " + bl.paramIndex + " &" + bl.boundIndex, b);
        }
    }

    private void printExtImpls(String indentation, Map<TypeIndexLocation, ATypeElement> extImpls) {
        for (Map.Entry<TypeIndexLocation, ATypeElement> ei : extImpls.entrySet()) {
            TypeIndexLocation idx = ei.getKey();
            ATypeElement ty = ei.getValue();
            if (idx.typeIndex == -1 || idx.typeIndex == 65535) {
                this.printTypeElementAndInnerTypes(indentation, "extends", ty);
                continue;
            }
            this.printTypeElementAndInnerTypes(indentation, "implements " + idx.typeIndex, ty);
        }
    }

    private void printASTInsertions(String indentation, Map<ASTPath, ATypeElement> insertAnnotations, Map<ASTPath, ATypeElementWithType> insertTypecasts) {
        ATypeElement el;
        ASTPath path;
        for (Map.Entry<ASTPath, ATypeElement> entry : insertAnnotations.entrySet()) {
            path = entry.getKey();
            el = entry.getValue();
            this.pw.print(indentation + "insert-annotation " + path + ":");
            this.printAnnotations(el);
            this.pw.println();
            this.printInnerTypes(INDENT, el, path);
        }
        for (Map.Entry<ASTPath, ATypeElement> entry : insertTypecasts.entrySet()) {
            path = entry.getKey();
            el = (ATypeElementWithType)entry.getValue();
            this.pw.print(indentation + "insert-typecast " + path + ":");
            this.printAnnotations(el);
            this.pw.print(" ");
            this.printType(((ATypeElementWithType)el).getType());
            this.pw.println();
            this.printInnerTypes(INDENT, el, path);
        }
    }

    private void printType(Type type) {
        switch (type.getKind()) {
            case ARRAY: {
                ArrayType a = (ArrayType)type;
                this.printType(a.getComponentType());
                this.pw.print("[]");
                break;
            }
            case BOUNDED: {
                BoundedType b = (BoundedType)type;
                this.printType(b.getName());
                this.pw.print(" ");
                this.pw.print((Object)b.getBoundKind());
                this.pw.print(" ");
                this.printType(b.getBound());
                break;
            }
            case DECLARED: {
                DeclaredType d = (DeclaredType)type;
                this.pw.print(d.getName());
                if (d.isWildcard()) break;
                DeclaredType inner = d.getInnerType();
                Iterator<Type> iter = d.getTypeParameters().iterator();
                if (iter.hasNext()) {
                    this.pw.print("<");
                    this.printType(iter.next());
                    while (iter.hasNext()) {
                        this.pw.print(", ");
                        this.printType(iter.next());
                    }
                    this.pw.print(">");
                }
                if (inner == null) break;
                this.pw.print(".");
                this.printType(inner);
            }
        }
    }

    private void write() throws DefException {
        OurDefCollector odc = new OurDefCollector();
        odc.visit();
        for (Map.Entry pe : this.scene.packages.entrySet()) {
            AElement elem = (AElement)pe.getValue();
            if (elem == null || elem.tlAnnotationsHere.isEmpty()) continue;
            this.pw.print("package " + (String)pe.getKey() + ":");
            this.printAnnotations(elem);
            this.pw.println();
        }
        String indent2 = "        ";
        String indent3 = "            ";
        for (Map.Entry ce : this.scene.classes.entrySet()) {
            String cname = (String)ce.getKey();
            AClass c = (AClass)ce.getValue();
            String pkg = IOUtils.packagePart(cname);
            String basename = IOUtils.basenamePart(cname);
            if ("package-info".equals(basename)) {
                if (c.tlAnnotationsHere.isEmpty()) continue;
                this.pw.print("package " + pkg + ":");
                this.printAnnotations(c);
                this.pw.println();
                continue;
            }
            this.pw.println("package " + pkg + ":");
            this.pw.print("class " + basename + ":");
            this.printAnnotations(c);
            this.pw.println();
            this.printBounds(INDENT, c.bounds);
            this.printExtImpls(INDENT, c.extendsImplements);
            this.printASTInsertions(INDENT, c.insertAnnotations, c.insertTypecasts);
            for (Map.Entry fe : c.fields.entrySet()) {
                String fname = (String)fe.getKey();
                AField f = (AField)fe.getValue();
                this.pw.println();
                this.printElement(INDENT, "field " + fname, f);
                this.printTypeElementAndInnerTypes("        ", "type", f.type);
                this.printASTInsertions("        ", f.insertAnnotations, f.insertTypecasts);
            }
            for (Map.Entry me : c.methods.entrySet()) {
                String mkey = (String)me.getKey();
                AMethod m3 = (AMethod)me.getValue();
                this.pw.println();
                this.printElement(INDENT, "method " + mkey, m3);
                this.printBounds("        ", m3.bounds);
                this.printTypeElementAndInnerTypes("        ", "return", m3.returnType);
                if (!m3.receiver.type.tlAnnotationsHere.isEmpty() || !m3.receiver.type.innerTypes.isEmpty()) {
                    this.printElementAndInnerTypes("        ", "receiver", m3.receiver);
                }
                this.printNumberedAmbigiousElements("        ", "parameter", m3.parameters);
                for (Map.Entry le : m3.body.locals.entrySet()) {
                    LocalLocation loc = (LocalLocation)le.getKey();
                    AElement l = (AElement)le.getValue();
                    StringBuilder sb = new StringBuilder("local ");
                    sb.append(loc.varName == null ? loc.index + " #" + loc.scopeStart + "+" + loc.scopeLength : loc.varName);
                    this.printElement("        ", sb.toString(), l);
                    this.printTypeElementAndInnerTypes("            ", "type", l.type);
                }
                this.printRelativeElements("        ", "typecast", m3.body.typecasts);
                this.printRelativeElements("        ", "instanceof", m3.body.instanceofs);
                this.printRelativeElements("        ", "new", m3.body.news);
                this.printRelativeElements("        ", "reference", "typearg", m3.body.refs);
                this.printRelativeElements("        ", "call", "typearg", m3.body.calls);
                for (Map.Entry entry : m3.body.funs.entrySet()) {
                    AMethod lambda = (AMethod)entry.getValue();
                    RelativeLocation loc = (RelativeLocation)entry.getKey();
                    this.pw.print("lambda " + loc.getLocationString() + ":\n");
                    this.printBounds("            ", lambda.bounds);
                    this.printTypeElementAndInnerTypes("            ", "return", lambda.returnType);
                }
                this.printASTInsertions("        ", m3.insertAnnotations, m3.insertTypecasts);
            }
            this.pw.println();
        }
    }

    private IndexFileWriter(AScene scene, Writer out) throws DefException {
        this.scene = scene;
        this.pw = new PrintWriter(out);
        this.write();
        this.pw.flush();
    }

    public static void write(AScene scene, Writer out) throws DefException {
        new IndexFileWriter(scene, out);
    }

    public static void write(AScene scene, String filename) throws IOException, DefException {
        IndexFileWriter.write(scene, new FileWriter(filename));
    }

    private class OurDefCollector
    extends DefCollector {
        OurDefCollector() throws DefException {
            super(IndexFileWriter.this.scene);
        }

        @Override
        protected void visitAnnotationDef(AnnotationDef d) {
            if (!d.name.contains("+")) {
                IndexFileWriter.this.pw.println("package " + IOUtils.packagePart(d.name) + ":");
                IndexFileWriter.this.pw.print("annotation @" + IOUtils.basenamePart(d.name) + ":");
                IndexFileWriter.this.printAnnotations(this.requiredMetaannotations(d.tlAnnotationsHere));
                IndexFileWriter.this.pw.println();
                IndexFileWriter.this.printAnnotationDefBody(d);
            }
        }

        private Collection<Annotation> requiredMetaannotations(Collection<Annotation> annos) {
            HashSet<Annotation> results = new HashSet<Annotation>();
            for (Annotation a : annos) {
                String aName = a.def.name;
                if (!aName.equals(Retention.class.getCanonicalName()) && !aName.equals(Target.class.getCanonicalName())) continue;
                results.add(a);
            }
            return results;
        }
    }
}

