/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.el;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import scenelib.annotations.Annotation;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.ElementVisitor;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.util.coll.VivifyingMap;

public final class AScene
implements Cloneable {
    private static boolean checkClones = true;
    public static boolean debugFoundMap = false;
    public final VivifyingMap<String, AElement> packages = AElement.newVivifyingLHMap_AE();
    public final Map<String, Set<String>> imports = new LinkedHashMap<String, Set<String>>();
    public final VivifyingMap<String, AClass> classes = new VivifyingMap<String, AClass>(new LinkedHashMap()){

        @Override
        public AClass createValueFor(String k) {
            return new AClass(k);
        }

        @Override
        public boolean subPrune(AClass v) {
            return v.prune();
        }
    };
    private static ElementVisitor<Void, AElement> checkVisitor = new ElementVisitor<Void, AElement>(){

        @Override
        public Void visitAnnotationDef(AnnotationDef el, AElement arg) {
            return null;
        }

        @Override
        public Void visitBlock(ABlock el, AElement arg) {
            ABlock b = (ABlock)arg;
            AScene.checkElems(el.locals, b.locals);
            return null;
        }

        @Override
        public Void visitClass(AClass el, AElement arg) {
            AClass c = (AClass)arg;
            AScene.checkElems(el.bounds, c.bounds);
            AScene.checkElems(el.extendsImplements, c.extendsImplements);
            AScene.checkElems(el.fieldInits, c.fieldInits);
            AScene.checkElems(el.fields, c.fields);
            AScene.checkElems(el.instanceInits, c.instanceInits);
            AScene.checkElems(el.methods, c.methods);
            AScene.checkElems(el.staticInits, c.staticInits);
            return this.visitDeclaration((ADeclaration)el, arg);
        }

        @Override
        public Void visitDeclaration(ADeclaration el, AElement arg) {
            ADeclaration d = (ADeclaration)arg;
            AScene.checkElems(el.insertAnnotations, d.insertAnnotations);
            AScene.checkElems(el.insertTypecasts, d.insertTypecasts);
            return this.visitElement((AElement)el, arg);
        }

        @Override
        public Void visitExpression(AExpression el, AElement arg) {
            AExpression e = (AExpression)arg;
            AScene.checkObject(el.id, e.id);
            AScene.checkElems(el.calls, e.calls);
            AScene.checkElems(el.funs, e.funs);
            AScene.checkElems(el.instanceofs, e.instanceofs);
            AScene.checkElems(el.news, e.news);
            AScene.checkElems(el.refs, e.refs);
            AScene.checkElems(el.typecasts, e.typecasts);
            return this.visitElement((AElement)el, arg);
        }

        @Override
        public Void visitField(AField el, AElement arg) {
            AField f = (AField)arg;
            AScene.checkElem(el.init, f.init);
            return this.visitDeclaration((ADeclaration)el, arg);
        }

        @Override
        public Void visitMethod(AMethod el, AElement arg) {
            AMethod m3 = (AMethod)arg;
            AScene.checkObject(el.methodName, m3.methodName);
            AScene.checkElem(el.body, m3.body);
            AScene.checkElem(el.returnType, m3.returnType);
            AScene.checkElems(el.bounds, m3.bounds);
            AScene.checkElems(el.parameters, m3.parameters);
            AScene.checkElems(el.throwsException, m3.throwsException);
            return null;
        }

        @Override
        public Void visitTypeElement(ATypeElement el, AElement arg) {
            ATypeElement t = (ATypeElement)arg;
            AScene.checkObject(el.description, t.description);
            AScene.checkElems(el.innerTypes, t.innerTypes);
            return null;
        }

        @Override
        public Void visitTypeElementWithType(ATypeElementWithType el, AElement arg) {
            ATypeElementWithType t = (ATypeElementWithType)arg;
            AScene.checkObject(el.getType(), t.getType());
            return this.visitTypeElement((ATypeElement)el, arg);
        }

        @Override
        public Void visitElement(AElement el, AElement arg) {
            AScene.checkObject(el.description, arg.description);
            if (el.tlAnnotationsHere.size() != arg.tlAnnotationsHere.size()) {
                AScene.cloneCheckFail();
            }
            for (Annotation a : el.tlAnnotationsHere) {
                if (arg.tlAnnotationsHere.contains(a)) continue;
                AScene.cloneCheckFail();
            }
            AScene.checkElem(el.type, arg.type);
            return null;
        }
    };

    public AScene() {
    }

    public AScene(AScene scene) {
        for (String key : scene.packages.keySet()) {
            AElement val = (AElement)scene.packages.get(key);
            this.packages.put(key, val.clone());
        }
        for (String key : scene.imports.keySet()) {
            Set<String> value = scene.imports.get(key);
            LinkedHashSet<String> copy = new LinkedHashSet<String>();
            copy.addAll(value);
            this.imports.put(key, copy);
        }
        for (String key : scene.classes.keySet()) {
            AClass clazz = (AClass)scene.classes.get(key);
            this.classes.put(key, clazz.clone());
        }
        if (checkClones) {
            AScene.checkClone(this, scene);
        }
    }

    public AScene clone() {
        return new AScene(this);
    }

    public boolean equals(Object o) {
        return o instanceof AScene && ((AScene)o).equals(this);
    }

    public boolean equals(AScene o) {
        return o.classes.equals(this.classes) && o.packages.equals(this.packages);
    }

    public int hashCode() {
        return this.classes.hashCode() + this.packages.hashCode();
    }

    public boolean prune() {
        return this.classes.prune() & this.packages.prune();
    }

    public String unparse() {
        StringBuilder sb = new StringBuilder();
        sb.append("packages:\n");
        for (Map.Entry entry : this.packages.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => " + entry.getValue() + "\n");
        }
        sb.append("classes:\n");
        for (Map.Entry entry : this.classes.entrySet()) {
            sb.append("  " + (String)entry.getKey() + " => \n");
            sb.append(((AClass)entry.getValue()).unparse("    "));
        }
        return sb.toString();
    }

    public String toString() {
        return this.unparse();
    }

    public static void checkClone(AScene s0, AScene s1) {
        if (s0 == null) {
            if (s1 != null) {
                AScene.cloneCheckFail();
            }
        } else {
            if (s1 == null) {
                AScene.cloneCheckFail();
            }
            s0.prune();
            s1.prune();
            if (s0 == s1) {
                AScene.cloneCheckFail();
            }
            AScene.checkElems(s0.packages, s1.packages);
            AScene.checkElems(s0.classes, s1.classes);
        }
    }

    public static <K, V extends AElement> void checkElems(VivifyingMap<K, V> m0, VivifyingMap<K, V> m1) {
        if (m0 == null) {
            if (m1 != null) {
                AScene.cloneCheckFail();
            }
        } else if (m1 == null) {
            AScene.cloneCheckFail();
        } else {
            for (Object k : m0.keySet()) {
                AScene.checkElem((AElement)m0.get(k), (AElement)m1.get(k));
            }
        }
    }

    public static void checkElem(AElement e0, AElement e1) {
        AScene.checkObject(e0, e1);
        if (e0 != null) {
            if (e0 == e1) {
                AScene.cloneCheckFail();
            }
            e0.accept(checkVisitor, e1);
        }
    }

    public static void checkObject(Object o0, Object o1) {
        if (o0 == null ? o1 != null : !o0.equals(o1) || !o1.equals(o0)) {
            throw new RuntimeException("clone check failed");
        }
    }

    private static void cloneCheckFail() {
        throw new RuntimeException("clone check failed");
    }

    public static void main(String[] args) {
        int status = 0;
        checkClones = true;
        for (int i = 0; i < args.length; ++i) {
            AScene s0 = new AScene();
            System.out.print(args[i] + ": ");
            try {
                IndexFileParser.parseFile(args[i], s0);
                s0.clone();
                System.out.println("ok");
                continue;
            }
            catch (Throwable e) {
                status = 1;
                System.out.println("failed");
                e.printStackTrace();
            }
        }
        System.exit(status);
    }
}

