/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.element.TypeParamElementAnnotationApplier;
import org.checkerframework.javacutil.ErrorReporter;

public class ClassTypeParamApplier
extends TypeParamElementAnnotationApplier {
    private final Symbol.ClassSymbol enclosingClass;

    public static void apply(AnnotatedTypeMirror.AnnotatedTypeVariable type, Element element, AnnotatedTypeFactory typeFactory) {
        new ClassTypeParamApplier(type, element, typeFactory).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror type, Element element) {
        return element.getKind() == ElementKind.TYPE_PARAMETER && element.getEnclosingElement() instanceof Symbol.ClassSymbol;
    }

    ClassTypeParamApplier(AnnotatedTypeMirror.AnnotatedTypeVariable type, Element element, AnnotatedTypeFactory typeFactory) {
        super(type, element, typeFactory);
        if (!(element.getEnclosingElement() instanceof Symbol.ClassSymbol)) {
            ErrorReporter.errorAbort("TypeParameter not enclosed by class?  Type( " + type + " ) Element ( " + element + " ) ");
        }
        this.enclosingClass = (Symbol.ClassSymbol)element.getEnclosingElement();
    }

    @Override
    protected TargetType lowerBoundTarget() {
        return TargetType.CLASS_TYPE_PARAMETER;
    }

    @Override
    protected TargetType upperBoundTarget() {
        return TargetType.CLASS_TYPE_PARAMETER_BOUND;
    }

    @Override
    public int getElementIndex() {
        return ((List)this.enclosingClass.getTypeParameters()).indexOf(this.element);
    }

    @Override
    protected TargetType[] validTargets() {
        return new TargetType[]{TargetType.CLASS_EXTENDS};
    }

    @Override
    protected Iterable<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.enclosingClass.getRawTypeAttributes();
    }

    @Override
    protected boolean isAccepted() {
        return ClassTypeParamApplier.accepts(this.type, this.element);
    }
}

