/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.stub;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.checkerframework.com.github.javaparser.ast.CompilationUnit;
import org.checkerframework.com.github.javaparser.ast.Node;
import org.checkerframework.com.github.javaparser.ast.StubUnit;
import org.checkerframework.com.github.javaparser.ast.body.BodyDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ConstructorDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.FieldDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.MethodDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.Parameter;
import org.checkerframework.com.github.javaparser.ast.body.TypeDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.VariableDeclarator;
import org.checkerframework.com.github.javaparser.ast.type.ClassOrInterfaceType;
import org.checkerframework.com.github.javaparser.ast.type.PrimitiveType;
import org.checkerframework.com.github.javaparser.ast.type.VoidType;
import org.checkerframework.com.github.javaparser.ast.type.WildcardType;
import org.checkerframework.com.github.javaparser.ast.visitor.SimpleVoidVisitor;
import org.checkerframework.framework.stub.FileStubResource;
import org.checkerframework.framework.stub.JarEntryStubResource;
import org.checkerframework.framework.stub.StubResource;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

public class StubUtil {
    static TypeDeclaration<?> findDeclaration(String className, StubUnit indexFile) {
        int indexOfDot = className.lastIndexOf(46);
        if (indexOfDot == -1) {
            assert (!indexFile.getCompilationUnits().isEmpty());
            assert (indexFile.getCompilationUnits().get(0).getPackageDeclaration() == null);
            return StubUtil.findDeclaration(className, indexFile.getCompilationUnits().get(0));
        }
        String packageName = className.substring(0, indexOfDot);
        String simpleName = className.substring(indexOfDot + 1);
        for (CompilationUnit cu : indexFile.getCompilationUnits()) {
            TypeDeclaration<?> type;
            if (!cu.getPackageDeclaration().isPresent() || !cu.getPackageDeclaration().get().getNameAsString().equals(packageName) || (type = StubUtil.findDeclaration(simpleName, cu)) == null) continue;
            return type;
        }
        return null;
    }

    static TypeDeclaration<?> findDeclaration(TypeElement type, StubUnit indexFile) {
        return StubUtil.findDeclaration(type.getQualifiedName().toString(), indexFile);
    }

    static FieldDeclaration findDeclaration(VariableElement field, StubUnit indexFile) {
        TypeDeclaration<?> type = StubUtil.findDeclaration((TypeElement)field.getEnclosingElement(), indexFile);
        if (type == null) {
            return null;
        }
        for (BodyDeclaration<?> member : type.getMembers()) {
            if (!(member instanceof FieldDeclaration)) continue;
            FieldDeclaration decl = (FieldDeclaration)member;
            for (VariableDeclarator var : decl.getVariables()) {
                if (!StubUtil.toString(var).equals(field.getSimpleName().toString())) continue;
                return decl;
            }
        }
        return null;
    }

    static BodyDeclaration<?> findDeclaration(ExecutableElement method, StubUnit indexFile) {
        TypeDeclaration<?> type = StubUtil.findDeclaration((TypeElement)method.getEnclosingElement(), indexFile);
        if (type == null) {
            return null;
        }
        String methodRep = StubUtil.toString(method);
        for (BodyDeclaration<?> member : type.getMembers()) {
            if (!(member instanceof MethodDeclaration ? StubUtil.toString((MethodDeclaration)member).equals(methodRep) : member instanceof ConstructorDeclaration && StubUtil.toString((ConstructorDeclaration)member).equals(methodRep))) continue;
            return member;
        }
        return null;
    }

    static TypeDeclaration<?> findDeclaration(String simpleName, CompilationUnit cu) {
        for (TypeDeclaration<?> type : cu.getTypes()) {
            if (!simpleName.equals(type.getNameAsString())) continue;
            return type;
        }
        return null;
    }

    static String toString(MethodDeclaration method) {
        return ElementPrinter.toString(method);
    }

    static String toString(ConstructorDeclaration constructor) {
        return ElementPrinter.toString(constructor);
    }

    static String toString(VariableDeclarator field) {
        return field.getNameAsString();
    }

    static String toString(FieldDeclaration field) {
        assert (field.getVariables().size() == 1);
        return StubUtil.toString((VariableDeclarator)field.getVariables().get(0));
    }

    static String toString(ExecutableElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getSimpleName());
        sb.append("(");
        Iterator<? extends VariableElement> i = element.getParameters().iterator();
        while (i.hasNext()) {
            sb.append(StubUtil.standarizeType(i.next().asType()));
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    static String toString(VariableElement element) {
        assert (element.getKind().isField());
        return element.getSimpleName().toString();
    }

    static String toString(Element element) {
        if (element instanceof ExecutableElement) {
            return StubUtil.toString((ExecutableElement)element);
        }
        if (element instanceof VariableElement) {
            return StubUtil.toString((VariableElement)element);
        }
        return null;
    }

    static Pair<String, String> partitionQualifiedName(String imported) {
        String typeName = imported.substring(0, imported.lastIndexOf("."));
        String name = imported.substring(imported.lastIndexOf(".") + 1);
        Pair<String, String> typeParts = Pair.of(typeName, name);
        return typeParts;
    }

    private static String standarizeType(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return StubUtil.standarizeType(((ArrayType)type).getComponentType()) + "[]";
            }
            case TYPEVAR: {
                return ((TypeVariable)type).asElement().getSimpleName().toString();
            }
            case DECLARED: {
                return ((DeclaredType)type).asElement().getSimpleName().toString();
            }
        }
        if (type.getKind().isPrimitive()) {
            return type.toString();
        }
        ErrorReporter.errorAbort("StubUtil: unhandled type: " + type);
        return null;
    }

    public static List<StubResource> allStubFiles(String stub) {
        ArrayList<StubResource> resources = new ArrayList<StubResource>();
        File stubFile = new File(stub);
        if (stubFile.exists()) {
            StubUtil.allStubFiles(stubFile, resources);
        } else {
            String workingDir = System.getProperty("user.dir") + System.getProperty("file.separator");
            stubFile = new File(workingDir + stub);
            if (stubFile.exists()) {
                StubUtil.allStubFiles(stubFile, resources);
            }
        }
        return resources;
    }

    private static boolean isStub(File f) {
        return f.isFile() && StubUtil.isStub(f.getName());
    }

    private static boolean isStub(String path) {
        return path.endsWith(".astub");
    }

    private static boolean isJar(File f) {
        return f.isFile() && f.getName().endsWith(".jar");
    }

    private static void allStubFiles(File stub, List<StubResource> resources) {
        block5: {
            block6: {
                JarFile file;
                block4: {
                    if (!StubUtil.isStub(stub)) break block4;
                    resources.add(new FileStubResource(stub));
                    break block5;
                }
                if (!StubUtil.isJar(stub)) break block6;
                try {
                    file = new JarFile(stub);
                }
                catch (IOException e) {
                    System.err.println("StubUtil: could not process JAR file: " + stub);
                    return;
                }
                Enumeration<JarEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!StubUtil.isStub(entry.getName())) continue;
                    resources.add(new JarEntryStubResource(file, entry));
                }
                break block5;
            }
            if (!stub.isDirectory()) break block5;
            File[] directoryContents = stub.listFiles();
            Arrays.sort(directoryContents, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (File enclosed : directoryContents) {
                StubUtil.allStubFiles(enclosed, resources);
            }
        }
    }

    private static final class ElementPrinter
    extends SimpleVoidVisitor<Void> {
        private final StringBuilder sb = new StringBuilder();

        private ElementPrinter() {
        }

        public static String toString(Node n) {
            ElementPrinter printer = new ElementPrinter();
            n.accept(printer, null);
            return printer.getOutput();
        }

        public String getOutput() {
            return this.sb.toString();
        }

        @Override
        public void visit(ConstructorDeclaration n, Void arg) {
            this.sb.append("<init>");
            this.sb.append("(");
            if (n.getParameters() != null) {
                Iterator<Parameter> i = n.getParameters().iterator();
                while (i.hasNext()) {
                    Parameter p = i.next();
                    p.accept(this, arg);
                    if (!i.hasNext()) continue;
                    this.sb.append(",");
                }
            }
            this.sb.append(")");
        }

        @Override
        public void visit(MethodDeclaration n, Void arg) {
            this.sb.append(n.getName());
            this.sb.append("(");
            if (n.getParameters() != null) {
                Iterator<Parameter> i = n.getParameters().iterator();
                while (i.hasNext()) {
                    Parameter p = i.next();
                    p.accept(this, arg);
                    if (!i.hasNext()) continue;
                    this.sb.append(",");
                }
            }
            this.sb.append(")");
        }

        @Override
        public void visit(Parameter n, Void arg) {
            n.getType().accept(this, arg);
            if (n.isVarArgs()) {
                this.sb.append("[]");
            }
        }

        @Override
        public void visit(ClassOrInterfaceType n, Void arg) {
            this.sb.append(n.getName());
        }

        @Override
        public void visit(PrimitiveType n, Void arg) {
            switch (n.getType()) {
                case BOOLEAN: {
                    this.sb.append("boolean");
                    break;
                }
                case BYTE: {
                    this.sb.append("byte");
                    break;
                }
                case CHAR: {
                    this.sb.append("char");
                    break;
                }
                case DOUBLE: {
                    this.sb.append("double");
                    break;
                }
                case FLOAT: {
                    this.sb.append("float");
                    break;
                }
                case INT: {
                    this.sb.append("int");
                    break;
                }
                case LONG: {
                    this.sb.append("long");
                    break;
                }
                case SHORT: {
                    this.sb.append("short");
                    break;
                }
                default: {
                    ErrorReporter.errorAbort("StubUtil: unknown type: " + (Object)((Object)n.getType()));
                }
            }
        }

        @Override
        public void visit(org.checkerframework.com.github.javaparser.ast.type.ArrayType n, Void arg) {
            n.getComponentType().accept(this, arg);
            this.sb.append("[]");
        }

        @Override
        public void visit(VoidType n, Void arg) {
            this.sb.append("void");
        }

        @Override
        public void visit(WildcardType n, Void arg) {
            ErrorReporter.errorAbort("StubUtil: don't print type args!");
        }
    }
}

