/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.util.debug;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.Collection;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;

public class TypeOutputtingChecker
extends BaseTypeChecker {
    @Override
    protected BaseTypeVisitor<?> createSourceVisitor() {
        return new Visitor(this);
    }

    public static void main(String[] args) {
        new TypeOutputtingChecker().run(args);
    }

    public void run(String[] args) {
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(new Context());
        Elements elements = env.getElementUtils();
        GeneralAnnotatedTypeFactory atypeFactory = new GeneralAnnotatedTypeFactory(this);
        for (String className : args) {
            TypeElement typeElt = elements.getTypeElement(className);
            TypeOutputtingChecker.printClassType(typeElt, atypeFactory);
        }
    }

    protected static void printClassType(TypeElement typeElt, AnnotatedTypeFactory atypeFactory) {
        assert (typeElt != null);
        String simpleName = typeElt.getSimpleName().toString();
        AnnotatedTypeMirror.AnnotatedDeclaredType type = atypeFactory.fromElement(typeElt);
        System.out.println(simpleName + "\t" + type + "\t" + type.directSuperTypes());
        for (Element element : typeElt.getEnclosedElements()) {
            if (element instanceof TypeElement) {
                TypeOutputtingChecker.printClassType((TypeElement)element, atypeFactory);
            }
            if (!element.getKind().isField() && !(element instanceof ExecutableElement)) continue;
            AnnotatedTypeMirror memberType = atypeFactory.fromElement(element);
            System.out.println(simpleName + "." + element + "\t\t" + memberType);
        }
    }

    public static class GeneralAnnotatedTypeFactory
    extends AnnotatedTypeFactory {
        public GeneralAnnotatedTypeFactory(BaseTypeChecker checker) {
            super(checker);
            this.postInit();
        }

        @Override
        public void postProcessClassTree(ClassTree tree) {
        }

        @Override
        public boolean isSupportedQualifier(AnnotationMirror a) {
            return true;
        }

        @Override
        public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            return new GeneralQualifierHierarchy(factory);
        }

        static class GeneralQualifierHierarchy
        extends MultiGraphQualifierHierarchy {
            public GeneralQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
                super(factory);
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
                return start;
            }

            @Override
            public AnnotationMirror getBottomAnnotation(AnnotationMirror start) {
                return start;
            }

            @Override
            public AnnotationMirror findAnnotationInSameHierarchy(Collection<? extends AnnotationMirror> annotations, AnnotationMirror annotationMirror) {
                return null;
            }

            public Set<AnnotationMirror> getTopAnnotations() {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy:getTopAnnotations() was called! It shouldn't be called.");
                return null;
            }

            public Set<AnnotationMirror> getBottomAnnotations() {
                return AnnotationUtils.createAnnotationSet();
            }

            @Override
            public Set<? extends AnnotationMirror> getTypeQualifiers() {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.getTypeQualifiers() was called! It shouldn't be called.");
                return null;
            }

            @Override
            public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.isSubtype() was called! It shouldn't be called.");
                return false;
            }

            @Override
            public boolean isSubtypeTypeVariable(AnnotationMirror subAnno, AnnotationMirror superAnno) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.isSubtypeTypeVariable() was called! It shouldn't be called.");
                return false;
            }

            @Override
            public boolean isSubtype(Collection<? extends AnnotationMirror> rhs, Collection<? extends AnnotationMirror> lhs) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.isSubtype() was called! It shouldn't be called.");
                return false;
            }

            @Override
            public boolean isSubtypeTypeVariable(Collection<? extends AnnotationMirror> subAnnos, Collection<? extends AnnotationMirror> superAnnos) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.isSubtypeTypeVariable() was called! It shouldn't be called.");
                return false;
            }

            @Override
            public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.leastUpperBound() was called! It shouldn't be called.");
                return null;
            }

            @Override
            public AnnotationMirror leastUpperBoundTypeVariable(AnnotationMirror a1, AnnotationMirror a2) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.leastUpperBoundTypeVariable() was called! It shouldn't be called.");
                return null;
            }

            @Override
            public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.greatestLowerBound() was called! It shouldn't be called.");
                return null;
            }

            @Override
            public AnnotationMirror greatestLowerBoundTypeVariable(AnnotationMirror a1, AnnotationMirror a2) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.greatestLowerBoundTypeVariable() was called! It shouldn't be called.");
                return null;
            }

            @Override
            public AnnotationMirror getPolymorphicAnnotation(AnnotationMirror start) {
                ErrorReporter.errorAbort("GeneralQualifierHierarchy.getPolymorphicAnnotation() was called! It shouldn't be called.");
                return null;
            }
        }
    }

    public static class Visitor
    extends BaseTypeVisitor<GenericAnnotatedTypeFactory<?, ?, ?, ?>> {
        String currentClass;

        public Visitor(BaseTypeChecker checker) {
            super(checker);
        }

        @Override
        public void processClassTree(ClassTree node) {
            TypeElement element = TreeUtils.elementFromDeclaration(node);
            this.currentClass = element.getSimpleName().toString();
            AnnotatedTypeMirror.AnnotatedDeclaredType type = this.atypeFactory.getAnnotatedType(node);
            System.out.println(node.getSimpleName() + "\t" + type + "\t" + type.directSuperTypes());
            super.processClassTree(node);
        }

        @Override
        public Void visitMethod(MethodTree node, Void p) {
            ExecutableElement elem = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror.AnnotatedExecutableType type = this.atypeFactory.getAnnotatedType(node);
            System.out.println(this.currentClass + "." + elem + "\t\t" + type);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Void p) {
            VariableElement elem = TreeUtils.elementFromDeclaration(node);
            if (elem.getKind().isField()) {
                AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node);
                System.out.println(this.currentClass + "." + elem + "\t\t" + type);
            }
            return null;
        }
    }
}

