/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.github.javaparser.ast.validator.chunks;

import java.util.ArrayList;
import java.util.Arrays;
import org.checkerframework.com.github.javaparser.ast.Modifier;
import org.checkerframework.com.github.javaparser.ast.body.AnnotationDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.ConstructorDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.EnumDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.FieldDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.MethodDeclaration;
import org.checkerframework.com.github.javaparser.ast.body.TypeDeclaration;
import org.checkerframework.com.github.javaparser.ast.expr.LambdaExpr;
import org.checkerframework.com.github.javaparser.ast.expr.VariableDeclarationExpr;
import org.checkerframework.com.github.javaparser.ast.modules.ModuleRequiresStmt;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import org.checkerframework.com.github.javaparser.ast.nodeTypes.NodeWithTokenRange;
import org.checkerframework.com.github.javaparser.ast.stmt.CatchClause;
import org.checkerframework.com.github.javaparser.ast.validator.ProblemReporter;
import org.checkerframework.com.github.javaparser.ast.validator.VisitorValidator;
import org.checkerframework.com.github.javaparser.utils.SeparatedItemStringBuilder;

public class ModifierValidator
extends VisitorValidator {
    private final Modifier[] interfaceWithNothingSpecial = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.ABSTRACT, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP};
    private final Modifier[] interfaceWithStaticAndDefault = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP, Modifier.DEFAULT};
    private final Modifier[] interfaceWithStaticAndDefaultAndPrivate = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP, Modifier.DEFAULT};
    private final boolean hasStrictfp;
    private final boolean hasDefaultAndStaticInterfaceMethods;
    private final boolean hasPrivateInterfaceMethods;

    public ModifierValidator(boolean hasStrictfp, boolean hasDefaultAndStaticInterfaceMethods, boolean hasPrivateInterfaceMethods) {
        this.hasStrictfp = hasStrictfp;
        this.hasDefaultAndStaticInterfaceMethods = hasDefaultAndStaticInterfaceMethods;
        this.hasPrivateInterfaceMethods = hasPrivateInterfaceMethods;
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
        if (n.isInterface()) {
            this.validateInterfaceModifiers(n, reporter);
        } else {
            this.validateClassModifiers(n, reporter);
        }
        super.visit(n, reporter);
    }

    private void validateClassModifiers(ClassOrInterfaceDeclaration n, ProblemReporter reporter) {
        if (n.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.FINAL, Modifier.STRICTFP);
        } else if (n.isNestedType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.STRICTFP);
        } else if (n.isLocalClassDeclaration()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.ABSTRACT, Modifier.FINAL, Modifier.STRICTFP);
        }
    }

    private void validateInterfaceModifiers(TypeDeclaration<?> n, ProblemReporter reporter) {
        if (n.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STRICTFP);
        } else if (n.isNestedType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.STRICTFP);
        }
    }

    @Override
    public void visit(EnumDeclaration n, ProblemReporter reporter) {
        if (n.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.STRICTFP);
        } else if (n.isNestedType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.STATIC, Modifier.STRICTFP);
        }
        super.visit(n, reporter);
    }

    @Override
    public void visit(AnnotationDeclaration n, ProblemReporter reporter) {
        this.validateInterfaceModifiers(n, reporter);
        super.visit(n, reporter);
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.ABSTRACT);
        super.visit(n, reporter);
    }

    @Override
    public void visit(ConstructorDeclaration n, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
        n.getParameters().forEach(p -> this.validateModifiers(p, reporter, Modifier.FINAL));
        super.visit(n, reporter);
    }

    @Override
    public void visit(FieldDeclaration n, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL, Modifier.TRANSIENT, Modifier.VOLATILE);
        super.visit(n, reporter);
    }

    @Override
    public void visit(MethodDeclaration n, ProblemReporter reporter) {
        if (n.isAbstract()) {
            SeparatedItemStringBuilder builder = new SeparatedItemStringBuilder("Cannot be 'abstract' and also '", "', '", "'.");
            for (Modifier m3 : Arrays.asList(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL, Modifier.NATIVE, Modifier.STRICTFP, Modifier.SYNCHRONIZED)) {
                if (!n.getModifiers().contains((Object)m3)) continue;
                builder.append(m3.asString(), new Object[0]);
            }
            if (builder.hasItems()) {
                reporter.report(n, builder.toString(), new Object[0]);
            }
        }
        if (n.getParentNode().isPresent() && n.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
            if (((ClassOrInterfaceDeclaration)n.getParentNode().get()).isInterface()) {
                if (this.hasDefaultAndStaticInterfaceMethods) {
                    if (this.hasPrivateInterfaceMethods) {
                        this.validateModifiers(n, reporter, this.interfaceWithStaticAndDefaultAndPrivate);
                    } else {
                        this.validateModifiers(n, reporter, this.interfaceWithStaticAndDefault);
                    }
                } else {
                    this.validateModifiers(n, reporter, this.interfaceWithNothingSpecial);
                }
            } else {
                this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP);
            }
        }
        n.getParameters().forEach(p -> this.validateModifiers(p, reporter, Modifier.FINAL));
        super.visit(n, reporter);
    }

    @Override
    public void visit(LambdaExpr n, ProblemReporter reporter) {
        n.getParameters().forEach(p -> this.validateModifiers(p, reporter, Modifier.FINAL));
        super.visit(n, reporter);
    }

    @Override
    public void visit(CatchClause n, ProblemReporter reporter) {
        this.validateModifiers(n.getParameter(), reporter, Modifier.FINAL);
        super.visit(n, reporter);
    }

    @Override
    public void visit(VariableDeclarationExpr n, ProblemReporter reporter) {
        this.validateModifiers(n, reporter, Modifier.FINAL);
        super.visit(n, reporter);
    }

    @Override
    public void visit(ModuleRequiresStmt n, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n, reporter, Modifier.TRANSITIVE, Modifier.STATIC);
        super.visit(n, reporter);
    }

    private <T extends NodeWithModifiers<?> & NodeWithTokenRange<?>> void validateModifiers(T n, ProblemReporter reporter, Modifier ... allowedModifiers) {
        this.validateAtMostOneOf(n, reporter, new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE});
        this.validateAtMostOneOf(n, reporter, new Modifier[]{Modifier.FINAL, Modifier.ABSTRACT});
        if (this.hasStrictfp) {
            this.validateAtMostOneOf(n, reporter, new Modifier[]{Modifier.NATIVE, Modifier.STRICTFP});
        } else {
            allowedModifiers = this.removeModifierFromArray(Modifier.STRICTFP, allowedModifiers);
        }
        for (Modifier m3 : n.getModifiers()) {
            if (this.arrayContains((Object[])allowedModifiers, (Object)m3)) continue;
            reporter.report(n, "'%s' is not allowed here.", m3.asString());
        }
    }

    private Modifier[] removeModifierFromArray(Modifier m3, Modifier[] allowedModifiers) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(Arrays.asList(allowedModifiers));
        newModifiers.remove((Object)m3);
        allowedModifiers = newModifiers.toArray(new Modifier[0]);
        return allowedModifiers;
    }

    private boolean arrayContains(Object[] items, Object searchItem) {
        for (Object o : items) {
            if (o != searchItem) continue;
            return true;
        }
        return false;
    }

    private <T extends NodeWithModifiers<?> & NodeWithTokenRange<?>> void validateAtMostOneOf(T t, ProblemReporter reporter, Modifier ... modifiers) {
        ArrayList<Modifier> foundModifiers = new ArrayList<Modifier>();
        for (Modifier m3 : modifiers) {
            if (!t.getModifiers().contains((Object)m3)) continue;
            foundModifiers.add(m3);
        }
        if (foundModifiers.size() > 1) {
            SeparatedItemStringBuilder builder = new SeparatedItemStringBuilder("Can have only one of '", "', '", "'.");
            for (Modifier m4 : foundModifiers) {
                builder.append(m4.asString(), new Object[0]);
            }
            reporter.report(t, builder.toString(), new Object[0]);
        }
    }
}

