/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import org.checkerframework.checker.units.UnitsAnnotatedTypeFactory;
import org.checkerframework.checker.units.qual.UnknownUnits;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;

public class UnitsVisitor
extends BaseTypeVisitor<UnitsAnnotatedTypeFactory> {
    public UnitsVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        ExpressionTree var = node.getVariable();
        ExpressionTree expr = node.getExpression();
        AnnotatedTypeMirror varType = ((UnitsAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(var);
        AnnotatedTypeMirror exprType = ((UnitsAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expr);
        Tree.Kind kind = node.getKind();
        if (kind == Tree.Kind.PLUS_ASSIGNMENT || kind == Tree.Kind.MINUS_ASSIGNMENT) {
            if (!((UnitsAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(exprType, varType)) {
                this.checker.report(Result.failure("compound.assignment.type.incompatible", varType, exprType), node);
            }
        } else if (exprType.getAnnotation(UnknownUnits.class) == null) {
            this.checker.report(Result.failure("compound.assignment.type.incompatible", varType, exprType), node);
        }
        return null;
    }
}

