/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.Subsequence;
import org.checkerframework.checker.index.lowerbound.LowerBoundAnnotatedTypeFactory;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;

public class LowerBoundVisitor
extends BaseTypeVisitor<LowerBoundAnnotatedTypeFactory> {
    private static final @CompilerMessageKey String LOWER_BOUND = "array.access.unsafe.low";
    private static final @CompilerMessageKey String NEGATIVE_ARRAY = "array.length.negative";
    private static final @CompilerMessageKey String FROM_NOT_NN = "from.not.nonnegative";

    public LowerBoundVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void type) {
        ExpressionTree index = tree.getIndex();
        String arrName = tree.getExpression().toString();
        AnnotatedTypeMirror indexType = ((LowerBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(index);
        if (!indexType.hasAnnotation(NonNegative.class) && !indexType.hasAnnotation(Positive.class)) {
            this.checker.report(Result.failure(LOWER_BOUND, indexType.toString(), arrName), index);
        }
        return super.visitArrayAccess(tree, type);
    }

    @Override
    public Void visitNewArray(NewArrayTree tree, Void type) {
        if (tree.getDimensions().size() > 0) {
            for (ExpressionTree expressionTree : tree.getDimensions()) {
                AnnotatedTypeMirror dimType = ((LowerBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expressionTree);
                if (dimType.hasAnnotation(NonNegative.class) || dimType.hasAnnotation(Positive.class)) continue;
                this.checker.report(Result.failure(NEGATIVE_ARRAY, dimType.toString()), expressionTree);
            }
        }
        return super.visitNewArray(tree, type);
    }

    @Override
    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueTree, @CompilerMessageKey String errorKey) {
        Subsequence subSeq = Subsequence.getSubsequenceFromTree(varTree, this.atypeFactory);
        if (subSeq != null) {
            AnnotationMirror anm;
            try {
                anm = ((LowerBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotationMirrorFromJavaExpressionString(subSeq.from, varTree, this.getCurrentPath());
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                anm = null;
            }
            if (anm == null || !AnnotationUtils.areSameByClass(anm, NonNegative.class) && !AnnotationUtils.areSameByClass(anm, Positive.class)) {
                this.checker.report(Result.failure(FROM_NOT_NN, subSeq.from, anm == null ? "@LowerBoundUnknown" : anm), valueTree);
            }
        }
        super.commonAssignmentCheck(varTree, valueTree, errorKey);
    }
}

