/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.Alphabet;
import com.sun.xml.internal.rngom.binary.BinaryPattern;
import com.sun.xml.internal.rngom.binary.DuplicateAttributeDetector;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.RestrictionViolationException;
import com.sun.xml.internal.rngom.binary.SchemaPatternBuilder;
import com.sun.xml.internal.rngom.binary.visitor.PatternFunction;
import com.sun.xml.internal.rngom.binary.visitor.PatternVisitor;

public class ChoicePattern
extends BinaryPattern {
    ChoicePattern(Pattern p1, Pattern p2) {
        super(p1.isNullable() || p2.isNullable(), ChoicePattern.combineHashCode(11, p1.hashCode(), p2.hashCode()), p1, p2);
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep1 = this.p1.expand(b);
        Pattern ep2 = this.p2.expand(b);
        if (ep1 != this.p1 || ep2 != this.p2) {
            return b.makeChoice(ep1, ep2);
        }
        return this;
    }

    @Override
    boolean containsChoice(Pattern p) {
        return this.p1.containsChoice(p) || this.p2.containsChoice(p);
    }

    @Override
    public void accept(PatternVisitor visitor) {
        visitor.visitChoice(this.p1, this.p2);
    }

    @Override
    public Object apply(PatternFunction f) {
        return f.caseChoice(this);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        if (dad != null) {
            dad.startChoice();
        }
        this.p1.checkRestrictions(context, dad, alpha);
        if (dad != null) {
            dad.alternative();
        }
        this.p2.checkRestrictions(context, dad, alpha);
        if (dad != null) {
            dad.endChoice();
        }
    }
}

