/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.ConnectorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GenericListeningConnector
extends ConnectorImpl
implements ListeningConnector {
    static final String ARG_ADDRESS = "address";
    static final String ARG_TIMEOUT = "timeout";
    Map<Map<String, ? extends Connector.Argument>, TransportService.ListenKey> listenMap;
    TransportService transportService;
    Transport transport;

    private GenericListeningConnector(TransportService transportService, boolean bl) {
        this.transportService = transportService;
        this.transport = new Transport(){

            @Override
            public String name() {
                return GenericListeningConnector.this.transportService.name();
            }
        };
        if (bl) {
            this.addStringArgument(ARG_ADDRESS, this.getString("generic_listening.address.label"), this.getString("generic_listening.address"), "", false);
        }
        this.addIntegerArgument(ARG_TIMEOUT, this.getString("generic_listening.timeout.label"), this.getString("generic_listening.timeout"), "", false, 0, Integer.MAX_VALUE);
        this.listenMap = new HashMap<Map<String, ? extends Connector.Argument>, TransportService.ListenKey>(10);
    }

    protected GenericListeningConnector(TransportService transportService) {
        this(transportService, false);
    }

    public static GenericListeningConnector create(TransportService transportService) {
        return new GenericListeningConnector(transportService, true);
    }

    public String startListening(String string, Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException {
        TransportService.ListenKey listenKey = this.listenMap.get(map);
        if (listenKey != null) {
            throw new IllegalConnectorArgumentsException("Already listening", new ArrayList<String>(map.keySet()));
        }
        listenKey = this.transportService.startListening(string);
        this.listenMap.put(map, listenKey);
        return listenKey.address();
    }

    @Override
    public String startListening(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException {
        String string = this.argument(ARG_ADDRESS, map).value();
        return this.startListening(string, map);
    }

    @Override
    public void stopListening(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException {
        TransportService.ListenKey listenKey = this.listenMap.get(map);
        if (listenKey == null) {
            throw new IllegalConnectorArgumentsException("Not listening", new ArrayList<String>(map.keySet()));
        }
        this.transportService.stopListening(listenKey);
        this.listenMap.remove(map);
    }

    @Override
    public VirtualMachine accept(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException {
        Connection connection;
        TransportService.ListenKey listenKey;
        String string = this.argument(ARG_TIMEOUT, map).value();
        int n = 0;
        if (string.length() > 0) {
            n = Integer.decode(string);
        }
        if ((listenKey = this.listenMap.get(map)) != null) {
            connection = this.transportService.accept(listenKey, n, 0L);
        } else {
            this.startListening(map);
            listenKey = this.listenMap.get(map);
            assert (listenKey != null);
            connection = this.transportService.accept(listenKey, n, 0L);
            this.stopListening(map);
        }
        return Bootstrap.virtualMachineManager().createVirtualMachine(connection);
    }

    @Override
    public boolean supportsMultipleConnections() {
        return this.transportService.capabilities().supportsMultipleConnections();
    }

    @Override
    public String name() {
        return this.transport.name() + "Listen";
    }

    @Override
    public String description() {
        return this.transportService.description();
    }

    @Override
    public Transport transport() {
        return this.transport;
    }
}

