/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.VMListener;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference,
VMListener {
    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ClassLoaderReferenceImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
        this.vm.state().addListener(this);
    }

    @Override
    protected String description() {
        return "ClassLoaderReference " + this.uniqueID();
    }

    @Override
    public List<ReferenceType> definedClasses() {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        for (ReferenceType referenceType : this.vm.allClasses()) {
            if (!referenceType.isPrepared() || !this.equals(referenceType.classLoader())) continue;
            arrayList.add(referenceType);
        }
        return arrayList;
    }

    @Override
    public List<ReferenceType> visibleClasses() {
        List<ReferenceType> list = null;
        try {
            Cache cache = (Cache)this.getCache();
            if (cache != null) {
                list = cache.visibleClasses;
            }
            if (list == null) {
                JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] classInfoArray = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, (ClassLoaderReferenceImpl)this).classes;
                list = new ArrayList<ReferenceType>(classInfoArray.length);
                for (int i = 0; i < classInfoArray.length; ++i) {
                    list.add(this.vm.referenceType(classInfoArray[i].typeID, classInfoArray[i].refTypeTag));
                }
                list = Collections.unmodifiableList(list);
                if (cache != null) {
                    cache.visibleClasses = list;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching visible classes (count = " + list.size() + ")");
                    }
                }
            }
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        return list;
    }

    Type findType(String string) throws ClassNotLoadedException {
        List<ReferenceType> list = this.visibleClasses();
        for (ReferenceType object2 : list) {
            if (!object2.signature().equals(string)) continue;
            return object2;
        }
        JNITypeParser jNITypeParser = new JNITypeParser(string);
        throw new ClassNotLoadedException(jNITypeParser.typeName(), "Class " + jNITypeParser.typeName() + " not loaded");
    }

    @Override
    byte typeValueKey() {
        return 108;
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        List<ReferenceType> visibleClasses = null;

        private Cache() {
        }
    }
}

